#!/bin/bash
#
# A template for building scripts to run the data extension software

# change the following two to change the input folder to use, which reflects the date of the last measurement
year=2022
month=03

set -x

# location of dei software
progdir=${HOME}/Code/DEI

# set the gas to use
gas="co2"

# set the input tag, corresponding to the year and month of the data tarball
tarball_date="${year}-${month}"

# calculate the fractional year
float_year=$( echo "scale=2 ; $year + ($month-0.25)/12" | bc )

# set the input folder
inputdir=${progdir}/input/from_ccgg/${gas}/results.web.${tarball_date}

# create a timestamp string for the results directory name (NOT USED)
thisday=`date +%Y-%m-%d`

# set the number of bootstrap runs to do
numbs=100

# set the init file
initfile=${inputdir}/init.${gas}.flask.trends.txt

# and the file with site information
siteinfo_file=${progdir}/siteinfo.txt

# build the output results directory name
outputdir=${progdir}/output/${gas}/results.web.${tarball_date}

# calculate the averages without any error estimates
python3 $progdir/dei_driver.py --siteinfo=${siteinfo_file} --initfile=${initfile} --inputdir=${inputdir} --bsdir=${outputdir} --gas=${gas} --quickfilter --stopdate ${float_year} --useadate

# add the atmospheric bootstrap runs to the results
#python3 $progdir/dei_driver.py --siteinfo=${siteinfo_file} --initfile=${initfile} --inputdir=${inputdir} --bsdir=${bsdir} --numbs=${numbs} --anchor --gas=$gas --quickfilter --unctype=atmospheric --bootstrap_only

## add the network bootstrap runs to the results
#python3 $progdir/dei_driver.py --siteinfo=${siteinfo_file} --initfile=${initfile} --inputdir=${inputdir} --bsdir=${bsdir} --numbs=${numbs} --anchor --gas=$gas --quickfilter --unctype=network --bootstrap_only

## get a summary of atmospheric bootstrap runs
#python $progdir/dei_bs_driver.py --initfile=$initfile --bsdir=$bsdir --gas=$gas --numbs=$numbs --unctype=atmospheric

## get a summary of network bootstrap runs
#python $progdir/dei_bs_driver.py --initfile=$initfile --bsdir=$bsdir --gas=$gas --numbs=$numbs --unctype=network

## combine the bootstrap methods to get total surface uncertainty file
#python $progdir/dei_effective_unc.py --bsdir=$bsdir --gas=$gas
