clc
clear all 
close all

paramfile = '/discover/nobackup/jkolassa/CLM_test/ctsm5.1/inputdata/lnd/clm2/paramdata/clm50_params.c210217.nc'

cn51_leaf_long = ncread(paramfile,'leaf_long');
cn51_params{1} = ncread(paramfile,'z0mr');
cn51_params{2} = ncread(paramfile,'displar');
cn51_params{3} = ncread(paramfile,'c3psn');
cn51_params{4} = ncread(paramfile,'slatop');
cn51_params{5} = ncread(paramfile,'dsladlai');
cn51_params{6} = ncread(paramfile,'leafcn');
cn51_params{7} = ncread(paramfile,'flnr');
cn51_params{8} = ncread(paramfile,'fnitr');
cn51_params{9} = ncread(paramfile,'woody');
cn51_params{10} = ncread(paramfile,'lflitcn');
cn51_params{11} = ncread(paramfile,'frootcn');
cn51_params{12} = ncread(paramfile,'livewdcn');
cn51_params{13} = ncread(paramfile,'deadwdcn');
cn51_params{14} = ncread(paramfile,'froot_leaf');
cn51_params{15} = ncread(paramfile,'stem_leaf');
cn51_params{16} = ncread(paramfile,'croot_stem');
cn51_params{17} = ncread(paramfile,'flivewd');
cn51_params{18} = ncread(paramfile,'fcur');
cn51_params{19} = ncread(paramfile,'lf_flab');
cn51_params{20} = ncread(paramfile,'lf_fcel');
cn51_params{21} = ncread(paramfile,'lf_flig');
cn51_params{22} = ncread(paramfile,'fr_flab');
cn51_params{23} = ncread(paramfile,'fr_fcel');
cn51_params{24} = ncread(paramfile,'fr_flig');
cn51_params{25} = ncread(paramfile,'leaf_long');
cn51_params{26} = ncread(paramfile,'evergreen');
cn51_params{27} = ncread(paramfile,'stress_decid');
cn51_params{28} = ncread(paramfile,'season_decid');
cn51_params{29} = ncread(paramfile,'xl');
cn51_params{30} = ncread(paramfile,'rholvis');
cn51_params{31} = ncread(paramfile,'rhosvis');
cn51_params{32} = ncread(paramfile,'taulvis');
cn51_params{33} = ncread(paramfile,'tausvis');
cn51_params{34} = ncread(paramfile,'cc_dstem');
cn51_params{35} = ncread(paramfile,'cc_leaf');
cn51_params{36} = ncread(paramfile,'cc_lstem');
cn51_params{37} = ncread(paramfile,'cc_other');
cn51_params{38} = ncread(paramfile,'fm_leaf');
cn51_params{39} = ncread(paramfile,'fm_lstem');
cn51_params{40} = ncread(paramfile,'fm_other');
cn51_params{41} = ncread(paramfile,'fm_root');
cn51_params{42} = ncread(paramfile,'fm_lroot');
cn51_params{43} = ncread(paramfile,'fm_droot');
cn51_params{44} = ncread(paramfile,'fd_pft');
cn51_params{45} = ncread(paramfile,'fsr_pft');
cn51_params{46} = ncread(paramfile,'grperc');
cn51_params{47} = ncread(paramfile,'grpnow');
%cn51_params{48} = ncread(paramfile,'dwood');

cn45_params{1} = [ 0., 0.055, 0.055, 0.055, 0.075, 0.075, 0.055, 0.055, 0.055, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120, 0.120];
cn45_params{2} = [0., 0.670, 0.670, 0.670, 0.670, 0.670, 0.670, 0.670, 0.670, 0.680, 0.680, 0.680, 0.680, 0.680, 0.680, 0.680, 0.680, 0.680, 0.680, 0.680];
cn45_params{3} = [1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    0.,    0.,    1.,    1.];
cn45_params{4} = [0., 0.010, 0.008, 0.024, 0.012, 0.012, 0.030, 0.030, 0.030, 0.012, 0.030, 0.030, 0.030, 0.030, 0.030, 0.030, 0.030, 0.030, 0.030, 0.030];
cn45_params{5} = [0.,0.00125,0.001, 0.003,0.0015,0.0015, 0.004, 0.004, 0.004,    0.,    0.,    0.,    0.,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
cn45_params{6} = [1.,   35.,   40.,   25.,   30.,   30.,   25.,   25.,   25.,   30.,   25.,   25.,   25.,   25.,   25.,   25.,   25.,   25.,   25.,   25.];
cn45_params{7} = [0.,0.0509,0.0466,0.0546,0.0461,0.0515,0.0716,0.1007,0.1007,0.0517,0.0943,0.0943,0.0943,0.1365,0.1365,0.1365,0.0900,0.0900,0.1758,0.1758];
cn45_params{8} = [0.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.]; % largely changed from CLM4!
cn45_params{9} = [0.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
cn45_params{10} = [1.,   70.,   80.,   50.,   60.,   60.,   50.,   50.,   50.,   60.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.];
cn45_params{11} = [1.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.,   42.];
cn45_params{12} = [1.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,   50.,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
cn45_params{13} = [1.,  500.,  500.,  500.,  500.,  500.,  500.,  500.,  500.,  500.,  500.,  500.,  500.,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
cn45_params{14} = [0.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    2.,    2.,    2.,    2.,    2.,    2.];
cn45_params{15} = [0.,   -1.,   -1.,   -1.,   -1.,   -1.,   -1.,   -1.,   -1.,   0.2,   0.2,   0.2,   0.2,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
cn45_params{16} = [0.,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
cn45_params{17} = [0.,   0.1,   0.1,   0.1,   0.1,   0.1,   0.1,   0.1,   0.1,   0.5,   0.5,   0.5,   0.1,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
cn45_params{18} = [0.,   1.0,   1.0,   0.5,   1.0,   1.0,   0.5,   0.5,   0.5,   1.0,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5]; %! our fix, same as CLM4 Catchment-CN, fzeng, 10 May 2018
cn45_params{19} = [0.,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25];
  cn45_params{20} = [0.,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5];
  cn45_params{21} = [0.,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25];
  cn45_params{22} = [0.,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25];
  cn45_params{23} = [0.,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5,   0.5];
  cn45_params{24} = [0.,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25,  0.25];
  cn45_params{25} = [0.,    3.,    6.,    1.,   1.5,   1.5,    1.,    1.,    1.,   1.5,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.];
  cn45_params{26} = [0.,    1.,    1.,    0.,    1.,    1.,    0.,    0.,    0.,    1.,    0.,    0.,    0.,    0.,    0.,    0.,    0.,    0.,    0.,    0.];
  cn45_params{27} = [0.,    0.,    0.,    0.,    0.,    0.,    1.,    0.,    0.,    0.,    1.,    1.,    0.,    0.,    1.,    1.,    1.,    1.,    1.,    1.];
  cn45_params{28} = [0.,    0.,    0.,    1.,    0.,    0.,    0.,    1.,    1.,    0.,    0.,    0.,    1.,    1.,    0.,    0.,    0.,    0.,    0.,    0.];
  cn45_params{29} = [0.,  0.01,  0.01,  0.01,   0.1,   0.1,  0.01,  0.25,  0.25,  0.01,  0.25,  0.25,  0.25,  -0.3,  -0.3,  -0.3,  -0.3,  -0.3,  -0.3,  -0.3];
  cn45_params{30} = [0.,  0.07,  0.07,  0.07,   0.1,   0.1,   0.1,   0.1,   0.1,  0.07,   0.1,   0.1,   0.1,  0.11,  0.11,  0.11,  0.11,  0.11,  0.11,  0.11];
  cn45_params{31} = [0.,  0.16,  0.16,  0.16,  0.16,  0.16,  0.16,  0.16,  0.16,  0.16,  0.16,  0.16,  0.16,  0.31,  0.31,  0.31,  0.31,  0.31,  0.31,  0.31];
  cn45_params{32} = [0.,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05,  0.05];
  cn45_params{33} = [0., 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,  0.12,  0.12,  0.12,  0.12,  0.12,  0.12,  0.12];
  cn45_params{34} = [0.,  0.22,  0.25,  0.25,  0.22,  0.22,  0.60,  0.22,  0.22,   0.3,   0.3,   0.3,   0.3,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8]; %assume type 6 is 35% tree and 65% grass, fzeng, 2019   
  cn45_params{35} = [0.,   0.8,   0.8,   0.8,   0.8,   0.8,  0.80,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8]; %assume type 6 is 35% tree and 65% grass, fzeng, 2019
  cn45_params{36} = [0.,  0.22,  0.25,  0.25,  0.22,  0.22,  0.60,  0.22,  0.22,   0.3,   0.3,   0.3,   0.3,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8]; %assume type 6 is 35% tree and 65% grass, fzeng, 2019
  cn45_params{37} = [0.,  0.45,   0.5,   0.5,  0.45,  0.45,  0.68,  0.45,  0.45,  0.55,  0.55,  0.55,  0.55,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8]; % assume type 6 is 35% tree and 65% grass, fzeng, 2019
 cn45_params{38} = [0.,   0.8,   0.8,   0.8,   0.8,   0.8,  0.80,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8]; %assume type 6 is 35% tree and 65% grass, fzeng, 2019
 cn45_params{39} = [0.,  0.45,   0.5,   0.5,  0.45,  0.45,  0.64,  0.35,  0.45,  0.55,  0.55,  0.55,  0.55,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8]; %assume type 6 is 35% tree and 65% grass, fzeng, 2019
 cn45_params{40} = [0.,  0.45,   0.5,   0.5,  0.45,  0.45,  0.64,  0.35,  0.45,  0.55,  0.55,  0.55,  0.55,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8,   0.8]; %assume type 6 is 35% tree and 65% grass, fzeng, 2019
 cn45_params{41} = [0.,  0.13,  0.15,  0.15,  0.13,  0.13,  0.17,   0.1,  0.13,  0.17,  0.17,  0.17,  0.17,   0.2,   0.2,   0.2,   0.2,   0.2,   0.2,   0.2]; %assume type 6 is 35% tree and 65% grass, fzeng, 2019
 cn45_params{42} = [0.,  0.13,  0.15,  0.15,  0.13,  0.13,  0.17,   0.1,  0.13,  0.17,  0.17,  0.17,  0.17,   0.2,   0.2,   0.2,   0.2,   0.2,   0.2,   0.2]; % assume type 6 is 35% tree and 65% grass, fzeng, 2019
 cn45_params{43} = [0.,  0.13,  0.15,  0.15,  0.13,  0.13,  0.17,   0.1,  0.13,  0.17,  0.17,  0.17,  0.17,   0.2,   0.2,   0.2,   0.2,   0.2,   0.2,   0.2];
 cn45_params{44} = [0.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.,   24.];
 cn45_params{45} = [0.,   0.4,  0.43,  0.43,   0.4,   0.4,  0.53,   0.4,   0.4,  0.46,  0.46,  0.46,  0.46,  0.60,  0.60,  0.60,  0.60,  0.60,  0.60,  0.60]; % assume type 6 is 35% tree and 65% grass, fzeng, 2019
  cn45_params{46} = [0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3,   0.3];
  cn45_params{47} = [1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.,    1.];

param_name{1} = 'z0mr';
param_name{2} = 'displar';
param_name{3} = 'c3psn';
param_name{4} = 'slatop';
param_name{5} = 'dsladlai';
param_name{6} = 'leafcn';
param_name{7} = 'flnr';

translation_vector = [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19;
                      0 1 2 3 4 5 6 7 8 9 10 10 11 12 13 13 14 14 15 15];

for v = 1:length(cn51_params)
    for i = 1:16

        cn45_index = find(translation_vector(2,:)==(i-1));

        param_mat{v}(i,1) = cn51_params{v}(i);
        param_mat{v}(i,2) = nanmean(cn45_params{v}(cn45_index));

    end
end
