clc
clear all
close all

exp_path = '/discover/nobackup/jkolassa/CN51_global/';
exp_name = 'GEOSldas_CN51_280_global';

exp_c2_path = '/discover/nobackup/jkolassa/CN51_global/';
exp_c2_name = 'GEOSldas_CN51_280_global_c2';

fix_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/';
fix_name = 'GEOSldas_CN51_local_280_test_pft10';

precip_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/';
precip_name = 'GEOSldas_CN51_local_280_test_precip';

temp_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/';
temp_name = 'GEOSldas_CN51_local_280_test_temp';

rzmc_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/';
rzmc_name = 'GEOSldas_CN51_local_280_test_rzmc';

cn45_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/';
cn45_name = 'GEOSldas_CN45_local_390_test_pft10';

cn45_280_path = '/discover/nobackup/jkolassa/test_new/';
cn45_280_name = 'GEOSldas_CN45_global_280';

gcfix_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/';
gcfix_name = 'GEOSldas_CN51_local_280_test_debug';

clm5_path = '/discover/nobackup/projects/geoscm/fzeng/CLM/archive/clm5_test/lnd/hist/';

start_year = 1980;
stop_year = 2019;

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

cn51_read_file = [exp_path exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' exp_name '.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));

fix_read_file = [fix_path fix_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' fix_name '.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
fix_lat_vec = double(ncread(fix_read_file,'lat'));
fix_lon_vec = double(ncread(fix_read_file,'lon'));

gcfix_read_file = [gcfix_path gcfix_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' gcfix_name '.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
gcfix_lat_vec = double(ncread(gcfix_read_file,'lat'));
gcfix_lon_vec = double(ncread(gcfix_read_file,'lon'));

fix_day_file = [fix_path fix_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' fix_name '.tavg24_1d_lnd_Nt.19800101_1200z.nc4'];
fix_day_cntlai = double(ncread(fix_day_file,'CNTLAI'));

precip_read_file = [precip_path precip_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' precip_name '.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
precip_lat_vec = double(ncread(precip_read_file,'lat'));
precip_lon_vec = double(ncread(precip_read_file,'lon'));

temp_read_file = [temp_path temp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' temp_name '.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
temp_lat_vec = double(ncread(temp_read_file,'lat'));
temp_lon_vec = double(ncread(temp_read_file,'lon'));

rzmc_read_file = [rzmc_path rzmc_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' rzmc_name '.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
rzmc_lat_vec = double(ncread(rzmc_read_file,'lat'));
rzmc_lon_vec = double(ncread(rzmc_read_file,'lon'));

cn45_read_file = [cn45_path cn45_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/' cn45_name '.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
cn45_lat_vec = double(ncread(cn45_read_file,'lat'));
cn45_lon_vec = double(ncread(cn45_read_file,'lon'));

cn51_rst_file = [exp_path exp_name '/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/' exp_name '.catchcnclm51_internal_rst.19800101_0000'];
ityp_data = ncread(cn51_rst_file,'ITY');
fveg_data = ncread(cn51_rst_file,'FVG');
cnpft_data = ncread(cn51_rst_file,'CNPFT');
elai_var_index = 69;
tlai_var_index = 73;
elai_data = cnpft_data(:,((elai_var_index-1)*6+1):(elai_var_index*6));
tlai_data = cnpft_data(:,((tlai_var_index-1)*6+1):(tlai_var_index*6));

clm5_read_file = [clm5_path 'clm5_test.clm2.h0.0001-01.nc'];
clm5_lat_vec = ncread(clm5_read_file,'lat');
clm5_lon_vec = ncread(clm5_read_file,'lon');
%convert CLM lons from [0 360] to [-180 180]
clm5_lon_vec = clm5_lon_vec-180;

for i = 1:length(lat_vec)

    dist_vec = sqrt((clm5_lat_vec-lat_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_lat_index(i) = min_index(1);

    dist_vec = sqrt((clm5_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_lon_index(i) = min_index(1);

end

mat_index = 0;
 y_index = 0;

for y = start_year:stop_year

    y_index = y_index + 1;
    y_str = num2str(y,'%04i');
    y_index_str = num2str(y_index,'%04i');

    % define month length based on leap year status
    if sum(y==leapYears)>0
       monthLength = monthLength_ly;
    else
       monthLength = monthLength_nly;
    end

    for m = 1:12

        mat_index = mat_index + 1;

        m_str = num2str(m,'%02i');

        % define file names

        exp_read_file = [exp_path exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' exp_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        exp_c2_read_file = [exp_c2_path exp_c2_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' exp_c2_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        fix_read_file = [fix_path fix_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' fix_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        precip_read_file = [precip_path precip_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' precip_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        temp_read_file = [temp_path temp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' temp_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        rzmc_read_file = [rzmc_path rzmc_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' rzmc_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        cn45_read_file = [cn45_path cn45_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' cn45_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        gcfix_read_file = [gcfix_path gcfix_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' gcfix_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        cn45_280_read_file = [cn45_280_path cn45_280_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' cn45_280_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        clm5_read_file = [clm5_path 'clm5_test.clm2.h0.' y_index_str '-' m_str '.nc'];

        if (mat_index==1)
           exp_cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_cncloss_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_et_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_evpsoil_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_evptrns_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_evpintr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_evpsbln_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

           exp_c2_cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_cncloss_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_et_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_evpsoil_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_evptrns_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_evpintr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp_c2_evpsbln_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

           fix_cngpp_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_cnnee_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_cncloss_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_cntlai_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_cntotc_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_et_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_evpsoil_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_evptrns_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_evpintr_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);
           fix_evpsbln_mat = NaN*ones(length(fix_lat_vec),(stop_year-start_year+1)*12);

           precip_cngpp_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_cnnee_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_cncloss_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_cntlai_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_cntotc_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_et_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_evpsoil_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_evptrns_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_evpintr_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);
           precip_evpsbln_mat = NaN*ones(length(precip_lat_vec),(stop_year-start_year+1)*12);

           temp_cngpp_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_cnnee_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_cncloss_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_cntlai_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_cntotc_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_et_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_evpsoil_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_evptrns_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_evpintr_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);
           temp_evpsbln_mat = NaN*ones(length(temp_lat_vec),(stop_year-start_year+1)*12);

           rzmc_cngpp_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_cnnee_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_cncloss_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_cntlai_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_cntotc_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_et_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_evpsoil_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_evptrns_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_evpintr_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);
           rzmc_evpsbln_mat = NaN*ones(length(rzmc_lat_vec),(stop_year-start_year+1)*12);

           cn45_cngpp_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_cnnee_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_cncloss_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_cntlai_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_cntotc_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_et_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_evpsoil_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_evptrns_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_evpintr_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);
           cn45_evpsbln_mat = NaN*ones(length(cn45_lat_vec),(stop_year-start_year+1)*12);

           gcfix_cngpp_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_cnnee_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_cncloss_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_cntlai_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_cntotc_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_et_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_evpsoil_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_evptrns_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_evpintr_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);
           gcfix_evpsbln_mat = NaN*ones(length(gcfix_lat_vec),(stop_year-start_year+1)*12);

           cn45_280_cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_cncloss_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_et_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_evpsoil_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_evptrns_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_evpintr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cn45_280_evpsbln_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

           clm5_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_lai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_closs_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_elai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_vegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_totc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
        end

        if exist(exp_read_file)

           exp_cngpp_mat(:,mat_index) = double(ncread(exp_read_file,'CNGPP'));
           exp_cnnee_mat(:,mat_index) = double(ncread(exp_read_file,'CNNEE'));
           exp_cncloss_mat(:,mat_index) = double(ncread(exp_read_file,'CLOSS'));
           exp_cntlai_mat(:,mat_index) = double(ncread(exp_read_file,'CNTLAI'));
           exp_cntotc_mat(:,mat_index) = double(ncread(exp_read_file,'CNTOTC'));
           exp_evpsoil_mat(:,mat_index) = double(ncread(exp_read_file,'EVPSOIL'));
           exp_evptrns_mat(:,mat_index) = double(ncread(exp_read_file,'EVPTRNS'));
           exp_evpintr_mat(:,mat_index) = double(ncread(exp_read_file,'EVPINTR'));
           exp_evpsbln_mat(:,mat_index) = double(ncread(exp_read_file,'EVPSBLN'));
           exp_et_mat(:,mat_index) = exp_evpsoil_mat(:,mat_index) + exp_evptrns_mat(:,mat_index) ...
                                      + exp_evpintr_mat(:,mat_index) + exp_evpsbln_mat(:,mat_index);
         else
           exp_cngpp_mat(:,mat_index) = NaN*ones(size(exp_cngpp_mat,1),1);
           exp_cnnee_mat(:,mat_index) = NaN*ones(size(exp_cnnee_mat,1),1);
           exp_cncloss_mat(:,mat_index) = NaN*ones(size(exp_cncloss_mat,1),1);
           exp_cntlai_mat(:,mat_index) = NaN*ones(size(exp_cntlai_mat,1),1);
           exp_cntotc_mat(:,mat_index) = NaN*ones(size(exp_cntotc_mat,1),1);
           exp_evpsoil_mat(:,mat_index) = NaN*ones(size(exp_evpsoil_mat,1),1);
           exp_evptrns_mat(:,mat_index) = NaN*ones(size(exp_evptrns_mat,1),1);
           exp_evpintr_mat(:,mat_index) = NaN*ones(size(exp_evpintr_mat,1),1);
           exp_evpsbln_mat(:,mat_index) = NaN*ones(size(exp_evpsbln_mat,1),1);
           exp_et_mat(:,mat_index) = NaN*ones(size(exp_et_mat,1),1);
        end


        if exist(exp_c2_read_file)

           exp_c2_cngpp_mat(:,mat_index) = double(ncread(exp_c2_read_file,'CNGPP'));
           exp_c2_cnnee_mat(:,mat_index) = double(ncread(exp_c2_read_file,'CNNEE'));
           exp_c2_cncloss_mat(:,mat_index) = double(ncread(exp_c2_read_file,'CLOSS'));
           exp_c2_cntlai_mat(:,mat_index) = double(ncread(exp_c2_read_file,'CNTLAI'));
           exp_c2_cntotc_mat(:,mat_index) = double(ncread(exp_c2_read_file,'CNTOTC'));
           exp_c2_evpsoil_mat(:,mat_index) = double(ncread(exp_c2_read_file,'EVPSOIL'));
           exp_c2_evptrns_mat(:,mat_index) = double(ncread(exp_c2_read_file,'EVPTRNS'));
           exp_c2_evpintr_mat(:,mat_index) = double(ncread(exp_c2_read_file,'EVPINTR'));
           exp_c2_evpsbln_mat(:,mat_index) = double(ncread(exp_c2_read_file,'EVPSBLN'));
           exp_c2_et_mat(:,mat_index) = exp_c2_evpsoil_mat(:,mat_index) + exp_c2_evptrns_mat(:,mat_index) ...
                                      + exp_c2_evpintr_mat(:,mat_index) + exp_c2_evpsbln_mat(:,mat_index);
         else 
           exp_c2_cngpp_mat(:,mat_index) = NaN*ones(size(exp_c2_cngpp_mat,1),1);
           exp_c2_cnnee_mat(:,mat_index) = NaN*ones(size(exp_c2_cnnee_mat,1),1);
           exp_c2_cncloss_mat(:,mat_index) = NaN*ones(size(exp_c2_cncloss_mat,1),1);
           exp_c2_cntlai_mat(:,mat_index) = NaN*ones(size(exp_c2_cntlai_mat,1),1);
           exp_c2_cntotc_mat(:,mat_index) = NaN*ones(size(exp_c2_cntotc_mat,1),1);
           exp_c2_evpsoil_mat(:,mat_index) = NaN*ones(size(exp_c2_evpsoil_mat,1),1);
           exp_c2_evptrns_mat(:,mat_index) = NaN*ones(size(exp_c2_evptrns_mat,1),1);
           exp_c2_evpintr_mat(:,mat_index) = NaN*ones(size(exp_c2_evpintr_mat,1),1);
           exp_c2_evpsbln_mat(:,mat_index) = NaN*ones(size(exp_c2_evpsbln_mat,1),1);
           exp_c2_et_mat(:,mat_index) = NaN*ones(size(exp_c2_et_mat,1),1);
        end  

        if exist(fix_read_file)

           fix_cngpp_mat(:,mat_index) = double(ncread(fix_read_file,'CNGPP'));
           fix_cnnee_mat(:,mat_index) = double(ncread(fix_read_file,'CNNEE'));
           fix_cncloss_mat(:,mat_index) = double(ncread(fix_read_file,'CLOSS'));
           fix_cntlai_mat(:,mat_index) = double(ncread(fix_read_file,'CNTLAI'));
           fix_cntotc_mat(:,mat_index) = double(ncread(fix_read_file,'CNTOTC'));
           fix_evpsoil_mat(:,mat_index) = double(ncread(fix_read_file,'EVPSOIL'));
           fix_evptrns_mat(:,mat_index) = double(ncread(fix_read_file,'EVPTRNS'));
           fix_evpintr_mat(:,mat_index) = double(ncread(fix_read_file,'EVPINTR'));
           fix_evpsbln_mat(:,mat_index) = double(ncread(fix_read_file,'EVPSBLN'));
           fix_et_mat(:,mat_index) = fix_evpsoil_mat(:,mat_index) + fix_evptrns_mat(:,mat_index) ...
                                      + fix_evpintr_mat(:,mat_index) + fix_evpsbln_mat(:,mat_index);
         else
           fix_cngpp_mat(:,mat_index) = NaN*ones(size(fix_cngpp_mat,1),1);
           fix_cnnee_mat(:,mat_index) = NaN*ones(size(fix_cnnee_mat,1),1);
           fix_cncloss_mat(:,mat_index) = NaN*ones(size(fix_cncloss_mat,1),1);
           fix_cntlai_mat(:,mat_index) = NaN*ones(size(fix_cntlai_mat,1),1);
           fix_cntotc_mat(:,mat_index) = NaN*ones(size(fix_cntotc_mat,1),1);
           fix_evpsoil_mat(:,mat_index) = NaN*ones(size(fix_evpsoil_mat,1),1);
           fix_evptrns_mat(:,mat_index) = NaN*ones(size(fix_evptrns_mat,1),1);
           fix_evpintr_mat(:,mat_index) = NaN*ones(size(fix_evpintr_mat,1),1);
           fix_evpsbln_mat(:,mat_index) = NaN*ones(size(fix_evpsbln_mat,1),1);
           fix_et_mat(:,mat_index) = NaN*ones(size(fix_et_mat,1),1);
        end

        if exist(precip_read_file)

           precip_cngpp_mat(:,mat_index) = double(ncread(precip_read_file,'CNGPP'));
           precip_cnnee_mat(:,mat_index) = double(ncread(precip_read_file,'CNNEE'));
           precip_cncloss_mat(:,mat_index) = double(ncread(precip_read_file,'CLOSS'));
           precip_cntlai_mat(:,mat_index) = double(ncread(precip_read_file,'CNTLAI'));
           precip_cntotc_mat(:,mat_index) = double(ncread(precip_read_file,'CNTOTC'));
           precip_evpsoil_mat(:,mat_index) = double(ncread(precip_read_file,'EVPSOIL'));
           precip_evptrns_mat(:,mat_index) = double(ncread(precip_read_file,'EVPTRNS'));
           precip_evpintr_mat(:,mat_index) = double(ncread(precip_read_file,'EVPINTR'));
           precip_evpsbln_mat(:,mat_index) = double(ncread(precip_read_file,'EVPSBLN'));
           precip_et_mat(:,mat_index) = precip_evpsoil_mat(:,mat_index) + precip_evptrns_mat(:,mat_index) ... 
                                      + precip_evpintr_mat(:,mat_index) + precip_evpsbln_mat(:,mat_index);
         else
           precip_cngpp_mat(:,mat_index) = NaN*ones(size(precip_cngpp_mat,1),1);
           precip_cnnee_mat(:,mat_index) = NaN*ones(size(precip_cnnee_mat,1),1);
           precip_cncloss_mat(:,mat_index) = NaN*ones(size(precip_cncloss_mat,1),1);
           precip_cntlai_mat(:,mat_index) = NaN*ones(size(precip_cntlai_mat,1),1);
           precip_cntotc_mat(:,mat_index) = NaN*ones(size(precip_cntotc_mat,1),1);
           precip_evpsoil_mat(:,mat_index) = NaN*ones(size(precip_evpsoil_mat,1),1);
           precip_evptrns_mat(:,mat_index) = NaN*ones(size(precip_evptrns_mat,1),1);
           precip_evpintr_mat(:,mat_index) = NaN*ones(size(precip_evpintr_mat,1),1);
           precip_evpsbln_mat(:,mat_index) = NaN*ones(size(precip_evpsbln_mat,1),1);
           precip_et_mat(:,mat_index) = NaN*ones(size(precip_et_mat,1),1);
        end 


        if exist(temp_read_file)

           temp_cngpp_mat(:,mat_index) = double(ncread(temp_read_file,'CNGPP'));
           temp_cnnee_mat(:,mat_index) = double(ncread(temp_read_file,'CNNEE'));
           temp_cncloss_mat(:,mat_index) = double(ncread(temp_read_file,'CLOSS'));
           temp_cntlai_mat(:,mat_index) = double(ncread(temp_read_file,'CNTLAI'));
           temp_cntotc_mat(:,mat_index) = double(ncread(temp_read_file,'CNTOTC'));
           temp_evpsoil_mat(:,mat_index) = double(ncread(temp_read_file,'EVPSOIL'));
           temp_evptrns_mat(:,mat_index) = double(ncread(temp_read_file,'EVPTRNS'));
           temp_evpintr_mat(:,mat_index) = double(ncread(temp_read_file,'EVPINTR'));
           temp_evpsbln_mat(:,mat_index) = double(ncread(temp_read_file,'EVPSBLN'));
           temp_et_mat(:,mat_index) = temp_evpsoil_mat(:,mat_index) + temp_evptrns_mat(:,mat_index) ... 
                                      + temp_evpintr_mat(:,mat_index) + temp_evpsbln_mat(:,mat_index);
         else
           temp_cngpp_mat(:,mat_index) = NaN*ones(size(temp_cngpp_mat,1),1);
           temp_cnnee_mat(:,mat_index) = NaN*ones(size(temp_cnnee_mat,1),1);
           temp_cncloss_mat(:,mat_index) = NaN*ones(size(temp_cncloss_mat,1),1);
           temp_cntlai_mat(:,mat_index) = NaN*ones(size(temp_cntlai_mat,1),1);
           temp_cntotc_mat(:,mat_index) = NaN*ones(size(temp_cntotc_mat,1),1);
           temp_evpsoil_mat(:,mat_index) = NaN*ones(size(temp_evpsoil_mat,1),1);
           temp_evptrns_mat(:,mat_index) = NaN*ones(size(temp_evptrns_mat,1),1);
           temp_evpintr_mat(:,mat_index) = NaN*ones(size(temp_evpintr_mat,1),1);
           temp_evpsbln_mat(:,mat_index) = NaN*ones(size(temp_evpsbln_mat,1),1);
           temp_et_mat(:,mat_index) = NaN*ones(size(temp_et_mat,1),1);
        end 

        if exist(rzmc_read_file)

           rzmc_cngpp_mat(:,mat_index) = double(ncread(rzmc_read_file,'CNGPP'));
           rzmc_cnnee_mat(:,mat_index) = double(ncread(rzmc_read_file,'CNNEE'));
           rzmc_cncloss_mat(:,mat_index) = double(ncread(rzmc_read_file,'CLOSS'));
           rzmc_cntlai_mat(:,mat_index) = double(ncread(rzmc_read_file,'CNTLAI'));
           rzmc_cntotc_mat(:,mat_index) = double(ncread(rzmc_read_file,'CNTOTC'));
           rzmc_evpsoil_mat(:,mat_index) = double(ncread(rzmc_read_file,'EVPSOIL'));
           rzmc_evptrns_mat(:,mat_index) = double(ncread(rzmc_read_file,'EVPTRNS'));
           rzmc_evpintr_mat(:,mat_index) = double(ncread(rzmc_read_file,'EVPINTR'));
           rzmc_evpsbln_mat(:,mat_index) = double(ncread(rzmc_read_file,'EVPSBLN'));
           rzmc_et_mat(:,mat_index) = rzmc_evpsoil_mat(:,mat_index) + rzmc_evptrns_mat(:,mat_index) ...
                                      + rzmc_evpintr_mat(:,mat_index) + rzmc_evpsbln_mat(:,mat_index);
         else
           rzmc_cngpp_mat(:,mat_index) = NaN*ones(size(rzmc_cngpp_mat,1),1);
           rzmc_cnnee_mat(:,mat_index) = NaN*ones(size(rzmc_cnnee_mat,1),1);
           rzmc_cncloss_mat(:,mat_index) = NaN*ones(size(rzmc_cncloss_mat,1),1);
           rzmc_cntlai_mat(:,mat_index) = NaN*ones(size(rzmc_cntlai_mat,1),1);
           rzmc_cntotc_mat(:,mat_index) = NaN*ones(size(rzmc_cntotc_mat,1),1);
           rzmc_evpsoil_mat(:,mat_index) = NaN*ones(size(rzmc_evpsoil_mat,1),1);
           rzmc_evptrns_mat(:,mat_index) = NaN*ones(size(rzmc_evptrns_mat,1),1);
           rzmc_evpintr_mat(:,mat_index) = NaN*ones(size(rzmc_evpintr_mat,1),1);
           rzmc_evpsbln_mat(:,mat_index) = NaN*ones(size(rzmc_evpsbln_mat,1),1);
           rzmc_et_mat(:,mat_index) = NaN*ones(size(rzmc_et_mat,1),1);
        end


        if exist(cn45_read_file)

           cn45_cngpp_mat(:,mat_index) = double(ncread(cn45_read_file,'CNGPP'));
           cn45_cnnee_mat(:,mat_index) = double(ncread(cn45_read_file,'CNNEE'));
           cn45_cncloss_mat(:,mat_index) = double(ncread(cn45_read_file,'CLOSS'));
           cn45_cntlai_mat(:,mat_index) = double(ncread(cn45_read_file,'CNTLAI'));
           cn45_cntotc_mat(:,mat_index) = double(ncread(cn45_read_file,'CNTOTC'));
           cn45_evpsoil_mat(:,mat_index) = double(ncread(cn45_read_file,'EVPSOIL'));
           cn45_evptrns_mat(:,mat_index) = double(ncread(cn45_read_file,'EVPTRNS'));
           cn45_evpintr_mat(:,mat_index) = double(ncread(cn45_read_file,'EVPINTR'));
           cn45_evpsbln_mat(:,mat_index) = double(ncread(cn45_read_file,'EVPSBLN'));
           cn45_et_mat(:,mat_index) = cn45_evpsoil_mat(:,mat_index) + cn45_evptrns_mat(:,mat_index) ...
                                      + cn45_evpintr_mat(:,mat_index) + cn45_evpsbln_mat(:,mat_index);
         else
           cn45_cngpp_mat(:,mat_index) = NaN*ones(size(cn45_cngpp_mat,1),1);
           cn45_cnnee_mat(:,mat_index) = NaN*ones(size(cn45_cnnee_mat,1),1);
           cn45_cncloss_mat(:,mat_index) = NaN*ones(size(cn45_cncloss_mat,1),1);
           cn45_cntlai_mat(:,mat_index) = NaN*ones(size(cn45_cntlai_mat,1),1);
           cn45_cntotc_mat(:,mat_index) = NaN*ones(size(cn45_cntotc_mat,1),1);
           cn45_evpsoil_mat(:,mat_index) = NaN*ones(size(cn45_evpsoil_mat,1),1);
           cn45_evptrns_mat(:,mat_index) = NaN*ones(size(cn45_evptrns_mat,1),1);
           cn45_evpintr_mat(:,mat_index) = NaN*ones(size(cn45_evpintr_mat,1),1);
           cn45_evpsbln_mat(:,mat_index) = NaN*ones(size(cn45_evpsbln_mat,1),1);
           cn45_et_mat(:,mat_index) = NaN*ones(size(cn45_et_mat,1),1);
        end

        if exist(gcfix_read_file)

           gcfix_cngpp_mat(:,mat_index) = double(ncread(gcfix_read_file,'CNGPP'));
           gcfix_cnnee_mat(:,mat_index) = double(ncread(gcfix_read_file,'CNNEE'));
           gcfix_cncloss_mat(:,mat_index) = double(ncread(gcfix_read_file,'CLOSS'));
           gcfix_cntlai_mat(:,mat_index) = double(ncread(gcfix_read_file,'CNTLAI'));
           gcfix_cntotc_mat(:,mat_index) = double(ncread(gcfix_read_file,'CNTOTC'));
           gcfix_evpsoil_mat(:,mat_index) = double(ncread(gcfix_read_file,'EVPSOIL'));
           gcfix_evptrns_mat(:,mat_index) = double(ncread(gcfix_read_file,'EVPTRNS'));
           gcfix_evpintr_mat(:,mat_index) = double(ncread(gcfix_read_file,'EVPINTR'));
           gcfix_evpsbln_mat(:,mat_index) = double(ncread(gcfix_read_file,'EVPSBLN'));
           gcfix_et_mat(:,mat_index) = gcfix_evpsoil_mat(:,mat_index) + gcfix_evptrns_mat(:,mat_index) ... 
                                      + gcfix_evpintr_mat(:,mat_index) + gcfix_evpsbln_mat(:,mat_index);
         else
           gcfix_cngpp_mat(:,mat_index) = NaN*ones(size(gcfix_cngpp_mat,1),1);
           gcfix_cnnee_mat(:,mat_index) = NaN*ones(size(gcfix_cnnee_mat,1),1);
           gcfix_cncloss_mat(:,mat_index) = NaN*ones(size(gcfix_cncloss_mat,1),1);
           gcfix_cntlai_mat(:,mat_index) = NaN*ones(size(gcfix_cntlai_mat,1),1);
           gcfix_cntotc_mat(:,mat_index) = NaN*ones(size(gcfix_cntotc_mat,1),1);
           gcfix_evpsoil_mat(:,mat_index) = NaN*ones(size(gcfix_evpsoil_mat,1),1);
           gcfix_evptrns_mat(:,mat_index) = NaN*ones(size(gcfix_evptrns_mat,1),1);
           gcfix_evpintr_mat(:,mat_index) = NaN*ones(size(gcfix_evpintr_mat,1),1);
           gcfix_evpsbln_mat(:,mat_index) = NaN*ones(size(gcfix_evpsbln_mat,1),1);
           gcfix_et_mat(:,mat_index) = NaN*ones(size(gcfix_et_mat,1),1);
        end 

        if exist(cn45_280_read_file)

           cn45_280_cngpp_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CNGPP'));
           cn45_280_cnnee_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CNNEE'));
           cn45_280_cncloss_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CLOSS'));
           cn45_280_cntlai_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CNTLAI'));
           cn45_280_cntotc_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CNTOTC'));
           cn45_280_evpsoil_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPSOIL'));
           cn45_280_evptrns_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPTRNS'));
           cn45_280_evpintr_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPINTR'));
           cn45_280_evpsbln_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPSBLN'));
           cn45_280_et_mat(:,mat_index) = cn45_280_evpsoil_mat(:,mat_index) + cn45_280_evptrns_mat(:,mat_index) ... 
                                      + cn45_280_evpintr_mat(:,mat_index) + cn45_280_evpsbln_mat(:,mat_index);
         else
           cn45_280_cngpp_mat(:,mat_index) = NaN*ones(size(cn45_280_cngpp_mat,1),1);
           cn45_280_cnnee_mat(:,mat_index) = NaN*ones(size(cn45_280_cnnee_mat,1),1);
           cn45_280_cncloss_mat(:,mat_index) = NaN*ones(size(cn45_280_cncloss_mat,1),1);
           cn45_280_cntlai_mat(:,mat_index) = NaN*ones(size(cn45_280_cntlai_mat,1),1);
           cn45_280_cntotc_mat(:,mat_index) = NaN*ones(size(cn45_280_cntotc_mat,1),1);
           cn45_280_evpsoil_mat(:,mat_index) = NaN*ones(size(cn45_280_evpsoil_mat,1),1);
           cn45_280_evptrns_mat(:,mat_index) = NaN*ones(size(cn45_280_evptrns_mat,1),1);
           cn45_280_evpintr_mat(:,mat_index) = NaN*ones(size(cn45_280_evpintr_mat,1),1);
           cn45_280_evpsbln_mat(:,mat_index) = NaN*ones(size(cn45_280_evpsbln_mat,1),1);
           cn45_280_et_mat(:,mat_index) = NaN*ones(size(cn45_280_et_mat,1),1);
        end

        if exist(clm5_read_file)
           tmp_gpp = double(ncread(clm5_read_file,'GPP'));
           tmp_nee = double(ncread(clm5_read_file,'NEE'));
           tmp_closs = double(ncread(clm5_read_file,'COL_FIRE_CLOSS'));
           tmp_lai = double(ncread(clm5_read_file,'TLAI'));
           tmp_elai = double(ncread(clm5_read_file,'ELAI'));
           tmp_vegc = double(ncread(clm5_read_file,'TOTVEGC'));
           tmp_totc = double(ncread(clm5_read_file,'TOTCOLC'));
           for l = 1:length(lat_vec)
               clm5_gpp_mat(l,mat_index) = tmp_gpp(clm5_lon_index(l),clm5_lat_index(l));
               clm5_nee_mat(l,mat_index) = tmp_nee(clm5_lon_index(l),clm5_lat_index(l));
               clm5_closs_mat(l,mat_index) = tmp_closs(clm5_lon_index(l),clm5_lat_index(l));
               clm5_elai_mat(l,mat_index) = tmp_elai(clm5_lon_index(l),clm5_lat_index(l));
               clm5_lai_mat(l,mat_index) = tmp_lai(clm5_lon_index(l),clm5_lat_index(l));
               clm5_vegc_mat(l,mat_index) = tmp_vegc(clm5_lon_index(l),clm5_lat_index(l));
               clm5_totc_mat(l,mat_index) = tmp_totc(clm5_lon_index(l),clm5_lat_index(l));
           end
         else
           clm5_gpp_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_nee_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_closs_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_lai_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_elai_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_vegc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_totc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
         end
 

        datenum_vec(mat_index) = datenum(y,m,30);
        year_vec(mat_index) = y;
        month_vec(mat_index) = m;

    end % m
end % y

% convert CLM5 carbon fluxes from gC/m2/s to kgC/m2/s
% and states from gc/m2 to kgC/m2

clm5_gpp_mat = clm5_gpp_mat*10^(-3);
clm5_nee_mat = clm5_nee_mat*10^(-3);
clm5_closs_mat = clm5_closs_mat*10^(-3);
clm5_vegc_mat = clm5_vegc_mat*10^(-3);
clm5_totc_mat = clm5_totc_mat*10^(-3);


ann_index = 0;

for y = start_year:stop_year

    ann_index = ann_index + 1;
    year_index = (year_vec==y);

    tmp = exp_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_exp(:,ann_index) = nanmean(tmp,2);

    tmp = exp_et_mat(:,year_index);
    mean_global_ann_et_exp(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_exp(:,ann_index) = nanmean(tmp,2);

    tmp = fix_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_fix(:,ann_index) = nanmean(tmp,2);

    tmp = fix_et_mat(:,year_index);
    mean_global_ann_et_fix(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_fix(:,ann_index) = nanmean(tmp,2);

    tmp = precip_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_precip(:,ann_index) = nanmean(tmp,2);

    tmp = precip_et_mat(:,year_index);
    mean_global_ann_et_precip(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_precip(:,ann_index) = nanmean(tmp,2);

    tmp = temp_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_temp(:,ann_index) = nanmean(tmp,2);

    tmp = temp_et_mat(:,year_index);
    mean_global_ann_et_temp(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_temp(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = rzmc_et_mat(:,year_index);
    mean_global_ann_et_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_et_mat(:,year_index);
    mean_global_ann_et_cn45(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_cn45(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = gcfix_et_mat(:,year_index);
    mean_global_ann_et_gcfix(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_gcfix(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = cn45_280_et_mat(:,year_index);
    mean_global_ann_et_cn45_280(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_cn45_280(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_cngpp_mat(:,year_index);
    mean_global_ann_cngpp_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_cnnee_mat(:,year_index);
    mean_global_ann_cnnee_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_cncloss_mat(:,year_index);
    mean_global_ann_cncloss_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_cncloss_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_cntlai_mat(:,year_index);
    mean_global_ann_cntlai_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_cntotc_mat(:,year_index);
    mean_global_ann_cntotc_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_evpsoil_mat(:,year_index);
    mean_global_ann_evpsoil_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsoil_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_evptrns_mat(:,year_index);
    mean_global_ann_evptrns_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_evptrns_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_evpintr_mat(:,year_index);
    mean_global_ann_evpintr_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpintr_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_evpsbln_mat(:,year_index);
    mean_global_ann_evpsbln_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_evpsbln_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = exp_c2_et_mat(:,year_index);
    mean_global_ann_et_exp_c2(ann_index) = nanmean(tmp(:));
    mean_local_ann_et_exp_c2(:,ann_index) = nanmean(tmp,2);

    tmp = clm5_gpp_mat(:,year_index);
    mean_global_ann_clm5_cngpp(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_cngpp(:,ann_index) = nanmean(tmp,2);

    tmp = clm5_nee_mat(:,year_index);
    mean_global_ann_clm5_cnnee(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_cnnee(:,ann_index) = nanmean(tmp,2);

    tmp = clm5_closs_mat(:,year_index);
    mean_global_ann_clm5_cncloss(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_cncloss(:,ann_index) = nanmean(tmp,2);

    tmp = clm5_lai_mat(:,year_index);
    mean_global_ann_clm5_cntlai(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_cntlai(:,ann_index) = nanmean(tmp,2);

    tmp = clm5_totc_mat(:,year_index);
    mean_global_ann_clm5_cntotc(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_cntotc(:,ann_index) = nanmean(tmp,2);

end

% find locations where vegetation dies off in first year

load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);

latlim = [-60 90];
lonlim = [-180 180];

nyears = 40;
nyears_cn45 = 10;
year_dieoff_total_c2 = NaN*ones(nyears,1);
year_dieoff_total = NaN*ones(nyears-1,1);
year_dieoff_total_cn45_280 = NaN*ones(nyears-1,1);


for i = 1:nyears
    year_data_index{i} = (mean_local_ann_cntlai_exp(:,i)~=0);
    year_data_index_cn45_280{i} = (mean_local_ann_cntlai_cn45_280(:,i)~=0);
    year_data_index_c2{i} = (mean_local_ann_cntlai_exp_c2(:,i)~=0);

    year_dieoff_index_c2{i} = (year_data_index{1}==1) & (year_data_index_c2{i}==0);
    year_dieoff_total_c2(i) = sum(year_dieoff_index_c2{i});

    if (i>=2)
       year_dieoff_index{i-1} = (year_data_index{1}==1) & (year_data_index{i}==0);
       year_dieoff_total(i-1) = sum(year_dieoff_index{i-1});

       year_dieoff_index_cn45_280{i-1} = (year_data_index_cn45_280{1}==1) & (year_data_index_cn45_280{i}==0);
       year_dieoff_total_cn45_280(i-1) = sum(year_dieoff_index_cn45_280{i-1});
    

       clm5_dieoff_lai{i-1} = mean_local_ann_clm5_cngpp(year_dieoff_index{i-1},i);
       tmp = year_dieoff_index{i-1} + isnan(mean_local_ann_clm5_cngpp(:,i));
       clm5_dieoff_lai_undef_index{i-1} = tmp==2;
       clm5_dieoff_undef(i-1) = sum(isnan(clm5_dieoff_lai{i-1}));
 
       tmp = mean_local_ann_clm5_cngpp(:,1:25);
       q_vec = quantile(tmp(:),0:0.1:1);
       q_index = NaN*ones(size(clm5_dieoff_lai{i-1}));

       for j = 1:length(clm5_dieoff_lai{i-1})
           if isnan(clm5_dieoff_lai{i-1}(j))==0
              lt_vec = clm5_dieoff_lai{i-1}(j)<=q_vec;
              one_index = find(lt_vec == 1);
              q_index(j) = one_index(1);
           end
       end

       clm5_dieoff_quantiles{i-1} = q_index;
 
       figure
       ax = axesm('miller','MapLatLimit',latlim,'MapLonLimit',lonlim,... 
            'FLatLimit',latlim,'FLonLimit',lonlim);
       framem off;
       %gridm on;
       setm(ax,'MLineLocation',10,'PLineLocation',10,'MeridianLabel','off',...      
           'ParallelLabel','on','MLabelLocation',10,'PLabelLocation',10,...       
           'MLabelParallel','south','FontSize',12)
       geoshow('landareas.shp', 'FaceColor', [1 1 1])
       scatterm(lat_vec(year_dieoff_index{i-1}),lon_vec(year_dieoff_index{i-1}),10,'filled','MarkerFaceColor','r','MarkerEdgeColor','k')
       hold on 
       scatterm(lat_vec(clm5_dieoff_lai_undef_index{i-1}),lon_vec(clm5_dieoff_lai_undef_index{i-1}),10,'filled','MarkerFaceColor','b','MarkerEdgeColor','k')
       plotm(coastlat, coastlon,'k')
       hold on                                       
       set(gca,'XLim',lonlim);
       set(gca,'YLim',latlim);
       tightmap
       title(['die-off locations year ' num2str(i-1)])
       set(gcf,'paperunits','centimeters')
       set(gcf,'paperposition',[1 1 17 15])
       saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/dieoff_locs_global_year' num2str(i-1)],'png')

       figure 
       h1 = histogram(clm5_dieoff_quantiles{i-1},'BinLimits',[1 11],'NumBins',11)
       title(['LAI in year ' num2str(i-1) ' dieoff locations; undefined: ' num2str(sum(isnan(clm5_dieoff_lai{i-1})))])
       set(gcf,'paperunits','centimeters')
       set(gcf,'paperposition',[1 1 17 15])
       saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/CLM5_LAIq_dieoff_year' num2str(i-1)],'png')
    end
end

year_dieoff_total_cn45_280(nyears_cn45+1:end) = NaN;

year_dieoff_total(year_dieoff_total==0) = NaN;
year_dieoff_total_c2(year_dieoff_total_c2==0) = NaN;
year_dieoff_total_cn45_280(year_dieoff_total_cn45_280==0) = NaN;

figure
plot(1:(nyears-1),year_dieoff_total,'LineWidth',2)
hold on
plot(1:(nyears),year_dieoff_total_c2,'LineWidth',2)
hold on
plot(1:(nyears-1),year_dieoff_total_cn45_280,'LineWidth',2)
hold on
plot(1:25,clm5_dieoff_undef(1:25),'LineWidth',2)
xlabel('simulation years')
ylabel('locations with 0 LAI in the year')
title('die-off locations')
legend('CN51 cycle 1','CN51 cycle 2','CN45','CLM5 undef')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/global_dieoff_locs'],'png')

%% find dominant PFT in die-off locations
%
%for i = 1:length(lat_vec)
%
%    max_index = find(fveg_data(i,:)==max(fveg_data(i,:)));
%    if length(max_index)>1
%      dom_ityp(i) = ityp_data(i,1);
%      dom_frac(i) = fveg_data(i,1);
%    else
%      dom_ityp(i) = ityp_data(i,max_index);
%      dom_frac(i) = fveg_data(i,max_index);
%    end
%
%    min_index = find(fveg_data(i,:)==min(fveg_data(i,:)));
%    if length(min_index)>1
%      sec_ityp(i) = ityp_data(i,2);
%      sec_frac(i) = fveg_data(i,2);
%    else
%      sec_ityp(i) = ityp_data(i,min_index);
%      sec_frac(i) = fveg_data(i,min_index);
%    end
%
%end
%
%dom_dieoff_mat = [dom_ityp(year1_dieoff_index)' dom_frac(year1_dieoff_index)'];
%sec_dieoff_mat = [sec_ityp(year1_dieoff_index)' sec_frac(year1_dieoff_index)'];
%
%figure
%histogram(dom_dieoff_mat(:,1))
%xlabel('PFT')
%ylabel('data count')
%title('PFTs of year 1 die-off locations')
%set(gcf,'paperunits','centimeters')
%set(gcf,'paperposition',[1 1 25 15])
%saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/PFT_dist_year1_dieoff_locs'],'png')
%
%year1_dieoff_tiles = find(year1_dieoff_index==1);
%
%for i = 1:50:length(year1_dieoff_tiles)
%
%    figure
%    LS = '-';
%    plot(datenum_vec(1:12),exp_cntlai_mat(year1_dieoff_tiles(i),1:12),'LineWidth',2);
%    grid on
%    datetick('x','mm-yyyy')
%    xlabel('date [mm-yyyy]')
%    ylabel('LAI [-]')
%    title('monthly average LAI [-] @280ppm')
%    set(gcf,'paperunits','centimeters')
%    set(gcf,'paperposition',[1 1 25 15])
%    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/CNTLAI_dieoff_mon_CN51_cycles_280_loc' num2str(i)],'png')
%end
%
%    n_months = 84;
%
%    figure
%    LS = '-';
%    plot(datenum_vec(1:n_months),exp_cntlai_mat(year1_dieoff_tiles(786),1:n_months),'LineWidth',2);
%    hold on 
%    plot(datenum_vec(1:n_months),fix_cntlai_mat(:,1:n_months),'LineWidth',2);
%    hold on
%    plot(datenum_vec(1:n_months),precip_cntlai_mat(:,1:n_months),'LineWidth',2);
%    hold on
%    plot(datenum_vec(1:n_months),temp_cntlai_mat(:,1:n_months),'LineWidth',2);
%    hold on
%    plot(datenum_vec(1:n_months),rzmc_cntlai_mat(:,1:n_months),'LineWidth',2);
%    hold on
%    plot(datenum_vec(1:n_months),cn45_cntlai_mat(:,1:n_months),'LineWidth',2);
%    hold on
%    plot(datenum_vec(1:n_months),gcfix_cntlai_mat(:,1:n_months),'LineWidth',2);
%    grid on
%    datetick('x','mm-yyyy')
%    xlabel('date [mm-yyyy]')
%    ylabel('LAI [-]')
%    title('monthly average LAI [-] @280ppm')
%    legend('baseline','water stress threshold','10mm precip','T + 10K','RZMC','CN45','GC fix')
%    set(gcf,'paperunits','centimeters')
%    set(gcf,'paperposition',[1 1 25 15])
%    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/CNTLAI_dieoff_mon_CN51_cycles_280_loc' num2str(786)],'png')
%
%datenum_plot_vec = [datenum(1980,1,1) datenum_vec];
%fix_cntlai_plot = [fix_day_cntlai fix_cntlai_mat];
%    figure
%    LS = '-';
%    plot(datenum_plot_vec(1:25),fix_cntlai_plot(:,1:25),'LineWidth',2);
%    grid on
%    datetick('x','mm-yyyy')
%    xlabel('date [mm-yyyy]')
%    ylabel('LAI [-]')
%    title('monthly average LAI [-] @280ppm')
%    %legend('baseline','CN45 params','10mm precip','T + 10K','RZMC','CN45')
%    set(gcf,'paperunits','centimeters')
%    set(gcf,'paperposition',[1 1 25 15])
%    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/CNTLAI_dieoff_mon_day1_loc' num2str(786)],'png')
%
%% compute initial LAI in dieoff locations
%
%elai_dieoff_mat = elai_data(year1_dieoff_index,:);
%tlai_dieoff_mat = tlai_data(year1_dieoff_index,:);
%
%% latitude and longitude information
%
%lat_dieoff_mat = lat_vec(year1_dieoff_index);
%lon_dieoff_mat = lon_vec(year1_dieoff_index);
%
%% locations at low latitudes and with significant vegetation
%
%max_tlai = max(tlai_dieoff_mat,[],2);
%candidate_locations = (abs(lat_dieoff_mat)<30) & (max_tlai>1);
%
%for i = 1:length(candidate_locations)
%    if candidate_locations(i)==1
%       figure
%       LS = '-';
%       plot(datenum_vec(1:12),exp_cntlai_mat(year1_dieoff_tiles(i),1:12),'LineWidth',2);
%       grid on
%       datetick('x','mm-yyyy')
%       xlabel('date [mm-yyyy]')
%       ylabel('LAI [-]')
%       title(['monthly average LAI [-] @280ppm lat: ' num2str(lat_dieoff_mat(i)) ' lon: ' num2str(lon_dieoff_mat(i))])
%       set(gcf,'paperunits','centimeters')
%       set(gcf,'paperposition',[1 1 25 15])
%       saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/CNTLAI_dieoff_mon_CN51_cycles_280_loc' num2str(i)],'png')
%    end
%end
%
%%% map year 1 dieoff locations
%%
%%% define plot domain
%%load coastlines;
%%[latcells, loncells] = polysplit(coastlat, coastlon);
%%latlim = lat_range;
%%lonlim = lon_range;
%%
%%
%%figure
%%ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
%%               'FLatLimit',lat_range,'FLonLimit',lon_range);
%%framem
%%gridm on; 
%%%    setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
%%%         'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
%%%          'MLabelParallel','south','FontSize',12)
%%setm(ax,'MLineLocation',5,'PLineLocation',5,...
%%     'ParallelLabel','on','PLabelLocation',5,...
%%     'MLabelParallel','south','FontSize',12)
%%geoshow('landareas.shp', 'FaceColor', [1 1 1],'FaceAlpha',0,'EdgeColor',[0 0 0]) 
%%    scatterm(ax,lat_vec(year1_dieoff_index),lon_vec(year1_dieoff_index),10,"filled","k")
%%    %plotm(coastlat, coastlon,'k')
%%    %hold on
%%    %plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-m','LineWidth',2)
%%    hold off 
%%    set(gca,'XLim',lonlim);
%%    set(gca,'YLim',latlim);
%%    tightmap
%%    title(['Locations with year 1 die-off'])
%%    set(gcf,'paperunits','centimeters')
%%    set(gcf,'paperposition',[1 1 17 15])
%%    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/tests/year1_dieoff_locs'],'png')
%%
%%
%%
