clc
clear all
close all


readPath = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_noDA_AMSRE_ASCAT/output/SMAP_EASEv2_M09_CONUS/';
catPath = [readPath 'cat/'];
anaPath = [readPath 'ana/'];
startYear = 2011;
stopYear = 2011;
startMonth = 7;
stopMonth = 9;

% account for data availability

startMonths = ones((stopYear-startYear+1),1);
startMonths(1) = startMonth;
stopMonths = 12*ones((stopYear-startYear+1),1);
stopMonths(end) = stopMonth;
totalMonths = sum(stopMonths-startMonths+1);

% account for effect of leap year

leapYears = 1992:4:2013;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

ensStr = {...
%     'ens0000';'ens0001';'ens0002';'ens0003';'ens0004';'ens0005';...
%     'ens0006';'ens0007';'ens0008';'ens0009';'ens0010';'ens0011';...
    'ens_avg'};
timeStr = {'0000z';'0300z';'0600z';'1200z';'1500z';'1800z';'2100z'};
yearIndex = 0;


for y = startYear:stopYear
    y
    
    yearStr = num2str(y);
    yearIndex = yearIndex + 1;
    
    if any(y==leapYears)
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end
    
    for m = startMonths(yearIndex):stopMonths(yearIndex)
        
        if m < 10
            monthStr = ['0' num2str(m)];
        else
            monthStr = num2str(m);
        end
        
        for d = 1:monthLength(m)
            
            if d < 10 
                dayStr = ['0' num2str(d)];
            else
                dayStr = num2str(d);
            end
            
            for i = 1:length(ensStr)
                
                catFile_new = [catPath ensStr{i} '/Y' yearStr '/M' monthStr '/'...
                    'AMSRE_ASCAT_DA_noDA_AMSRE_ASCAT.' ensStr{i} '.ldas_tile_daily_out.'...
                    yearStr monthStr dayStr '.bin'];

                
                for j = 2
                    
                    catFile_old = [catPath ensStr{i} '/Y' yearStr '/M' monthStr '/'...
                        'AMSRE_ASCAT_DA_noDA_AMSRE_ASCAT_' num2str(j) '.' ensStr{i} '.ldas_tile_daily_out.'...
                        yearStr monthStr dayStr '.bin'];
                    
                    if exist(catFile_old,'file')
                        
                        renameCmd = ['mv ' catFile_old ' ' catFile_new];
                        status = system(renameCmd);
                        
                        
                    end
                    
                    
                    for t = 1:length(timeStr)
                        
                        anaFile_new = [anaPath ensStr{i} '/Y' yearStr '/M' monthStr '/'...
                            'AMSRE_ASCAT_DA_noDA_AMSRE_ASCAT.' ensStr{i} '.ldas_ObsFcstAna.'...
                            yearStr monthStr dayStr '_' timeStr{t} '.bin'];
                        
                        anaFile_old = [anaPath ensStr{i} '/Y' yearStr '/M' monthStr '/'...
                            'AMSRE_ASCAT_DA_noDA_AMSRE_ASCAT_' num2str(j) '.' ensStr{i} '.ldas_ObsFcstAna.'...
                            yearStr monthStr dayStr '_' timeStr{t} '.bin'];
                        
                        if exist(anaFile_old,'file')
                            
                            renameCmd2 = ['mv ' anaFile_old ' ' anaFile_new];
                            status = system(renameCmd2);
                        
                        
                        end
                        
                    end
                    
                end

                
            end
            
            
        end
    end
end