function [tile_data] = read_tile_data(fname, N_tile, N_out_fields)

% read tile-space "tavg" or "inst" output from LDASsa
%  
% reichle  20 Jul 2010
% reichle,  4 Mar 2011 - adapted to read flexible number of N_out_fields
%
% ------------------------------------------------------------------

if ~exist('N_out_fields','var')
  N_out_fields = 44;
end

int_precision   = 'int32';      % precision of fortran tag
float_precision = 'float32';    % precision of data in input file

disp(['reading from ', fname])

ifp = fopen( fname, 'r', 'l' );

% read all records

tile_data = NaN*ones(N_out_fields,N_tile);

for i=1:N_out_fields
  
  fortran_tag = fread( ifp, 1, int_precision );
  tmp_data    = fread( ifp, [1 N_tile], float_precision );
  fortran_tag = fread( ifp, 1, int_precision );
  
  tile_data(i,:) = tmp_data;
  
end

fclose(ifp);
  
% ======= EOF ==========================================================
