function [bias_obs,bias_tcount] = read_obsbias_ldas_rst(fname)

%  
% draper, Apr 2013. 
%
% ------------------------------------------------------------------

int_precision   = 'int32';      % precision of fortran tag
float_precision = 'float32';    % precision of data in input file

disp(['reading from ', fname])

ifp = fopen( fname, 'r', 'b' );

fortran_tag = fread( ifp, 1, int_precision );
tmp_data    = fread( ifp, [1 3], int_precision );

N_cat       	= tmp_data(1); 
N_obs_type	= tmp_data(2); 
N_bias 		= tmp_data(3); 

% read all records

bias_obs = NaN*ones(N_cat,N_obs_type,N_bias); 
bias_tcount  = NaN*ones(N_cat,N_obs_type,N_bias,2); 

% read N_param

for j=1:N_bias
for i=1:N_obs_type

  fortran_tag = fread( ifp, 1, int_precision );
  tmp_data    = fread( ifp, [1 N_cat], float_precision );
  fortran_tag = fread( ifp, 1, int_precision );
  
  bias_obs(:,i,j) = tmp_data;

  for k=1:2

  fortran_tag = fread( ifp, 1, int_precision );
  tmp_data    = fread( ifp, [1 N_cat], int_precision );
  fortran_tag = fread( ifp, 1, int_precision );
  
  bias_tcount(:,i,j,k) = tmp_data;
 
end

  
end
end

fclose(ifp);

% ======= EOF ==========================================================
