function [rstrt_data] = read_catch_ldas_rst(fname, N_tile)

%  
% reichle,  5 Sep 2007
%
% ------------------------------------------------------------------

N_rstrt_fields = 25;

int_precision   = 'int32';      % precision of fortran tag
float_precision = 'float32';    % precision of data in input file

disp(['reading from ', fname])

ifp = fopen( fname, 'r', 'b' );

% read all records

tile_data = NaN*ones(N_rstrt_fields,N_tile);

for i=1:N_rstrt_fields
  
  fortran_tag = fread( ifp, 1, int_precision );
  tmp_data    = fread( ifp, [1 N_tile], float_precision );
  fortran_tag = fread( ifp, 1, int_precision );
  
  rstrt_data(i,:) = tmp_data;
  
end

fclose(ifp);
  
% ======= EOF ==========================================================
