
function [ cat_progn, cparam ] = read_catch_internal_rst( fname, N_tile);

% Q. Liu,  16 Dec 2010
% reichle, 10 Jan 2011
% 
% ------------------------------------------------------------------


int_precision   = 'int32';      % precision of fortran tag
float_precision = 'float32';    % precision of data in input file

disp(['read_catch_internal_rst.m: reading from ', fname])

ifp = fopen( fname, 'r', 'l' );

% records #1 to #30 store Catchment model parameters

for i=1:30
  
  fortran_tag        = fread( ifp,  1,         int_precision   );
  tmp_data_real(i,:) = fread( ifp, [1 N_tile], float_precision );
  fortran_tag        = fread( ifp,  1,         int_precision   );

end

cparam.bf1    = tmp_data_real( 1,:)';
cparam.bf2    = tmp_data_real( 2,:)';
cparam.bf3    = tmp_data_real( 3,:)';
cparam.vgwmax = tmp_data_real( 4,:)';
cparam.cdcr1  = tmp_data_real( 5,:)';
cparam.cdcr2  = tmp_data_real( 6,:)';
cparam.psis   = tmp_data_real( 7,:)';
cparam.bee    = tmp_data_real( 8,:)';
cparam.poros  = tmp_data_real( 9,:)';
cparam.wpwet  = tmp_data_real(10,:)';
cparam.cond   = tmp_data_real(11,:)';
cparam.gnu    = tmp_data_real(12,:)';
cparam.ars1   = tmp_data_real(13,:)';
cparam.ars2   = tmp_data_real(14,:)';
cparam.ars3   = tmp_data_real(15,:)';
cparam.ara1   = tmp_data_real(16,:)';
cparam.ara2   = tmp_data_real(17,:)';
cparam.ara3   = tmp_data_real(18,:)';
cparam.ara4   = tmp_data_real(19,:)';
cparam.arw1   = tmp_data_real(20,:)';
cparam.arw2   = tmp_data_real(21,:)';
cparam.arw3   = tmp_data_real(22,:)';
cparam.arw4   = tmp_data_real(23,:)';
cparam.tsa1   = tmp_data_real(24,:)';
cparam.tsa2   = tmp_data_real(25,:)';
cparam.tsb1   = tmp_data_real(26,:)';
cparam.tsb2   = tmp_data_real(27,:)';
cparam.atau   = tmp_data_real(28,:)';
cparam.btau   = tmp_data_real(29,:)';
cparam.vegcls = tmp_data_real(30,:)';
  
clear tmp_data_real

% ---------------------------------------------------------------
%
% records #31 to #52 store Catchment prognostic variables
% (except #43 which is for TSURF, which is a diagnostic)

% record #31 holds tc1, tc2, tc4, and tpsn1 (ie, 4*N_catd entries)

fortran_tag   = fread( ifp,  1,           int_precision   );
tmp_data_real = fread( ifp, [1 N_tile*4], float_precision );
fortran_tag   = fread( ifp,  1,           int_precision   );

cat_progn.tc1 = tmp_data_real(         1:   N_tile);
cat_progn.tc2 = tmp_data_real(  N_tile+1: 2*N_tile);
cat_progn.tc4 = tmp_data_real(2*N_tile+1: 3*N_tile);

clear tmp_data_real

% record #32 holds qa1, qa2, qa4, and qc_over_snow

fortran_tag   = fread( ifp,  1,           int_precision   );
tmp_data_real = fread( ifp, [1 N_tile*4], float_precision );
fortran_tag   = fread( ifp,  1,           int_precision   );

cat_progn.qa1 = tmp_data_real(         1: N_tile);
cat_progn.qa2 = tmp_data_real(  N_tile+1: 2*N_tile);
cat_progn.qa4 = tmp_data_real(2*N_tile+1: 3*N_tile);

clear tmp_data_real

% records #33 to #52 store rest of Catchment prognostic variables
% (except #43 which is for TSURF, which is a diagnostic)

for i=1:20
    fortran_tag        = fread( ifp,  1,         int_precision   );
    tmp_data_real(i,:) = fread( ifp, [1 N_tile], float_precision );
    fortran_tag        = fread( ifp,  1,         int_precision   );
end

cat_progn.capac  = tmp_data_real( 1,:);
cat_progn.catdef = tmp_data_real( 2,:);
cat_progn.rzexc  = tmp_data_real( 3,:);
cat_progn.srfexc = tmp_data_real( 4,:);

cat_progn.ght1   = tmp_data_real( 5,:);
cat_progn.ght2   = tmp_data_real( 6,:);
cat_progn.ght3   = tmp_data_real( 7,:);
cat_progn.ght4   = tmp_data_real( 8,:);
cat_progn.ght5   = tmp_data_real( 9,:);
cat_progn.ght6   = tmp_data_real(10,:);

% skip tmp_data_real(11,:) = record #43 (Tsurf not a prognostic variable!)

cat_progn.wesn1  = tmp_data_real(12,:);
cat_progn.wesn2  = tmp_data_real(13,:);
cat_progn.wesn3  = tmp_data_real(14,:);

cat_progn.htsn1  = tmp_data_real(15,:);
cat_progn.htsn2  = tmp_data_real(16,:);
cat_progn.htsn3  = tmp_data_real(17,:);

cat_progn.sndz1  = tmp_data_real(18,:);
cat_progn.sndz2  = tmp_data_real(19,:);
cat_progn.sndz3  = tmp_data_real(20,:);

% ignore the rest of the file

fclose(ifp);

% =========== EOF ===========================================
