function [cat_bias, N_catbias] = read_catbias_ldas_rst(fname, N_tile)

%  
% reichle, 27 Mar 2013
%
% ------------------------------------------------------------------

N_rst_fields = 25;

int_precision   = 'int32';      % precision of fortran tag
float_precision = 'float32';    % precision of data in input file

disp(['reading from ', fname])

ifp = fopen( fname, 'r', 'b' );

% read header

fortran_tag = fread( ifp, 1, int_precision );
tmp_data    = fread( ifp, [1 3], int_precision );
fortran_tag = fread( ifp, 1, int_precision );

model_dtstep = tmp_data(1);
N_tile_tmp   = tmp_data(2);
N_catbias    = tmp_data(3);

if N_tile_tmp~=N_tile

  error('inconsistent number of tiles')

end

% read trelax

cat_bias     = NaN*ones(N_rst_fields,N_catbias,N_tile);

for j=1:N_catbias
  
  for i=1:N_rst_fields
    
    fortran_tag = fread( ifp, 1, int_precision );
    tmp_data    = fread( ifp, [1 N_tile], float_precision );
    fortran_tag = fread( ifp, 1, int_precision );
    
    cat_bias(i,j,:) = tmp_data;
    
  end
end

fclose(ifp);

% ======= EOF ==========================================================
