function [tile_data] = read_adapt(fname, N_tile, N_adapt)

%  
% reichle, 18 Dec 2006
%
% ------------------------------------------------------------------

int_precision   = 'int32';      % precision of fortran tag
float_precision = 'float32';    % precision of data in input file

disp(['reading from ', fname])

ifp = fopen( fname, 'r', 'b' );

% read all records

tile_data = NaN*ones(N_adapt,N_tile);

for i=1:N_adapt
  
  fortran_tag = fread( ifp, 1, int_precision );
  tmp_data    = fread( ifp, [1 N_tile], float_precision );
  fortran_tag = fread( ifp, 1, int_precision );
  
  tile_data(i,:) = tmp_data;
  
end

fclose(ifp);
  
% ======= EOF ==========================================================
