function [SMOS_data, inc_angle, col_ind, row_ind, asc_flag, version, start_time, end_time, N_grid, tile_id] = ...
    read_SMOS_prep(fname, N_out_fields, read_ind_latlon ,data_product, ifp)

% Gabrielle De Lannoy, 04 Oct 2010
%
% Read various types of gridded files, related to SMOS.
%
% SMOS_data  = data, corresponding to the output fields [array(N_out_fields,N_grid,N_angle)]
% inc_angle  = incidence angles [array(N_angle)]
% col_ind    = EASE(v2) M36 column indices, or longitudes [array(N_grid)]
% row_ind    = EASE(v2) M36 row indices, or latitudes [array(N_grid)]
% asc_flag   = ascending or descending flag: 1=ascending, 0=descending [int]
% version    = SMOS processor version number [int]
% start_time = start data recording in this swath [structure]
% end_time   = end data recording in this swath [structure]
% N_grid     = number of grid cells [int]
% tile_id    = optional LDASsa tile_ids [array(N_grid)]
%
% ------------------------------------------------------------------

%                 % 1 - Col-index, 0-based;
                  % 2 - Row-index, 0-based; 
                  %OR (for nearest neighbour)
                  % 1 - Lon;
                  % 2 - Lat; 

%Tb-files:
%------------------------------------------------------------------
%N_out_fields     % 1 - Tbh 
                  % 2 - Tbv 

                  % 3 - heterogeneity index Tbh
                  % 4 - heterogeneity index Tbv

                  % 5 - # SMOS pixels in EASE grid pixel Tbh
                  % 6 - # SMOS pixels in EASE grid pixel Tbv

                  % 7 - RA Tbh
                  % 8 - RA Tbv
                  %=> repeated for T3 and T4 (9-16)
                  
%SM-files:
%------------------------------------------------------------------
%N_out_fields     % 1  - SM [N float] 
                  % 2  - ST [N float] 
                  % 3  - tau [N float] 
                  % 4  - Tbh 42.5^o simulated on antenna reference frame [N float]
                  % 5  - Tbv 42.5^o simulated on antenna reference frame [N float]
                  % 6  - RSTDSM [N float]
                  % 7  - RSTDST [N float]
                  % 8  - RSTDtau [N float]
                  % 9  - stdv in SM EASE pixel (heterogeneity index) [N float]
		          % 10 - number of SMOS SM pixels per EASE grid cell [N int] 

% 26SEP12 - GDL; added optional output of tile_id (for scaling files)
% 26OCT12 - GDL; added 'version' (to identify SMOS (re-)processor version)
% ------------------------------------------------------------------

int_precision   = 'int32';      % precision of fortran tag
float_precision = 'float32';    % precision of data in input file

disp(['reading from ', fname])

if ~exist('ifp','var')
  ifp = fopen( fname, 'r', 'b' );
end

fortran_tag  = fread( ifp, 1, int_precision );
tmp_data_int = fread( ifp, [1 2], int_precision );
fortran_tag  = fread( ifp, 1, int_precision );
asc_flag     = tmp_data_int(1);
version      = tmp_data_int(2);  %could be version# in SMOS-files, or Ndata_min in scalingfiles

fortran_tag = fread( ifp, 1, int_precision );
tmp_data_int = fread( ifp, [1 5], int_precision );
fortran_tag = fread( ifp, 1, int_precision );

start_time.year  = tmp_data_int(1);
start_time.month = tmp_data_int(2);
start_time.day   = tmp_data_int(3);
start_time.hour  = tmp_data_int(4);
start_time.min   = tmp_data_int(5);

fortran_tag = fread( ifp, 1, int_precision );
tmp_data_int = fread( ifp, [1 5], int_precision );
fortran_tag = fread( ifp, 1, int_precision );

end_time.year  = tmp_data_int(1);
end_time.month = tmp_data_int(2);
end_time.day   = tmp_data_int(3);
end_time.hour  = tmp_data_int(4);
end_time.min   = tmp_data_int(5);

if ~strcmp(data_product,'scaling')
    fortran_tag  = fread( ifp, 1, int_precision );
    tmp_data_int = fread( ifp, [1 2], int_precision );
    fortran_tag  = fread( ifp, 1, int_precision );

    N_grid  = tmp_data_int(1);
    N_angle = tmp_data_int(2);
    N_tile  = 1;
else
    fortran_tag  = fread( ifp, 1, int_precision );
    tmp_data_int = fread( ifp, [1 3], int_precision );
    fortran_tag  = fread( ifp, 1, int_precision );

    N_grid  = tmp_data_int(1);
    N_angle = tmp_data_int(2);
    N_tile  = tmp_data_int(3);
end

disp(['N_grid and N_angle:',num2str(N_grid),' and ' ,num2str(N_angle)]);

% read all records

if (N_grid > 1)

    fortran_tag = fread( ifp, 1,    int_precision );
    inc_angle   = fread( ifp, [1 N_angle], float_precision );
    fortran_tag = fread( ifp, 1,    int_precision );

    if (strcmp(read_ind_latlon,'ind'))

    fortran_tag = fread( ifp, 1,    int_precision );
    col_ind     = fread( ifp, [1 N_grid], int_precision );
    fortran_tag = fread( ifp, 1,    int_precision );

    fortran_tag = fread( ifp, 1,    int_precision );
    row_ind     = fread( ifp, [1 N_grid], int_precision );
    fortran_tag = fread( ifp, 1,    int_precision );

    elseif (strcmp(read_ind_latlon,'latlon'))
        
    fortran_tag = fread( ifp, 1,    int_precision );
    col_ind     = fread( ifp, [1 N_grid], float_precision );
    fortran_tag = fread( ifp, 1,    int_precision );
    
    fortran_tag = fread( ifp, 1,    int_precision );
    row_ind     = fread( ifp, [1 N_grid], float_precision );
    fortran_tag = fread( ifp, 1,    int_precision );

    elseif (strcmp(read_ind_latlon,'latlon_id') )

    fortran_tag = fread( ifp, 1,    int_precision );
    col_ind     = fread( ifp, [1 N_grid], float_precision );
    fortran_tag = fread( ifp, 1,    int_precision );
    
    fortran_tag = fread( ifp, 1,    int_precision );
    row_ind     = fread( ifp, [1 N_grid], float_precision );
    fortran_tag = fread( ifp, 1,    int_precision );

    for i=1:N_tile
     fortran_tag = fread( ifp, 1,    int_precision );
     tile_id(:,i)= fread( ifp, [1 N_grid], int_precision );  %before 12aug13: tile_id = fread( ifp, [1 N_grid], int_precision );
     fortran_tag = fread( ifp, 1,    int_precision );       
    end
    
    else
        
        error('not sure how the file looks like, based on the combination of input-specs')
        
    end

    SMOS_data = NaN*ones(N_out_fields,N_grid,N_angle);
    
    for i=1:N_out_fields
       for j=1:N_angle 

         if (((i == 5 || i==6 || i == 13 || i == 14) && ...
              ( strcmp(data_product,'SCLF1C') || strcmp(data_product,'BWLF1C'))) ||...
              ((i == 10) && strcmp(data_product,'SMUDP2') ))% || ...
              %((i == 5 || i==10) && strcmp(data_product,'scaling'))) 
          fortran_tag = fread( ifp, 1,    int_precision );
          tmp_data    = fread( ifp, [1 N_grid], int_precision );
          fortran_tag = fread( ifp, 1,    int_precision ); 
         else        
          fortran_tag = fread( ifp, 1, int_precision );
          tmp_data    = fread( ifp, [1 N_grid], float_precision );
          fortran_tag = fread( ifp, 1, int_precision );
         end
         
         SMOS_data(i,1:N_grid,j) = tmp_data(1:N_grid);
         
      end
    end

    SMOS_data = squeeze(SMOS_data);

else
    
    SMOS_data = NaN*ones(N_out_fields,1);
    col_ind   = NaN;
    row_ind   = NaN;
    inc_angle = NaN;
    
end

fclose(ifp);
  
% ======= EOF ==========================================================
