clc 
clear all 
close all

readPath = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_test/AMSRE_ASCAT_DA_test/output/SMAP_EASEv2_M09_GLOBAL/cat/ens_avg/Y2014/M04/';
gridPath = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_test/AMSRE_ASCAT_DA_test/output/SMAP_EASEv2_M09_GLOBAL/rc_out/';
readFiles = dir(readPath);
readFiles = readFiles(3:end);

[data_tag, data_units] = get_data_tag(10,46,46);
nrPoints = 1653157;

for i = 1%:length(readFiles)
    
    readFile = [readPath readFiles(i).name];
    [tile_data] = read_tile_data(readFile, nrPoints, 46);
    
    tileCoordFile = [gridPath 'AMSRE_ASCAT_DA_test.ldas_tilecoord.bin'];  
    [tile_coord ] = read_tilecoord( tileCoordFile, 0 );
    
    tileGridFile = [gridPath 'AMSRE_ASCAT_DA_test.ldas_tilegrids.bin'];
    [ tile_grid_g, tile_grid_d ] = read_tilegrids( tileGridFile );
    
    plot_lats = tile_coord.com_lat(1:nrPoints);
    plot_lons = tile_coord.com_lon(1:nrPoints);
    
end

map_plot(plot_lats,plot_lons,tile_data(3,:),data_tag{3},data_units{3})