
% mcm.m = "my color map"

% ------------------------------------------------------------------
%
% colorbars designed after 
%
% "The End of the Rainbow? Color Schemes for Improved Data Graphics"
%
% by A. Light and P. J. Bartlein
%
% EOS 85 (4), 385-391, 5 Oct 2004
%
% http://geography.uoregon.edu/datagraphics
%
% (local copy at janus:/usr0/users/reichle/matlab/color_scales.htm )
%
% reichle, 14 Oct 2004
%
% -----------------------------
%
% location of color_scale_files

%mcm_path = '/janus/usr0/users/reichle/matlab/color_scales_files/';
mcm_path = '~/matlab/color_scales_files/';

% pick neutral color for odd-numbered colorbars

%mcm_neutral = [ .6 .6 .6 ];
mcm_neutral = [ 1 1 1 ];

mcm_list = {'mcm_GrMg_16'; ...
	    'mcm_BrBu_10'; ...
	    'mcm_BrBu_12'; ...
	    'mcm_Bu_10'; ...
	    'mcm_Bu_7'; ...
	    'mcm_BuDOr_12'; ...
	    'mcm_BuDOr_18'; ...
	    'mcm_BuDRd_12'; ...
	    'mcm_BuDRd_18'; ...
	    'mcm_BuGr_14'; ...
	    'mcm_BuGy_8'; ...
	    'mcm_BuOr_10'; ...
	    'mcm_BuOr_12'; ...
	    'mcm_BuOr_8'; ...
	    'mcm_BuOrR_14'; ...
	    'mcm_Cat_12'; ...
	    'mcm_GrMg_16'};


% -----------------------------------------

for mcm_i=1:length(mcm_list)  
  
  % load colormap from RGB ".dat" file
  
  eval(['load -ascii ', mcm_path, '/', mcm_list{mcm_i},'.dat'])
  
  % find out number of colors
  
  mcm_N_tmp = eval( ['size(',mcm_list{mcm_i},',1)'] );
  
  % find out where the number of colors appear in the name
  
  mcm_ind_tmp = findstr( num2str(mcm_N_tmp), mcm_list{mcm_i} );
  
  % check whether number of colors matches what's in the name
  
  if isempty(mcm_ind_tmp)
    disp('mcm.m: ERROR with number of colors. RETURNING.')
    return
  end

  
  % plot test figure with colorbar 
  
  if 0
    figure
    pcolor(rand(12))
    eval(['colormap(',mcm_list{i},')'])
    colorbar
    drawnow
  end  
    
  if rem(mcm_N_tmp,2)==0
    
    % create odd-numbered color scheme by inserting neutral color in middle
    
    eval([mcm_list{mcm_i}(1:mcm_ind_tmp-1), ...
	  num2str( 1 + str2num(mcm_list{mcm_i}(mcm_ind_tmp:end)) ), ...
	  ' = ', ...
	  '[', mcm_list{mcm_i},'(1:',num2str(mcm_N_tmp/2), ',:); ', ...
	  'mcm_neutral; ', ...
	  mcm_list{mcm_i},'(', num2str(mcm_N_tmp/2+1), ':end,:)];' ])
    
    
    % plot test figure with colorbar 
    
    if 0
      figure
      pcolor(rand(12))
      eval(['colormap(',mcm_list{i}(1:mcm_ind_tmp-1), ...
	    num2str( 1 + str2num(mcm_list{i}(mcm_ind_tmp:end)) ), ...
	    ')'])
      colorbar
      drawnow
    end  
    
  end
  
end

clear mcm_N_tmp mcm_ind_tmp mcm_list mcm_i



dwwwwww = 0.1; 
wwwwww  = (0:dwwwwww:1-dwwwwww)';

mcm_tmp = [];

for i=1:11
  
  mcm_tmp = [mcm_tmp; ...
             (1-wwwwww)*mcm_BuDRd_12(i,:) + wwwwww*mcm_BuDRd_12(i+1,:)];
  
end

mcm_tmp = [ mcm_tmp; mcm_BuDRd_12(end,:) ];

mcm_BuDRd_111 = mcm_tmp;



% -----------------------------------------------------------------

% "rainbow" colormaps (before Oct 2004)

mcm12 = [ .75 0   1;              % 1  (dark magenta)
	  1   0   1;              % 2  magenta  
	  .5  0   0;               % 3  dark red
	  .9  0   0;              % 4  red
	  1   .75 0;              % 5  orange
	  1   1   0;              % 6  yellow
	  .75 1   0;              % 7  (light green)
	  0   1   0;              % 8  green
	  0   1   .75;            % 9  (?)
	  0   1   1;              % 10 cyan
	  0   0   1;              % 11 blue
	  0   0  .5];             % 12 dark blue


mcm10 = mcm12( [ 1 2 4:8 10:12],:);          % out 3, 9

mcm9  = mcm12( [ 1 2 4:8 10 11],:);          % out 12

mcm8  = mcm12( [ 1 4:8 10 11], :);

mcm6  = mcm12( [ 1 4:6 8 11], :);

% include white and grey

mcm12wg = [ 1 1 1;
	    .6 .6 .6 ;
	    mcm12( [ 1:8 10 11],:) ];

mcm10wg = [ 1 1 1;
	    .6 .6 .6 ;
	    mcm12( [1 2 4:8 11 ],:) ];

mcm9wg = [ 1 1 1;
	   .6 .6 .6 ;
	   mcm12( [1 4:8 11 ],:) ];



if exist('iiiiiiiii','var')
  disp('ERROR: conflict with variable name "iiiiiiiii"')
  disp('returning')
  return
end

mcm12e = [];

for iiiiiiiii=1:12
  mcm12e = [ mcm12e; ones(120,1)*mcm12(iiiiiiiii,:) ];
end  

mcm10e = [];

for iiiiiiiii=1:10
  mcm10e = [ mcm10e; ones(100,1)*mcm10(iiiiiiiii,:) ];
end  

mcm9e = [];

for iiiiiiiii=1:9
  mcm9e = [ mcm9e; ones(90,1)*mcm9(iiiiiiiii,:) ];
end  

mcm8e = [];

for iiiiiiiii=1:8
  mcm8e = [ mcm8e; ones(80,1)*mcm8(iiiiiiiii,:) ];
end  

mcm6e = [];

for iiiiiiiii=1:6
  mcm6e = [ mcm6e; ones(60,1)*mcm6(iiiiiiiii,:) ];
end  

clear iiiiiiiii


% -----------------------------------------------------------------

% anomalies (blue for neg, red for pos, grey in middle)


mcmanom20 = [ 0  0  .4;      ...      %  1     
	      0  0  .6;      ...      %  2
	      0  0  .8;      ...      %  3
	      0  0  1.;      ...      %  4
	      0  .4 1.;      ...      %  5 
	      0  .6 1.;      ...      %  6
	      0  .8 1.;      ...      %  7
	      0  1. 1.;      ...      %  8
	      0  1. .8;      ...      %  9
	      .8 .8 .8;      ...      % 10
	      .8 .8 .8;      ...      % 11
	      .8 1. 0;       ...      % 12
	      1. 1. 0;       ...      % 13
	      1. .8 0;       ...      % 14
	      1. .6 0;       ...      % 15
	      1. .4 0;       ...      % 16
	      1. 0  0;       ...      % 17
	      .8 0  0;       ...      % 18
	      .6 0  0;       ...      % 19
	      .4 0  0   ];            % 20


mcmanom19 = mcmanom20;
mcmanom19( 11,: ) = [];


mcmanom18 = mcmanom20;
mcmanom18( [9    12], :) = [];

mcmanom17 = mcmanom20;
mcmanom17( [9 11 12], :) = [];


mcmanom16 = mcmanom20;
mcmanom16( [1 9    12 20], :) = [];

mcmanom15 = mcmanom20;
mcmanom15( [1 9 11 12 20], :) = [];


mcmanom14 = mcmanom20;
mcmanom14( [1 5 9    12 16 20], :) = [];

mcmanom13 = mcmanom20;
mcmanom13( [1 5 9 11 12 16 20], :) = [];


mcmanom12 = mcmanom20;
mcmanom12( [1 3 5 9    12 16 18 20], :) = [];

mcmanom11 = mcmanom20;
mcmanom11( [1 3 5 9 11 12 16 18 20], :) = [];


mcmanom10 = mcmanom20;
mcmanom10( [1 3 5 7 9    12 14 16 18 20], :) = [];

mcmanom9  = mcmanom20;
mcmanom9(  [1 3 5 7 9 11 12 14 16 18 20], :) = [];


mcmanom10doodle = [
         0         0    0.4000
         0         0    1.0000
         0    1.0000    1.0000
         0    1.0000    0
    0.8000    0.8000    0.8000
    0.8000    0.8000    0.8000
    1.0000    1.0000         0
    1.0000    0.6000         0
    1.0000         0         0
    0.4000         0         0
		  ];


mcmanom9doodle = [
         0         0    0.4000
         0         0    1.0000
         0    1.0000    1.0000
         0    1.0000    0
    0.8000    0.8000    0.8000
    1.0000    1.0000         0
    1.0000    0.6000         0
    1.0000         0         0
    0.4000         0         0
		  ];



mcmanom9bw = [
         0         0    0
         0.4       0.4  0.4
         0.6       0.6  0.6
         0.8       0.8  0.8
         1.        1.   1.
         0.8       0.8  0.8
         0.6       0.6  0.6
         0.4       0.4  0.4
         0         0    0 ];


mcmanom7bw = [
         0         0    0
         0.3       0.3  0.3
         0.5       0.5  0.5
         .85        .85   .85
         0.5       0.5  0.5
         0.3       0.3  0.3
         0         0    0 ];


% -------------------------------------------------------------------

% colormap for "drought monitor" maps

% created manually using /discover/home/rreichle/SMAP/browse/create_drought_monitor_cmap.m 

mcm_drought_monitor = [
    0.6000         0         0
    0.6000         0         0
    0.6000         0         0
    0.6000         0         0
    0.6000         0         0
    1.0000         0         0
    1.0000         0         0
    1.0000         0         0
    1.0000         0         0
    1.0000         0         0
    1.0000         0         0
    1.0000         0         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.5020         0
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    0.8000    0.6000
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    1.0000    1.0000         0
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.8784    0.8784    0.8784
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.5020    1.0000         0
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
    0.6000    1.0000    0.6000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    1.0000    1.0000
         0    0.5020    1.0000
         0    0.5020    1.0000
         0    0.5020    1.0000
         0    0.5020    1.0000
         0    0.5020    1.0000
         0    0.5020    1.0000
         0    0.5020    1.0000
         0         0    1.0000
         0         0    1.0000
         0         0    1.0000
         0         0    1.0000
         0         0    1.0000
    ];


% -------------------------------------------------------------------

return


% test colormaps

tmp = rand(10);

for i=20:-1:9
  
  figure
  
  pcolor( tmp );
  
  eval( ['colormap(mcmanom', num2str(i), ')'] );
  
  colorbar
  
end


% ======================== EOF =====================================
