clc
clear all
close all

read_path = '/discover/nobackup/elee15/GEOSldas_4_0/sims/IDS/fcst_ctrl/smap9km_daily/output/SMAP_EASEv2_M09_GLOBAL/rs/ens0000/Y2001/';

min_lat = 55;
max_lat = 65;
min_lon = 60;
max_lon = 90;

tile_coord_file = '/discover/nobackup/elee15/GEOSldas_4_0/sims/IDS/fcst_ctrl/smap9km_daily/output/SMAP_EASEv2_M09_GLOBAL/rc_out/smap9km_daily.ldas_tilecoord.bin';
tile_coord_data = read_tilecoord_le(tile_coord_file);

loc_index = (tile_coord_data.com_lon <= min_lon) + (tile_coord_data.com_lon > max_lon) + ...
            (tile_coord_data.com_lat <= min_lat) + (tile_coord_data.com_lat > max_lat);
loc_index = loc_index == 0;

fveg_matrix = NaN*ones(sum(loc_index),12);
diff_vec = NaN*ones(sum(loc_index),11);

for m = 1:12

    m_str = num2str(m,'%02i'); 

    read_file = [read_path 'M' m_str  '/smap9km_daily.catchcn_internal_rst.2001' m_str '01_0000'];
    fveg_data = ncread(read_file,'FVG');
    fveg_matrix(:,m) = fveg_data(loc_index,4);

    if (m>1) 
       diff_vec(:,m) = fveg_matrix(:,m) - fveg_matrix(:,m-1);
    end
end
