clc 
clear all 
close all


rho_spatial = [ 0.84 0.66];
rho_temporal = [0.58 0.50];
RMSE = [0.078 0.142; 0 0];

figure
b = bar([rho_spatial; rho_temporal],'FaceColor','flat');
cmap = gray(2);
cmap(1,:) = cmap(1,:) + 0.2;
cmap(2,:) = cmap(2,:) - 0.2;
for i = 1:2
  b(i).CData = repmat(cmap(i,:),2,1);
end
grid on
ylim(gca,[0.2 0.9])
xticks([1 2])
xticklabels({'spatial correlation','temporal correlation'})
ylabel('correlation [-]')
legend('data fusion','a posteriori combination')
saveas(gcf,'/home/jkolassa/Projects/ecmwf_nn_retr_rho_bar','png')

figure
b = bar(RMSE,'FaceColor','flat');
cmap = gray(2);
cmap(1,:) = cmap(1,:) + 0.2;
cmap(2,:) = cmap(2,:) - 0.2;
for i = 1:2 
  b(i).CData = repmat(cmap(i,:),2,1);
end
grid on
xlim([0 1.5])
xticks([1 2]) 
xticklabels({'RMSE','-'})
ylabel('RMSE [m^3 m^{-3}]')
legend('data fusion','a posteriori combination','Location','northwest')
saveas(gcf,'/home/jkolassa/Projects/ecmwf_nn_retr_RMSE_bar','png')

