clc 
clear all
close all

read_path = '/discover/nobackup/jkolassa/CCN_calibration/CCN_cal_test/output/SMAP_EASEv2_M09_CONUS/cat/ens_avg/Y2003/M01/';
read_file = [read_path 'CCN_cal_test.ens_avg.ldas_tile_xhourly_out.20030101_1200z.bin'];

startYear = 2003;
stopYear = 2003;
startMonth = 1;
stopMonth = 1;
collectionID = 6;
nrOutVar = 40;


%--------------------------------------------------------------------------
% COMPUTATIONS
%--------------------------------------------------------------------------


% account for data availability

startMonths = ones((stopYear-startYear+1),1);
startMonths(1) = startMonth;
stopMonths = 12*ones((stopYear-startYear+1),1);
stopMonths(end) = stopMonth;
totalMonths = sum(stopMonths-startMonths+1);

% account for effect of leap year

leapYears = 1992:4:2013;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% get variable names and units according to collection ID and number of
% outputs variables

[data_tag, data_units] = get_data_tag(collectionID, nrOutVar, nrOutVar);

% read no DA coordinate data

coord_path = '/discover/nobackup/jkolassa/CCN_calibration/CCN_cal_test/output/SMAP_EASEv2_M09_CONUS/rc_out/';

tileCoordFile = [coord_path 'CCN_cal_test.ldas_tilecoord.bin'];
[tile_coord_data ] = read_tilecoord( tileCoordFile, 0 );


da_points = length(tile_coord_data.com_lat);

plot_lats = tile_coord_data.com_lat(1:da_points);
plot_lons = tile_coord_data.com_lon(1:da_points);

[tile_data] = read_tile_data(read_file, da_points, nrOutVar+36);