pro compare_abl_visdf_nirdf_bcs

; Compare two visdf and nirdf modis scale files. One is "old land" and is binary file,
; the other is also "old land" but created with updated PR so it is as well binary
; both files have same info on cenlat and cenlon

; created: Nov 5 2021 Biljana Orescanin SSAI@NASA


; read in visdf-.bin
filename1   ='/discover/nobackup/ltakacs/bcs/Icarus/Icarus_MERRA-2/CF0180x6C_DE1440xPE0720/visdf_180x1080.dat'
; read in nirdf-.bin
filename1_2   ='/discover/nobackup/ltakacs/bcs/Icarus/Icarus_MERRA-2/CF0180x6C_DE1440xPE0720/nirdf_180x1080.dat'
; red var name SWLAND
filename1_3   ='/discover/nobackup/borescan/par/ltakacs_ica_c180_o2/output/CF0180x6C_GLOBAL/cat/ens0000/Y1980/M01/ltakacs_ica_c180_o2.tavg24_2d_lnd_Nx.19800101_1200z.nc4'
; info on cenlat and cenlon
filename1_gl='/discover/nobackup/borescan/par/ltakacs_ica_c180_o2/output/CF0180x6C_GLOBAL/rc_out/ltakacs_ica_c180_o2.ldas_tilecoord.txt'

visdf1  =fltarr(195136l)
nirdf1_2=fltarr(195136l)
yr   =0.
mn   =0.
dy   =0.
dum  =0.
yr1  =0.
mn1  =0.
dy1  =0.

openr,lun1, filename1, /get_lun,/F77_UNFORMATTED
readu,lun1, yr,mn,dy,dum,dum,dum,yr1,mn1,dy1,dum,dum,dum,dum,dum
readu,lun1, visdf1                             
free_lun,lun1


openr,lun1, filename1_2, /get_lun,/F77_UNFORMATTED
readu,lun1, yr,mn,dy,dum,dum,dum,yr1,mn1,dy1,dum,dum,dum,dum,dum
readu,lun1, nirdf1_2                           
free_lun,lun1

data1_gl=fltarr(15,195136L)
dummy=' '
openr,lun2, filename1_gl, /get_lun
readf,lun2, dummy                     
readf,lun2, data1_gl                  
free_lun,lun2

;asign names
lon_1=reform(data1_gl(3 ,*))
lat_1=reform(data1_gl(4 ,*))

; read in visdf-.bin
filename2   ='/discover/nobackup/borescan/BCS/update_branch/develop/ica_180_o2/CF0180x6C_DE1440xPE0720/visdf_180x1080.dat'
; read in nirdf-.bin
filename2_2   ='/discover/nobackup/borescan/BCS/update_branch/develop/ica_180_o2/CF0180x6C_DE1440xPE0720/nirdf_180x1080.dat'
; red var name SWLAND
filename2_3   ='/discover/nobackup/borescan/par/ICA_C180_O2/output/CF0180x6C_GLOBAL/cat/ens0000/Y1980/M01/ICA_C180_O2.tavg24_2d_lnd_Nx.19800101_1200z.nc4'
; info on cenlat and cenlon
filename2_gl='/discover/nobackup/borescan/par/ICA_C180_O2/output/CF0180x6C_GLOBAL/rc_out/ICA_C180_O2.ldas_tilecoord.txt'

visdf2  =fltarr(195136l)
nirdf2_2=fltarr(195136l)

openr,lun1, filename2, /get_lun,/F77_UNFORMATTED
readu,lun1, yr,mn,dy,dum,dum,dum,yr1,mn1,dy1,dum,dum,dum,dum,dum
readu,lun1, visdf2                             
free_lun,lun1


openr,lun1, filename2_2, /get_lun,/F77_UNFORMATTED
readu,lun1, yr,mn,dy,dum,dum,dum,yr1,mn1,dy1,dum,dum,dum,dum,dum
readu,lun1, nirdf2_2                           
free_lun,lun1


print, "min(visdf2), min(visdf1)"
print,  min(visdf2), min(visdf1)

print, "max(visdf2), max(visdf1)"
print,  max(visdf2), max(visdf1)


print, "min(nirdf2_2), min(nirdf1_2)"
print,  min(nirdf2_2), min(nirdf1_2)

print, "max(nirdf2_2), max(nirdf1_2)"
print,  max(nirdf2_2), max(nirdf1_2)


; -- Plot

; -- Define a region of interest so I can deal only with these data
lat_min = -90 ;  40 ;  30 ; 40
lat_max =  90 ;  60 ;  90 ; 60 
lon_min =-180 ; -90 ;-180 ;-90    
lon_max = 180 ; -50 ; 180 ;-50 
rgn     =[lat_min,lat_max,lon_min,lon_max]
rgn_str =strcompress(strtrim(rgn))
rgn_str =  'Lon('+rgn_str(0)+'!Uo!N : '+rgn_str(1)+'!Uo!N)' + $
         '; Lat('+rgn_str(2)+'!Uo!N : '+rgn_str(3)+'!Uo!N)'

   ; this is what I want to plot 
  mis_val  =100
  diff2plot=nirdf2_2-nirdf1_2
   ; indexes where any of the two sets have missing values
  ind_mis =where(nirdf1_2 gt mis_val or  nirdf2_2 gt mis_val,n_mis)
  ind_val =where(nirdf1_2 lt mis_val and nirdf2_2 lt mis_val ,c_val)
  meann   =strmid(strtrim(mean    (diff2plot[ind_val] ),2),0,14)
  std     =strmid(strtrim(stddev  (diff2plot[ind_val] ),2),0,14)
  mean_abs=strmid(strtrim(mean(abs(diff2plot[ind_val])),2),0,14) 
  max_abs_diff=strmid(strtrim(max(abs(diff2plot[ind_val])),2),0,14)
   ; flagging those missing points with -888. so I can mask it out in the plot
  if n_mis gt 0 then diff2plot[ind_mis]=-888.
   ; name of the output file
  outfile_name='vegdyn_plots/nirdf_dif' 
  
  pmap, diff2plot, lat_1,lon_1, /coast,vmin=0.0000000001,vmax=0.000001, region=rgn,    $
        NCTICK=4,mis_val=-888., mis_col=3,/islands, title="Scaling Factor NIRDF Difference",    $
        subtitle='Mean='+meann+' STD='+std +' MaxAbsDiff='+max_abs_diff,$
        units='[-]', col_file='rcolor2_reverse.tbl', psize=30,          $
        /horizontal,xlabel='Longitude', ylabel='Latitude',              $
                  /ps_land, ps_file=         outfile_name+'.eps'
  spawn, 'convert -density 200 -rotate 270 '+outfile_name+'.eps '       $
         +'                                '+outfile_name+'.png'
  spawn, 'rm -f                            '+outfile_name+'.eps'

   ; this is what I want to plot 
  mis_val  =100
  diff2plot=nirdf2_2
   ; indexes where any of the two sets have missing values
  ind_mis =where(nirdf2_2 gt mis_val,n_mis)
  ind_val =where(nirdf2_2 lt mis_val,c_val)
  meann   =strmid(strtrim(mean    (diff2plot[ind_val] ),2),0,14)
  std     =strmid(strtrim(stddev  (diff2plot[ind_val] ),2),0,14)
   ; flagging those missing points with -888. so I can mask it out in the plot
  if n_mis gt 0 then diff2plot[ind_mis]=-888.
   ; name of the output file
  outfile_name='vegdyn_plots/nirdf2_2' 
  
  pmap, diff2plot, lat_1,lon_1, /coast,vmin=0,vmax=4, region=rgn, cmax=254,       $
        NCTICK=4,mis_val=-888., mis_col=3,/islands, title="Scaling Factor new NIRDF",    $
        subtitle='from current branch  Mean='+meann+' STD='+std+'; min(visdf)='+strtrim(min(nirdf2_2),2)+'; max(nirdf)='+strtrim(max(nirdf2_2),2), units='[-]',         $
        /horizontal,xlabel='Longitude', ylabel='Latitude', psize=50,    $
                  /ps_land, ps_file=         outfile_name+'.eps'
  spawn, 'convert -density 200 -rotate 270 '+outfile_name+'.eps '       $
         +'                                '+outfile_name+'.png'
  spawn, 'rm -f                            '+outfile_name+'.eps'


   ; this is what I want to plot 
  mis_val  =100
  diff2plot=visdf2-visdf1
   ; indexes where any of the two sets have missing values
  ind_mis =where(visdf1 gt mis_val or  visdf2 gt mis_val,n_mis)
  ind_val =where(visdf1 lt mis_val and visdf2 lt mis_val ,c_val)
  meann   =strmid(strtrim(mean    (diff2plot[ind_val] ),2),0,14)
  std     =strmid(strtrim(stddev  (diff2plot[ind_val] ),2),0,14)
  mean_abs=strmid(strtrim(mean(abs(diff2plot[ind_val])),2),0,14) 
  max_abs_diff=strmid(strtrim(max(abs(diff2plot[ind_val])),2),0,14)
   ; flagging those missing points with -888. so I can mask it out in the plot
  if n_mis gt 0 then diff2plot[ind_mis]=-888.
   ; name of the output file
  outfile_name='vegdyn_plots/visdf_dif' 
  
  pmap, diff2plot, lat_1,lon_1, /coast,vmin=0.0000001,vmax=0.00001, region=rgn,    $
        NCTICK=4,mis_val=-888., mis_col=3,/islands, title="Scaling Factor VISDF Difference",    $
        subtitle='Mean='+meann+' STD='+std +' MaxAbsDiff='+max_abs_diff,$
        units='[-]', col_file='rcolor2_reverse.tbl', psize=20,          $
        /horizontal,xlabel='Longitude', ylabel='Latitude',              $
                  /ps_land, ps_file=         outfile_name+'.eps'
  spawn, 'convert -density 200 -rotate 270 '+outfile_name+'.eps '       $
         +'                                '+outfile_name+'.png'
  spawn, 'rm -f                            '+outfile_name+'.eps'

   ; this is what I want to plot 
  mis_val  =100
  diff2plot=visdf2
   ; indexes where any of the two sets have missing values
  ind_mis =where(visdf2 gt mis_val,n_mis)
  ind_val =where(visdf2 lt mis_val,c_val)
  meann   =strmid(strtrim(mean    (diff2plot[ind_val] ),2),0,14)
  std     =strmid(strtrim(stddev  (diff2plot[ind_val] ),2),0,14)
   ; flagging those missing points with -888. so I can mask it out in the plot
  if n_mis gt 0 then diff2plot[ind_mis]=-888.
   ; name of the output file
  outfile_name='vegdyn_plots/visdf2_2' 
  
  pmap, diff2plot, lat_1,lon_1, /coast,vmin=0,vmax=4, region=rgn, cmax=254,       $
        NCTICK=4,mis_val=-888., mis_col=3,/islands, title="Scaling Factor new VISDF ",    $
        subtitle='from current branch  Mean='+meann+' STD='+std +'; min(visdf)='+strtrim(min(visdf2),2)+'; max(visdf)='+strtrim(max(visdf2),2), units='[-]',         $
        /horizontal,xlabel='Longitude', ylabel='Latitude', psize=50,    $
                  /ps_land, ps_file=         outfile_name+'.eps'
  spawn, 'convert -density 200 -rotate 270 '+outfile_name+'.eps '       $
         +'                                '+outfile_name+'.png'
  spawn, 'rm -f                            '+outfile_name+'.eps'


stop
end

