clc
clear all
close all

cn51_read_path = '/discover/nobackup/jkolassa/CN51_config_debug/carbon_balance_files/';
cn45_read_path = '/discover/nobackup/jkolassa/test_new/carbon_balance_files/';
cn51_err_read_path = '/discover/nobackup/jkolassa/CN51_config_debug/carbon_error_files/';
cn45_err_read_path = '/discover/nobackup/jkolassa/test_new/carbon_error_files/';

%----------------------
% read PFT data
%----------------------

cn51_rst_file = '/discover/nobackup/jkolassa/CN51_config_debug/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_CN51_local_280.catchcnclm51_internal_rst.19800101_0000';

cn51_pft_type = ncread(cn51_rst_file,'ITY');
cn51_pft_frac = ncread(cn51_rst_file,'FVG');

cn51_pft_name_short = {...
           'NETT',...
           'NEBT',...
           'NDBT',...
           'BETrT',...
           'BETT',...
           'BDTrT',...
           'BDTT',...
           'BDBT',...
           'BETS',...
           'BDTS',...
           'BDBS',...
           'AC3',...
           'NAC3',...
           'C4',...
           'C3Cr'...
           };


%-----------------------------------
% read phenology categorization data
%-----------------------------------
param_read_path = '/discover/nobackup/jkolassa/CLM/parameter_files/';
param_file = [param_read_path 'ctsm51_params.c210923.nc'];

evergreen_data = ncread(param_file,'evergreen');
cn51_evergreen = evergreen_data(2:16);
seas_decid_data = ncread(param_file,'season_decid');
cn51_seas_decid = seas_decid_data(2:16);
stress_decid_data = ncread(param_file,'stress_decid');
cn51_stress_decid = stress_decid_data(2:16);
woody_data = ncread(param_file,'woody');
cn51_woody = woody_data(2:16);
seas_decid_temp_data = ncread(param_file,'season_decid_temperate');
cn51_seas_decid_temp = seas_decid_temp_data(2:16);

%-----------------------------------
% read location data
%-----------------------------------

cn51_data_file = '/discover/nobackup/jkolassa/CN51_config_debug/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.monthly.198001.nc4';

cn51_lat = ncread(cn51_data_file,'lat');
cn51_lon = ncread(cn51_data_file,'lon');

%----------------------
% read CN51 column data
%----------------------

% autotrophic respiration
cn51_ar_col_file = [cn51_read_path 'ar_col_year1'];
fid = fopen(cn51_ar_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_ar_col = reshape(data,[2,length(data)/2]);
cn51_ar_col = cn51_ar_col';

% carbon loss to fire
cn51_closs_col_file = [cn51_read_path 'closs_col_year1'];
fid = fopen(cn51_closs_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_closs_col = reshape(data,[2,length(data)/2]);
cn51_closs_col = cn51_closs_col';

% ecosystem respiration
cn51_er_col_file = [cn51_read_path 'er_col_year1'];
fid = fopen(cn51_er_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_er_col = reshape(data,[2,length(data)/2]);
cn51_er_col = cn51_er_col';

% GPP
cn51_gpp_col_file = [cn51_read_path 'gpp_col_year1'];
fid = fopen(cn51_gpp_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_gpp_col = reshape(data,[2,length(data)/2]);
cn51_gpp_col = cn51_gpp_col';

% grain carbon
cn51_grainc_col_file = [cn51_read_path 'grainc_col_year1'];
fid = fopen(cn51_grainc_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_grainc_col = reshape(data,[2,length(data)/2]);
cn51_grainc_col = cn51_grainc_col';

% heterotrophic respiration
cn51_hr_col_file = [cn51_read_path 'hr_col_year1'];
fid = fopen(cn51_hr_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_hr_col = reshape(data,[2,length(data)/2]);
cn51_hr_col = cn51_hr_col';

% harvest excess maintenance respiration flux
cn51_hrvxsmr_col_file = [cn51_read_path 'hrvxsmr_col_year1'];
fid = fopen(cn51_hrvxsmr_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_hrvxsmr_col = reshape(data,[2,length(data)/2]);
cn51_hrvxsmr_col = cn51_hrvxsmr_col';

% soil organic matter carbon
cn51_somc_col_file = [cn51_read_path 'somc_col_year1'];
fid = fopen(cn51_somc_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_somc_col = reshape(data,[2,length(data)/2]);
cn51_somc_col = cn51_somc_col';

% wood harvest carbon
cn51_woodh_col_file = [cn51_read_path 'woodh_col_year1'];
fid = fopen(cn51_woodh_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_woodh_col = reshape(data,[2,length(data)/2]);
cn51_woodh_col = cn51_woodh_col';

% excess maintenance respiration
cn51_xsmr_col_file = [cn51_read_path 'xsmr_col_year1'];
fid = fopen(cn51_xsmr_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_xsmr_col = reshape(data,[2,length(data)/2]);
cn51_xsmr_col = cn51_xsmr_col';

% beginning total column carbon
cn51_totcbeg_col_file = [cn51_read_path 'totcbeg_col_year1'];
fid = fopen(cn51_totcbeg_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_totcbeg_col = reshape(data,[2,length(data)/2]);
cn51_totcbeg_col = cn51_totcbeg_col';

% end total column carbon
cn51_totcend_col_file = [cn51_read_path 'totcend_col_year1'];
fid = fopen(cn51_totcend_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_totcend_col = reshape(data,[2,length(data)/2]);
cn51_totcend_col = cn51_totcend_col';

% carbon imbalance
cn51_errcb_col_file = [cn51_err_read_path 'carbon_error_col_year1'];
fid = fopen(cn51_errcb_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_errcb_col = reshape(data,[2,length(data)/2]);
cn51_errcb_col = cn51_errcb_col';


%% carbon truncation
%cn51_ctrunc_col_file = [cn51_read_path 'ctrunc_col_year1'];
%fid = fopen(cn51_ctrunc_col_file,'r');
%data = fscanf(fid,'%i %f');
%fclose(fid);
%
%cn51_ctrunc_col = reshape(data,[2,length(data)/2]);
%cn51_ctrunc_col = cn51_ctrunc_col';
%
%% patch-level carbon
%cn51_totcp2c_col_file = [cn51_read_path 'totcp2c_col_year1'];
%fid = fopen(cn51_totcp2c_col_file,'r');
%data = fscanf(fid,'%i %f');
%fclose(fid);
%
%cn51_totcp2c_col = reshape(data,[2,length(data)/2]);
%cn51_totcp2c_col = cn51_totcp2c_col';
%
%% coarse woody debris
%cn51_cwdc_col_file = [cn51_read_path 'cwdc_col_year1'];
%fid = fopen(cn51_cwdc_col_file,'r');
%data = fscanf(fid,'%i %f');
%fclose(fid);
%
%cn51_cwdc_col = reshape(data,[2,length(data)/2]);
%cn51_cwdc_col = cn51_cwdc_col';
%
%% litter carbon
%cn51_totlitc_col_file = [cn51_read_path 'totlitc_col_year1'];
%fid = fopen(cn51_totlitc_col_file,'r');
%data = fscanf(fid,'%i %f');
%fclose(fid);
%
%cn51_totlitc_col = reshape(data,[2,length(data)/2]);
%cn51_totlitc_col = cn51_totlitc_col';


%------------------------
% read CN51 gridcell data
%------------------------

% carbon loss to fire
cn51_closs_grc_file = [cn51_read_path 'closs_grc_year1'];
fid = fopen(cn51_closs_grc_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_closs_grc = reshape(data,[2,length(data)/2]);
cn51_closs_grc = cn51_closs_grc';

% hrvxsmr
cn51_hrvxsmr_grc_file = [cn51_read_path 'hrvxsmr_grc_year1'];
fid = fopen(cn51_hrvxsmr_grc_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_hrvxsmr_grc = reshape(data,[2,length(data)/2]);
cn51_hrvxsmr_grc = cn51_hrvxsmr_grc';

% land use flux
cn51_landuse_grc_file = [cn51_read_path 'landuse_grc_year1'];
fid = fopen(cn51_landuse_grc_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_landuse_grc = reshape(data,[2,length(data)/2]);
cn51_landuse_grc = cn51_landuse_grc';

% NEE
cn51_nee_grc_file = [cn51_read_path 'nee_grc_year1'];
fid = fopen(cn51_nee_grc_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_nee_grc = reshape(data,[2,length(data)/2]);
cn51_nee_grc = cn51_nee_grc';

% NEP
cn51_nep_grc_file = [cn51_read_path 'nep_grc_year1'];
fid = fopen(cn51_nep_grc_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn51_nep_grc = reshape(data,[2,length(data)/2]);
cn51_nep_grc = cn51_nep_grc';

%-------------------------
% read CN45 column files
%-------------------------

% autotrophic respiration
cn45_ar_col_file = [cn45_read_path 'ar_col'];
fid = fopen(cn45_ar_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_ar_col = reshape(data,[2,length(data)/2]);
cn45_ar_col = cn45_ar_col';

% carbon loss to fire
cn45_closs_col_file = [cn45_read_path 'closs_col'];
fid = fopen(cn45_closs_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_closs_col = reshape(data,[2,length(data)/2]);
cn45_closs_col = cn45_closs_col';

% dwt
cn45_dwt_col_file = [cn45_read_path 'dwt_col'];
fid = fopen(cn45_dwt_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_dwt_col = reshape(data,[2,length(data)/2]);
cn45_dwt_col = cn45_dwt_col';

% er
cn45_er_col_file = [cn45_read_path 'er_col'];
fid = fopen(cn45_er_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_er_col = reshape(data,[2,length(data)/2]);
cn45_er_col = cn45_er_col';

% gpp
cn45_gpp_col_file = [cn45_read_path 'gpp_col'];
fid = fopen(cn45_gpp_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_gpp_col = reshape(data,[2,length(data)/2]);
cn45_gpp_col = cn45_gpp_col';

% hr
cn45_hr_col_file = [cn45_read_path 'hr_col'];
fid = fopen(cn45_hr_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_hr_col = reshape(data,[2,length(data)/2]);
cn45_hr_col = cn45_hr_col';

% hrvxsmr
cn45_hrvxsmr_col_file = [cn45_read_path 'hrvxsmr_col'];
fid = fopen(cn45_hrvxsmr_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_hrvxsmr_col = reshape(data,[2,length(data)/2]);
cn45_hrvxsmr_col = cn45_hrvxsmr_col';

% nee
cn45_nee_col_file = [cn45_read_path 'nee_col'];
fid = fopen(cn45_nee_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_nee_col = reshape(data,[2,length(data)/2]);
cn45_nee_col = cn45_nee_col';

% product
cn45_product_col_file = [cn45_read_path 'product_col'];
fid = fopen(cn45_product_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_product_col = reshape(data,[2,length(data)/2]);
cn45_product_col = cn45_product_col';

% beginning carbon balance
cn45_totcbeg_col_file = [cn45_read_path 'totcbeg_col'];
fid = fopen(cn45_totcbeg_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_totcbeg_col = reshape(data,[2,length(data)/2]);
cn45_totcbeg_col = cn45_totcbeg_col';

% end carbon balance
cn45_totcend_col_file = [cn45_read_path 'totcend_col'];
fid = fopen(cn45_totcend_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_totcend_col = reshape(data,[2,length(data)/2]);
cn45_totcend_col = cn45_totcend_col';

% carbon imbalance
cn45_errcb_col_file = [cn45_err_read_path 'carbon_error_col'];
fid = fopen(cn45_errcb_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_errcb_col = reshape(data,[2,length(data)/2]);
cn45_errcb_col = cn45_errcb_col';

% carbon truncation
cn45_ctrunc_col_file = [cn45_read_path 'ctrunc_col'];
fid = fopen(cn45_ctrunc_col_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

cn45_ctrunc_col = reshape(data,[2,length(data)/2]);
cn45_ctrunc_col = cn45_ctrunc_col';


%-------------------
% transform matrices
%-------------------

for i = 1:max(cn51_gpp_col(:,1))

    col_index = find(cn51_gpp_col(:,1)==i);
    col_index_2 = find(cn51_somc_col(:,1)==i);
    col_index_3 = find(cn51_errcb_col(:,1)==i);
    col_index_4 = find(cn51_totcbeg_col(:,1)==i);

    cn51_ar_col_mat(i,:) = cn51_ar_col(col_index,2);
    cn51_closs_col_mat(i,:) = cn51_closs_col(col_index,2);
    cn51_er_col_mat(i,:) = cn51_er_col(col_index,2);
    cn51_gpp_col_mat(i,:) = cn51_gpp_col(col_index,2);
    cn51_grainc_col_mat(i,:) = cn51_grainc_col(col_index_2,2);
    cn51_hr_col_mat(i,:) = cn51_hr_col(col_index,2);
    cn51_hrvxsmr_col_mat(i,:) = cn51_hrvxsmr_col(col_index_2,2);
    cn51_somc_col_mat(i,:) = cn51_somc_col(col_index_2,2);
    cn51_woodh_col_mat(i,:) = cn51_woodh_col(col_index_2,2);
    cn51_xsmr_col_mat(i,:) = cn51_xsmr_col(col_index_2,2);
    cn51_totcbeg_col_mat(i,:) = cn51_totcbeg_col(col_index_4,2);
    cn51_totcend_col_mat(i,:) = cn51_totcend_col(col_index_4,2);
    cn51_errcb_col_mat(i,:) = cn51_errcb_col(col_index_3,2);
end

for i = 1:max(cn51_closs_grc(:,1))

    grc_index = find(cn51_closs_grc(:,1)==i);

    cn51_closs_grc_mat(i,:) = cn51_closs_grc(grc_index,2);
    cn51_hrvxsmr_grc_mat(i,:) = cn51_hrvxsmr_grc(grc_index,2);
    cn51_landuse_grc_mat(i,:) = cn51_landuse_grc(grc_index,2);
    cn51_nee_grc_mat(i,:) = cn51_nee_grc(grc_index,2);
    cn51_nep_grc_mat(i,:) = cn51_nep_grc(grc_index,2);

end

for i = 1:max(cn45_gpp_col(:,1))

    col_index = find(cn45_gpp_col(:,1)==i);
    col_index_2 = find(cn45_totcbeg_col(:,1)==i);
    col_index_3 = find(cn45_errcb_col(:,1)==i);

    cn45_ar_col_mat(i,:) = cn45_ar_col(col_index,2);
    cn45_closs_col_mat(i,:) = cn45_closs_col(col_index,2);
    cn45_dwt_col_mat(i,:) = cn45_dwt_col(col_index,2);
    cn45_er_col_mat(i,:) = cn45_er_col(col_index,2);
    cn45_gpp_col_mat(i,:) = cn45_gpp_col(col_index,2);
    cn45_hr_col_mat(i,:) = cn45_hr_col(col_index,2);
    cn45_hrvxsmr_col_mat(i,:) = cn45_hrvxsmr_col(col_index,2);
    cn45_nee_col_mat(i,:) = cn45_nee_col(col_index,2);
    cn45_product_col_mat(i,:) = cn45_product_col(col_index,2);
    cn45_totcbeg_col_mat(i,:) = cn45_totcbeg_col(col_index_2,2);
    cn45_totcend_col_mat(i,:) = cn45_totcend_col(col_index_2,2);
    cn45_errcb_col_mat(i,:) = cn45_errcb_col(col_index_3,2);

end

%-------------------
% read forcing data
%-------------------

%forc_base_path = '/discover/nobackup/jkolassa/CN51_config_debug/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/';
%
%rainf_mat = NaN*ones(118,12);
%tair_mat = NaN*ones(118,12);
%sfmc_mat = NaN*ones(118,12);
%
%for m = 1:12
% 
%    m_str = num2str(m,'%02i');
%
%    forc_file = [forc_base_path 'M' m_str '/GEOSldas_CN51_local_280.tavg24_1d_lfs_Nt.monthly.1980' m_str '.nc4'];
%    lnd_file = [forc_base_path 'M' m_str '/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.monthly.1980' m_str     '.nc4'];
%    
%   rainf_mat(:,m) = ncread(forc_file,'Rainf');
%   tair_mat(:,m)  = ncread(forc_file,'Tair');
%   sfmc_mat(:,m) = ncread(lnd_file,'SFMC');
%
%end
%
%rainf_avg = nanmean(rainf_mat,2);
%tair_avg = nanmean(tair_mat,2);
%sfmc_avg = nanmean(sfmc_mat,2);

%---------------------------------------------
% compute carbon imbalance
%---------------------------------------------

cn51_cb_inputs = cn51_gpp_col_mat;
cn51_cb_outputs = cn51_er_col_mat + cn51_closs_col_mat;
cn51_totc_diff_col = cn51_totcend_col_mat - cn51_totcbeg_col_mat;

cn45_cb_inputs = cn45_gpp_col_mat;
cn45_cb_outputs = cn45_er_col_mat + cn45_closs_col_mat;
cn45_totc_diff_col = cn45_totcend_col_mat - cn45_totcbeg_col_mat;

%---------------------------------------------
% compute carbon balance (NEE) from common sense
%-----------------------------------------------

% compute column level NEE
cn51_cb_col = cn51_gpp_col_mat - cn51_closs_col_mat - cn51_er_col_mat;
cn45_cb_col = cn45_gpp_col_mat - cn45_closs_col_mat - cn45_er_col_mat;

cn51_nep_col_mat = cn51_gpp_col_mat - cn51_er_col_mat;

% transform to gridcell level

wtcol = [0.1 0.45 0.45]';

cn51_pft_type_col = NaN*ones(size(cn51_gpp_col_mat,1),2);
cn51_pft_frac_col = NaN*ones(size(cn51_gpp_col_mat,1),2);
cn51_lat_col = NaN*ones(size(cn51_gpp_col_mat,1),1);
cn51_lon_col = NaN*ones(size(cn51_gpp_col_mat,1),1);
cn51_col_col = NaN*ones(size(cn51_gpp_col_mat,1),1);

cn51_rainf_col = NaN*ones(size(cn51_gpp_col_mat,1),1);
cn51_tair_col = NaN*ones(size(cn51_gpp_col_mat,1),1);
cn51_sfmc_col = NaN*ones(size(cn51_gpp_col_mat,1),1);

for i = 1:size(cn51_nee_grc_mat,1)

    column_start_index = (i-1)*3 + 1;
    column_stop_index = i*3;

    cn51_pft_type_col(column_start_index:column_stop_index,:) = cn51_pft_type(i,:).*ones(3,1);
    cn51_pft_frac_col(column_start_index:column_stop_index,:) = cn51_pft_frac(i,:).*ones(3,1);

    cn51_lat_col(column_start_index:column_stop_index,:) = cn51_lat(i).*ones(3,1);
    cn51_lon_col(column_start_index:column_stop_index,:) = cn51_lon(i).*ones(3,1);

    cn51_col_col(column_start_index:column_stop_index,:) = [1 2 3];    

   % cn51_rainf_col(column_start_index:column_stop_index) = rainf_avg(i).*ones(3,1);
   % cn51_tair_col(column_start_index:column_stop_index) = tair_avg(i).*ones(3,1);
   % cn51_sfmc_col(column_start_index:column_stop_index) = sfmc_avg(i).*ones(3,1);

    cn51_cb_col_tmp = cn51_cb_col(column_start_index:column_stop_index,:);
   
    cn51_cb_col_tmp(1,:) = cn51_cb_col_tmp(1,:).*wtcol(1);
    cn51_cb_col_tmp(2,:) = cn51_cb_col_tmp(2,:).*wtcol(2);
    cn51_cb_col_tmp(3,:) = cn51_cb_col_tmp(3,:).*wtcol(3);

    cn51_cb_grc(i,:) = nansum(cn51_cb_col_tmp,1);

    cn51_closs_col_tmp = cn51_closs_col_mat(column_start_index:column_stop_index,:);

    cn51_closs_col_tmp(1,:) = cn51_closs_col_tmp(1,:).*wtcol(1);
    cn51_closs_col_tmp(2,:) = cn51_closs_col_tmp(2,:).*wtcol(2);
    cn51_closs_col_tmp(3,:) = cn51_closs_col_tmp(3,:).*wtcol(3);

    cn51_closs_agg_grc(i,:) = nansum(cn51_closs_col_tmp,1);

    cn51_nep_col_tmp = cn51_nep_col_mat(column_start_index:column_stop_index,:);

    cn51_nep_col_tmp(1,:) = cn51_nep_col_tmp(1,:).*wtcol(1);
    cn51_nep_col_tmp(2,:) = cn51_nep_col_tmp(2,:).*wtcol(2);
    cn51_nep_col_tmp(3,:) = cn51_nep_col_tmp(3,:).*wtcol(3);

    cn51_nep_agg_grc(i,:) = nansum(cn51_nep_col_tmp,1);

    cn51_gpp_col_tmp = cn51_gpp_col_mat(column_start_index:column_stop_index,:);

    cn51_gpp_col_tmp(1,:) = cn51_gpp_col_tmp(1,:).*wtcol(1);
    cn51_gpp_col_tmp(2,:) = cn51_gpp_col_tmp(2,:).*wtcol(2);
    cn51_gpp_col_tmp(3,:) = cn51_gpp_col_tmp(3,:).*wtcol(3);

    cn51_gpp_agg_grc(i,:) = nansum(cn51_gpp_col_tmp,1);


end

cn51_cb_grc_avg = nanmean(cn51_cb_grc,1);
cn51_nee_grc_avg = nanmean(cn51_nee_grc_mat,1);

cn51_closs_agg_grc_diff = cn51_closs_grc_mat - cn51_closs_agg_grc;
cn51_closs_agg_grc_diff_avg = nanmean(cn51_closs_agg_grc_diff,1);

cn51_nep_agg_grc_diff = cn51_nep_grc_mat - cn51_nep_agg_grc;
cn51_nep_agg_grc_diff_avg = nanmean(cn51_nep_agg_grc_diff,1);

cn51_agg_error =  cn51_nep_agg_grc_diff - cn51_closs_agg_grc_diff;
cn51_agg_error_avg = nanmean(cn51_agg_error,1);

for i = 2:length(cn51_totcend_col_mat)

    totc_sanitycheck_diff(:,i) = cn51_totcbeg_col_mat(:,i) - cn51_totcend_col_mat(:,i-1);

end

c1_index = 1:3:352;
c2_index = 2:3:353;
c3_index = 3:3:354;

cn51_gpp_col_avg = 0.1*nanmean(cn51_gpp_col_mat(c1_index,:),1) + ...
                   0.45*nanmean(cn51_gpp_col_mat(c2_index,:),1) + ...
                   0.45*nanmean(cn51_gpp_col_mat(c3_index,:),1);
cn51_closs_col_avg = 0.1*nanmean(cn51_closs_col_mat(c1_index,:),1) + ...
                   0.45*nanmean(cn51_closs_col_mat(c2_index,:),1) + ...
                   0.45*nanmean(cn51_closs_col_mat(c3_index,:),1);
cn51_er_col_avg = 0.1*nanmean(cn51_er_col_mat(c1_index,:),1) + ...
                   0.45*nanmean(cn51_er_col_mat(c2_index,:),1) + ...
                   0.45*nanmean(cn51_er_col_mat(c3_index,:),1);
cn51_cb_col_avg = 0.1*nanmean(cn51_cb_col(c1_index,:),1) + ...
                   0.45*nanmean(cn51_cb_col(c2_index,:),1) + ...
                   0.45*nanmean(cn51_cb_col(c3_index,:),1);
cn51_totc_diff_col_avg = 0.1*nanmean(cn51_totc_diff_col(c1_index,:),1) + ...
                   0.45*nanmean(cn51_totc_diff_col(c2_index,:),1) + ...
                   0.45*nanmean(cn51_totc_diff_col(c3_index,:),1);
cn51_totcbeg_col_avg = 0.1*nanmean(cn51_totcbeg_col_mat(c1_index,:),1) + ...
                   0.45*nanmean(cn51_totcbeg_col_mat(c2_index,:),1) + ...
                   0.45*nanmean(cn51_totcbeg_col_mat(c3_index,:),1);
cn51_totcend_col_avg = 0.1*nanmean(cn51_totcend_col_mat(c1_index,:),1) + ...
                   0.45*nanmean(cn51_totcend_col_mat(c2_index,:),1) + ...
                   0.45*nanmean(cn51_totcend_col_mat(c3_index,:),1);
cn51_errcb_col_avg = 0.1*nanmean(cn51_errcb_col_mat(c1_index,:),1) + ...
                   0.45*nanmean(cn51_errcb_col_mat(c2_index,:),1) + ...
                   0.45*nanmean(cn51_errcb_col_mat(c3_index,:),1);



cn45_gpp_col_avg = 0.1*nanmean(cn45_gpp_col_mat(c1_index,:),1) + ... 
                   0.45*nanmean(cn45_gpp_col_mat(c2_index,:),1) + ... 
                   0.45*nanmean(cn45_gpp_col_mat(c3_index,:),1);
cn45_closs_col_avg = 0.1*nanmean(cn45_closs_col_mat(c1_index,:),1) + ... 
                   0.45*nanmean(cn45_closs_col_mat(c2_index,:),1) + ... 
                   0.45*nanmean(cn45_closs_col_mat(c3_index,:),1);
cn45_er_col_avg = 0.1*nanmean(cn45_er_col_mat(c1_index,:),1) + ... 
                   0.45*nanmean(cn45_er_col_mat(c2_index,:),1) + ... 
                   0.45*nanmean(cn45_er_col_mat(c3_index,:),1);
cn45_cb_col_avg = 0.1*nanmean(cn45_cb_col(c1_index,:),1) + ... 
                   0.45*nanmean(cn45_cb_col(c2_index,:),1) + ... 
                   0.45*nanmean(cn45_cb_col(c3_index,:),1);
cn45_totc_diff_col_avg = 0.1*nanmean(cn45_totc_diff_col(c1_index,:),1) + ... 
                   0.45*nanmean(cn45_totc_diff_col(c2_index,:),1) + ... 
                   0.45*nanmean(cn45_totc_diff_col(c3_index,:),1);
cn45_totcbeg_col_avg = 0.1*nanmean(cn45_totcbeg_col_mat(c1_index,:),1) + ... 
                   0.45*nanmean(cn45_totcbeg_col_mat(c2_index,:),1) + ... 
                   0.45*nanmean(cn45_totcbeg_col_mat(c3_index,:),1);
cn45_totcend_col_avg = 0.1*nanmean(cn45_totcend_col_mat(c1_index,:),1) + ... 
                   0.45*nanmean(cn45_totcend_col_mat(c2_index,:),1) + ... 
                   0.45*nanmean(cn45_totcend_col_mat(c3_index,:),1);
cn45_errcb_col_avg = 0.1*nanmean(cn45_errcb_col_mat(c1_index,:),1) + ...
                   0.45*nanmean(cn45_errcb_col_mat(c2_index,:),1) + ...
                   0.45*nanmean(cn45_errcb_col_mat(c3_index,:),1);


cn51_totc_beg_end_diff_col_avg = cn51_totcend_col_avg - cn51_totcbeg_col_avg;

figure
plot(cn51_cb_grc_avg, '-b')
hold on
plot(cn51_nee_grc_avg, '-r')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/NEE_CN_CN51_grc'],'png')

cn51_nee_agg = cn51_nep_agg_grc - cn51_closs_agg_grc;
cn51_nee_agg_avg = nanmean(cn51_nee_agg,1);

cn51_nee_diff_grc = cn51_nee_grc_avg + (cn51_cb_grc_avg);
cn51_nee_diff_grc_perc = (cn51_nee_diff_grc./cn51_nee_grc_avg);

figure
plot(cn51_nee_diff_grc, '-b')
ylabel('NEE diff [gc m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/NEE_CN_diff_CN51_grc'],'png')

figure
plot(cn51_nee_diff_grc_perc, '-b')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/NEE_CN_diff_perc_CN51_grc'],'png')

cn51_nee_diff_grc_2 = cn51_nee_grc_avg - (cn51_nee_agg_avg);

figure
plot(cn51_nee_diff_grc_2, '-b')
ylabel('NEE diff [gc m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/NEE_CN_diff_CN51_grc'],'png')


figure
plot(cn51_cb_col_avg*5400, '-b')
hold on
plot(cn51_totc_diff_col_avg, '-r')
legend('(col\_inputs - col\_outputs)*dt','totc\_end - totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN51_col'],'png')

for i = 1:size(cn51_cb_col,1)

    figure
    plot(cn51_cb_col(i,:)*5400, '-b')
    hold on
    plot(cn51_totc_diff_col(i,:), '-r')
    legend('(col\_inputs - col\_outputs)*dt','totc\_end - totc\_beg')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN51_col_' num2str(i)],'png')

end


figure
plot(cn45_cb_col_avg*5400, '-b')
hold on
plot(cn45_totc_diff_col_avg, '-r')
legend('(col\_inputs - col\_outputs)*dt','totc\_end - totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN45_col'],'png')

lim_val = quantile(abs([cn51_cb_col_avg*5400 cn51_totc_diff_col_avg]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;

figure 
plot(cn51_cb_col_avg(1:end)*5400,cn51_totc_diff_col_avg,'*b')
hold on
plot(x,y,':k')
axis([-1*lim_val lim_val -1*lim_val lim_val])
xlabel('(col\_inputs - col\_outputs)*dt')
ylabel('totc\_end - totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN51_col_scatter_avg'],'png')

tmp = cn51_cb_col(:,5:end);

lim_val = quantile(abs([tmp(:)*5400; cn51_totc_diff_col(:)]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;

figure
plot(tmp*5400,cn51_totc_diff_col(:,5:end),'*b')
hold on
plot(x,y,':k')
axis([-1*lim_val lim_val -1*lim_val lim_val])
xlabel('(col\_inputs - col\_outputs)*dt')
ylabel('totc\_end - totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN51_col_scatter'],'png')

corr_array = NaN*ones(size(cn51_cb_col,1),1);
abs_bias_array = NaN*ones(size(cn51_cb_col,1),1);
good_lats = [];
bad_lats = [];
good_lons = [];
bad_lons = [];
good_cols = [];
bad_cols = [];

for i = 1:size(cn51_cb_col,1)

    if (cn51_evergreen(cn51_pft_type_col(i,1)))
       pft_phenology{1} = 'evergreen';
    elseif (cn51_seas_decid(cn51_pft_type_col(i,1)))
       pft_phenology{1} = 'seas. decid.';
    elseif (cn51_stress_decid(cn51_pft_type_col(i,1)))
       pft_phenology{1} = 'stress decid.';
    end

    if (cn51_evergreen(cn51_pft_type_col(i,2)))
       pft_phenology{2} = 'evergreen';
    elseif (cn51_seas_decid(cn51_pft_type_col(i,2)))
       pft_phenology{2} = 'seas. decid.';
    elseif (cn51_stress_decid(cn51_pft_type_col(i,2)))
       pft_phenology{2} = 'stress decid.';
    end

    if (cn51_woody(cn51_pft_type_col(i,1)))
       pft_woody{1} = 'woody';
    else
       pft_woody{1} = 'non-woody';
    end

    if (cn51_woody(cn51_pft_type_col(i,2)))
       pft_woody{2} = 'woody';
    else
       pft_woody{2} = 'non-woody';
    end

    corr_mat = corrcoef(cn51_cb_col(i,1:end)*5400,cn51_totc_diff_col(i,:));
    corr_array(i) = corr_mat(1,2);

    abs_bias_array(i) = nanmean(abs((cn51_cb_col(i,1:end)*5400) - cn51_totc_diff_col(i,:)));

    if (corr_array(i)>0.99) & (abs_bias_array(i)<=10^(-3))
      good_lats = [good_lats cn51_lat_col(i)];
      good_lons = [good_lons cn51_lon_col(i)];
      good_cols = [good_cols i];
    else
      bad_lats = [bad_lats cn51_lat_col(i)];
      bad_lons = [bad_lons cn51_lon_col(i)];      
      bad_cols = [bad_cols i];
    end    


    i
    lim_val = 0.5;
    figure
    plot(cn51_cb_col(i,1:end)*5400,cn51_totc_diff_col(i,:),'*b')
    hold on
    plot(x,y,':k')
    axis([-1*lim_val lim_val -1*lim_val lim_val])
    xlabel('(col\_inputs - col\_outputs)*dt')
    ylabel('totc\_end - totc\_beg')
    title(['lat: ' num2str(cn51_lat_col(i),'%2.2f') ', lon: ' num2str(cn51_lon_col(i),'%2.2f') ...
           ', col: ', num2str(cn51_col_col(i),'%i')])
    dim = [0.2 0.5 0.3 0.3];
    dim = [0.15 0.6 0.3 0.3];
    str = {['PFT prim: ' cn51_pft_name_short{cn51_pft_type_col(i,1)} ' (' num2str(cn51_pft_type_col(i,1)) '; ' num2str(cn51_pft_frac_col(i,1)*100,'%2.2f') '%)'],...
           ['PFT prim. phen.: ' pft_phenology{1} ' (' pft_woody{1} ')'],...
           ['PFT sec:  ' cn51_pft_name_short{cn51_pft_type_col(i,2)} ' (' num2str(cn51_pft_type_col(i,2)) '; ' num2str(cn51_pft_frac_col(i,2)*100,'%2.2f') '%)'],...
           ['PFT sec. phen.: ' pft_phenology{2} ' (' pft_woody{2} ')'],...
           ['CLOSS avg: ' num2str(nanmean(cn51_closs_col_mat(i,:))) ' gC m^{-2} s^{-1}'],...
           ['GPP avg: ' num2str(nanmean(cn51_gpp_col_mat(i,:))) '; min: ' num2str(min(cn51_gpp_col_mat(i,:))) '; max: ' num2str(max(cn51_gpp_col_mat(i,:))) ' gC m^{-2} s^{-1}'],...
           ['ER avg: ' num2str(nanmean(cn51_er_col_mat(i,:))) '; min: ' num2str(min(cn51_er_col_mat(i,:))) '; max: ' num2str(max(cn51_er_col_mat(i,:))) ' gC m^{-2} s^{-1}'],...          
    %       ['Rainf avg: ' num2str(cn51_rainf_col(i)) ' kg m^{-2} s^{-1}'],...
    %       ['Tair avg: ' num2str(cn51_tair_col(i)) ' K'],...
    %       ['SFMC avg: ' num2str(cn51_sfmc_col(i)) ' m^{3} m^{-3}'],...
           };
    %annotation('textbox',dim,'String',str,'FitBoxToText','on','FaceAlpha',0.5);
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN51_col_scatter_' num2str(i)],'png')

end

   load coastlines;
    [latcells, loncells] = polysplit(coastlat, coastlon);
    lat_range = [-60 90];
    lon_range = [-180 180];
    latlim = [-60 90];
    lonlim = [-180 180];

    cmap_mat = colormap(jet(15));

    figure
    ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
               'FLatLimit',lat_range,'FLonLimit',lon_range);
    framem
    gridm on; 
    setm(ax,'MLineLocation',60,'PLineLocation',60,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',60,...
    'MLabelParallel','south','FontSize',12)
    geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
    scatterm(bad_lats,bad_lons,15,'r','filled')
    plotm(coastlat, coastlon,'k') 
    set(gca,'XLim',lonlim);
    set(gca,'YLim',latlim);
    tightmap
    title(['good and bad locations'])
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 17 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/bad_locs'],'png')

    figure
    ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
               'FLatLimit',lat_range,'FLonLimit',lon_range);
    framem
    gridm on;
    setm(ax,'MLineLocation',60,'PLineLocation',60,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',60,...
    'MLabelParallel','south','FontSize',12)
    geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
    scatterm(good_lats,good_lons,15,'b','filled')
    plotm(coastlat, coastlon,'k')
    set(gca,'XLim',lonlim);
    set(gca,'YLim',latlim);
    tightmap
    title(['good and bad locations'])
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 17 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/good_locs'],'png')


lim_val = quantile(abs([cn45_cb_col_avg*5400 cn45_totc_diff_col_avg]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;

figure
plot(cn45_cb_col_avg(2:end)*5400,cn45_totc_diff_col_avg,'*b')
hold on
plot(x,y,':k')
axis([-1*lim_val lim_val -1*lim_val lim_val])
xlabel('(col\_inputs - col\_outputs)*dt')
ylabel('totc\_end - totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN45_col_scatter_avg'],'png')


tmp = cn45_cb_col(:,2:end);

lim_val = quantile(abs([tmp(:)*5400; cn45_totc_diff_col(:)]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;

figure
plot(tmp*5400,cn45_totc_diff_col,'*b')
hold on
plot(x,y,':k')
axis([-1*lim_val lim_val -1*lim_val lim_val])
xlabel('(col\_inputs - col\_outputs)*dt')
ylabel('totc\_end - totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CB_terms_CN45_col_scatter'],'png')


tmp = cn51_gpp_col_mat(:,5:end);
x1 = tmp(:);
y1 = cn51_errcb_col_mat(:);

corr_mat = corrcoef(x1,abs(y1));
cn51_corr_gpp_errcb = corr_mat(1,2);

lim_val = quantile(abs([x y]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;

figure
plot(x1,y1,'*b')
%hold on
%plot(x,y,':k')
%axis([-1*lim_val lim_val -1*lim_val lim_val])
xlabel('GPP [gC m^{-2} s^{-1}]')
ylabel('carbon imbalance [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/GPP_errcb_CN51_col_scatter'],'png')


figure
plot(cn51_totc_beg_end_diff_col_avg, '-b')
title('totc\_end - totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/totc_diff_CN51_col'],'png')


figure
plot(cn51_totcbeg_col_avg, '-b')
title('totc\_beg')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/totc_beg_CN51_col'],'png')

figure
plot(cn51_totcend_col_avg, '-b')
title('totc\_end')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/totc_end_CN51_col'],'png')

figure
plot(cn51_gpp_col_avg, '-b')
hold on
plot(cn45_gpp_col_avg, '-r')
title('GPP [gC m^{-2} s^{-1}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/GPP_CN51_CN45_col'],'png')

lim_val = quantile(abs([cn51_gpp_col_avg cn45_gpp_col_avg]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;

figure 
plot(cn51_gpp_col_avg,cn45_gpp_col_avg,'*b')
hold on
plot(x,y,':k')
axis([0 lim_val 0 lim_val])
xlabel('CN51 GPP [gC m^{-2} s^{-1}]')
ylabel('CN45 GPP [gC m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/GPP_CN51_CN45_col_scatter'],'png')

figure
plot(cn51_closs_col_avg, '-b')
hold on
plot(cn45_closs_col_avg, '-r')
title('CLOSS [gC m^{-2} s^{-1}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CLOSS_CN51_CN45_col'],'png')

lim_val = quantile(abs([cn51_closs_col_avg cn45_closs_col_avg]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;


figure
plot(cn51_closs_col_avg,cn45_closs_col_avg,'*b')
hold on
plot(x,y,':k')
axis([0 lim_val 0 lim_val])
xlabel('CN51 CLOSS [gC m^{-2} s^{-1}]')
ylabel('CN45 CLOSS [gC m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/CLOSS_CN51_CN45_col_scatter'],'png')

figure
plot(cn51_er_col_avg, '-b')
hold on
plot(cn45_er_col_avg, '-r')
title('ER [gC m^{-2} s^{-1}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/ER_CN51_CN45_col'],'png')

lim_val = quantile(abs([cn51_er_col_avg cn45_er_col_avg]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;


figure
plot(cn51_er_col_avg,cn45_er_col_avg,'*b')
hold on
plot(x,y,':k')
axis([0 lim_val 0 lim_val])
xlabel('CN51 ER [gC m^{-2} s^{-1}]')
ylabel('CN45 ER [gC m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/ER_CN51_CN45_col_scatter'],'png')

lim_val = quantile(abs([cn51_errcb_col_avg cn45_errcb_col_avg]),0.99);
x = -1*lim_val:10^(-5):lim_val;
y = x;

figure
plot(cn51_errcb_col_avg,cn45_errcb_col_avg(4:end),'*b')
hold on
plot(x,y,':k')
axis([-1*lim_val lim_val -1*lim_val lim_val])
xlabel('CN51 carbon imbalance [gC m^{-2}]')
ylabel('CN45 carbon imbalance [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/balance/ERRCB_CN51_CN45_col_scatter'],'png')

% compute correlations between carbon fluxes and errors

tmp = cn51_gpp_col_mat(:,5:end);
x1 = tmp(:);
y1 = cn51_errcb_col_mat(:);

corr_mat = corrcoef(x1,abs(y1));
cn51_corr_gpp_errcb = corr_mat(1,2);

tmp = cn51_er_col_mat(:,5:end);
x1 = tmp(:);
y1 = cn51_errcb_col_mat(:);

corr_mat = corrcoef(x1,abs(y1));
cn51_corr_er_errcb = corr_mat(1,2);

tmp = cn51_closs_col_mat(:,5:end);
x1 = tmp(:);
y1 = cn51_errcb_col_mat(:);

corr_mat = corrcoef(x1,abs(y1));
cn51_corr_closs_errcb = corr_mat(1,2);

