clc
clear all
close all

base_path = '/discover/nobackup/projects/geoscm/fzeng/Catchment-CN5.1/local_runs/';
base_exp_name = 'GEOSldas_CN51_local_280';
exp_name = base_exp_name;
nr_of_cycles = 12;

cn40_read_path = '/discover/nobackup/jkolassa/test_new/GEOSldas_CN40_local/output/SMAP_EASEv2_M09_GLOBAL/cat/ens0000/';
cn45_read_path = '/discover/nobackup/projects/geoscm/fzeng/GEOSldas45_M36_rst_ldas06_15/output/SMAP_EASEv2_M36/cat/ens0000/';

start_year = 1980;
stop_year = 2019;

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

cn51_rst_file = ['/discover/nobackup/projects/geoscm/fzeng/Catchment-CN5.1/local_runs/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_CN51_local_280.catchcnclm51_internal_rst.19800101_0000'];
tile_id = double(ncread(cn51_rst_file,'TILE_ID'));

cn51_read_file = ['/discover/nobackup/projects/geoscm/fzeng/Catchment-CN5.1/local_runs/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
cn45_read_file = [cn45_read_path 'Y2001/M01/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.200101.nc4'];
cn40_read_file = [cn40_read_path 'Y1981/M01/GEOSldas_CN40_local.tavg24_1d_lnd_Nt.monthly.198101.nc4'];

lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));

cn45_lat_vec = double(ncread(cn45_read_file,'lat'));
cn45_lon_vec = double(ncread(cn45_read_file,'lon'));

cn40_lat_vec = double(ncread(cn40_read_file,'lat'));
cn40_lon_vec = double(ncread(cn40_read_file,'lon'));

for i = 1:length(lat_vec)
    dist_vec = sqrt((cn45_lat_vec-lat_vec(i)).^2 + (cn45_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    data_index(i) = min_index(1);
end

    mat_index = 0;
    y_index = 0;

    for y = start_year:stop_year

        y_index = y_index + 1;
        y_str = num2str(y,'%04i');

        % define month length based on leap year status
        if sum(y==leapYears)>0
            monthLength = monthLength_ly;
        else
            mothLength = monthLength_nly;
        end

        for m = 1:12

            mat_index = mat_index + 1;

            m_str = num2str(m,'%02i');

            % define file names

            cn51_read_file = [base_path exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                           '/M' m_str '/' exp_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

            cn40_read_file = [cn40_read_path 'Y' y_str '/M' m_str '/GEOSldas_CN40_local.tavg24_1d_lnd_Nt.monthly.' ...
                              y_str m_str '.nc4'];
            cn45_read_file = [cn45_read_path 'Y' y_str '/M' m_str '/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

            % initialize arrays

            if (mat_index == 1)

                cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cncloss_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnvegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnroot_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnsr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnadd_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnxsmr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                cngpp_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnnee_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cncloss_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntlai_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntotc_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnvegc_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnroot_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnadd_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                cngpp_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnnee_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cncloss_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntlai_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntotc_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnvegc_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnroot_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

             end

            if exist(cn51_read_file)
               cngpp_mat(:,mat_index) = double(ncread(cn51_read_file,'CNGPP'));
               cnnee_mat(:,mat_index) = double(ncread(cn51_read_file,'CNNEE'));
               cncloss_mat(:,mat_index) = double(ncread(cn51_read_file,'CLOSS'));
               cntlai_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTLAI'));
               cntotc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTOTC'));
               cnvegc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNVEGC'));
               cnroot_mat(:,mat_index) = double(ncread(cn51_read_file,'CNROOT'));
               cnsr_mat(:,mat_index) = double(ncread(cn51_read_file,'CNSR'));
               cnadd_mat(:,mat_index) = double(ncread(cn51_read_file,'CNADD'));
               cnxsmr_mat(:,mat_index) = double(ncread(cn51_read_file,'CNXSMR'));
            else
               cngpp_mat(:,mat_index) = NaN*ones(size(cngpp_mat,1),1);
               cnnee_mat(:,mat_index) = NaN*ones(size(cnnee_mat,1),1);
               cncloss_mat(:,mat_index) = NaN*ones(size(cncloss_mat,1),1);
               cntlai_mat(:,mat_index) = NaN*ones(size(cntlai_mat,1),1);
               cntotc_mat(:,mat_index) = NaN*ones(size(cntotc_mat,1),1);
               cnvegc_mat(:,mat_index) = NaN*ones(size(cnvegc_mat,1),1);
               cnroot_mat(:,mat_index) = NaN*ones(size(cnroot_mat,1),1);
               cnsr_mat(:,mat_index) = NaN*ones(size(cnsr_mat,1),1);
               cnadd_mat(:,mat_index) = NaN*ones(size(cnadd_mat,1),1);
               cnxsmr_mat(:,mat_index) = NaN*ones(size(cnxsmr_mat,1),1);
            end

               if exist(cn40_read_file)
                  cngpp_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNGPP'));
                  cnnee_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNNEE'));
                  cncloss_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CLOSS'));
                  cntlai_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNTLAI'));
                  cntotc_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNTOTC'));
                  cnvegc_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNVEGC'));
                  cnroot_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNROOT'));
                  cnadd_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNADD'));
                else
                  cngpp_cn40_mat(:,mat_index) = NaN*ones(size(cngpp_cn40_mat,1),1);
                  cnnee_cn40_mat(:,mat_index) = NaN*ones(size(cnnee_cn40_mat,1),1);
                  cncloss_cn40_mat(:,mat_index) = NaN*ones(size(cncloss_cn40_mat,1),1);
                  cntlai_cn40_mat(:,mat_index) = NaN*ones(size(cntlai_cn40_mat,1),1);
                  cntotc_cn40_mat(:,mat_index) = NaN*ones(size(cntotc_cn40_mat,1),1);
                  cnvegc_cn40_mat(:,mat_index) = NaN*ones(size(cnvegc_cn40_mat,1),1);
                  cnroot_cn40_mat(:,mat_index) = NaN*ones(size(cnroot_cn40_mat,1),1);
                  cnadd_cn40_mat(:,mat_index) = NaN*ones(size(cnadd_cn40_mat,1),1);
                end

               if exist(cn45_read_file)
                  tmp_mat = double(ncread(cn45_read_file,'CNGPP'));
                  cngpp_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNNEE'));
                  cnnee_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CLOSS'));
                  cncloss_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNTLAI'));
                  cntlai_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNTOTC'));
                  cntotc_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNVEGC'));
                  cnvegc_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNROOT'));
                  cnroot_cn45_mat(:,mat_index) = tmp_mat(data_index);
                else
                  cngpp_cn45_mat(:,mat_index) = NaN*ones(size(cngpp_cn45_mat,1),1);
                  cnnee_cn45_mat(:,mat_index) = NaN*ones(size(cnnee_cn45_mat,1),1);
                  cncloss_cn45_mat(:,mat_index) = NaN*ones(size(cncloss_cn45_mat,1),1);
                  cntlai_cn45_mat(:,mat_index) = NaN*ones(size(cntlai_cn45_mat,1),1);
                  cntotc_cn45_mat(:,mat_index) = NaN*ones(size(cntotc_cn45_mat,1),1);
                  cnvegc_cn45_mat(:,mat_index) = NaN*ones(size(cnvegc_cn45_mat,1),1);
                  cnroot_cn45_mat(:,mat_index) = NaN*ones(size(cnroot_cn45_mat,1),1);
                end


         end % m
      end % y

mean_cn51_cngpp = nanmean(cngpp_mat,1);
mean_cn45_cngpp = nanmean(cngpp_cn45_mat,1);

cn51_zero_mat = cngpp_mat==0;
cn51_data_mat = cn51_zero_mat==0;
cn51_data_points = sum(cn51_data_mat,1);

cn45_zero_mat = cngpp_cn45_mat==0;
cn45_data_mat = cn45_zero_mat==0;
cn45_data_points = sum(cn45_data_mat,1);

figure
plot(mean_cn51_cngpp,'LineWidth',2)
hold on
plot(mean_cn45_cngpp,'LineWidth',2)
hold off
grid on
xlabel('month')
ylabel('GPP [kg m^{-2} s^{-1}]')
legend('CN51','CN45','Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_monthly_CN51_cycle1_280'],'png')

mean_cn51_cntlai = nanmean(cntlai_mat,1);
mean_cn45_cntlai = nanmean(cntlai_cn45_mat,1);

cn51_zero_mat_cntlai = cntlai_mat==0;
cn51_data_mat_cntlai = cn51_zero_mat_cntlai==0;
cn51_data_points_cntlai = sum(cn51_data_mat_cntlai,1);

cn45_zero_mat_cntlai = cntlai_cn45_mat==0;
cn45_data_mat_cntlai = cn45_zero_mat_cntlai==0;
cn45_data_points_cntlai = sum(cn45_data_mat_cntlai,1);

figure
plot(mean_cn51_cntlai,'LineWidth',2)
hold on
plot(mean_cn45_cntlai,'LineWidth',2)
hold off
grid on
xlabel('month')
ylabel('LAI [-]')
legend('CN51','CN45','Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_monthly_CN51_cycle1_280'],'png')

% plot LAI and CLOSS for some problematic locations

zero_locations = [2 4 5 18 36 114 116 117];

for i = 1:length(zero_locations)
    figure
    yyaxis left
    plot(cntlai_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('LAI [-]')
    yyaxis right
    plot(cncloss_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('CLOSS [kg m^{-2} s^{-1}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_CLOSS_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')


    figure
    plot(cntlai_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('LAI [-]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')

    figure
    plot(cntotc_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('total carbon  [kg m^{-2}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTOTC_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')

    figure
    plot(cnvegc_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('total vegetation carbon [kg m^{-2}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNVEGC_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')

    figure
    plot(cnroot_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('total root carbon [kg m^{-2}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNROOT_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')

    figure
    plot(cnsr_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('total soil respiration [kg m^{-2}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNSR_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')

    figure
    plot(cnadd_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('CN added to manatin positive C [kg m^{-2} s^{1}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNADD_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')

    figure
    plot(cnxsmr_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('abstract C pool to meet excess MR demand [kg m^{-2}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNXSMR_monthly_CN51_cycle1_280_loc' num2str(zero_locations(i))],'png')

    figure
    plot(cnadd_cn40_mat(zero_locations(i),:),'LineWidth',2)
    ylabel('CN added to manatin positive C [kg m^{-2} s^{1}]')
    xlabel('month [-]')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNADD_monthly_CN40_cycle1_280_loc' num2str(zero_locations(i))],'png')
end
