clc
clear all 
close all

cn51_read_path = '/discover/nobackup/jkolassa/CN51_test_local/CN51_out_files/';

% read CN51 water potential data

cn51_read_file = [cn51_read_path 'out.txt'];

fileID = fopen(cn51_read_file,'r');
cn51_vegwp_read_mat = fscanf(fileID,'%i %f %f %f %f');
fclose(fileID);

%cn51_vegwp = reshape(cn51_vegwp_read_mat,[5,914688/2]);
cn51_vegwp = reshape(cn51_vegwp_read_mat,[5,4280832/2]);
cn51_vegwp = cn51_vegwp';

% read transpiration data

cn51_tran_file = [cn51_read_path 'tran.txt'];

fileID = fopen(cn51_tran_file,'r');
cn51_tran_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_tran = reshape(cn51_tran_read_mat,[2,457344]);
cn51_tran = reshape(cn51_tran_read_mat,[2,2140416]);
cn51_tran = cn51_tran';

% read LAI data

cn51_tlai_file = [cn51_read_path 'tlai.txt'];

fileID = fopen(cn51_tlai_file,'r');
cn51_tlai_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_tlai = reshape(cn51_tlai_read_mat,[2,457344]);
cn51_tlai = reshape(cn51_tlai_read_mat,[2,2140416]);
cn51_tlai = cn51_tlai';

% read LAI sun/shade data

cn51_laiss_file = [cn51_read_path 'lai_sun_sha.txt'];

fileID = fopen(cn51_laiss_file,'r');
cn51_laiss_read_mat = fscanf(fileID,'%i %f %f');
fclose(fileID);

%cn51_laiss = reshape(cn51_laiss_read_mat,[3,457344]);
cn51_laiss = reshape(cn51_laiss_read_mat,[3,2140416]);
cn51_laiss = cn51_laiss';


% read GPP data
    
cn51_gpp_file = [cn51_read_path 'gpp.txt'];
    
fileID = fopen(cn51_gpp_file,'r');
cn51_gpp_read_mat = fscanf(fileID,'%i %f %f %f');
fclose(fileID);

%cn51_gpp = reshape(cn51_gpp_read_mat,[4,76224/2]);
cn51_gpp = reshape(cn51_gpp_read_mat,[4,356736/2]);
cn51_gpp = cn51_gpp';

% read leaf carbon data

cn51_leafc_file = [cn51_read_path 'leafc.txt'];

fileID = fopen(cn51_leafc_file,'r');
cn51_leafc_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_leafc = reshape(cn51_leafc_read_mat,[2,76224/2]);
cn51_leafc = reshape(cn51_leafc_read_mat,[2,356736/2]);
cn51_leafc = cn51_leafc';

% read conductance data

cn51_cond_file = [cn51_read_path 'cond.txt'];

fileID = fopen(cn51_cond_file,'r');
cn51_cond_read_mat = fscanf(fileID,'%i %f %f %f');
fclose(fileID);

%cn51_cond = reshape(cn51_cond_read_mat,[4,914688/2]);
cn51_cond = reshape(cn51_cond_read_mat,[4,4280832/2]);
cn51_cond = cn51_cond';

% read hydrology data

cn51_hydro_file = [cn51_read_path 'hydro.txt'];

fileID = fopen(cn51_hydro_file,'r');
cn51_hydro_read_mat = fscanf(fileID,'%i %f %f %f');
fclose(fileID);

%cn51_hydro = reshape(cn51_hydro_read_mat,[4,914688/2]);
cn51_hydro = reshape(cn51_hydro_read_mat,[4,4280832/2]);
cn51_hydro = cn51_hydro';

% read CN51 cpool_to_leafc data

cn51_cpool_to_leafc_file = [cn51_read_path 'cpool_to_leafc.txt'];

fileID = fopen(cn51_cpool_to_leafc_file,'r');
cn51_cpool_to_leafc_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_cpool_to_leafc = reshape(cn51_cpool_to_leafc_read_mat,[2,38112]);
cn51_cpool_to_leafc = reshape(cn51_cpool_to_leafc_read_mat,[2,178368]);
cn51_cpool_to_leafc = cn51_cpool_to_leafc';

% read CN51 hrv_leafc_to_litter data

cn51_hrv_leafc_to_litter_file = [cn51_read_path 'hrv_leafc_to_litter.txt'];

fileID = fopen(cn51_hrv_leafc_to_litter_file,'r');
cn51_hrv_leafc_to_litter_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_hrv_leafc_to_litter = reshape(cn51_hrv_leafc_to_litter_read_mat,[2,38112]);
cn51_hrv_leafc_to_litter = reshape(cn51_hrv_leafc_to_litter_read_mat,[2,178368]);
cn51_hrv_leafc_to_litter = cn51_hrv_leafc_to_litter';

% read CN51 leafc_to_litter data

cn51_leafc_to_litter_file = [cn51_read_path 'leafc_to_litter.txt'];

fileID = fopen(cn51_leafc_to_litter_file,'r');
cn51_leafc_to_litter_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_leafc_to_litter = reshape(cn51_leafc_to_litter_read_mat,[2,38112]);
cn51_leafc_to_litter = reshape(cn51_leafc_to_litter_read_mat,[2,178368]);
cn51_leafc_to_litter = cn51_leafc_to_litter';

% read CN51 leafc_xfer_to_leafc data

cn51_leafc_xfer_to_leafc_file = [cn51_read_path 'leafc_xfer_to_leafc.txt'];

fileID = fopen(cn51_leafc_xfer_to_leafc_file,'r');
cn51_leafc_xfer_to_leafc_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_leafc_xfer_to_leafc = reshape(cn51_leafc_xfer_to_leafc_read_mat,[2,38112]);
cn51_leafc_xfer_to_leafc = reshape(cn51_leafc_xfer_to_leafc_read_mat,[2,178368]);
cn51_leafc_xfer_to_leafc = cn51_leafc_xfer_to_leafc';

% read CN51 m_leafc_to_fire data

cn51_m_leafc_to_fire_file = [cn51_read_path 'm_leafc_to_fire.txt'];

fileID = fopen(cn51_m_leafc_to_fire_file,'r');
cn51_m_leafc_to_fire_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_m_leafc_to_fire = reshape(cn51_m_leafc_to_fire_read_mat,[2,38112]);
cn51_m_leafc_to_fire = reshape(cn51_m_leafc_to_fire_read_mat,[2,178368]);
cn51_m_leafc_to_fire = cn51_m_leafc_to_fire';

% read CN51 m_leafc_to_litter_fire data

cn51_m_leafc_to_litter_fire_file = [cn51_read_path 'm_leafc_to_litter_fire.txt'];

fileID = fopen(cn51_m_leafc_to_litter_fire_file,'r');
cn51_m_leafc_to_litter_fire_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_m_leafc_to_litter_fire = reshape(cn51_m_leafc_to_litter_fire_read_mat,[2,38112]);
cn51_m_leafc_to_litter_fire = reshape(cn51_m_leafc_to_litter_fire_read_mat,[2,178368]);
cn51_m_leafc_to_litter_fire = cn51_m_leafc_to_litter_fire';

% read CN51 m_leafc_to_litter data

cn51_m_leafc_to_litter_file = [cn51_read_path 'm_leafc_to_litter.txt'];

fileID = fopen(cn51_m_leafc_to_litter_file,'r');
cn51_m_leafc_to_litter_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

%cn51_m_leafc_to_litter = reshape(cn51_m_leafc_to_litter_read_mat,[2,38112]);
cn51_m_leafc_to_litter = reshape(cn51_m_leafc_to_litter_read_mat,[2,178368]);
cn51_m_leafc_to_litter = cn51_m_leafc_to_litter';


% read CLM5 water potential data

clm5_read_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/out.txt';

fileID = fopen(clm5_read_file,'r');
clm5_vegwp_read_mat = fscanf(fileID,'%i %i %f %f %f %f');
fclose(fileID);

clm5_vegwp = reshape(clm5_vegwp_read_mat,[6,134514/2]);
clm5_vegwp = clm5_vegwp';

% read CLM5 transpiration data

clm5_tran_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/tran.txt';

fileID = fopen(clm5_tran_file,'r');
clm5_tran_read_mat = fscanf(fileID,'%i %i %f');
fclose(fileID);

clm5_tran = reshape(clm5_tran_read_mat,[3,67257]);
clm5_tran = clm5_tran';

% read CLM5 LAI data

clm5_tlai_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/tlai.txt';

fileID = fopen(clm5_tlai_file,'r');
clm5_tlai_read_mat = fscanf(fileID,'%i %i %f');
fclose(fileID);

clm5_tlai = reshape(clm5_tlai_read_mat,[3,67257]);
clm5_tlai = clm5_tlai';

% read CLM5 LAI sun/shade  data

clm5_laiss_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/lai_sun_sha.txt';

fileID = fopen(clm5_laiss_file,'r');
clm5_laiss_read_mat = fscanf(fileID,'%i %f %f');
fclose(fileID);

clm5_laiss = reshape(clm5_laiss_read_mat,[3,17378/2]);
clm5_laiss = clm5_laiss';

% read CLM5 GPP data

clm5_gpp_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/gpp.txt';

fileID = fopen(clm5_gpp_file,'r');
clm5_gpp_read_mat = fscanf(fileID,'%i %f %f %f');
fclose(fileID);

clm5_gpp = reshape(clm5_gpp_read_mat,[4,17378/2]);
clm5_gpp = clm5_gpp';

% read CLM5 leaf carbon data

clm5_leafc_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/leafc.txt';

fileID = fopen(clm5_leafc_file,'r');
clm5_leafc_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_leafc = reshape(clm5_leafc_read_mat,[2,8687]);
clm5_leafc = clm5_leafc';


%% read CLM5 transpiration data
%
%clm5_tran_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/tran2.txt';
%
%fileID = fopen(clm5_tran_file,'r');
%clm5_tran_read_mat = fscanf(fileID,'%i %f');
%fclose(fileID);
%
%clm5_tran = reshape(clm5_tran_read_mat,[2,13077]);
%clm5_tran = clm5_tran';



% read CLM5 conductance data

clm5_cond_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/cond.txt';

fileID = fopen(clm5_cond_file,'r');
clm5_cond_read_mat = fscanf(fileID,'%i %i %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f');
fclose(fileID);

clm5_cond = reshape(clm5_cond_read_mat,[62,1412397/21]);
clm5_cond = clm5_cond';

% read CLM5 hydrology data

clm5_hydro_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/hydro.txt';

fileID = fopen(clm5_hydro_file,'r');
clm5_hydro_read_mat = fscanf(fileID,'%i %i %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f');
fclose(fileID);

clm5_hydro = reshape(clm5_hydro_read_mat,[77,1748682/26]);
clm5_hydro = clm5_hydro';


% read CLM5 root fraction

clm5_rootfr_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/rootfr.txt';

fileID = fopen(clm5_rootfr_file,'r');
clm5_rootfr_read_mat = fscanf(fileID,'%i %i %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f');
fclose(fileID);

clm5_rootfr = reshape(clm5_rootfr_read_mat,[27,605313/9]);
clm5_rootfr = clm5_rootfr';

% read CLM5 cpool_to_leafc fraction

clm5_cpool_to_leafc_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/cpool_to_leafc.txt';

fileID = fopen(clm5_cpool_to_leafc_file,'r');
clm5_cpool_to_leafc_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_cpool_to_leafc = reshape(clm5_cpool_to_leafc_read_mat,[2,8689]);
clm5_cpool_to_leafc = clm5_cpool_to_leafc';

% read CLM5 hrv_leafc_to_litter fraction

clm5_hrv_leafc_to_litter_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/hrv_leafc_to_litter.txt';

fileID = fopen(clm5_hrv_leafc_to_litter_file,'r');
clm5_hrv_leafc_to_litter_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_hrv_leafc_to_litter = reshape(clm5_hrv_leafc_to_litter_read_mat,[2,8689]);
clm5_hrv_leafc_to_litter = clm5_hrv_leafc_to_litter';

% read CLM5 leafc_to_litter fraction

clm5_leafc_to_litter_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/leafc_to_litter.txt';

fileID = fopen(clm5_leafc_to_litter_file,'r');
clm5_leafc_to_litter_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_leafc_to_litter = reshape(clm5_leafc_to_litter_read_mat,[2,8689]);
clm5_leafc_to_litter = clm5_leafc_to_litter';

% read CLM5 leafc_xfer_to_leafc fraction

clm5_leafc_xfer_to_leafc_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/leafc_xfer_to_leafc.txt';

fileID = fopen(clm5_leafc_xfer_to_leafc_file,'r');
clm5_leafc_xfer_to_leafc_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_leafc_xfer_to_leafc = reshape(clm5_leafc_xfer_to_leafc_read_mat,[2,8689]);
clm5_leafc_xfer_to_leafc = clm5_leafc_xfer_to_leafc';

% read CLM5 m_leafc_to_fire fraction

clm5_m_leafc_to_fire_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/m_leafc_to_fire.txt';

fileID = fopen(clm5_m_leafc_to_fire_file,'r');
clm5_m_leafc_to_fire_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_m_leafc_to_fire = reshape(clm5_m_leafc_to_fire_read_mat,[2,8689]);
clm5_m_leafc_to_fire = clm5_m_leafc_to_fire';

% read CLM5 m_leafc_to_litter_fire fraction

clm5_m_leafc_to_litter_fire_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/m_leafc_to_litter_fire.txt';

fileID = fopen(clm5_m_leafc_to_litter_fire_file,'r');
clm5_m_leafc_to_litter_fire_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_m_leafc_to_litter_fire = reshape(clm5_m_leafc_to_litter_fire_read_mat,[2,8689]);
clm5_m_leafc_to_litter_fire = clm5_m_leafc_to_litter_fire';

% read CLM5 m_leafc_to_litter fraction

clm5_m_leafc_to_litter_file = '/discover/nobackup/jkolassa/CLM_test/ctsm_test_runs/ctsm_test/run/m_leafc_to_litter.txt';

fileID = fopen(clm5_m_leafc_to_litter_file,'r');
clm5_m_leafc_to_litter_read_mat = fscanf(fileID,'%i %f');
fclose(fileID);

clm5_m_leafc_to_litter = reshape(clm5_m_leafc_to_litter_read_mat,[2,8689]);
clm5_m_leafc_to_litter = clm5_m_leafc_to_litter';

% read vegetation distribution fraction

cn51_rst_file = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_CN51_local_280_xroot/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_CN51_local_280_xroot.catchcnclm51_internal_rst.19800101_0000';
ityp = ncread(cn51_rst_file, 'ITY');
fveg = ncread(cn51_rst_file, 'FVG');


patch_vec = [5 11 21 27 37 43];

for i = 1:length(patch_vec)
    patch_index = cn51_vegwp(:,1) == patch_vec(i);

    cn51_vegwp_patch{i} = cn51_vegwp(patch_index,2:end);
    cn51_tran_patch{i} = cn51_tran(patch_index,2:end);
    cn51_cond_patch{i} = cn51_cond(patch_index,2:end);
    cn51_hydro_patch{i} = cn51_hydro(patch_index,2:end);
    cn51_tlai_patch{i} = cn51_tlai(patch_index,2:end);
    cn51_laiss_patch{i} = cn51_laiss(patch_index,2:end);

    patch_index_gpp = cn51_gpp(:,1) == patch_vec(i);
    cn51_gpp_patch{i} = cn51_gpp(patch_index_gpp,2);
    cn51_psnsun_patch{i} = cn51_gpp(patch_index_gpp,3);
    cn51_psnsha_patch{i} = cn51_gpp(patch_index_gpp,4);
    cn51_leafc_patch{i} = cn51_leafc(patch_index_gpp,2);
    cn51_cpool_to_leafc_patch{i} = cn51_cpool_to_leafc(patch_index_gpp,2);
    cn51_hrv_leafc_to_litter_patch{i} = cn51_hrv_leafc_to_litter(patch_index_gpp,2);
    cn51_leafc_to_litter_patch{i} = cn51_leafc_to_litter(patch_index_gpp,2);
    cn51_leafc_xfer_to_leafc_patch{i} = cn51_leafc_xfer_to_leafc(patch_index_gpp,2);
    cn51_m_leafc_to_fire_patch{i} = cn51_m_leafc_to_fire(patch_index_gpp,2);
    cn51_m_leafc_to_litter_fire_patch{i} = cn51_m_leafc_to_litter_fire(patch_index_gpp,2);
    cn51_m_leafc_to_litter_patch{i} = cn51_m_leafc_to_litter(patch_index_gpp,2);   
end

% compute patch averages

pft4_avg_vegwp = (0.1*cn51_vegwp_patch{1} + 0.45*cn51_vegwp_patch{3} + 0.45*cn51_vegwp_patch{5});
pft4_avg_tran = (0.1*cn51_tran_patch{1} + 0.45*cn51_tran_patch{3} + 0.45*cn51_tran_patch{5});
pft4_avg_cond = (0.1*cn51_cond_patch{1} + 0.45*cn51_cond_patch{3} + 0.45*cn51_cond_patch{5});
pft4_avg_gpp = (0.1*cn51_gpp_patch{1} + 0.45*cn51_gpp_patch{3} + 0.45*cn51_gpp_patch{5});
pft4_avg_psnsun = (0.1*cn51_psnsun_patch{1} + 0.45*cn51_psnsun_patch{3} + 0.45*cn51_psnsun_patch{5});
pft4_avg_psnsha = (0.1*cn51_psnsha_patch{1} + 0.45*cn51_psnsha_patch{3} + 0.45*cn51_psnsha_patch{5});
pft4_avg_hydro = (0.1*cn51_hydro_patch{1} + 0.45*cn51_hydro_patch{3} + 0.45*cn51_hydro_patch{5});
pft4_avg_tlai = (0.1*cn51_tlai_patch{1} + 0.45*cn51_tlai_patch{3} + 0.45*cn51_tlai_patch{5});
pft4_avg_leafc = (0.1*cn51_leafc_patch{1} + 0.45*cn51_leafc_patch{3} + 0.45*cn51_leafc_patch{5});
pft4_avg_laiss = (0.1*cn51_laiss_patch{1} + 0.45*cn51_laiss_patch{3} + 0.45*cn51_laiss_patch{5});
pft4_avg_cpool_to_leafc = (0.1*cn51_cpool_to_leafc_patch{1} + 0.45*cn51_cpool_to_leafc_patch{3} + 0.45*cn51_cpool_to_leafc_patch{5});
pft4_avg_hrv_leafc_to_litter = (0.1*cn51_hrv_leafc_to_litter_patch{1} + 0.45*cn51_hrv_leafc_to_litter_patch{3} + 0.45*cn51_hrv_leafc_to_litter_patch{5});
pft4_avg_leafc_to_litter = (0.1*cn51_leafc_to_litter_patch{1} + 0.45*cn51_leafc_to_litter_patch{3} + 0.45*cn51_leafc_to_litter_patch{5});
pft4_avg_leafc_xfer_to_leafc = (0.1*cn51_leafc_xfer_to_leafc_patch{1} + 0.45*cn51_leafc_xfer_to_leafc_patch{3} + 0.45*cn51_leafc_xfer_to_leafc_patch{5});
pft4_avg_m_leafc_to_fire = (0.1*cn51_m_leafc_to_fire_patch{1} + 0.45*cn51_m_leafc_to_fire_patch{3} + 0.45*cn51_m_leafc_to_fire_patch{5});
pft4_avg_m_leafc_to_litter_fire = (0.1*cn51_m_leafc_to_litter_fire_patch{1} + 0.45*cn51_m_leafc_to_litter_fire_patch{3} + 0.45*cn51_m_leafc_to_litter_fire_patch{5});
pft4_avg_m_leafc_to_litter = (0.1*cn51_m_leafc_to_litter_patch{1} + 0.45*cn51_m_leafc_to_litter_patch{3} + 0.45*cn51_m_leafc_to_litter_patch{5});


% isolate CLM5 PFT 5 data

patch_index = clm5_vegwp(:,1) == 11199;

iter_index = find(clm5_vegwp(:,2) == 0);
iter_index = iter_index-1;
iter_index(iter_index<=0) = [];
pft4_clm5_vegwp = clm5_vegwp(iter_index,3:end);

iter_index = find(clm5_tran(:,2) == 0);
iter_index = iter_index-1;
iter_index(iter_index<=0) = [];
pft4_clm5_tran = clm5_tran(iter_index,3);

iter_index = find(clm5_tlai(:,2) == 0);
iter_index = iter_index-1;
iter_index(iter_index<=0) = [];
pft4_clm5_tlai = clm5_tlai(iter_index,3);

iter_index = find(clm5_cond(:,2) == 0);
iter_index = iter_index-1;
iter_index(iter_index<=0) = [];
pft4_clm5_ksoil_root = clm5_cond(iter_index,3:22);
pft4_clm5_rootcond = clm5_cond(iter_index,23:42);
pft4_clm5_soilcond = clm5_cond(iter_index,43:62);

iter_index = find(clm5_hydro(:,2) == 0);
iter_index = iter_index-1;
iter_index(iter_index<=0) = [];
pft4_clm5_hkl = clm5_hydro(iter_index,3:27);
pft4_clm5_hksat = clm5_hydro(iter_index,24:52);
pft4_clm5_smp = clm5_hydro(iter_index,53:77);

pft4_clm5_gpp = clm5_gpp(:,2);
pft4_clm5_psnsun = clm5_gpp(:,3);
pft4_clm5_psnsha = clm5_gpp(:,4);

pft4_clm5_leafc = clm5_leafc(:,2);
pft4_clm5_cpool_to_leafc = clm5_cpool_to_leafc(:,2);
pft4_clm5_hrv_leafc_to_litter = clm5_hrv_leafc_to_litter(:,2);
pft4_clm5_leafc_to_litter = clm5_leafc_to_litter(:,2);
pft4_clm5_leafc_xfer_to_leafc = clm5_leafc_xfer_to_leafc(:,2);
pft4_clm5_m_leafc_to_fire = clm5_m_leafc_to_fire(:,2);
pft4_clm5_m_leafc_to_litter_fire = clm5_m_leafc_to_litter_fire(:,2);
pft4_clm5_m_leafc_to_litter = clm5_m_leafc_to_litter(:,2);


pft4_clm5_laisun = clm5_laiss(:,2);
pft4_clm5_laisha = clm5_laiss(:,3);

monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
time_vec = 7.5:7.5:(7.5*size(pft4_avg_vegwp,1));
time_vec_90min = 90:90:(90*size(pft4_avg_gpp,1));
time_vec_clm = 30:30:30*48*sum(monthLength_nly(1:6));


figure
plot(time_vec,pft4_avg_vegwp(:,1),'LineWidth',2)
hold on
plot(time_vec,pft4_avg_vegwp(:,2),'LineWidth',2)
hold on
plot(time_vec,pft4_avg_vegwp(:,3),'LineWidth',2)
hold on
plot(time_vec,pft4_avg_vegwp(:,4),'LineWidth',2)
hold off 
grid on
xlabel('time [minutes]')
ylabel('vegetation water matric potential [mm]')
legend('sunlit leaf','shaded leaf','xylem','root')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4'],'png')

figure
plot(pft4_clm5_vegwp(:,1),'LineWidth',2)
hold on
plot(pft4_clm5_vegwp(:,2),'LineWidth',2)
hold on
plot(pft4_clm5_vegwp(:,3),'LineWidth',2)
hold on
plot(pft4_clm5_vegwp(:,4),'LineWidth',2)
hold off
grid on
ylabel('vegetation water matric potential [mm]')
legend('sunlit leaf','shaded leaf','xylem','root')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_CLM5'],'png')

figure
plot(time_vec(1:192),pft4_avg_vegwp(1:192,1),'LineWidth',2)
hold on
plot(time_vec(1:192),pft4_avg_vegwp(1:192,2),'LineWidth',2)
hold on
plot(time_vec(1:192),pft4_avg_vegwp(1:192,3),'LineWidth',2)
hold on
plot(time_vec(1:192),pft4_avg_vegwp(1:192,4),'LineWidth',2)
hold off
grid on
xlabel('time [minutes]')
ylabel('vegetation water matric potential [mm]')
legend('sunlit leaf','shaded leaf','xylem','root')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_24h'],'png')

figure
plot(time_vec(1:192),pft4_avg_vegwp(1:192,1),'LineWidth',2)
hold on
plot(time_vec_clm(1:48),pft4_clm5_vegwp(1:48,1),'LineWidth',2)
hold off
grid on
xlabel('time [minutes]')
ylabel('vegetation water matric potential [mm]')
title('sunlit leaf')
legend('CN51','CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_sunlit_PFT4_24h'],'png')

figure 
tiledlayout("vertical")
plot(time_vec,pft4_avg_vegwp(:,1),'LineWidth',2)
xlabel('time [minutes]')
ylabel('vegetation water matric potential [mm]')
title('sunlit leaf')

nexttile
plot(time_vec,pft4_avg_vegwp(:,2),'LineWidth',2)
xlabel('time [minutes]')  
ylabel('vegetation water matric potential [mm]')
title('shaded leaf')

nexttile
plot(time_vec,pft4_avg_vegwp(:,3),'LineWidth',2)
xlabel('time [minutes]')
ylabel('vegetation water matric potential [mm]')
title('xylem')

nexttile
plot(time_vec,pft4_avg_vegwp(:,4),'LineWidth',2)
xlabel('time [minutes]')
ylabel('vegetation water matric potential [mm]')
title('root')

set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_tiled'],'png')

figure 
subplot(2,1,1)
plot(time_vec,pft4_avg_vegwp(:,1),'LineWidth',2)
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 max(time_vec)])
title('sunlit leaf CN51')

subplot(2,1,2)
plot(pft4_clm5_vegwp(:,1),'LineWidth',2) 
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 length(time_vec_clm)])
title('sunlit leaf CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_sunlit_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec,pft4_avg_vegwp(:,2),'LineWidth',2)
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 max(time_vec)])
title('shaded leaf CN51')

subplot(2,1,2)
plot(pft4_clm5_vegwp(:,2),'LineWidth',2) 
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 length(time_vec_clm)])
title('shaded leaf CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_shaded_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec,pft4_avg_vegwp(:,3),'LineWidth',2)
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 max(time_vec)])
title('xylem CN51')

subplot(2,1,2)
plot(pft4_clm5_vegwp(:,3),'LineWidth',2) 
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 length(time_vec_clm)])
title('xylem CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_xylem_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec,pft4_avg_vegwp(:,4),'LineWidth',2)
set(gca,'YLim',[-0.25*10^5 0])
set(gca,'XLim',[0 max(time_vec)])
title('root CN51')

subplot(2,1,2)
plot(pft4_clm5_vegwp(:,4),'LineWidth',2) 
set(gca,'YLim',[-0.25*10^5 0])
set(gca,'XLim',[0 length(time_vec_clm)])
title('root CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_root_tiled'],'png')

plot_months = [1 6];
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];

for i = 1:length(plot_months)

    if plot_months(i)==1
       cn_start_index(i) = 1;
       cn_stop_index(i) = monthLength_nly(i)*192;
       cn_start_index_gpp(i) = 1;
       cn_stop_index_gpp(i) = monthLength_nly(i)*16;
       clm_start_index(i) = 1;
       clm_stop_index(i) = monthLength_nly(i)*48;
    else
       cn_start_index(i) = (sum(monthLength_nly(1:(plot_months(i)-1)))*192) + 1;
       cn_stop_index(i) = sum(monthLength_nly(1:plot_months(i)))*192;
       cn_start_index_gpp(i) = (sum(monthLength_nly(1:(plot_months(i)-1)))*16) + 1;
       cn_stop_index_gpp(i) = sum(monthLength_nly(1:plot_months(i)))*16;
       clm_start_index(i) = (sum(monthLength_nly(1:(plot_months(i)-1)))*48) + 1;
       clm_stop_index(i) = sum(monthLength_nly(1:plot_months(i)))*48;
    end
end

cn_start_index_gpp(3) = (sum(monthLength_nly(1:(13-1)))*16) + 1;
cn_stop_index_gpp(3) = (sum(monthLength_nly(1:12))+monthLength_nly(1))*16;
cn_start_index(3) = (sum(monthLength_nly(1:(13-1)))*192) + 1;
cn_stop_index(3) = (sum(monthLength_nly(1:12))+monthLength_nly(1))*192;

cn_start_index_gpp(4) = (sum(monthLength_nly(1:(13-1))*5)*16) + 1;
cn_stop_index_gpp(4) = (sum(monthLength_nly(1:12)*5)+monthLength_nly(1))*16;
cn_start_index(4) = (sum(monthLength_nly(1:(13-1)))*5*192) + 1;
cn_stop_index(4) = (sum(monthLength_nly(1:12)*5)+monthLength_nly(1))*192;

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_vegwp(cn_start_index(i):cn_stop_index(i),1),...
    'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('sunlit leaf CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,...
    pft4_clm5_vegwp(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('sunlit leaf CLM5')
legend(legend_str)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_sunlit_months_1_6_tiled'],'png')


figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_vegwp(cn_start_index(i):cn_stop_index(i),2),...
    'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('shaded leaf CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,...
    pft4_clm5_vegwp(clm_start_index(i):clm_stop_index(i),2),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('shaded leaf CLM5')
legend(legend_str)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_shaded_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_vegwp(cn_start_index(i):cn_stop_index(i),3),...
    'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('xylem CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,...
    pft4_clm5_vegwp(clm_start_index(i):clm_stop_index(i),1),'LineWidth',3)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3*10^5 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('xylem CLM5')
legend(legend_str)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_xylem_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_vegwp(cn_start_index(i):cn_stop_index(i),4),...
    'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-0.3*10^5 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('root CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,...
    pft4_clm5_vegwp(clm_start_index(i):clm_stop_index(i),4),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-0.3*10^5 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('root CLM5')
legend(legend_str)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_root_months_1_6_tiled'],'png')

figure 
plot(time_vec,pft4_avg_vegwp(:,1),'LineWidth',2)
title('sunlit leaf CN51')
saveas(gcf,['test'],'png')

% plot potential differences

cn51_xylem_root = pft4_avg_vegwp(:,3) - pft4_avg_vegwp(:,4);
clm5_xylem_root = pft4_clm5_vegwp(:,3) - pft4_clm5_vegwp(:,4);

cn51_sha_xylem = pft4_avg_vegwp(:,2) - pft4_avg_vegwp(:,3);
clm5_sha_xylem = pft4_clm5_vegwp(:,2) - pft4_clm5_vegwp(:,3);

cn51_sun_xylem = pft4_avg_vegwp(:,1) - pft4_avg_vegwp(:,3);
clm5_sun_xylem = pft4_clm5_vegwp(:,1) - pft4_clm5_vegwp(:,3);

figure
subplot(2,1,1)
plot(time_vec,cn51_xylem_root,'LineWidth',2)
set(gca,'YLim',[-2.5*10^5 0])
set(gca,'XLim',[0 max(time_vec)])
title('psi_{xylem} - psi_{root} CN51')

subplot(2,1,2)
plot(clm5_xylem_root,'LineWidth',2)
set(gca,'YLim',[-2.5*10^5 0])
set(gca,'XLim',[0 max(time_vec_clm)])
title('psi_{xylem} - psi_{root} CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_root_xylem_diff_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec,cn51_sha_xylem,'LineWidth',2)
set(gca,'YLim',[-2000 0])
set(gca,'XLim',[0 max(time_vec)])
title('psi_{sha} - psi_{xylem} CN51')

subplot(2,1,2)
plot(clm5_sha_xylem,'LineWidth',2)
set(gca,'YLim',[-2000 0])
set(gca,'XLim',[0 max(time_vec_clm)])
title('psi_{sha} - psi_{xylem} CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_xylem_sha_diff_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec,cn51_sun_xylem,'LineWidth',2)
set(gca,'YLim',[-3000 0])
set(gca,'XLim',[0 max(time_vec)])
title('psi_{sun} - psi_{xylem} CN51')

subplot(2,1,2)
plot(clm5_sun_xylem,'LineWidth',2)
set(gca,'YLim',[-3000 0])
set(gca,'XLim',[0 max(time_vec_clm)])
title('psi_{sun} - psi_{xylem} CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_xylem_sun_diff_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,cn51_xylem_root(cn_start_index(i):cn_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-2.5*10^5 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('psi_{xylem} - psi_{root} CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,clm5_xylem_root(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-2.5*10^5 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('psi_{xylem} - psi_{root} CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_root_xylem_diff_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,cn51_sha_xylem(cn_start_index(i):cn_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-2000 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('psi_{sha} - psi_{xylem} CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,clm5_sha_xylem(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-2000 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('psi_{sha} - psi_{xylem} CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_xylem_sha_diff_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,cn51_sun_xylem(cn_start_index(i):cn_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3000 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('psi_{sun} - psi_{xylem} CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,clm5_sun_xylem(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-3000 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('psi_{sun} - psi_{xylem} CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGWP_PFT4_xylem_sun_diff_months_1_6_tiled'],'png')

% plot transpiration

figure
subplot(2,1,1)
plot(time_vec,pft4_avg_tran(:,1),'LineWidth',2)
set(gca,'YLim',[0 8*10^(-5)])
set(gca,'XLim',[0 max(time_vec)])
title('transpiration [mm] CN51')

subplot(2,1,2)
plot(time_vec_clm,pft4_clm5_tran(:,1),'LineWidth',2)
set(gca,'YLim',[0 8*10^(-5)])
set(gca,'XLim',[0 max(time_vec_clm)])
title('transpiration [mm] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TRAN_PFT4_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_tran(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 8*10^(-5)])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('transpiration [mm] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_tran(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 8*10^(-5)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('transpiration [mm] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TRAN_PFT4_months_1_6_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec(1:192),pft4_avg_tran(1:192,1),'LineWidth',2)
set(gca,'YLim',[0 8*10^(-5)])
%set(gca,'XLim',[0 max(time_vec)])
title('transpiration [mm] CN51')

subplot(2,1,2)
plot(time_vec_clm(1:48),pft4_clm5_tran(1:48,1),'LineWidth',2)
set(gca,'YLim',[0 8*10^(-5)])
%set(gca,'XLim',[0 max(time_vec_clm)])
title('transpiration [mm] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TRAN_PFT4_day1_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec(193:384),pft4_avg_tran(193:384,1),'LineWidth',2)
set(gca,'YLim',[0 8*10^(-5)])
%set(gca,'XLim',[0 max(time_vec)])
title('transpiration [mm] CN51')

subplot(2,1,2)
plot(time_vec_clm(49:96),pft4_clm5_tran(49:96,1),'LineWidth',2)
set(gca,'YLim',[0 8*10^(-5)])
%set(gca,'XLim',[0 max(time_vec_clm)])
title('transpiration [mm] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TRAN_PFT4_day2_tiled'],'png')

% plot gpp

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_gpp(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;  
plot(plot_time_vec,pft4_avg_gpp(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4; 
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_gpp(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('GPP [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_gpp(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('GPP [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_PFT4_months_1_6_tiled'],'png')

% plot leaf carbon

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('leaf carbon [gC m^{-2}] CN51')
legend(legend_str)

pft4_clm5_leafc = [pft4_clm5_leafc; NaN; NaN];

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_leafc(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('leaf carbon [gC m^{-2}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LEAFC_PFT4_months_1_6_tiled'],'png')

% plot LAI sun/sha

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_laiss(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
plot(plot_time_vec,pft4_avg_laiss(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('LAI sunlit [-] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_laisun(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('LAI sunlit [-] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAISUN_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_laiss(cn_start_index(i):cn_stop_index(i),2),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
plot(plot_time_vec,pft4_avg_laiss(cn_start_index(i):cn_stop_index(i),2),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('LAI shade [-] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_laisha(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 3*10^(-4)]) 
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('LAI shade [-] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAISHA_PFT4_months_1_6_tiled'],'png')

% plot photosynthesis

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_psnsun(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 1.5*10^(-4)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('PSNSUN [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_psnsun(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 1.5*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('PSNSUN [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/PSNSUN_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)    
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_psnsha(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 1.5*10^(-4)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('PSNSHA [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};  
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_psnsha(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 1.5*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('PSNSHA [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])    
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/PSNSHA_PFT4_months_1_6_tiled'],'png')

% plot LAI

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_tlai(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
plot(plot_time_vec,pft4_avg_tlai(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
plot(plot_time_vec,pft4_avg_tlai(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
set(gca,'YLim',[0 9])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('LAI [-] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_tlai(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 9])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('LAI [-] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TLAI_PFT4_months_1_6_tiled'],'png')

% plot conductances

legend_str = {'10mm','40mm','90mm','160mm','260mm','400mm','580mm','800mm','1060mm','1360mm','1700mm','2080mm',...
                    '2500mm','2990mm','3580mm','4270mm','5060mm','5950mm','6940mm','8030mm'};
cmap_mat = colormap(jet(20));


figure
subplot(2,1,1)
plot(time_vec,pft4_avg_cond(:,1),'LineWidth',2)
set(gca,'YLim',[0 6*10^(-9)])
set(gca,'XLim',[0 max(time_vec)])
title('k\_soil\_root [mm/s] CN51')

subplot(2,1,2) 
for i = 1:size(pft4_clm5_ksoil_root,2)
    plot(pft4_clm5_ksoil_root(:,i),'Color',cmap_mat(i,:),'LineWidth',2)
    hold on
end
hold off
set(gca,'YLim',[0 6*10^(-9)])
set(gca,'XLim',[0 max(time_vec_clm)])
title('k\_soil\_root [mm/s] CLM5')
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 25])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/K_SOIL_ROOT_PFT4_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec,pft4_avg_cond(:,2),'LineWidth',2)
set(gca,'YLim',[0 6*10^(-9)])
set(gca,'XLim',[0 max(time_vec)])
title('root conductance [mm/s] CN51')

subplot(2,1,2)
for i = 1:size(pft4_clm5_rootcond,2)
    plot(pft4_clm5_rootcond(:,i),'Color',cmap_mat(i,:),'LineWidth',2)
    hold on
end
hold off
set(gca,'YLim',[0 6*10^(-9)])
set(gca,'XLim',[0 max(time_vec_clm)])
title('root conductance [mm/s] CLM5')
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 25])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/ROOTCOND_PFT4_tiled'],'png')

figure
subplot(2,1,1)
plot(time_vec,pft4_avg_cond(:,3),'LineWidth',2)
set(gca,'YLim',[0 6*10^(-3)])
set(gca,'XLim',[0 max(time_vec)])
title('soil conductance [mm/s] CN51')

subplot(2,1,2)
for i = 1:size(pft4_clm5_rootcond,2)
    plot(pft4_clm5_soilcond(:,i),'Color',cmap_mat(i,:),'LineWidth',2)
    hold on
end 
set(gca,'YLim',[0 6*10^(-4)])
set(gca,'XLim',[0 max(time_vec_clm)])
title('soil conductance [mm/s] CLM5')
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 25])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/SOILCOND_PFT4_tiled'],'png')

pft4_clm5_ksoil_root_avg = sum(pft4_clm5_ksoil_root(:,1:8),2);
pft4_clm5_rootcond_avg = sum(pft4_clm5_rootcond(:,1:8),2);
pft4_clm5_soilcond_avg = sum(pft4_clm5_soilcond(:,1:8),2);

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_cond(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 4*10^(-8)])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('k\_soil\_root [mm/s] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_ksoil_root_avg(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 4*10^(-8)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('k\_soil\_root [mm/s] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/K_SOIL_ROOT_PFT4_avg_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_cond(cn_start_index(i):cn_stop_index(i),2),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 4*10^(-8)])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('root conductance [mm/s] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_rootcond_avg(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 4*10^(-8)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('root conductance [mm/s] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/ROOTCOND_PFT4_avg_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_cond(cn_start_index(i):cn_stop_index(i),3),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 6*10^(-3)])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('soil conductance [mm/s] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_soilcond_avg(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 6*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('soil conductance [mm/s] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/SOILCOND_PFT4_avg_months_1_6_tiled'],'png')

% plot hyrdology

pft4_clm5_hkl_avg = sum(pft4_clm5_hkl(:,1:8),2);
pft4_clm5_hksat_avg = sum(pft4_clm5_hksat(:,1:8),2);
pft4_clm5_smp_avg = sum(pft4_clm5_smp(:,1:8),2);

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_hydro(cn_start_index(i):cn_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 0.07])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('hydraulic conductivity [mm/s] CN51')
legend(legend_str)
    
subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_hkl_avg(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 0.07])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('hydraulic conductivity [mm/s] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/HKL_PFT4_avg_months_1_6_tiled'],'png')

figure
legend_str = {};      
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_hydro(cn_start_index(i):cn_stop_index(i),2),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 0.12])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('hydraulic conductivity at saturation [mm/s] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)     
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_hksat_avg(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 0.12])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('hydraulic conductivity at saturation [mm/s] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/HKSAT_PFT4_avg_months_1_6_tiled'],'png')

figure
legend_str = {};      
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec(cn_start_index(i):cn_stop_index(i))-time_vec(cn_start_index(i))+7.5;
    plot(plot_time_vec,pft4_avg_hydro(cn_start_index(i):cn_stop_index(i),3),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-25000 0])
set(gca,'XLim',[0 time_vec(cn_stop_index(1))])
title('soil matric potential [mm] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)     
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_smp_avg(clm_start_index(i):clm_stop_index(i)),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-25000 0])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('soil matric potential [mm] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/SMP_PFT4_avg_months_1_6_tiled'],'png')

% plot fluxes contributing to leaf carbon
       
figure 
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_cpool_to_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end    
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_cpool_to_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_cpool_to_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
%set(gca,'YLim',[0 2*10^(-5)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('cpool\_to\_leafc [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_cpool_to_leafc(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 2*10^(-5)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('cpool\_to\_leafc [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_cpool_to_leafc_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_hrv_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_hrv_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_hrv_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('hrv\_leafc\_to\_litter [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_hrv_leafc_to_litter(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('hrv\_ leafc\_to\_litter [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_hrv_leafc_to_litter_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
set(gca,'YLim',[0 9*10^(-6)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('leafc\_to\_litter [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_leafc_to_litter(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 9*10^(-6)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('leafc\_to\_litter [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_leafc_to_litter_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_leafc_xfer_to_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc_xfer_to_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc_xfer_to_leafc(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
set(gca,'YLim',[0 6*10^(-6)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('leafc\_xfer\_to\_leafc [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_leafc_xfer_to_leafc(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 6*10^(-6)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('leafc\_xfer\_to\_leafc [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_leafc_xfer_to_leafc_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_m_leafc_to_fire(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_m_leafc_to_fire(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_m_leafc_to_fire(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('m\_leafc\_to\_fire [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {}; 
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_m_leafc_to_fire(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('m\_leafc\_to\_fire [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_m_leafc_to_fire_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_m_leafc_to_litter_fire(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_m_leafc_to_litter_fire(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_m_leafc_to_litter_fire(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('m\_leafc\_to\_litter\_fire [gC m^{-2} s^{-1}] CN51')
legend(legend_str)

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_m_leafc_to_litter_fire(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
%set(gca,'YLim',[0 3*10^(-4)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('m\_leafc\_to\_litter\_fire [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])   
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_m_leafc_to_litter_fire_PFT4_months_1_6_tiled'],'png')

figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_m_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_m_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_m_leafc_to_litter(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
set(gca,'YLim',[0 2.5*10^(-7)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title('m\_leafc\_to\_litter [gC m^{-2} s^{-1}] CN51')
legend(legend_str)      

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_m_leafc_to_litter(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[0 2.5*10^(-7)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title('m\_leafc\_to\_litter [gC m^{-2} s^{-1}] CLM5')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_m_leafc_to_litter_PFT4_months_1_6_tiled'],'png')

% compute total flux

pft4_avg_leafc_total_flux = pft4_avg_cpool_to_leafc + pft4_avg_leafc_xfer_to_leafc - pft4_avg_hrv_leafc_to_litter ...
                          - pft4_avg_leafc_to_litter - pft4_avg_m_leafc_to_fire - pft4_avg_m_leafc_to_litter ...
                          - pft4_avg_m_leafc_to_litter_fire;
pft4_clm5_leafc_total_flux = pft4_clm5_cpool_to_leafc + pft4_clm5_leafc_xfer_to_leafc - pft4_clm5_hrv_leafc_to_litter ...
                          - pft4_clm5_leafc_to_litter - pft4_clm5_m_leafc_to_fire - pft4_clm5_m_leafc_to_litter ...
                          - pft4_clm5_m_leafc_to_litter_fire;


figure
legend_str = {};
subplot(2,1,1)
for i = 1:length(plot_months)
    plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
    plot(plot_time_vec,pft4_avg_leafc_total_flux(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
i = 3; 
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc_total_flux(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(13)];
i = 4;
plot_time_vec = time_vec_90min(cn_start_index_gpp(i):cn_stop_index_gpp(i))-time_vec_90min(cn_start_index_gpp(i))+90;
plot(plot_time_vec,pft4_avg_leafc_total_flux(cn_start_index_gpp(i):cn_stop_index_gpp(i),1),'LineWidth',2)
legend_str{i} = ['month ' num2str(61)];
hold off
set(gca,'YLim',[-1*10^(-5) 1.5*10^(-5)])
set(gca,'XLim',[0 time_vec_90min(cn_stop_index_gpp(1))])
title(['total flux to leaf carbon pool [gC m^{-2} s^{-1}] CN51; avg. for 6-months: ' num2str(nanmean(pft4_avg_leafc_total_flux(1:cn_stop_index_gpp(2))),2)]);
legend(legend_str)      

subplot(2,1,2)
legend_str = {};
for i = 1:length(plot_months)
    plot_time_vec_clm = time_vec_clm(clm_start_index(i):clm_stop_index(i))-time_vec_clm(clm_start_index(i))+30;
    plot(plot_time_vec_clm,pft4_clm5_leafc_total_flux(clm_start_index(i):clm_stop_index(i),1),'LineWidth',2)
    hold on
    legend_str{i} = ['month ' num2str(plot_months(i))];
end
hold off
set(gca,'YLim',[-1*10^(-5) 1.5*10^(-5)])
set(gca,'XLim',[0 time_vec_clm(clm_stop_index(1))])
title(['total flux to leaf carbon pool [gC m^{-2} s^{-1}] CLM5; avg. for 6-months: ' num2str(nanmean(pft4_clm5_leafc_total_flux),2)])
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15]) 
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_leafc_total_flux_PFT4_months_1_6_tiled'],'png')

time_vec = 1:90:length(pft4_avg_leafc_total_flux);
time_vec = (time_vec/60)/24;

figure
plot(pft4_avg_leafc_total_flux,'LineWidth',2)
grid on
title(['total flux to leaf carbon pool [gC m^{-2} s^{-1}] CN51'])
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LC_leafc_total_flux_total_period'],'png')

time_vec = 1:7.5:length(pft4_avg_tlai);
time_vec = (time_vec/60)/24;

figure
plot(pft4_avg_tlai,'LineWidth',2)
grid on
title(['total LAI [-] CN51'])
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TLAI_total_period'],'png')
