clc
clear all
close all

% read old CatchCN PFT distribution

cnveg_file = '/discover/nobackup/jkolassa/new/CNCLM51_bcs/SMAP_EASEv2_M36/clsm/CLM_veg_typs_fracs';

fid = fopen(cnveg_file,'r');
out = {};
while ~feof(fid)
    data = textscan(fid,'%d%d%d%d%d%d%f%f%f%f%d%d%f%f');
end
fclose(fid);

type_mat = [data{3} data{4} data{5} data{6}];
frac_mat = [data{7} data{8} data{9} data{10}];

restart_file = '/discover/nobackup/jkolassa/restarts/GEOSldas_CNCLM45_NT/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_CNCLM45_NT.catchcnclm51_internal_rst.19800101_0000.4PFT';
cnpft_old = ncread(restart_file,'CNPFT');
psnsham_old = ncread(restart_file,'PSNSHAM');
psnsunm_old = ncread(restart_file,'PSNSUNM');

type_mat = ncread(restart_file,'ITY');
frac_mat = ncread(restart_file,'FVG');

psn_file = '/discover/nobackup/jkolassa/CN40_CN45_test_runs/GEOSldas_CN45/input/restart/catchcnclm45_internal_rst';
psnsham_old = ncread(psn_file,'PSNSHAM');
psnsunm_old = ncread(psn_file,'PSNSUNM');


frac_mat_new = NaN*ones(size(frac_mat,1),2);
type_mat_new = NaN*ones(size(type_mat,1),2);
cnpft_new = NaN*ones(size(cnpft_old,1),498);
psnsham_new = NaN*ones(size(psnsham_old,1),2,size(psnsham_old,3));
psnsunm_new = NaN*ones(size(psnsunm_old,1),2,size(psnsunm_old,3));

for i = 1:size(type_mat,1)
    for v = 1:83
        for nz = 1:3 
            for nv = 1:2 

                new_index = (v-1)*6 + (nv-1)*3 + nz;
                nv_old = (nv-1)*2 + [1 2];
                old_index = (v-1)*12 + (nv_old-1)*3 + nz; 
                type_mat_new(i,1) = max([type_mat(i,1) type_mat(i,2)]);
                type_mat_new(i,2) = max([type_mat(i,3) type_mat(i,4)]);

                if (nv == 1)
                if (type_mat(i,1) == type_mat(i,2))
                  % disp('type 1 and type 2 are the same')
                   frac_mat_new(i,1) = frac_mat(i,1) + frac_mat(i,2);
                   if (isnan(cnpft_old(i,old_index(1))) & (frac_mat(i,1)==0))
                      cnpft_old(i,old_index(1)) = 0;
                   end
                   if (isnan(cnpft_old(i,old_index(2))) & (frac_mat(i,2)==0))
                      cnpft_old(i,old_index(2)) = 0;
                   end
                   if (isnan(psnsunm_old(i,1,nz)) & (frac_mat(i,1)==0))
                      psnsunm_old(i,1,nz) = 0;
                   end 
                   if (isnan(psnsunm_old(i,2,nz)) & (frac_mat(i,2)==0))
                      psnsunm_old(i,2,nz) = 0;
                   end 
                   if (isnan(psnsham_old(i,1,nz)) & (frac_mat(i,1)==0))
                      psnsham_old(i,1,nz) = 0;
                   end 
                   if (isnan(psnsham_old(i,2,nz)) & (frac_mat(i,2)==0))
                      psnsham_old(i,2,nz) = 0;
                   end
                   cnpft_new(i,new_index) = (frac_mat(i,1)*cnpft_old(i,old_index(1)) + ...
                                            frac_mat(i,2)*cnpft_old(i,old_index(2)))/...
                                            (frac_mat(i,1) + frac_mat(i,2));
                   psnsunm_new(i,1,nz) = (frac_mat(i,1)*psnsunm_old(i,1,nz) + ...
                                         frac_mat(i,2)*psnsunm_old(i,2,nz))/...
                                         (frac_mat(i,1) + frac_mat(i,2));
                   psnsham_new(i,1,nz) = (frac_mat(i,1)*psnsham_old(i,1,nz) + ...
                                         frac_mat(i,2)*psnsham_old(i,2,nz))/...
                                         (frac_mat(i,1) + frac_mat(i,2));
                else
                  % disp('1 and 2 are different')
                   frac_mat_new(i,1) = max([frac_mat(i,1) frac_mat(i,2)]);
                   cnpft_new(i,new_index) = max(abs(cnpft_old(i,old_index)));
                   psnsunm_new(i,1,nz) = max([psnsunm_old(i,1,nz) psnsunm_old(i,2,nz)]);
                   psnsham_new(i,1,nz) = max([psnsham_old(i,1,nz) psnsham_old(i,2,nz)]);
                end
                end

                if (nv==2)
                if (type_mat(i,3) == type_mat(i,4))
                   %disp('type 3 and 4 are the same')
                   frac_mat_new(i,2) = frac_mat(i,3) + frac_mat(i,4);
                   if (isnan(cnpft_old(i,old_index(1))) & (frac_mat(i,3)==0))
                      cnpft_old(i,old_index(1)) = 0;
                   end
                   if (isnan(cnpft_old(i,old_index(2))) & (frac_mat(i,4)==0))
                      cnpft_old(i,old_index(2)) = 0;
                   end
                   if (isnan(psnsunm_old(i,3,nz)) & (frac_mat(i,3)==0))
                      psnsunm_old(i,3,nz) = 0;
                   end 
                   if (isnan(psnsunm_old(i,4,nz)) & (frac_mat(i,4)==0))
                      psnsunm_old(i,4,nz) = 0;
                   end
                   if (isnan(psnsham_old(i,3,nz)) & (frac_mat(i,3)==0))
                      psnsham_old(i,3,nz) = 0;
                   end
                   if (isnan(psnsham_old(i,4,nz)) & (frac_mat(i,4)==0))
                      psnsham_old(i,4,nz) = 0;
                   end
                   
                   cnpft_new(i,new_index) = (frac_mat(i,3)*cnpft_old(i,old_index(1)) + ...
                                            frac_mat(i,4)*cnpft_old(i,old_index(2)))/...
                                            (frac_mat(i,3) + frac_mat(i,4));
                   psnsunm_new(i,1,nz) = (frac_mat(i,3)*psnsunm_old(i,3,nz) + ...
                                         frac_mat(i,4)*psnsunm_old(i,4,nz))/...
                                         (frac_mat(i,3) + frac_mat(i,4));
                   psnsham_new(i,1,nz) = (frac_mat(i,3)*psnsham_old(i,3,nz) + ...
                                         frac_mat(i,4)*psnsham_old(i,4,nz))/...
                                         (frac_mat(i,3) + frac_mat(i,4));
                else
                   frac_mat_new(i,2) = max([frac_mat(i,3) frac_mat(i,4)]);
                   cnpft_new(i,new_index) = max(abs(cnpft_old(i,old_index)));
                   psnsunm_new(i,2,nz) = max([psnsunm_old(i,3,nz) psnsunm_old(i,4,nz)]);
                   psnsham_new(i,2,nz) = max([psnsham_old(i,3,nz) psnsham_old(i,4,nz)]);
                end
                end
                 
             end 
        end
    end    
 end 

psnsham_new(isnan(psnsham_new)) = 0;
psnsunm_new(isnan(psnsunm_new)) = 0;

%frac_mat_new = frac_mat_new/100;

save_file = '/discover/nobackup/jkolassa/new/old_rst';

nccreate(save_file,"FVG","Dimensions",{"tile",size(frac_mat_new,1),"unknown_dim2",size(frac_mat_new,2)}, ...
                   "FillValue","disable");
nccreate(save_file,"ITY","Dimensions",{"tile",size(type_mat_new,1),"unknown_dim2",size(type_mat_new,2)}, ...
                   "FillValue","disable");
nccreate(save_file,"CNPFT","Dimensions",{"tile",size(cnpft_new,1),"unknown_dim4",size(cnpft_new,2)}, ...
                   "FillValue","disable");
nccreate(save_file,"PSNSHAM","Dimensions",{"tile",size(psnsham_new,1),"unknown_dim2",size(psnsham_new,2),"unknown_dim1",size(psnsham_new,3)}, ...
                   "FillValue","disable");
nccreate(save_file,"PSNSUNM","Dimensions",{"tile",size(psnsunm_new,1),"unknown_dim2",size(psnsunm_new,2),"unknown_dim1",size(psnsunm_new,3)}, ...
                   "FillValue","disable");


ncwrite(save_file,'FVG',frac_mat_new);
ncwriteatt(save_file,'FVG',"long_name","vegetation_fraction");
ncwriteatt(save_file,'FVG',"units","1");

ncwrite(save_file,'ITY',type_mat_new);
ncwriteatt(save_file,'ITY',"long_name","vegetation_type");
ncwriteatt(save_file,'ITY',"units","1");

ncwrite(save_file,'CNPFT',cnpft_new);
ncwriteatt(save_file,'CNPFT',"long_name","PFT level restart vars");
ncwriteatt(save_file,'CNPFT',"units","1");

ncwrite(save_file,'PSNSHAM',psnsham_new);
ncwriteatt(save_file,'PSNSHAM',"long_name","CN sum for shaded photosyn");
ncwriteatt(save_file,'PSNSHAM',"units","umol m-2 s-1");

ncwrite(save_file,'PSNSUNM',psnsunm_new);
ncwriteatt(save_file,'PSNSUNM',"long_name","CN sum for sunlit photosyn");
ncwriteatt(save_file,'PSNSUNM',"units","umol m-2 s-1");
