clc
clear all
close all

read_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_CN51_local/output/SMAP_EASEv2_M36/cat/ens0000/';
%read_path = '/discover/nobackup/jkolassa/new/GEOSldas_CN51/output/SMAP_EASEv2_M36/cat/ens0000/';
%clm45_read_path = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_CN45_local/output/SMAP_EASEv2_M36/cat/ens0000/';
clm45_read_path = '/discover/nobackup/projects/geoscm/fzeng/GEOSldas45_M36_rst_ldas06_15/output/SMAP_EASEv2_M36/cat/ens0000/';
%read_path = '/discover/nobackup/jkolassa/new/GEOSldas_CN51/output/SMAP_EASEv2_M36/cat/ens0000/';
clm5_read_path = '/discover/nobackup/projects/geoscm/fzeng/CLM/archive/clm5_test/lnd/hist/';
start_year = 1980;
stop_year = 1989;

rst_file = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_CN51_local/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_CN51_local.catchcnclm51_internal_rst.19800101_0000';
tile_id = ncread(rst_file,'TILE_ID');
ityp = ncread(rst_file,'ITY');
fvg = ncread (rst_file,'FVG');

for i = 1:length(ityp)
    [max_value,max_index] = max(fvg(i,:));
    if (max_value>=0.7)
       dom_pft(i) = ityp(i,max_index);
    else
       dom_pft(i) = NaN;
    end
end 

pft_name = {...
           'Needleleaf evergreen temperate tree',...
           'Needleleaf evergreen boreal tree',...
           'Needleleaf deciduous boreal tree',...
           'Broadleaf evergreen tropical tree',...
           'Broadleaf evergreen temperate tree',...
           'Broadleaf deciduous tropical tree',...
           'Broadleaf deciduous temperate tree',...
           'Broadleaf deciduous boreal tree',...
           'Broadleaf evergreen temperate shrub',...
           'Broadleaf deciduous temperate shrub',...
           'Broadleaf deciduous boreal shrub',...
           'Arctic C3 grass',...
           'Non-arctic C3 grass',...
           'C4 grass',...
           'C3 crop'...
           };

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

mat_index = 0;

for y = start_year:stop_year

    y_str = num2str(y,'%04i');

    % define month length based on leap year status
    if sum(y==leapYears)>0
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end

    % loop over months
    for m = 1:12

        mat_index = mat_index + 1;

        m_str = num2str(m,'%02i');

        read_file = [read_path 'Y' y_str '/M' m_str '/GEOSldas_CN51_local.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
%        read_file = [read_path 'Y' y_str '/M' m_str '/GEOSldas_CN51.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
%        clm45_read_file = [clm45_read_path 'Y' y_str '/M' m_str '/GEOSldas_CN45_local.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        clm45_read_file = [clm45_read_path 'Y' y_str '/M' m_str '/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
     % read_file = [read_path 'Y' y_str '/M' m_str '/GEOSldas_CN51.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        clm5_read_file = [clm5_read_path 'clm5_test.clm2.h0.0001-' m_str '.nc'];

        if (mat_index == 1)
           lat_vec = double(ncread(read_file,'lat'));
           lon_vec = double(ncread(read_file,'lon'));

           clm45_lat_vec = double(ncread(clm45_read_file,'lat'));
           clm45_lon_vec = double(ncread(clm45_read_file,'lon'));

           clm5_lat_vec = ncread(clm5_read_file,'lat');
           clm5_lon_vec = ncread(clm5_read_file,'lon');
           clm5_lon_vec(clm5_lon_vec>180) = clm5_lon_vec(clm5_lon_vec>180) - 360;

           cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cnrootc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cnvegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           sfmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           rzmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

           clm45_cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm45_cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm45_cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm45_cnrootc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm45_cnvegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm45_cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm45_sfmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm45_rzmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

           clm5_tlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_rootc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_vegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_totc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_sfmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           clm5_rzmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

           for i = 1:length(lat_vec)

               dist_vec = sqrt((clm45_lat_vec-lat_vec(i)).^2 + (clm45_lon_vec-lon_vec(i)).^2);
               min_index = find(dist_vec==min(dist_vec));
               data_index(i) = min_index(1);

               lat_dist = sqrt((clm5_lat_vec-lat_vec(i)).^2);
               clm5_lat_index(i) = find(lat_dist==min(lat_dist));
              
               lon_dist = sqrt((clm5_lon_vec-lon_vec(i)).^2);
               clm5_lon_index(i) = find(lon_dist==min(lon_dist));
           end
        end

        cntlai_mat(:,mat_index) = double(ncread(read_file,'CNTLAI'));
        cngpp_mat(:,mat_index) = double(ncread(read_file,'CNGPP'));
        cnnee_mat(:,mat_index) = double(ncread(read_file,'CNNEE'));
        cnroot_mat(:,mat_index) = double(ncread(read_file,'CNROOT'));
        cnvegc_mat(:,mat_index) = double(ncread(read_file,'CNVEGC'));
        cntotc_mat(:,mat_index) = double(ncread(read_file,'CNTOTC'));
        sfmc_mat(:,mat_index) = double(ncread(read_file,'SFMC'));
        rzmc_mat(:,mat_index) = double(ncread(read_file,'RZMC'));
 
        tmp_mat = double(ncread(clm45_read_file,'CNTLAI'));
        clm45_cntlai_mat(:,mat_index) = tmp_mat(data_index);
        tmp_mat = double(ncread(clm45_read_file,'CNGPP'));
        clm45_cngpp_mat(:,mat_index) = tmp_mat(data_index);
        tmp_mat = double(ncread(clm45_read_file,'CNNEE'));
        clm45_cnnee_mat(:,mat_index) = tmp_mat(data_index);
        tmp_mat = double(ncread(clm45_read_file,'CNROOT'));
        clm45_cnroot_mat(:,mat_index) = tmp_mat(data_index);
        tmp_mat = double(ncread(clm45_read_file,'CNVEGC'));
        clm45_cnvegc_mat(:,mat_index) = tmp_mat(data_index);
        tmp_mat = double(ncread(clm45_read_file,'CNTOTC'));
        clm45_cntotc_mat(:,mat_index) = tmp_mat(data_index);
        tmp_mat = double(ncread(clm45_read_file,'SFMC'));
        clm45_sfmc_mat(:,mat_index) = tmp_mat(data_index);
        tmp_mat = double(ncread(clm45_read_file,'RZMC'));
        clm45_rzmc_mat(:,mat_index) = tmp_mat(data_index);

        lai_tmp_mat = ncread(clm5_read_file,'TLAI');
        gpp_tmp_mat = ncread(clm5_read_file,'GPP');
        nee_tmp_mat = ncread(clm5_read_file,'NEE');
        totc_tmp_mat = ncread(clm5_read_file,'TOTCOLC');
        vegc_tmp_mat = ncread(clm5_read_file,'TOTVEGC');

        for i = 1:length(lat_vec)
            clm5_gpp_mat(i,mat_index) = gpp_tmp_mat(clm5_lon_index(i),clm5_lat_index(i));
            clm5_tlai_mat(i,mat_index) = lai_tmp_mat(clm5_lon_index(i),clm5_lat_index(i));
            clm5_nee_mat(i,mat_index) = nee_tmp_mat(clm5_lon_index(i),clm5_lat_index(i));
            clm5_totc_mat(i,mat_index) = totc_tmp_mat(clm5_lon_index(i),clm5_lat_index(i));
            clm5_vegc_mat(i,mat_index) = vegc_tmp_mat(clm5_lon_index(i),clm5_lat_index(i));
        end

%        clm45_cntlai_mat(:,mat_index) = double(ncread(clm45_read_file,'CNTLAI'));
%        clm45_cngpp_mat(:,mat_index) = double(ncread(clm45_read_file,'CNGPP'));
%        clm45_cnnee_mat(:,mat_index) = double(ncread(clm45_read_file,'CNNEE'));
%        clm45_cnroot_mat(:,mat_index) = double(ncread(clm45_read_file,'CNROOT'));
%        clm45_cnvegc_mat(:,mat_index) = double(ncread(clm45_read_file,'CNVEGC'));
%        clm45_cntotc_mat(:,mat_index) = double(ncread(clm45_read_file,'CNTOTC'));
%        clm45_sfmc_mat(:,mat_index) = double(ncread(clm45_read_file,'SFMC'));
%        clm45_rzmc_mat(:,mat_index) = double(ncread(clm45_read_file,'RZMC'));

        datenum_vec(mat_index) = datenum(y,m,1);
        year_vec(mat_index) = y;
        month_vec(mat_index) = m;
    end
end

cntlai_mat(:,mat_index+1:end) = [];

% convert CLM GPP to kgC/m^2/s

clm5_gpp_mat = clm5_gpp_mat*10^(-3);
clm5_nee_mat = clm5_nee_mat*10^(-3);
clm5_totc_mat = clm5_totc_mat*10^(-3);
clm5_vegc_mat = clm5_vegc_mat*10^(-3);

% compute difference matrices

diff_cn51_cn45_gpp = clm45_cngpp_mat - cngpp_mat; 
diff_cn51_clm5_gpp = clm5_gpp_mat - cngpp_mat;


%% filter out locations with no data
%
%zero_mat = (cngpp_mat == 0);
%zero_index = (sum(zero_mat,2)==size(cngpp_mat,2));
%
%cngpp_mat(zero_index,:) = [];
%clm45_cngpp_mat(zero_index,:) = [];
%clm5_gpp_mat(zero_index,:) = [];

mean_global_cntlai = nanmean(cntlai_mat,1);
mean_nh_cntlai = nanmean(cntlai_mat(lat_vec>0,:),1);
mean_sh_cntlai = nanmean(cntlai_mat(lat_vec<=0,:),1);

figure
plot(datenum_vec,mean_global_cntlai,'-k','LineWidth',2);
%hold on
%plot(datenum_vec,mean_nh_cntlai,'-b','LineWidth',2);
%hold on 
%plot(datenum_vec,mean_sh_cntlai,'-k','LineWidth',2);
%hold off
grid on
xlabel('date')
ylabel('LAI')
title('average LAI')
legend('Global')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTLAI_cycle1'],'png')

ann_index = 0;

for y = start_year:stop_year

    ann_index = ann_index + 1;
    year_index = (year_vec==y);

    tmp = cntlai_mat(:,year_index);
    mean_global_ann_cntlai(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntlai(:,ann_index) = nanmean(tmp,2);
    tmp = cngpp_mat(:,year_index);
    mean_global_ann_cngpp(ann_index) = nanmean(tmp(:));
    mean_local_ann_cngpp(:,ann_index) = nanmean(tmp,2);
    tmp = cnnee_mat(:,year_index);
    mean_global_ann_cnnee(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnnee(:,ann_index) = nanmean(tmp,2);
    tmp = cnroot_mat(:,year_index);
    mean_global_ann_cnroot(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnroot(:,ann_index) = nanmean(tmp,2);
    tmp = cnvegc_mat(:,year_index);
    mean_global_ann_cnvegc(ann_index) = nanmean(tmp(:));
    mean_local_ann_cnvegc(:,ann_index) = nanmean(tmp,2);
    tmp = cntotc_mat(:,year_index);
    mean_global_ann_cntotc(ann_index) = nanmean(tmp(:));
    mean_local_ann_cntotc(:,ann_index) = nanmean(tmp,2);
    tmp = sfmc_mat(:,year_index);
    mean_global_ann_sfmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_sfmc(:,ann_index) = nanmean(tmp,2);
    tmp = rzmc_mat(:,year_index);
    mean_global_ann_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = clm45_cntlai_mat(:,year_index);
    mean_global_ann_clm45_cntlai(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_cntlai(:,ann_index) = nanmean(tmp,2);
    tmp = clm45_cngpp_mat(:,year_index);
    mean_global_ann_clm45_cngpp(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_cngpp(:,ann_index) = nanmean(tmp,2);
    tmp = clm45_cnnee_mat(:,year_index);
    mean_global_ann_clm45_cnnee(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_cnnee(:,ann_index) = nanmean(tmp,2);
    tmp = clm45_cnroot_mat(:,year_index);
    mean_global_ann_clm45_cnroot(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_cnroot(:,ann_index) = nanmean(tmp,2);
    tmp = clm45_cnvegc_mat(:,year_index);
    mean_global_ann_clm45_cnvegc(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_cnvegc(:,ann_index) = nanmean(tmp,2);
    tmp = clm45_cntotc_mat(:,year_index);
    mean_global_ann_clm45_cntotc(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_cntotc(:,ann_index) = nanmean(tmp,2);
    tmp = clm45_sfmc_mat(:,year_index);
    mean_global_ann_clm45_sfmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_sfmc(:,ann_index) = nanmean(tmp,2);
    tmp = clm45_rzmc_mat(:,year_index);
    mean_global_ann_clm45_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm45_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = clm5_tlai_mat(:,year_index);
    mean_global_ann_clm5_tlai(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_tlai(:,ann_index) = nanmean(tmp,2);
    tmp = clm5_gpp_mat(:,year_index);
    mean_global_ann_clm5_gpp(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_gpp(:,ann_index) = nanmean(tmp,2);
    tmp = clm5_nee_mat(:,year_index);
    mean_global_ann_clm5_nee(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_nee(:,ann_index) = nanmean(tmp,2);
    tmp = clm5_totc_mat(:,year_index);
    mean_global_ann_clm5_totc(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_totc(:,ann_index) = nanmean(tmp,2);
    tmp = clm5_vegc_mat(:,year_index);
    mean_global_ann_clm5_vegc(ann_index) = nanmean(tmp(:));
    mean_local_ann_clm5_vegc(:,ann_index) = nanmean(tmp,2);


    tmp = diff_cn51_cn45_gpp(:,year_index);
    mean_diff_cngpp(ann_index) = nanmean(tmp(:));

    for p = 1:15

       pft_index = find(dom_pft==p);

       pft_index_cell{p} = pft_index;

       tmp = cntlai_mat(pft_index,year_index);
       mean_global_ann_cntlai_pft(p,ann_index) = nanmean(tmp(:));
       tmp = cngpp_mat(pft_index,year_index);
       mean_global_ann_cngpp_pft(p,ann_index) = nanmean(tmp(:));
       tmp = cnnee_mat(pft_index,year_index);
       mean_global_ann_cnnee_pft(p,ann_index) = nanmean(tmp(:));
       tmp = cnroot_mat(pft_index,year_index);
       mean_global_ann_cnroot_pft(p,ann_index) = nanmean(tmp(:));
       tmp = cnvegc_mat(pft_index,year_index);
       mean_global_ann_cnvegc_pft(p,ann_index) = nanmean(tmp(:));
       tmp = cntotc_mat(pft_index,year_index);
       mean_global_ann_cntotc_pft(p,ann_index) = nanmean(tmp(:));
       tmp = sfmc_mat(pft_index,year_index);
       mean_global_ann_sfmc_pft(p,ann_index) = nanmean(tmp(:));
       tmp = rzmc_mat(pft_index,year_index);
       mean_global_ann_rzmc_pft(p,ann_index) = nanmean(tmp(:));
  
       tmp = clm45_cntlai_mat(pft_index,year_index);
       mean_global_ann_clm45_cntlai_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm45_cngpp_mat(pft_index,year_index);
       mean_global_ann_clm45_cngpp_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm45_cnnee_mat(pft_index,year_index);
       mean_global_ann_clm45_cnnee_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm45_cnroot_mat(pft_index,year_index);
       mean_global_ann_clm45_cnroot_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm45_cnvegc_mat(pft_index,year_index);
       mean_global_ann_clm45_cnvegc_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm45_cntotc_mat(pft_index,year_index);
       mean_global_ann_clm45_cntotc_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm45_sfmc_mat(pft_index,year_index);
       mean_global_ann_clm45_sfmc_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm45_rzmc_mat(pft_index,year_index);
       mean_global_ann_clm45_rzmc_pft(p,ann_index) = nanmean(tmp(:));

       tmp = clm5_tlai_mat(pft_index,year_index);
       mean_global_ann_clm5_tlai_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm5_gpp_mat(pft_index,year_index);
       mean_global_ann_clm5_gpp_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm5_nee_mat(pft_index,year_index);
       mean_global_ann_clm5_nee_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm5_totc_mat(pft_index,year_index);
       mean_global_ann_clm5_totc_pft(p,ann_index) = nanmean(tmp(:));
       tmp = clm5_vegc_mat(pft_index,year_index);
       mean_global_ann_clm5_vegc_pft(p,ann_index) = nanmean(tmp(:));
    end 
   
end 

figure
yyaxis left
plot(start_year:stop_year,mean_global_ann_cntlai,'LineWidth',2);
ylabel('LAI [-]')
yyaxis right
plot(start_year:stop_year,mean_global_ann_clm45_cntlai,'LineWidth',2);
grid on
xlabel('year')
ylabel('LAI [-]')
title('annual average LAI [-]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTLAI_ann_cycle1'],'png')

figure
yyaxis left
plot(start_year:stop_year,mean_global_ann_cngpp,'LineWidth',2);
ylabel('GPP [kg m^{-2} s^{-1}]')
yyaxis right
plot(start_year:stop_year,mean_global_ann_clm45_cngpp,'LineWidth',2);
grid on
xlabel('year')
ylabel('GPP [kg m^{-2} s^{-1}]')
title('annual average GPP [kg m^{-2} s^{-1}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNGPP_ann_cycle1'],'png')

figure
yyaxis left 
plot(start_year:stop_year,mean_global_ann_cnnee,'LineWidth',2);
ylabel('NEE [kg m^{-2} s^{-1}]')
yyaxis right 
plot(start_year:stop_year,mean_global_ann_clm45_cnnee,'LineWidth',2);
ylabel('NEE [kg m^{-2} s^{-1}]')
grid on
xlabel('year')
ylabel('NEE [kg m^{-2} s^{-1}]')
title('annual average NEE [kg m^{-2} s^{-1}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNNEE_ann_cycle1'],'png')

figure
yyaxis left
plot(start_year:stop_year,mean_global_ann_cnroot,'LineWidth',2);
ylabel('root carbon [kg m^{-2}]')
yyaxis right
plot(start_year:stop_year,mean_global_ann_clm45_cnroot,'LineWidth',2);
ylabel('root carbon [kg m^{-2}]')
grid on
xlabel('year')
title('annual average root carbon [kg m^{-2}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNROOTC_ann_cycle1'],'png')

figure
yyaxis left 
plot(start_year:stop_year,mean_global_ann_cnvegc,'LineWidth',2);
ylabel('vegetation carbon [kg m^{-2}]')
yyaxis right
plot(start_year:stop_year,mean_global_ann_clm45_cnvegc,'LineWidth',2);
grid on
xlabel('year')
ylabel('vegetation carbon [kg m^{-2}]')
title('annual average vegetation carbon [kg m^{-2}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNVEGC_ann_cycle1'],'png')

figure
yyaxis left
plot(start_year:stop_year,mean_global_ann_cntotc,'LineWidth',2);
ylabel('total carbon [kg m^{-2}]')
yyaxis right 
plot(start_year:stop_year,mean_global_ann_clm45_cntotc,'LineWidth',2);
grid on
xlabel('year')
ylabel('total carbon [kg m^{-2}]')
title('annual average total carbon [kg m^{-2}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTOTC_ann_cycle1'],'png')

figure
yyaxis left
plot(start_year:stop_year,mean_global_ann_sfmc,'LineWidth',2);
ylabel('surface soil moisture [m^{3} m^{-3}]')
yyaxis right
plot(start_year:stop_year,mean_global_ann_clm45_sfmc,'LineWidth',2);
grid on
xlabel('year')
ylabel('surface soil moisture [m^{3} m^{-3}]')
title('annual average surface soil moisture [m^{3} m^{-3}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/SFMC_ann_cycle1'],'png')

figure
yyaxis left
plot(start_year:stop_year,mean_global_ann_rzmc,'LineWidth',2);
ylabel('root-zone soil moisture [m^{3} m^{-3}]')
yyaxis right 
plot(start_year:stop_year,mean_global_ann_clm45_rzmc,'LineWidth',2);
grid on
xlabel('year')
ylabel('root-zone soil moisture [m^{3} m^{-3}]')
title('annual average root-zone soil moisture [m^{3} m^{-3}]')
legend('CN51','CN45')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/RZMC_ann_cycle1'],'png')

figure
plot(start_year:stop_year,mean_global_ann_cntlai,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm45_cntlai,'LineWidth',2);
hold on 
plot(start_year:stop_year,mean_global_ann_clm5_tlai,'LineWidth',2);
hold off
grid on
xlabel('year')
ylabel('LAI [-]')
title('annual average LAI [-]')
legend('CN51','CN45','CLM5*')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTLAI_ann_cycle1_all'],'png')


figure
plot(start_year:stop_year,mean_global_ann_cngpp,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm45_cngpp,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm5_gpp,'LineWidth',2);
hold off
grid on
xlabel('year')
ylabel('GPP [kgC m^{-2} s^{-1}]')
title('annual average GPP [kgC m^{-2} s^{-1}]')
legend('CN51','CN45','CLM5*')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNGPP_ann_cycle1_all'],'png')

figure
plot(start_year:stop_year,mean_global_ann_cnnee,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm45_cnnee,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm5_nee,'LineWidth',2);
hold off
grid on
xlabel('year')
ylabel('NEE [kgC m^{-2} s^{-1}]')
title('annual average NEE [kgC m^{-2} s^{-1}]')
legend('CN51','CN45','CLM5*')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNNEE_ann_cycle1_all'],'png')

figure
plot(start_year:stop_year,mean_global_ann_cntotc,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm45_cntotc,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm5_totc,'LineWidth',2);
hold off
grid on
xlabel('year')
ylabel('Total Carbon [kgC m^{-2} s^{-1}]')
title('annual average total carbon [kgC m^{-2} s^{-1}]')
legend('CN51','CN45','CLM5*')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTOTC_ann_cycle1_all'],'png')

figure
plot(start_year:stop_year,mean_global_ann_cnvegc,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm45_cnvegc,'LineWidth',2);
hold on
plot(start_year:stop_year,mean_global_ann_clm5_vegc,'LineWidth',2);
hold off
grid on 
xlabel('year')
ylabel('Vegetation Carbon [kgC m^{-2} s^{-1}]')
title('annual average vegetation carbon [kgC m^{-2} s^{-1}]')
legend('CN51','CN45','CLM5*')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNVEGC_ann_cycle1_all'],'png')



cmap = colormap(lines(16));
cmap = cmap + 0.05;
legend_entries = {};
plot_index = 0;


for p = 1:15
    if (any(dom_pft==p))
       figure
       for i = 1:length(pft_index_cell{p})
           if (any(isnan(mean_local_ann_cngpp(pft_index_cell{p}(i),:))==0) & ...
              any(isnan(mean_local_ann_clm5_gpp(pft_index_cell{p}(i),:))==0))
           plot(start_year:stop_year,mean_local_ann_cngpp(pft_index_cell{p}(i),:),...
           'LineWidth',0.5,'Color',cmap(i,:));
           hold on
           plot(start_year:stop_year,mean_local_ann_clm5_gpp(pft_index_cell{p}(i),:),...
           'LineWidth',0.5,'LineStyle','--','Color',cmap(i,:));
           hold on
           end
       end 
       plot(start_year:stop_year,mean_global_ann_cngpp_pft(p,:),'LineWidth',2,'Color','m');
       hold on
       plot(start_year:stop_year,mean_global_ann_clm5_gpp_pft(p,:),...
       'LineStyle','--','LineWidth',2,'Color','m');
       hold off 
       grid on
       xlabel('year')
       ylabel('GPP [kgC m^{-2} s^{-1}]')
       title(pft_name{p})
       set(gcf,'paperunits','centimeters')
       set(gcf,'paperposition',[1 1 17 15])
       saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNGPP_ann_cycle1_all_pft' num2str(p)],'png')

   end
end 

for p = 1:15
     if length(pft_index_cell{p})>1
       figure
       plot(start_year:stop_year,mean_global_ann_cngpp_pft(p,:),'LineWidth',2);
       hold on
       plot(start_year:stop_year,mean_global_ann_clm45_cngpp_pft(p,:),...
       'LineStyle','--','LineWidth',2);
       hold on
       plot(start_year:stop_year,mean_global_ann_clm5_gpp_pft(p,:),...
       'LineStyle','--','LineWidth',2);
       hold off
       grid on
       xlabel('year')
       ylabel('GPP [kgC m^{-2} s^{-1}]')
       legend('CN51','CN45','CLM5*')
       title([pft_name{p} ' (' num2str(length(pft_index_cell{p})) ')'])
       set(gcf,'paperunits','centimeters')
       set(gcf,'paperposition',[1 1 17 15])
       saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNGPP_ann_cycle1_pft' num2str(p)],'png')
     end
end



cngpp_vec = cngpp_mat(:);
clm5_gpp_vec = clm5_gpp_mat(:);
x = min(cngpp_vec):max(cngpp_vec);

figure
plot(cngpp_vec,clm5_gpp_vec,'.')
hold on 
plot(x,x,'-r')
hold off
grid on
xlabel('CN51 GPP [kg m^{-2} s^{-1}]')
ylabel('CLM5 GPP [kg m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_scatter'],'png')

mean_diff_cn51_clm5_gpp = nanmean(diff_cn51_clm5_gpp,1);

figure
plot(datenum_vec,diff_cn51_clm5_gpp,'-','Color',[0.5 0.5 0.5])
hold on 
plot(datenum_vec,mean_diff_cn51_clm5_gpp,'-r','LineWidth',2)
grid on
datetick('x','mm-yyyy')
xlabel('Date [MM-YYYY]')
ylabel('\Delta GPP [kg m^{-2} s^{-1}]')
title('\Delta GPP (CLM5 - CN51) [kg m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_diff_cn51_clm5'],'png')


nc_lat = 35.68;
nc_lon = -76.74;
lat_dist = sqrt((lat_vec-nc_lat).^2);
lat_index = find(lat_dist==min(lat_dist));
lon_dist = sqrt((lon_vec-nc_lon).^2);
lon_index = find(lon_dist==min(lon_dist));
