clc
clear all 
close all

orig_file = '/discover/nobackup/jkolassa/CLM/parameter_files/ctsm51_params.c210923.nc';
fcur_orig = ncread(orig_file,'fcur');
leaf_long_orig = ncread(orig_file,'leaf_long');

fcur_new = fcur_orig;
fcur_new(fcur_new==0) = 0.5;

leaf_long_new = leaf_long_orig;
leaf_long_new(leaf_long_new<=1) = 1



save_file = '/discover/nobackup/jkolassa/CLM/parameter_files/ctsm51_params.c210923_forCNCLM.nc';

nccreate(save_file,"fcur","Dimensions",{"pft",size(fcur_orig,1)}, ...
                   "FillValue","disable");
nccreate(save_file,"leaf_long","Dimensions",{"pft",size(leaf_long_orig,1)}, ...
                   "FillValue","disable");

ncwrite(save_file,'fcur',fcur_new);
ncwriteatt(save_file,'fcur',"long_name","Allocation parameter: fraction of allocation that goes to currently displayed growth, remainder to storage");
ncwriteatt(save_file,'fcur',"units","fraction");
ncwriteatt(save_file,'fcur',"coordinates","pftname");

ncwrite(save_file,'leaf_long',leaf_long_new);
ncwriteatt(save_file,'leaf_long',"long_name","Leaf longevity");
ncwriteatt(save_file,'leaf_long',"units","years");
ncwriteatt(save_file,'leaf_long',"coordinates","pftname");


