clc 
clear all
close all

base_path = '/discover/nobackup/jkolassa/CN51_global_daily/';
base_exp_name = 'GEOSldas_CN51_280_global'; 

start_year = 1980;
stop_year = 1980;
    
leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

cn51_read_file = ['/discover/nobackup/jkolassa/CN51_global_daily/GEOSldas_CN51_280_global/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_280_global.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));

mat_index = 0;
y_index = 0;

for y = start_year%:stop_year

    y_str = num2str(y,'%04i');

    % define month length based on leap year status
    if sum(y==leapYears)>0
          monthLength = monthLength_ly;
    else
         monthLength = monthLength_nly;
    end

    % loop over months
    for m = 1%:12

        m_str = num2str(m,'%02i');

        for d = 1:monthLength(m)

            mat_index = mat_index + 1;

            d_str = num2str(d,'%02i');

            % define file names

            cn51_read_file = [base_path base_exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                           '/M' m_str '/' base_exp_name '.tavg24_1d_lnd_Nt.' y_str m_str d_str '_1200z.nc4'];

            % initialize arrays

            if (mat_index == 1)

                cngpp_mat = NaN*ones(length(lat_vec),monthLength(m));
                cnnee_mat = NaN*ones(length(lat_vec),monthLength(m));
                cntlai_mat = NaN*ones(length(lat_vec),monthLength(m));
                cncloss_mat = NaN*ones(length(lat_vec),monthLength(m));
                cnar_mat = NaN*ones(length(lat_vec),monthLength(m));
                cnhr_mat = NaN*ones(length(lat_vec),monthLength(m));
                cntotc_mat = NaN*ones(length(lat_vec),monthLength(m));
                et_mat = NaN*ones(length(lat_vec),monthLength(m));
                evpsoil_mat = NaN*ones(length(lat_vec),monthLength(m));
                evptrns_mat = NaN*ones(length(lat_vec),monthLength(m));
                evpintr_mat = NaN*ones(length(lat_vec),monthLength(m));
                evpsbln_mat = NaN*ones(length(lat_vec),monthLength(m));
           end

            % read data

            if exist(cn51_read_file)
               cngpp_mat(:,mat_index) = double(ncread(cn51_read_file,'CNGPP'));
               cnnee_mat(:,mat_index) = double(ncread(cn51_read_file,'CNNEE'));
               cntlai_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTLAI'));
               cncloss_mat(:,mat_index) = double(ncread(cn51_read_file,'CLOSS'));
               cnar_mat(:,mat_index) = double(ncread(cn51_read_file,'CNAR'));
               cnhr_mat(:,mat_index) = double(ncread(cn51_read_file,'CNHR'));
               cntotc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTOTC'));
               evpsoil_mat(:,mat_index) = double(ncread(cn51_read_file,'EVPSOIL'));
               evptrns_mat(:,mat_index) = double(ncread(cn51_read_file,'EVPTRNS'));
               evpintr_mat(:,mat_index) = double(ncread(cn51_read_file,'EVPINTR'));
               evpsbln_mat(:,mat_index) = double(ncread(cn51_read_file,'EVPSBLN'));
               et_mat(:,mat_index) = evpsoil_mat(:,mat_index) + evptrns_mat(:,mat_index) ...
                                      + evpintr_mat(:,mat_index) + evpsbln_mat(:,mat_index);
            else
               cngpp_mat(:,mat_index) = NaN*ones(size(cngpp_mat,1),1);
               cnnee_mat(:,mat_index) = NaN*ones(size(cnnee_mat,1),1);
               cntlai_mat(:,mat_index) = NaN*ones(size(cntlai_mat,1),1);
               cncloss_mat(:,mat_index) = NaN*ones(size(cncloss_mat,1),1);
               cnar_mat(:,mat_index) = NaN*ones(size(cnar_mat,1),1);
               cnhr_mat(:,mat_index) = NaN*ones(size(cnhr_mat,1),1);
               cntotc_mat(:,mat_index) = NaN*ones(size(cntotc_mat,1),1);
               evpsoil_mat(:,mat_index) = NaN*ones(size(evpsoil_mat,1),1);
               evptrns_mat(:,mat_index) = NaN*ones(size(evptrns_mat,1),1);
               evpintr_mat(:,mat_index) = NaN*ones(size(evpintr_mat,1),1);
               evpsbln_mat(:,mat_index) = NaN*ones(size(evpsbln_mat,1),1);
               et_mat(:,mat_index) = NaN*ones(size(et_mat,1),1);
            end

            datenum_vec(mat_index) = datenum(y,m,d);
            year_vec(mat_index) = y;
            month_vec(mat_index) = m;

        end % d
    end % m
end % y

% compute global means

mean_cngpp_mat = nanmean(cngpp_mat,1);
mean_cnnee_mat = nanmean(cnnee_mat,1);
mean_cntlai_mat = nanmean(cntlai_mat,1);
mean_cncloss_mat = nanmean(cncloss_mat,1);
mean_cnar_mat = nanmean(cnar_mat,1);
mean_cnhr_mat = nanmean(cnhr_mat,1);
mean_cntotc_mat = nanmean(cntotc_mat,1);
mean_evpsoil_mat = nanmean(evpsoil_mat,1);
mean_evptrns_mat = nanmean(evptrns_mat,1);
mean_evpintr_mat = nanmean(evpintr_mat,1);
mean_evpsbln_mat = nanmean(evpsbln_mat,1);
mean_et_mat = nanmean(et_mat,1);

% plot global average time series

figure
plot(datenum_vec,mean_cngpp_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('GPP [kg m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_cnnee_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('NEE [kg m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_cntlai_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('LAI [-]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/LAI_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_cncloss_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('CLOSS [kg m^{-2} s^{-1}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/CLOSS_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_cnar_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('AR [kg m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/AR_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_cnhr_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('HR [kg m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/HR_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_evpsoil_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('EVPSOIL [W m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/EVPSOIL_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_evptrns_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('EVPTRNS [W m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/EVPTRNS_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_evpintr_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('EVPINTR [W m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/EVPINTR_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_evpsbln_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('EVPSBLN [W m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/EVPSBLN_daily_CN51_280'],'png')

figure
plot(datenum_vec,mean_et_mat,'LineWidth',2)
grid on
datetick('x','mm-dd')
xlabel('date')
ylabel('ET [W m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 7])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/ET_daily_CN51_280'],'png')

