clc
clear all
close all

base_path = '/discover/nobackup/jkolassa/staging_dir/';
base_exp_name = 'GEOSldas_CN51_280_global';
nr_of_cycles = 1;

clm5_of_path = '/discover/nobackup/jkolassa/CLM5_sim/';

start_year = 1980;
stop_year = 2019;

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% compute mapping indices
cn51_read_file = ['/discover/nobackup/jkolassa/CN51_global/GEOSldas_CN51_280_global/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_280_global.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
clm5_ar_read_file = [clm5_of_path 'clm50_release-clm5.0.20_1deg_GSWP3V1_isofix2_hist.clm2.h0.AR.185001-201412.nc'];
clm5_hr_read_file = [clm5_of_path 'clm50_release-clm5.0.20_1deg_GSWP3V1_isofix2_hist.clm2.h0.HR.185001-201412.nc'];

lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));


% read released CLM simulation data

clm5_of_lat_vec = ncread(clm5_ar_read_file,'lat');
clm5_of_lon_vec = ncread(clm5_ar_read_file,'lon');
clm5_of_time_vec = ncread(clm5_ar_read_file,'time');
clm5_of_ar_vec = ncread(clm5_ar_read_file,'AR');
clm5_of_hr_vec = ncread(clm5_hr_read_file,'HR');
%convert CLM lons from [0 360] to [-180 180]
clm5_of_lon_vec(clm5_of_lon_vec>180) = clm5_of_lon_vec(clm5_of_lon_vec>180)-360;

for i = 1:length(lat_vec)

    dist_vec = sqrt((clm5_of_lat_vec-lat_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lat_index(i) = min_index(1);

    dist_vec = sqrt((clm5_of_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lon_index(i) = min_index(1);

end

for i = 1:nr_of_cycles

    if (i>1)
       cyc_str = ['c' num2str(i,'%0i')];
       exp_name = [base_exp_name '_' cyc_str];
    else
       exp_name = base_exp_name;
    end

    mat_index = 0;
    y_index = 0;
    mat_index_clm5_mod = (start_year-1850)*12;

    for y = start_year:stop_year

        y_index = y_index + 1;
        y_str = num2str(y,'%04i');
        y_index_str = num2str(y_index,'%04i');

        % define month length based on leap year status
        if sum(y==leapYears)>0
            monthLength = monthLength_ly;
        else
            monthLength = monthLength_nly;
        end

        % loop over months
        for m = 1:12

            mat_index = mat_index + 1;
            mat_index_clm5_mod = mat_index_clm5_mod + 1;

            m_str = num2str(m,'%02i');

            % define file names

            cn51_read_file = [base_path exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                           '/M' m_str '/' exp_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

            % initialize arrays

            if (mat_index == 1)

                cnar_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnhr_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                if (i ==1)
                   clm5_of_pi_ar_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_mod_ar_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   clm5_of_pi_hr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_mod_hr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                end
            end % mat_index

            % read data

            if exist(cn51_read_file)
               cnar_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNAR'));
               cnhr_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNHR'));
            else
               cnar_mat{i}(:,mat_index) = NaN*ones(size(cnar_mat{i},1),1);
               cnhr_mat{i}(:,mat_index) = NaN*ones(size(cnhr_mat{i},1),1);
            end

            if (i == 1)

                for l = 1:length(lat_vec)
                    clm5_of_pi_ar_mat(l,mat_index) = clm5_of_ar_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index);
                    clm5_of_pi_hr_mat(l,mat_index) = clm5_of_hr_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index);
                    if (mat_index_clm5_mod<=size(clm5_of_ar_vec,3))
                       clm5_of_mod_ar_mat(l,mat_index) = clm5_of_ar_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index_clm5_mod);
                    end
                    if (mat_index_clm5_mod<=size(clm5_of_hr_vec,3))
                       clm5_of_mod_hr_mat(l,mat_index) = clm5_of_hr_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index_clm5_mod);
                    end 
                end

                datenum_vec(mat_index) = datenum(y,m,1);
                year_vec(mat_index) = y;
                month_vec(mat_index) = m;

            end % i == 1

        end % m
      end % y
end % i

% convert CLM5 carbon fluxes from gC/m2/s to kgC/m2/s
% and states from gc/m2 to kgC/m2

clm5_of_pi_ar_mat = clm5_of_pi_ar_mat*10^(-3);
clm5_of_mod_ar_mat = clm5_of_mod_ar_mat*10^(-3);

clm5_of_pi_hr_mat = clm5_of_pi_hr_mat*10^(-3);
clm5_of_mod_hr_mat = clm5_of_mod_hr_mat*10^(-3);

for i = 1:nr_of_cycles

    ann_index = 0;

    for y = start_year:stop_year

        ann_index = ann_index + 1;
        year_index = (year_vec==y);

        tmp = cnar_mat{i}(:,year_index);
        mean_global_ann_cnar{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cnar{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cnhr_mat{i}(:,year_index);
        mean_global_ann_cnhr{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cnhr{i}(:,ann_index) = nanmean(tmp,2);

        if (i == 1)

           tmp = clm5_of_pi_ar_mat(:,year_index);
           mean_global_ann_clm5_of_pi_cnar(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_pi_cnar(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_mod_ar_mat(:,year_index);
           mean_global_ann_clm5_of_mod_cnar(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_mod_cnar(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_pi_hr_mat(:,year_index);
           mean_global_ann_clm5_of_pi_cnhr(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_pi_cnhr(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_mod_hr_mat(:,year_index);
           mean_global_ann_clm5_of_mod_cnhr(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_mod_cnhr(:,ann_index) = nanmean(tmp,2);
        end

     end
end

legend_str = {};

figure
for i = 1:nr_of_cycles
    if (i < 8)
        LS = '-';
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_cnar{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cnar,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cnar,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('AR [kg m^{-2} s^{-1}]')
title('annual average AR [kg m^{-2} s^{-1}]')
legend_str{i+1} = 'CLM5 NCAR (1850 - 1890)';
legend_str{i+2} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/AR_ann_CN51_cycles_280'],'png')

legend_str = {}; 

figure
for i = 1:nr_of_cycles
    if (i < 8)
        LS = '-';
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_cnhr{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cnhr,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cnhr,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('HR [kg m^{-2} s^{-1}]')
title('annual average HR [kg m^{-2} s^{-1}]')
legend_str{i+1} = 'CLM5 NCAR (1850 - 1890)';
legend_str{i+2} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/HR_ann_CN51_cycles_280'],'png')

% compute and plot mean maps

mean_ar_cn51 = nanmean(cnar_mat{nr_of_cycles},2);
mean_ar_clm5_of_pi = nanmean(clm5_of_pi_ar_mat,2);
mean_ar_clm5_of_mod = nanmean(clm5_of_mod_ar_mat,2);
mean_ar_cn51_c1 = nanmean(cnar_mat{1},2);

mean_hr_cn51 = nanmean(cnhr_mat{nr_of_cycles},2);
mean_hr_clm5_of_pi = nanmean(clm5_of_pi_hr_mat,2);
mean_hr_clm5_of_mod = nanmean(clm5_of_mod_hr_mat,2);
mean_hr_cn51_c1 = nanmean(cnhr_mat{1},2);

tmp = mean_ar_cn51*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_ar_cn51 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_ar_clm5_of_pi*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_ar_clm5_of_pi = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_ar_clm5_of_mod*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_ar_clm5_of_mod = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_ar_cn51_c1*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_ar_cn51_c1 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1

tmp = mean_hr_cn51*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_hr_cn51 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_hr_clm5_of_pi*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_hr_clm5_of_pi = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_hr_clm5_of_mod*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_hr_clm5_of_mod = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_hr_cn51_c1*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_hr_cn51_c1 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1

test_lat = unique(lat_vec);
test_lon = unique(lon_vec);

[lon_mat,lat_mat] = meshgrid(test_lon,test_lat);

mean_ar_cn51_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_ar_clm5_of_pi_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_ar_clm5_of_mod_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_ar_clm5_of_1850_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));

mean_hr_cn51_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_hr_clm5_of_pi_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_hr_clm5_of_mod_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_hr_clm5_of_1850_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));

for i = 1:length(lon_vec)

    % map tile data to plottable grid

    lat_index = test_lat == lat_vec(i);
    lon_index = test_lon == lon_vec(i);

    mean_ar_cn51_mat(lat_index,lon_index) = mean_ar_cn51(i);
    mean_ar_clm5_of_pi_mat(lat_index,lon_index) = mean_ar_clm5_of_pi(i);
    mean_ar_clm5_of_mod_mat(lat_index,lon_index) = mean_ar_clm5_of_mod(i);
    mean_ar_clm5_of_1850_mat(lat_index,lon_index) = mean_local_ann_clm5_of_pi_cnar(i,1);
    mean_ar_cn51_c1_mat(lat_index,lon_index) = mean_ar_cn51_c1(i);

    mean_hr_cn51_mat(lat_index,lon_index) = mean_hr_cn51(i);
    mean_hr_clm5_of_pi_mat(lat_index,lon_index) = mean_hr_clm5_of_pi(i);
    mean_hr_clm5_of_mod_mat(lat_index,lon_index) = mean_hr_clm5_of_mod(i);
    mean_hr_clm5_of_1850_mat(lat_index,lon_index) = mean_local_ann_clm5_of_pi_cnhr(i,1);
    mean_hr_cn51_c1_mat(lat_index,lon_index) = mean_hr_cn51_c1(i);

end

load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);

latlim = [-60 90];
lonlim = [-180 180];

cmap_mat = cmocean('speed',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(mean_ar_cn51_mat(:),0.01);
s2 = quantile(mean_ar_cn51_mat(:),0.99);
caxis_min = s1;
caxis_max = s2;

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_ar_cn51_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean AR CN51 [kgC m^{-2} s^{-1}] cycle 3'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/AR_CN51'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_ar_clm5_of_pi_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean AR CLM5 NCAR [kgC m^{-2} s^{-1}] (1850 - 1890)'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/AR_CLM5_NCAR_1850_1890'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_ar_clm5_of_mod_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean AR CLM5 NCAR [kgC m^{-2} s^{-1}] (1980 - 2014))'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/AR_CLM5_NCAR_1980_2014'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_ar_clm5_of_1850_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean AR CLM5 NCAR [kgC m^{-2} s^{-1}] 1850'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/AR_CLM5_NCAR_1850'],'png')


cmap_mat = cmocean('speed',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(mean_hr_cn51_mat(:),0.01);
s2 = quantile(mean_hr_cn51_mat(:),0.99);
caxis_min = s1;
caxis_max = s2;

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_hr_cn51_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean HR CN51 [kgC m^{-2} s^{-1}] cycle 3'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/HR_CN51'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_hr_clm5_of_pi_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean HR CLM5 NCAR [kgC m^{-2} s^{-1}] (1850 - 1890)'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/HR_CLM5_NCAR_1850_1890'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_hr_clm5_of_mod_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean HR CLM5 NCAR [kgC m^{-2} s^{-1}] (1980 - 2014))'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/HR_CLM5_NCAR_1980_2014'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_hr_clm5_of_1850_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean HR CLM5 NCAR [kgC m^{-2} s^{-1}] 1850'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/HR_CLM5_NCAR_1850'],'png')

