clc
clear all
close all

base_path = '/discover/nobackup/jkolassa/new/';
base_exp_name = 'GEOSldas_CN51_local_280';
base_path = '/discover/nobackup/jkolassa/CN51_config_test/';
base_exp_name = 'GEOSldas_CN51_local_280';
base_path = '/discover/nobackup/jkolassa/CN51_bgc_param_test/';
base_exp_name = 'GEOSldas_CN51_local_280';
%base_path = '/discover/nobackup/jkolassa/CN51_NDEP100/';
%base_exp_name = 'GEOSldas_CN51_local_280';
old_path = '/discover/nobackup/jkolassa/new/old_cycle_exps/';
old_exp_name = 'GEOSldas_CN51_local_280';
old_path = '/discover/nobackup/jkolassa/CN51_config_change/';
old_exp_name = 'GEOSldas_CN51_local_280';
%old_path = '/discover/nobackup/jkolassa/CN51_config_change/';
%old_exp_name = 'GEOSldas_CN51_local_280';
nr_of_cycles = 1;
nr_of_old_cycles = 1;
last_full_year = 2000;

legend_new = 'CN51 with latest round of changes cycle ';
legend_old = 'CN51 before cycle '; 

cn40_read_path = '/discover/nobackup/jkolassa/test_new/GEOSldas_CN40_local/output/SMAP_EASEv2_M09_GLOBAL/cat/ens0000/';
cn45_read_path = '/discover/nobackup/projects/geoscm/fzeng/GEOSldas45_M36_rst_ldas06_15/output/SMAP_EASEv2_M36/cat/ens0000/';
clm5_read_path = ['/discover/nobackup/projects/geoscm/fzeng/CLM/archive/clm5_test/lnd/hist/'];
fluxcom_read_path = '/discover/nobackup/elee15/data/gpp/FluxCom/';
fluxsat_read_path = '/discover/nobackup/elee15/data/gpp/FluxSat/monthly/';
maiac_read_path = '/discover/nobackup/elee15/data/gpp/maiac/';
vpm_read_path = '/discover/nobackup/elee15/data/gpp/vpm/';
clm5_of_path = '/discover/nobackup/jkolassa/CLM5_sim/';

start_year = 1980;
stop_year = 2019;
nr_complete_years = last_full_year - start_year + 1;


leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% read PFT distribution data

cn51_rst_file = '/discover/nobackup/jkolassa/new/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_CN51_local_280.catchcnclm51_internal_rst.19800101_0000';
cn40_rst_file = '/discover/nobackup/jkolassa/test_new/GEOSldas_CN40_local/output/SMAP_EASEv2_M09_GLOBAL/rs/ens0000/Y1981/M01/GEOSldas_CN40_local.catchcnclm40_internal_rst.19810101_0000';

tile_id = ncread(cn51_rst_file,'TILE_ID');

% compute mapping indices

cn51_read_file = ['/discover/nobackup/jkolassa/new/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
cn45_read_file = [cn45_read_path 'Y2001/M01/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.200101.nc4'];
cn40_read_file = [cn40_read_path 'Y1981/M01/GEOSldas_CN40_local.tavg24_1d_lnd_Nt.monthly.198101.nc4'];
fluxcom_gpp_read_file = [fluxcom_read_path 'GPP.RS.FP-ALL.MLM-ALL.METEO-NONE.720_360.monthly.2001.nc'];
fluxsat_gpp_read_file = [fluxsat_read_path 'SatFlux_GPP_200302.nc'];
maiac_gpp_read_file = [maiac_read_path 'GPP_MAIAC_200301.nc'];
vpm_gpp_read_file = [vpm_read_path 'VPM_GPP_200301.nc'];
clm5_gpp_read_file = [clm5_of_path 'clm50_release-clm5.0.20_1deg_GSWP3V1_isofix2_hist.clm2.h0.GPP.185001-201412.nc'];
clm5_lai_read_file = [clm5_of_path 'clm50_release-clm5.0.20_1deg_GSWP3V1_isofix2_hist.clm2.h0.TLAI.185001-201412.nc'];
clm5_nee_read_file = [clm5_of_path 'clm50_release-clm5.0.20_1deg_GSWP3V1_isofix2_hist.clm2.h0.NEE.185001-201412.nc'];

lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));

cn45_lat_vec = double(ncread(cn45_read_file,'lat'));
cn45_lon_vec = double(ncread(cn45_read_file,'lon'));

cn40_lat_vec = double(ncread(cn40_read_file,'lat'));
cn40_lon_vec = double(ncread(cn40_read_file,'lon'));

fc_lat_vec = ncread(fluxcom_gpp_read_file,'latitude');
fc_lon_vec = ncread(fluxcom_gpp_read_file,'longitude');

fs_lat_vec = ncread(fluxsat_gpp_read_file,'latitude');
fs_lon_vec = ncread(fluxsat_gpp_read_file,'longitude');

maiac_lat_vec = ncread(maiac_gpp_read_file,'latitude');
maiac_lon_vec = ncread(maiac_gpp_read_file,'longitude');

vpm_lat_vec = ncread(vpm_gpp_read_file,'latitude');
vpm_lon_vec = ncread(vpm_gpp_read_file,'longitude');

clm5_read_file = [clm5_read_path 'clm5_test.clm2.h0.0001-01.nc'];
clm5_lat_vec = ncread(clm5_read_file,'lat');
clm5_lon_vec = ncread(clm5_read_file,'lon');
%convert CLM lons from [0 360] to [-180 180]
clm5_lon_vec(clm5_lon_vec>180) = clm5_lon_vec(clm5_lon_vec>180)-360;

% read released CLM simulation data

clm5_of_lat_vec = ncread(clm5_gpp_read_file,'lat');
clm5_of_lon_vec = ncread(clm5_gpp_read_file,'lon');
clm5_of_time_vec = ncread(clm5_gpp_read_file,'time');
clm5_of_gpp_vec = ncread(clm5_gpp_read_file,'GPP');
clm5_of_lai_vec = ncread(clm5_lai_read_file,'TLAI');
clm5_of_nee_vec = ncread(clm5_nee_read_file,'NEE');
%convert CLM lons from [0 360] to [-180 180]
clm5_of_lon_vec(clm5_of_lon_vec>180) = clm5_of_lon_vec(clm5_of_lon_vec>180)-360;

for i = 1:length(lat_vec)
    lat_dist = sqrt((fc_lat_vec-lat_vec(i)).^2);
    fc_lat_index(i) = find(lat_dist==min(lat_dist));

    lon_dist = sqrt((fc_lon_vec-lon_vec(i)).^2);
    fc_lon_index(i) = find(lon_dist==min(lon_dist));

    dist_vec = sqrt((cn45_lat_vec-lat_vec(i)).^2 + (cn45_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    data_index(i) = min_index(1);

%    dist_vec = sqrt((cn40_lat_vec-lat_vec(i)).^2 + (cn40_lon_vec-lon_vec(i)).^2);
%    min_index = find(dist_vec==min(dist_vec));
%    cn40_data_index(i) = min_index(1);

    lat_dist = sqrt((fs_lat_vec-lat_vec(i)).^2);
    fs_lat_index(i) = find(lat_dist==min(lat_dist));

    lon_dist = sqrt((fs_lon_vec-lon_vec(i)).^2);
    fs_lon_index(i) = find(lon_dist==min(lon_dist));

    lat_dist = sqrt((maiac_lat_vec-lat_vec(i)).^2);
    maiac_lat_index(i) = find(lat_dist==min(lat_dist));

    lon_dist = sqrt((maiac_lon_vec-lon_vec(i)).^2);
    maiac_lon_index(i) = find(lon_dist==min(lon_dist));

    lat_dist = sqrt((vpm_lat_vec-lat_vec(i)).^2);
    vpm_lat_index(i) = find(lat_dist==min(lat_dist));

    lon_dist = sqrt((vpm_lon_vec-lon_vec(i)).^2);
    vpm_lon_index(i) = find(lon_dist==min(lon_dist));

    dist_vec = sqrt((clm5_lat_vec-lat_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_lat_index(i) = min_index(1);

    dist_vec = sqrt((clm5_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_lon_index(i) = min_index(1);

    dist_vec = sqrt((clm5_of_lat_vec-lat_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lat_index(i) = min_index(1);

    dist_vec = sqrt((clm5_of_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lon_index(i) = min_index(1);
end

for i = 1:nr_of_cycles

    if (i>1)
       cyc_str = ['c' num2str(i,'%0i')];
       exp_name = [base_exp_name '_' cyc_str];
       transient_name = [transient_exp_name '_' cyc_str];
    else
       exp_name = base_exp_name;
       old_name = old_exp_name;
    end

    mat_index = 0;
    y_index = 0;
    mat_index_clm5_mod = (start_year-1850)*12;

    for y = start_year:stop_year

        y_index = y_index + 1;
        y_str = num2str(y,'%04i');
        y_index_str = num2str(y_index,'%04i');

        % define month length based on leap year status
        if sum(y==leapYears)>0
            monthLength = monthLength_ly;
        else
            monthLength = monthLength_nly;
        end

        % loop over months
        for m = 1:12

            mat_index = mat_index + 1;
            mat_index_clm5_mod = mat_index_clm5_mod + 1;

            m_str = num2str(m,'%02i');

            % define file names

            cn51_read_file = [base_path exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                           '/M' m_str '/' exp_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

            old_read_file = [old_path old_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                           '/M' m_str '/' old_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

            if (i==1)
               cn40_read_file = [cn40_read_path 'Y' y_str '/M' m_str '/GEOSldas_CN40_local.tavg24_1d_lnd_Nt.monthly.' ...
                                y_str m_str '.nc4'];
               cn45_read_file = [cn45_read_path 'Y' y_str '/M' m_str '/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
               fluxcom_gpp_read_file = [fluxcom_read_path 'GPP.RS.FP-ALL.MLM-ALL.METEO-NONE.720_360.monthly.' y_str '.nc'];
               fluxsat_gpp_read_file = [fluxsat_read_path 'SatFlux_GPP_' y_str m_str '.nc'];
               maiac_gpp_read_file = [maiac_read_path 'GPP_MAIAC_' y_str m_str '.nc'];
               vpm_gpp_read_file = [vpm_read_path 'VPM_GPP_' y_str m_str '.nc'];
               clm5_read_file = [clm5_read_path 'clm5_test.clm2.h0.' y_index_str '-' m_str '.nc'];
            end 

            % initialize arrays

            if (mat_index == 1)

                cngpp_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnnee_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cncloss_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntlai_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntotc_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                et_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpsoil_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evptrns_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpintr_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpsbln_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                cngpp_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cnnee_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cncloss_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntlai_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntotc_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                et_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpsoil_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evptrns_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpintr_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpsbln_old_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                if (i ==1)
                   cngpp_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cnnee_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cncloss_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cntlai_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cntotc_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   et_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsoil_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evptrns_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpintr_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsbln_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   fc_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   fs_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   maiac_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   vpm_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   cngpp_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cnnee_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cncloss_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cntlai_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cntotc_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   et_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsoil_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evptrns_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpintr_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsbln_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   clm5_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_lai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_closs_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_elai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_vegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_totc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   clm5_of_pi_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_mod_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_pi_lai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_mod_lai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_pi_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_mod_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                end
            end % mat_index

            % read data

            if exist(cn51_read_file)
               cngpp_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNGPP'));
               cnnee_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNNEE'));
               cncloss_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CLOSS'));
               cntlai_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNTLAI'));
               cntotc_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNTOTC'));
               evpsoil_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPSOIL'));
               evptrns_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPTRNS'));
               evpintr_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPINTR'));
               evpsbln_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPSBLN'));
               et_mat{i}(:,mat_index) = evpsoil_mat{i}(:,mat_index) + evptrns_mat{i}(:,mat_index) ...
                                      + evpintr_mat{i}(:,mat_index) + evpsbln_mat{i}(:,mat_index);
            else
               cngpp_mat{i}(:,mat_index) = NaN*ones(size(cngpp_mat{i},1),1);
               cnnee_mat{i}(:,mat_index) = NaN*ones(size(cnnee_mat{i},1),1);
               cncloss_mat{i}(:,mat_index) = NaN*ones(size(cncloss_mat{i},1),1);
               cntlai_mat{i}(:,mat_index) = NaN*ones(size(cntlai_mat{i},1),1);
               cntotc_mat{i}(:,mat_index) = NaN*ones(size(cntotc_mat{i},1),1);
               evpsoil_mat{i}(:,mat_index) = NaN*ones(size(evpsoil_mat{i},1),1);
               evptrns_mat{i}(:,mat_index) = NaN*ones(size(evptrns_mat{i},1),1);
               evpintr_mat{i}(:,mat_index) = NaN*ones(size(evpintr_mat{i},1),1);
               evpsbln_mat{i}(:,mat_index) = NaN*ones(size(evpsbln_mat{i},1),1);
               et_mat{i}(:,mat_index) = NaN*ones(size(et_mat{i},1),1);
            end

            if exist(old_read_file)
               cngpp_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'CNGPP'));
               cnnee_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'CNNEE'));
               cncloss_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'CLOSS'));
               cntlai_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'CNTLAI'));
               cntotc_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'CNTOTC'));
               evpsoil_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'EVPSOIL'));
               evptrns_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'EVPTRNS'));
               evpintr_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'EVPINTR'));
               evpsbln_old_mat{i}(:,mat_index) = double(ncread(old_read_file,'EVPSBLN'));
               et_old_mat{i}(:,mat_index) = evpsoil_old_mat{i}(:,mat_index) + evptrns_old_mat{i}(:,mat_index) ...
                                      + evpintr_old_mat{i}(:,mat_index) + evpsbln_old_mat{i}(:,mat_index);
            else
               cngpp_old_mat{i}(:,mat_index) = NaN*ones(size(cngpp_old_mat{i},1),1);
               cnnee_old_mat{i}(:,mat_index) = NaN*ones(size(cnnee_old_mat{i},1),1);
               cncloss_old_mat{i}(:,mat_index) = NaN*ones(size(cncloss_old_mat{i},1),1);
               cntlai_old_mat{i}(:,mat_index) = NaN*ones(size(cntlai_old_mat{i},1),1);
               cntotc_old_mat{i}(:,mat_index) = NaN*ones(size(cntotc_old_mat{i},1),1);
               evpsoil_old_mat{i}(:,mat_index) = NaN*ones(size(evpsoil_old_mat{i},1),1);
               evptrns_old_mat{i}(:,mat_index) = NaN*ones(size(evptrns_old_mat{i},1),1);
               evpintr_old_mat{i}(:,mat_index) = NaN*ones(size(evpintr_old_mat{i},1),1);
               evpsbln_old_mat{i}(:,mat_index) = NaN*ones(size(evpsbln_old_mat{i},1),1);
               et_old_mat{i}(:,mat_index) = NaN*ones(size(et_old_mat{i},1),1);
            end

            if (i == 1)
               if exist(cn40_read_file)
                  cngpp_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNGPP'));
                  cnnee_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNNEE'));
                  cncloss_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CLOSS'));
                  cntlai_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNTLAI'));
                  cntotc_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'CNTOTC'));
                  evpsoil_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'EVPSOIL'));
                  evptrns_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'EVPTRNS'));
                  evpintr_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'EVPINTR'));
                  evpsbln_cn40_mat(:,mat_index) = double(ncread(cn40_read_file,'EVPSBLN'));
                  et_cn40_mat(:,mat_index) = evpsoil_cn40_mat(:,mat_index) + evptrns_cn40_mat(:,mat_index) ...
                                              + evpintr_cn40_mat(:,mat_index) + evpsbln_cn40_mat(:,mat_index);
                else
                  cngpp_cn40_mat(:,mat_index) = NaN*ones(size(cngpp_cn40_mat,1),1);
                  cnnee_cn40_mat(:,mat_index) = NaN*ones(size(cnnee_cn40_mat,1),1);
                  cncloss_cn40_mat(:,mat_index) = NaN*ones(size(cncloss_cn40_mat,1),1);
                  cntlai_cn40_mat(:,mat_index) = NaN*ones(size(cntlai_cn40_mat,1),1);
                  cntotc_cn40_mat(:,mat_index) = NaN*ones(size(cntotc_cn40_mat,1),1);
                  evpsoil_cn40_mat(:,mat_index) = NaN*ones(size(evpsoil_cn40_mat,1),1);
                  evptrns_cn40_mat(:,mat_index) = NaN*ones(size(evptrns_cn40_mat,1),1);
                  evpintr_cn40_mat(:,mat_index) = NaN*ones(size(evpintr_cn40_mat,1),1);
                  evpsbln_cn40_mat(:,mat_index) = NaN*ones(size(evpsbln_cn40_mat,1),1);
                  et_cn40_mat(:,mat_index) = NaN*ones(size(et_cn40_mat,1),1);
                end

               if exist(cn45_read_file)
                  tmp_mat = double(ncread(cn45_read_file,'CNGPP'));
                  cngpp_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNNEE'));
                  cnnee_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CLOSS'));
                  cncloss_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNTLAI'));
                  cntlai_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNTOTC'));
                  cntotc_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPTRNS'));
                  evptrns_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPSOIL'));
                  evpsoil_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPINTR'));
                  evpintr_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPSBLN'));
                  evpsbln_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  et_cn45_mat(:,mat_index) = evpsoil_cn45_mat(:,mat_index) + evptrns_cn45_mat(:,mat_index) ...
                                              + evpintr_cn45_mat(:,mat_index) + evpsbln_cn45_mat(:,mat_index);
                else
                  cngpp_cn45_mat(:,mat_index) = NaN*ones(size(cngpp_cn45_mat,1),1);
                  cnnee_cn45_mat(:,mat_index) = NaN*ones(size(cnnee_cn45_mat,1),1);
                  cncloss_cn45_mat(:,mat_index) = NaN*ones(size(cncloss_cn45_mat,1),1);
                  cntlai_cn45_mat(:,mat_index) = NaN*ones(size(cntlai_cn45_mat,1),1);
                  cntotc_cn45_mat(:,mat_index) = NaN*ones(size(cntotc_cn45_mat,1),1);
                  evpsoil_cn45_mat(:,mat_index) = NaN*ones(size(evpsoil_cn45_mat,1),1);
                  evptrns_cn45_mat(:,mat_index) = NaN*ones(size(evptrns_cn45_mat,1),1);
                  evpintr_cn45_mat(:,mat_index) = NaN*ones(size(evpintr_cn45_mat,1),1);
                  evpsbln_cn45_mat(:,mat_index) = NaN*ones(size(evpsbln_cn45_mat,1),1);
                  et_cn45_mat(:,mat_index) = NaN*ones(size(et_cn45_mat,1),1);
                end

                if exist(clm5_read_file)
                   tmp_gpp = double(ncread(clm5_read_file,'GPP'));
                   tmp_nee = double(ncread(clm5_read_file,'NEE'));
                   tmp_closs = double(ncread(clm5_read_file,'COL_FIRE_CLOSS'));
                   tmp_lai = double(ncread(clm5_read_file,'TLAI'));
                   tmp_elai = double(ncread(clm5_read_file,'ELAI'));
                   tmp_vegc = double(ncread(clm5_read_file,'TOTVEGC'));
                   tmp_totc = double(ncread(clm5_read_file,'TOTCOLC'));
                   for l = 1:length(lat_vec)
                       clm5_gpp_mat(l,mat_index) = tmp_gpp(clm5_lon_index(l),clm5_lat_index(l));
                       clm5_nee_mat(l,mat_index) = tmp_nee(clm5_lon_index(l),clm5_lat_index(l));
                       clm5_closs_mat(l,mat_index) = tmp_closs(clm5_lon_index(l),clm5_lat_index(l));
                       clm5_elai_mat(l,mat_index) = tmp_elai(clm5_lon_index(l),clm5_lat_index(l));
                       clm5_lai_mat(l,mat_index) = tmp_lai(clm5_lon_index(l),clm5_lat_index(l));
                       clm5_vegc_mat(l,mat_index) = tmp_vegc(clm5_lon_index(l),clm5_lat_index(l));
                       clm5_totc_mat(l,mat_index) = tmp_totc(clm5_lon_index(l),clm5_lat_index(l));
                   end
                 else
                   clm5_gpp_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
                   clm5_nee_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
                   clm5_closs_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
                   clm5_lai_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
                   clm5_elai_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
                   clm5_vegc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
                   clm5_totc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
                  end

                if (exist(fluxsat_gpp_read_file)~=0)
                   fs_gpp_tmp_mat = ncread(fluxsat_gpp_read_file,'GPP');
                   for k = 1:length(lat_vec)
                       fs_gpp_mat(k,mat_index) = fs_gpp_tmp_mat(fs_lon_index(k),fs_lat_index(k));
                   end
                end

                if (exist(maiac_gpp_read_file)~=0)
                   maiac_gpp_tmp_mat = ncread(maiac_gpp_read_file,'GPP');
                   maiac_gpp_tmp_mat(maiac_gpp_tmp_mat==-999) = NaN;
                   for k = 1:length(lat_vec)
                       maiac_gpp_mat(k,mat_index) = maiac_gpp_tmp_mat(maiac_lon_index(k),maiac_lat_index(k));
                   end
                end

                if (exist(vpm_gpp_read_file)~=0)
                   vpm_gpp_tmp_mat = ncread(vpm_gpp_read_file,'GPP');
                   for k = 1:length(lat_vec)
                       vpm_gpp_mat(k,mat_index) = vpm_gpp_tmp_mat(vpm_lon_index(k),vpm_lat_index(k));
                   end
                end

                datenum_vec(mat_index) = datenum(y,m,1);
                year_vec(mat_index) = y;
                month_vec(mat_index) = m;

                for l = 1:length(lat_vec)
                    clm5_of_pi_gpp_mat(l,mat_index) = clm5_of_gpp_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index);
                    clm5_of_pi_lai_mat(l,mat_index) = clm5_of_lai_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index);
                    clm5_of_pi_nee_mat(l,mat_index) = clm5_of_nee_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index);
                    if (mat_index_clm5_mod<=size(clm5_of_gpp_vec,3))
                       clm5_of_mod_gpp_mat(l,mat_index) = clm5_of_gpp_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index_clm5_mod);
                       clm5_of_mod_lai_mat(l,mat_index) = clm5_of_lai_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index_clm5_mod);
                       clm5_of_mod_nee_mat(l,mat_index) = clm5_of_nee_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index_clm5_mod);
                    end
                end

            end % i == 1

        end % m

        if (i == 1)
           if (exist(fluxcom_gpp_read_file)~=0)
              gpp_tmp_mat = ncread(fluxcom_gpp_read_file,'GPP');
              for k = 1:length(lat_vec)
                  start_index = (y_index-1)*12 + 1;
                  stop_index = y_index*12;
                  fc_gpp_mat(k,start_index:stop_index) = gpp_tmp_mat(fc_lon_index(k),fc_lat_index(k),:);
               end
           end
        end
      end % y
end % i

% convert CLM5 carbon fluxes from gC/m2/s to kgC/m2/s
% and states from gc/m2 to kgC/m2

clm5_gpp_mat = clm5_gpp_mat*10^(-3);
clm5_nee_mat = clm5_nee_mat*10^(-3);
clm5_closs_mat = clm5_closs_mat*10^(-3);
clm5_vegc_mat = clm5_vegc_mat*10^(-3);
clm5_totc_mat = clm5_totc_mat*10^(-3);

clm5_of_pi_gpp_mat = clm5_of_pi_gpp_mat*10^(-3);
clm5_of_mod_gpp_mat = clm5_of_mod_gpp_mat*10^(-3);
clm5_of_pi_nee_mat = clm5_of_pi_nee_mat*10^(-3);
clm5_of_mod_nee_mat = clm5_of_mod_nee_mat*10^(-3);

% convert observed GPP from gC m^-2 day^-1 to kgC m^-2 s^-1

fc_gpp_mat = fc_gpp_mat*10^(-3);
fc_gpp_mat = fc_gpp_mat./86400;

fs_gpp_mat = fs_gpp_mat*10^(-3);
fs_gpp_mat = fs_gpp_mat./86400;

maiac_gpp_mat = maiac_gpp_mat*10^(-3);
maiac_gpp_mat = maiac_gpp_mat./86400;

vpm_gpp_mat = vpm_gpp_mat*10^(-3);
vpm_gpp_mat = vpm_gpp_mat./86400;

for i = 1:nr_of_cycles

    ann_index = 0;

    for y = start_year:stop_year

        ann_index = ann_index + 1;
        year_index = (year_vec==y);

        tmp = cngpp_mat{i}(:,year_index);
        mean_global_ann_cngpp{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cngpp{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cnnee_mat{i}(:,year_index);
        mean_global_ann_cnnee{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cnnee{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cncloss_mat{i}(:,year_index);
        mean_global_ann_cncloss{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cncloss{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cntlai_mat{i}(:,year_index);
        mean_global_ann_cntlai{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cntlai{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cntotc_mat{i}(:,year_index);
        mean_global_ann_cntotc{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cntotc{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpsoil_mat{i}(:,year_index);
        mean_global_ann_evpsoil{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evpsoil{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evptrns_mat{i}(:,year_index);
        mean_global_ann_evptrns{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evptrns{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpintr_mat{i}(:,year_index);
        mean_global_ann_evpintr{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evpintr{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpsbln_mat{i}(:,year_index);
        mean_global_ann_evpsbln{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evpsbln{i}(:,ann_index) = nanmean(tmp,2);

        tmp = et_mat{i}(:,year_index);
        mean_global_ann_et{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_et{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cngpp_old_mat{i}(:,year_index);
        mean_global_ann_old_cngpp{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_cngpp{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cnnee_old_mat{i}(:,year_index);
        mean_global_ann_old_cnnee{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_cnnee{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cncloss_old_mat{i}(:,year_index);
        mean_global_ann_old_cncloss{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_cncloss{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cntlai_old_mat{i}(:,year_index);
        mean_global_ann_old_cntlai{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_cntlai{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cntotc_old_mat{i}(:,year_index);
        mean_global_ann_old_cntotc{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_cntotc{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpsoil_old_mat{i}(:,year_index);
        mean_global_ann_old_evpsoil{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_evpsoil{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evptrns_old_mat{i}(:,year_index);
        mean_global_ann_old_evptrns{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_evptrns{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpintr_old_mat{i}(:,year_index);
        mean_global_ann_old_evpintr{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_evpintr{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpsbln_old_mat{i}(:,year_index);
        mean_global_ann_old_evpsbln{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_evpsbln{i}(:,ann_index) = nanmean(tmp,2);

        tmp = et_old_mat{i}(:,year_index);
        mean_global_ann_old_et{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_old_et{i}(:,ann_index) = nanmean(tmp,2);

        if (i == 1)

           tmp = cngpp_cn40_mat(:,year_index);
           mean_global_ann_cn40_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = cnnee_cn40_mat(:,year_index);
           mean_global_ann_cn40_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = cncloss_cn40_mat(:,year_index);
           mean_global_ann_cn40_cncloss(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_cncloss(:,ann_index) = nanmean(tmp,2);

           tmp = cntlai_cn40_mat(:,year_index);
           mean_global_ann_cn40_cntlai(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_cntlai(:,ann_index) = nanmean(tmp,2);

           tmp = cntotc_cn40_mat(:,year_index);
           mean_global_ann_cn40_cntotc(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_cntotc(:,ann_index) = nanmean(tmp,2);

           tmp = evpsoil_cn40_mat(:,year_index);
           mean_global_ann_cn40_evpsoil(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_evpsoil(:,ann_index) = nanmean(tmp,2);

           tmp = evptrns_cn40_mat(:,year_index);
           mean_global_ann_cn40_evptrns(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_evptrns(:,ann_index) = nanmean(tmp,2);

           tmp = evpintr_cn40_mat(:,year_index);
           mean_global_ann_cn40_evpintr(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_evpintr(:,ann_index) = nanmean(tmp,2);

           tmp = evpsbln_cn40_mat(:,year_index);
           mean_global_ann_cn40_evpsbln(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_evpsbln(:,ann_index) = nanmean(tmp,2);

           tmp = et_cn40_mat(:,year_index);
           mean_global_ann_cn40_et(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn40_et(:,ann_index) = nanmean(tmp,2);

           tmp = fc_gpp_mat(:,year_index);
           mean_global_ann_fc_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_fc_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = fs_gpp_mat(:,year_index);
           mean_global_ann_fs_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_fs_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = maiac_gpp_mat(:,year_index);
           mean_global_ann_maiac_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_maiac_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = vpm_gpp_mat(:,year_index);
           mean_global_ann_vpm_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_vpm_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = cngpp_cn45_mat(:,year_index);
           mean_global_ann_cn45_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = cnnee_cn45_mat(:,year_index);
           mean_global_ann_cn45_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = cncloss_cn45_mat(:,year_index);
           mean_global_ann_cn45_cncloss(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cncloss(:,ann_index) = nanmean(tmp,2);

           tmp = cntlai_cn45_mat(:,year_index);
           mean_global_ann_cn45_cntlai(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cntlai(:,ann_index) = nanmean(tmp,2);

           tmp = cntotc_cn45_mat(:,year_index);
           mean_global_ann_cn45_cntotc(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cntotc(:,ann_index) = nanmean(tmp,2);

           tmp = evpsoil_cn45_mat(:,year_index);
           mean_global_ann_cn45_evpsoil(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evpsoil(:,ann_index) = nanmean(tmp,2);

           tmp = evptrns_cn45_mat(:,year_index);
           mean_global_ann_cn45_evptrns(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evptrns(:,ann_index) = nanmean(tmp,2);

           tmp = evpintr_cn45_mat(:,year_index);
           mean_global_ann_cn45_evpintr(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evpintr(:,ann_index) = nanmean(tmp,2);

           tmp = evpsbln_cn45_mat(:,year_index);
           mean_global_ann_cn45_evpsbln(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evpsbln(:,ann_index) = nanmean(tmp,2);

           tmp = et_cn45_mat(:,year_index);
           mean_global_ann_cn45_et(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_et(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_gpp_mat(:,year_index);
           mean_global_ann_clm5_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_nee_mat(:,year_index);
           mean_global_ann_clm5_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_closs_mat(:,year_index);
           mean_global_ann_clm5_cncloss(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_cncloss(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_lai_mat(:,year_index);
           mean_global_ann_clm5_cntlai(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_cntlai(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_totc_mat(:,year_index);
           mean_global_ann_clm5_cntotc(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_cntotc(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_pi_gpp_mat(:,year_index);
           mean_global_ann_clm5_of_pi_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_pi_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_mod_gpp_mat(:,year_index);
           mean_global_ann_clm5_of_mod_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_mod_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_pi_lai_mat(:,year_index);
           mean_global_ann_clm5_of_pi_cntlai(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_pi_cntlai(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_mod_lai_mat(:,year_index);
           mean_global_ann_clm5_of_mod_cntlai(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_mod_cntlai(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_pi_nee_mat(:,year_index);
           mean_global_ann_clm5_of_pi_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_pi_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_mod_nee_mat(:,year_index);
           mean_global_ann_clm5_of_mod_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_mod_cnnee(:,ann_index) = nanmean(tmp,2);

        end

     end
end

legend_str = {};
legend_counter = 0;

cmap = lines(nr_of_cycles);

figure
for i = 1:nr_of_cycles
    plot(start_year:last_full_year,mean_global_ann_cngpp{i}(1:nr_complete_years),'LineWidth',2,'LineStyle','-','Color','r');
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
    plot(start_year:stop_year,mean_global_ann_old_cngpp{i},'LineWidth',2,'LineStyle','--','Color',cmap(i,:));
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  ['CN51 cycle old ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_fc_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_fs_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_maiac_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_vpm_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_cn40_cngpp,'LineWidth',2,'LineStyle','-','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_cngpp,'LineWidth',2,'LineStyle','--','Color','k');
hold on
%plot(start_year:stop_year,mean_global_ann_clm5_cngpp,'LineWidth',2,'LineStyle','--','Color','m');
%hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cngpp,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cngpp,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('GPP [kg m^{-2} s^{-1}]')
title('annual average GPP [kg m^{-2} s^{-1}]')
legend_str{legend_counter+1} = 'FluxCom';
legend_str{legend_counter+2} = 'FluxSat';
legend_str{legend_counter+3} = 'MAIAC';
legend_str{legend_counter+4} = 'VPM';
legend_str{legend_counter+5} = 'CN40 (@390ppm)';
legend_str{legend_counter+6} = 'CN45 (@390ppm)';
%legend_str{i+7} = 'CLM5 Jana';
legend_str{legend_counter+7} = 'CLM5 NCAR (1850 - 1890)';
legend_str{legend_counter+8} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_ann_CN51_cycles_280_old_vs_new'],'png')

legend_str = {};
legend_counter = 0;

figure
for i = 1:nr_of_cycles
    plot(start_year:last_full_year,mean_global_ann_cntlai{i}(1:nr_complete_years),'LineWidth',2,'LineStyle','-','Color','r');
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  [legend_new num2str(i) ' (@280ppm)'];
    plot(start_year:stop_year,mean_global_ann_old_cntlai{i},'LineWidth',2,'LineStyle','--','Color',cmap(i,:));
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  [legend_old num2str(i) ' (@280ppm)'];
end
hold on
plot(start_year:stop_year,mean_global_ann_cn40_cntlai,'LineWidth',2,'LineStyle','-','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_cntlai,'LineWidth',2,'LineStyle','--','Color','k');
%hold on
%plot(start_year:stop_year,mean_global_ann_clm5_cntlai,'LineWidth',2,'LineStyle','--','Color','m');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cntlai,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cntlai,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('LAI [-]')
title('annual average LAI [-]')
legend_str{legend_counter+1} = 'CN40 (@390ppm)';
legend_str{legend_counter+2} = 'CN45 (@390ppm)';
%legend_str{i+3} = 'CLM5';
legend_str{legend_counter+3} = 'CLM5 NCAR (1850 - 1890)';
legend_str{legend_counter+4} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTLAI_ann_CN51_cycles_280_old_vs_new'],'png')                                              

legend_str = {};
legend_counter = 0;

figure
for i = 1:nr_of_cycles
   % plot(start_year:last_full_year,mean_global_ann_cntlai{i}(1:nr_complete_years),'LineWidth',2,'LineStyle','-','Color',cmap(i,:));
    %hold on
    %legend_counter = legend_counter + 1;
    %legend_str{legend_counter} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
    plot(start_year:stop_year,mean_global_ann_old_cntlai{i},'LineWidth',2,'LineStyle','--','Color',cmap(i,:));
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  ['CN51 cycle new config ' num2str(i) ' (@280ppm)'];
end
hold on
plot(start_year:stop_year,mean_global_ann_cn40_cntlai,'LineWidth',2,'LineStyle','-','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_cntlai,'LineWidth',2,'LineStyle','--','Color','k');
%hold on
%plot(start_year:stop_year,mean_global_ann_clm5_cntlai,'LineWidth',2,'LineStyle','--','Color','m');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cntlai,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cntlai,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('LAI [-]')
title('annual average LAI [-]')
legend_str{legend_counter+1} = 'CN40 (@390ppm)';
legend_str{legend_counter+2} = 'CN45 (@390ppm)';
%legend_str{i+3} = 'CLM5';
legend_str{legend_counter+3} = 'CLM5 NCAR (1850 - 1890)';
legend_str{legend_counter+4} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTLAI_ann_CN51_cycles_280_old'],'png')


% compute LAI rate of change
for i = 2:nr_complete_years

    roc_cn51_cntlai(i-1) = mean_global_ann_cntlai{1}(i) - mean_global_ann_cntlai{1}(i-1);
    roc_cn51_old_cntlai(i-1) = mean_global_ann_old_cntlai{1}(i) - mean_global_ann_old_cntlai{1}(i-1);
end

legend_str = {};
legend_counter = 0;

figure
for i = 1:nr_of_cycles
    plot(1:(nr_complete_years-1),roc_cn51_cntlai,'LineWidth',2,'LineStyle','-','Color',cmap(i,:));
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  [legend_new num2str(i) ' (@280ppm)'];
    plot(1:(nr_complete_years-1),roc_cn51_old_cntlai,'LineWidth',2,'LineStyle','--','Color',cmap(i,:));
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  [legend_old num2str(i) ' (@280ppm)'];
end
hold off
grid on
xlabel('year')
ylabel('\Delta LAI [-]')
title('change in annual average LAI [-]')
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTLAI_ann_roc_CN51_cycles_280_old_vs_new'],'png') 

legend_str = {};
legend_counter = 0;

%figure
%for i = 1:nr_of_cycles
%    plot(start_year:last_full_year,mean_local_ann_cngpp{i}(k,1:nr_complete_years),'LineWidth',2,'LineStyle','-','Color',cmap(i,:));
%    hold on
%    legend_counter = legend_counter + 1;
%    legend_str{legend_counter} =  [legend_new num2str(i) ' (@280ppm)'];
%    plot(start_year:stop_year,mean_local_ann_old_cngpp{i}(k,:),'LineWidth',2,'LineStyle','--','Color',cmap(i,:));
%    hold on
%    legend_counter = legend_counter + 1;
%    legend_str{legend_counter} =  [legend_old num2str(i) ' (@280ppm)'];
%end
%hold off
%grid on
%xlabel('year')
%ylabel(' GPP [-]')
%title('change in annual average GPP [kg m^{-2} s^{-1}]')
%legend(legend_str,'Location','bestoutside')
%set(gcf,'paperunits','centimeters')
%set(gcf,'paperposition',[1 1 25 15])
%saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_ann_CN51_cycles_280_old_vs_new'],'png')

for k = 1:size(mean_local_ann_cntlai{1},1)

legend_str = {};
legend_counter = 0;

figure
for i = 1:nr_of_cycles
    plot(start_year:last_full_year,mean_local_ann_cntlai{i}(k,1:nr_complete_years),'LineWidth',2,'LineStyle','-','Color',cmap(i,:));
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  [legend_new num2str(i) ' (@280ppm)'];
    plot(start_year:stop_year,mean_local_ann_old_cntlai{i}(k,:),'LineWidth',2,'LineStyle','--','Color',cmap(i,:));
    hold on
    legend_counter = legend_counter + 1;
    legend_str{legend_counter} =  [legend_old num2str(i) ' (@280ppm)'];
end
hold on
plot(start_year:stop_year,mean_local_ann_cn40_cntlai(k,:),'LineWidth',2,'LineStyle','-','Color','k');
hold on
plot(start_year:stop_year,mean_local_ann_cn45_cntlai(k,:),'LineWidth',2,'LineStyle','--','Color','k');
%hold on
%plot(start_year:stop_year,mean_global_ann_clm5_cntlai,'LineWidth',2,'LineStyle','--','Color','m');
hold on
plot(start_year:stop_year,mean_local_ann_clm5_of_pi_cntlai(k,:),'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_local_ann_clm5_of_mod_cntlai(k,:),'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('LAI [-]')
title('annual average LAI [-]')
legend_str{legend_counter+1} = 'CN40 (@390ppm)';
legend_str{legend_counter+2} = 'CN45 (@390ppm)';
%legend_str{i+3} = 'CLM5';
legend_str{legend_counter+3} = 'CLM5 NCAR (1850 - 1890)';
legend_str{legend_counter+4} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CNTLAI_ann_CN51_cycles_280_old_vs_new_loc_' num2str(k)],'png')  

end
