clc                
clear all          
close all 

exp1_path = '/discover/nobackup/jkolassa/CN51_FLWALPHA/';
exp1_name = 'GEOSldas_CN51_local_280'; 
exp1_plot_name = 'FLWALPHA04';
exp1_plot_name_legend = 'FLWALPHA=0.04';

exp2_path = '/discover/nobackup/jkolassa/CN51_update/';
exp2_name = 'GEOSldas_CN51_local_280'; 
exp2_plot_name = 'FLWALPHA005';
exp2_plot_name_legend = 'FLWALPHA=0.005';

start_year = 1980;
stop_year = 2019;

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

cn51_read_file = ['/discover/nobackup/projects/geoscm/fzeng/Catchment-CN5.1/local_runs/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.monthly.198001.nc4'];

lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));

mat_index = 0;
y_index = 0;

for y = start_year:stop_year

    y_index = y_index + 1;
    y_str = num2str(y,'%04i');
    y_index_str = num2str(y_index,'%04i');

    % define month length based on leap year status
    if sum(y==leapYears)>0
       monthLength = monthLength_ly;
    else
       monthLength = monthLength_nly;
    end

    % loop over months
    for m = 1:12

        mat_index = mat_index + 1;

        m_str = num2str(m,'%02i');

        % define file names

        exp1_read_file = [exp1_path exp1_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                         '/M' m_str '/' exp1_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
        exp2_read_file = [exp2_path exp2_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ... 
                         '/M' m_str '/' exp2_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        % initialize arrays

        if (mat_index == 1)
           exp1_cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_cncloss_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_sfmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_rzmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_et_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_evpsoil_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_evptrns_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_evpintr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_evpsbln_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp1_runsurf_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

           exp2_cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_cncloss_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_sfmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_rzmc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_et_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_evpsoil_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_evptrns_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_evpintr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_evpsbln_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
           exp2_runsurf_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
        end

        % read data

        if exist(exp1_read_file)
           exp1_cngpp_mat(:,mat_index) = double(ncread(exp1_read_file,'CNGPP'));
           exp1_cnnee_mat(:,mat_index) = double(ncread(exp1_read_file,'CNNEE'));
           exp1_cncloss_mat(:,mat_index) = double(ncread(exp1_read_file,'CLOSS'));
           exp1_cntlai_mat(:,mat_index) = double(ncread(exp1_read_file,'CNTLAI'));
           exp1_cntotc_mat(:,mat_index) = double(ncread(exp1_read_file,'CNTOTC'));
           exp1_sfmc_mat(:,mat_index) = double(ncread(exp1_read_file,'SFMC'));
           exp1_rzmc_mat(:,mat_index) = double(ncread(exp1_read_file,'RZMC'));
           exp1_evpsoil_mat(:,mat_index) = double(ncread(exp1_read_file,'LHLANDSOIL'));
           exp1_evptrns_mat(:,mat_index) = double(ncread(exp1_read_file,'LHLANDTRNS'));
           exp1_evpintr_mat(:,mat_index) = double(ncread(exp1_read_file,'LHLANDINTR'));
           exp1_evpsbln_mat(:,mat_index) = double(ncread(exp1_read_file,'LHLANDSBLN'));
           exp1_et_mat(:,mat_index) = exp1_evpsoil_mat(:,mat_index) + exp1_evptrns_mat(:,mat_index) ...
                                      + exp1_evpintr_mat(:,mat_index) + exp1_evpsbln_mat(:,mat_index);
           exp1_runsurf_mat(:,mat_index) = double(ncread(exp1_read_file,'RUNSURFLAND'));
         else
           exp1_cngpp_mat(:,mat_index) = NaN*ones(size(exp1_cngpp_mat,1),1);
           exp1_cnnee_mat(:,mat_index) = NaN*ones(size(exp1_cnnee_mat,1),1);
           exp1_cncloss_mat(:,mat_index) = NaN*ones(size(exp1_cncloss_mat,1),1);
           exp1_cntlai_mat(:,mat_index) = NaN*ones(size(exp1_cntlai_mat,1),1);
           exp1_cntotc_mat(:,mat_index) = NaN*ones(size(exp1_cntotc_mat,1),1);
           exp1_sfmc_mat(:,mat_index) = NaN*ones(size(exp1_sfmc_mat,1),1);
           exp1_rzmc_mat(:,mat_index) = NaN*ones(size(exp1_rzmc_mat,1),1);
           exp1_evpsoil_mat(:,mat_index) = NaN*ones(size(exp1_evpsoil_mat,1),1);
           exp1_evptrns_mat(:,mat_index) = NaN*ones(size(exp1_evptrns_mat,1),1);
           exp1_evpintr_mat(:,mat_index) = NaN*ones(size(exp1_evpintr_mat,1),1);
           exp1_evpsbln_mat(:,mat_index) = NaN*ones(size(exp1_evpsbln_mat,1),1);
           exp1_et_mat(:,mat_index) = NaN*ones(size(exp1_et_mat,1),1);
           exp1_runsurf_mat(:,mat_index) = NaN*ones(size(exp1_runsurf_mat,1),1);
         end

        if exist(exp2_read_file)
           exp2_cngpp_mat(:,mat_index) = double(ncread(exp2_read_file,'CNGPP'));
           exp2_cnnee_mat(:,mat_index) = double(ncread(exp2_read_file,'CNNEE'));
           exp2_cncloss_mat(:,mat_index) = double(ncread(exp2_read_file,'CLOSS'));
           exp2_cntlai_mat(:,mat_index) = double(ncread(exp2_read_file,'CNTLAI'));
           exp2_cntotc_mat(:,mat_index) = double(ncread(exp2_read_file,'CNTOTC'));
           exp2_sfmc_mat(:,mat_index) = double(ncread(exp2_read_file,'SFMC'));
           exp2_rzmc_mat(:,mat_index) = double(ncread(exp2_read_file,'RZMC'));
           exp2_evpsoil_mat(:,mat_index) = double(ncread(exp2_read_file,'LHLANDSOIL'));
           exp2_evptrns_mat(:,mat_index) = double(ncread(exp2_read_file,'LHLANDTRNS'));
           exp2_evpintr_mat(:,mat_index) = double(ncread(exp2_read_file,'LHLANDINTR'));
           exp2_evpsbln_mat(:,mat_index) = double(ncread(exp2_read_file,'LHLANDSBLN'));
           exp2_et_mat(:,mat_index) = exp2_evpsoil_mat(:,mat_index) + exp2_evptrns_mat(:,mat_index) ...
                                      + exp2_evpintr_mat(:,mat_index) + exp2_evpsbln_mat(:,mat_index);
           exp2_runsurf_mat(:,mat_index) = double(ncread(exp2_read_file,'RUNSURFLAND'));
         else
           exp2_cngpp_mat(:,mat_index) = NaN*ones(size(exp2_cngpp_mat,1),1);
           exp2_cnnee_mat(:,mat_index) = NaN*ones(size(exp2_cnnee_mat,1),1);
           exp2_cncloss_mat(:,mat_index) = NaN*ones(size(exp2_cncloss_mat,1),1);
           exp2_cntlai_mat(:,mat_index) = NaN*ones(size(exp2_cntlai_mat,1),1);
           exp2_cntotc_mat(:,mat_index) = NaN*ones(size(exp2_cntotc_mat,1),1);
           exp2_sfmc_mat(:,mat_index) = NaN*ones(size(exp2_sfmc_mat,1),1);
           exp2_rzmc_mat(:,mat_index) = NaN*ones(size(exp2_rzmc_mat,1),1);
           exp2_evpsoil_mat(:,mat_index) = NaN*ones(size(exp2_evpsoil_mat,1),1);
           exp2_evptrns_mat(:,mat_index) = NaN*ones(size(exp2_evptrns_mat,1),1);
           exp2_evpintr_mat(:,mat_index) = NaN*ones(size(exp2_evpintr_mat,1),1);
           exp2_evpsbln_mat(:,mat_index) = NaN*ones(size(exp2_evpsbln_mat,1),1);
           exp2_et_mat(:,mat_index) = NaN*ones(size(exp2_et_mat,1),1);
           exp2_runsurf_mat(:,mat_index) = NaN*ones(size(exp2_runsurf_mat,1),1);
         end

         datenum_vec(mat_index) = datenum(y,m,1);
         year_vec(mat_index) = y;
         month_vec(mat_index) = m;

    end
end

% convert LHLAND values from W/m^2 to mm/day

exp1_evpsoil_mmd_mat = exp1_evpsoil_mat*0.0864*0.408;
exp1_evptrns_mmd_mat = exp1_evptrns_mat*0.0864*0.408;
exp1_evpintr_mmd_mat = exp1_evpintr_mat*0.0864*0.408;
exp1_evpsbln_mmd_mat = exp1_evpsbln_mat*0.0864*0.352;
exp1_et_mmd_mat = exp1_et_mat*0.0864*0.408;

exp2_evpsoil_mmd_mat = exp2_evpsoil_mat*0.0864*0.408;
exp2_evptrns_mmd_mat = exp2_evptrns_mat*0.0864*0.408;
exp2_evpintr_mmd_mat = exp2_evpintr_mat*0.0864*0.408;
exp2_evpsbln_mmd_mat = exp2_evpsbln_mat*0.0864*0.352;
exp2_et_mmd_mat = exp2_et_mat*0.0864*0.408;

% convert runoff from kg/m^2/s to mm/day

exp1_runsurf_mmd_mat = exp1_runsurf_mat*86400;
exp2_runsurf_mmd_mat = exp2_runsurf_mat*86400;

ann_index = 0;

for y = start_year:stop_year

    ann_index = ann_index + 1;
    year_index = (year_vec==y);

    tmp = exp1_cngpp_mat(:,year_index);
    mean_global_ann_exp1_cngpp(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_cngpp(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_cnnee_mat(:,year_index);
    mean_global_ann_exp1_cnnee(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_cnnee(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_cncloss_mat(:,year_index);
    mean_global_ann_exp1_cncloss(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_cncloss(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_cntlai_mat(:,year_index);
    mean_global_ann_exp1_cntlai(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_cntlai(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_cntotc_mat(:,year_index);
    mean_global_ann_exp1_cntotc(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_cntotc(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_sfmc_mat(:,year_index);
    mean_global_ann_exp1_sfmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_sfmc(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_rzmc_mat(:,year_index);
    mean_global_ann_exp1_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_et_mmd_mat(:,year_index);
    mean_global_ann_exp1_et(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_et(:,ann_index) = nanmean(tmp,2);

    tmp = exp1_runsurf_mat(:,year_index);
    mean_global_ann_exp1_runsurf(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp1_runsurf(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_cngpp_mat(:,year_index);
    mean_global_ann_exp2_cngpp(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_cngpp(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_cnnee_mat(:,year_index);
    mean_global_ann_exp2_cnnee(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_cnnee(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_cncloss_mat(:,year_index);
    mean_global_ann_exp2_cncloss(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_cncloss(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_cntlai_mat(:,year_index);
    mean_global_ann_exp2_cntlai(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_cntlai(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_cntotc_mat(:,year_index);
    mean_global_ann_exp2_cntotc(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_cntotc(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_sfmc_mat(:,year_index);
    mean_global_ann_exp2_sfmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_sfmc(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_rzmc_mat(:,year_index);
    mean_global_ann_exp2_rzmc(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_rzmc(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_et_mmd_mat(:,year_index);
    mean_global_ann_exp2_et(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_et(:,ann_index) = nanmean(tmp,2);

    tmp = exp2_runsurf_mat(:,year_index);
    mean_global_ann_exp2_runsurf(ann_index) = nanmean(tmp(:));
    mean_local_ann_exp2_runsurf(:,ann_index) = nanmean(tmp,2);
end

figure
plot(start_year:stop_year,mean_global_ann_exp1_cngpp,'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_global_ann_exp2_cngpp,'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('GPP [kg m^{-2} s^{-1}]')
title('annual average GPP [kg m^{-2} s^{-1}]')
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name],'png')

figure
plot(start_year:stop_year,mean_global_ann_exp1_cnnee,'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_global_ann_exp2_cnnee,'LineWidth',2,'LineStyle','-');
hold off 
grid on
xlabel('year')
ylabel('NEE [kg m^{-2} s^{-1}]')
title('annual average NEE [kg m^{-2} s^{-1}]')
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/NEE_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name],'png')

figure
plot(start_year:stop_year,mean_global_ann_exp1_cntlai,'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_global_ann_exp2_cntlai,'LineWidth',2,'LineStyle','-');
hold off 
grid on
xlabel('year')
ylabel('LAI [-]')
title('annual average LAI [-]')
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name],'png')

figure
plot(start_year:stop_year,mean_global_ann_exp1_sfmc,'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_global_ann_exp2_sfmc,'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('SFMC [m^3 m^{-3}]')
title('annual average SFMC [m^3 m^{-3}]')
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/SFMC_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name],'png')

figure
plot(start_year:stop_year,mean_global_ann_exp1_rzmc,'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_global_ann_exp2_rzmc,'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('RZMC [m^3 m^{-3}]')
title('annual average RZMC [m^3 m^{-3}]')
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters') 
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/RZMC_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name],'png')

figure
plot(start_year:stop_year,mean_global_ann_exp1_et,'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_global_ann_exp2_et,'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('ET [mm/day]')
title('annual average ET [mm/day]')
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/ET_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name],'png')

figure
plot(start_year:stop_year,mean_global_ann_exp1_runsurf,'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_global_ann_exp2_runsurf,'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('RUNSURF [mm/day]')
title('annual average RUNSURF [mm/day]')
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/RUNSURF_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name],'png')


for i = 1:size(mean_local_ann_exp1_cngpp,1)

figure
plot(start_year:stop_year,mean_local_ann_exp1_cngpp(i,:),'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_local_ann_exp2_cngpp(i,:),'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('GPP [kg m^{-2} s^{-1}]')
title(['annual average GPP [kg m^{-2} s^{-1}] at location ' num2str(i) ' lat: ' num2str(lat_vec(i),'%2.2f') '; lon: ' num2str(lon_vec(i),'%2.2f')])
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name '_loc_' num2str(i)],'png')

figure
plot(start_year:stop_year,mean_local_ann_exp1_cnnee(i,:),'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_local_ann_exp2_cnnee(i,:),'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('NEE [kg m^{-2} s^{-1}]')
title(['annual average NEE [kg m^{-2} s^{-1}] at location ' num2str(i) ' lat: ' num2str(lat_vec(i),'%2.2f') '; lon: ' num2str(lon_vec(i),'%2.2f')])
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/NEE_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name '_loc_' num2str(i)],'png')

figure
plot(start_year:stop_year,mean_local_ann_exp1_cntlai(i,:),'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_local_ann_exp2_cntlai(i,:),'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('LAI [-]')
title(['annual average LAI [-] at location ' num2str(i) ' lat: ' num2str(lat_vec(i),'%2.2f') '; lon: ' num2str(lon_vec(i),'%2.2f')])
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name '_loc_' num2str(i)],'png')

figure
plot(start_year:stop_year,mean_local_ann_exp1_sfmc(i,:),'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_local_ann_exp2_sfmc(i,:),'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('SFMC [m^3 m^{-3}]')
title(['annual average SFMC [m^3 m^{-3}] at location ' num2str(i) ' lat: ' num2str(lat_vec(i),'%2.2f') '; lon: ' num2str(lon_vec(i),'%2.2f')])
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/SFMC_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name '_loc_' num2str(i)],'png')

figure
plot(start_year:stop_year,mean_local_ann_exp1_rzmc(i,:),'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_local_ann_exp2_rzmc(i,:),'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('RZMC [m^3 m^{-3}]')
title(['annual average RZMC [m^3 m^{-3}] at location ' num2str(i) ' lat: ' num2str(lat_vec(i),'%2.2f') '; lon: ' num2str(lon_vec(i),'%2.2f')])
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/RZMC_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name '_loc_' num2str(i)],'png')

figure
plot(start_year:stop_year,mean_local_ann_exp1_et(i,:),'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_local_ann_exp2_et(i,:),'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('ET [mm/day]')
title(['annual average ET [mm/day] at location ' num2str(i) ' lat: ' num2str(lat_vec(i),'%2.2f') '; lon: ' num2str(lon_vec(i),'%2.2f')])
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/ET_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name '_loc_' num2str(i)],'png')

figure
plot(start_year:stop_year,mean_local_ann_exp1_runsurf(i,:),'LineWidth',2,'LineStyle','-');
hold on
plot(start_year:stop_year,mean_local_ann_exp2_runsurf(i,:),'LineWidth',2,'LineStyle','-');
hold off
grid on
xlabel('year')
ylabel('RUNSURF [mm/day]')
title(['annual average RUNSURF [mm/day] at location ' num2str(i) ' lat: ' num2str(lat_vec(i),'%2.2f') '; lon: ' num2str(lon_vec(i),'%2.2f')])
legend_str{1} = exp1_plot_name_legend;
legend_str{2} = exp2_plot_name_legend;
legend(legend_str,'Location','bestoutside')
set(findall(gcf,'-property','FontSize'),'FontSize',14)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/RUNSURF_ann_CN51_cycles_280_comp_' exp1_plot_name '_vs_' exp2_plot_name '_loc_' num2str(i)],'png')

end

% compute difference statistics

mean_local_ann_cngpp_diff = mean_local_ann_exp1_cngpp - mean_local_ann_exp2_cngpp;
mean_local_ann_cntlai_diff = mean_local_ann_exp1_cntlai - mean_local_ann_exp2_cntlai;
mean_local_ann_cnnee_diff = mean_local_ann_exp1_cnnee - mean_local_ann_exp2_cnnee;
mean_local_ann_rzmc_diff = mean_local_ann_exp1_rzmc - mean_local_ann_exp2_rzmc;
mean_local_ann_sfmc_diff = mean_local_ann_exp1_sfmc - mean_local_ann_exp2_sfmc;
mean_local_ann_et_diff = mean_local_ann_exp1_et - mean_local_ann_exp2_et;
mean_local_ann_runsurf_diff = mean_local_ann_exp1_runsurf - mean_local_ann_exp2_runsurf;

[abs_max_local_cngpp_diff,abs_max_local_cngpp_diff_index] = max(abs(mean_local_ann_cngpp_diff),[],'all');
[abs_max_local_cngpp_diff_index_row,abs_max_local_cngpp_diff_index_col] = find(abs(mean_local_ann_cngpp_diff)==abs_max_local_cngpp_diff);
[abs_max_local_cntlai_diff,abs_max_local_cntlai_diff_index] = max(abs(mean_local_ann_cntlai_diff),[],'all');
[abs_max_local_cntlai_diff_index_row,abs_max_local_cntlai_diff_index_col] = find(abs(mean_local_ann_cntlai_diff)==abs_max_local_cntlai_diff);
[abs_max_local_cnnee_diff,abs_max_local_cnnee_diff_index] = max(abs(mean_local_ann_cnnee_diff),[],'all');
[abs_max_local_cnnee_diff_index_row,abs_max_local_cnnee_diff_index_col] = find(abs(mean_local_ann_cnnee_diff)==abs_max_local_cnnee_diff);
[abs_max_local_sfmc_diff,abs_max_local_sfmc_diff_index] = max(abs(mean_local_ann_sfmc_diff),[],'all');
[abs_max_local_sfmc_diff_index_row,abs_max_local_sfmc_diff_index_col] = find(abs(mean_local_ann_sfmc_diff)==abs_max_local_sfmc_diff);
[abs_max_local_rzmc_diff,abs_max_local_rzmc_diff_index] = max(abs(mean_local_ann_rzmc_diff),[],'all');
[abs_max_local_rzmc_diff_index_row,abs_max_local_rzmc_diff_index_col] = find(abs(mean_local_ann_rzmc_diff)==abs_max_local_rzmc_diff);
[abs_max_local_et_diff,abs_max_local_et_diff_index] = max(abs(mean_local_ann_et_diff),[],'all');
[abs_max_local_et_diff_index_row,abs_max_local_et_diff_index_col] = find(abs(mean_local_ann_et_diff)==abs_max_local_et_diff);
[abs_max_local_runsurf_diff,abs_max_local_runsurf_diff_index] = max(abs(mean_local_ann_runsurf_diff),[],'all');
[abs_max_local_runsurf_diff_index_row,abs_max_local_runsurf_diff_index_col] = find(abs(mean_local_ann_runsurf_diff)==abs_max_local_runsurf_diff);

abs_mean_local_cngpp_diff = nanmean(abs(mean_local_ann_cngpp_diff),2);
abs_mean_local_cngpp_diff_index = find(abs_mean_local_cngpp_diff==max(abs_mean_local_cngpp_diff));
abs_mean_local_cntlai_diff = nanmean(abs(mean_local_ann_cntlai_diff),2);
abs_mean_local_cntlai_diff_index = find(abs_mean_local_cntlai_diff==max(abs_mean_local_cntlai_diff));
abs_mean_local_cnnee_diff = nanmean(abs(mean_local_ann_cnnee_diff),2);
abs_mean_local_cnnee_diff_index = find(abs_mean_local_cnnee_diff==max(abs_mean_local_cnnee_diff));
abs_mean_local_sfmc_diff = nanmean(abs(mean_local_ann_sfmc_diff),2);
abs_mean_local_sfmc_diff_index = find(abs_mean_local_sfmc_diff==max(abs_mean_local_sfmc_diff));
abs_mean_local_rzmc_diff = nanmean(abs(mean_local_ann_rzmc_diff),2);
abs_mean_local_rzmc_diff_index = find(abs_mean_local_rzmc_diff==max(abs_mean_local_rzmc_diff));
abs_mean_local_et_diff = nanmean(abs(mean_local_ann_et_diff),2);
abs_mean_local_et_diff_index = find(abs_mean_local_et_diff==max(abs_mean_local_et_diff));
abs_mean_local_runsurf_diff = nanmean(abs(mean_local_ann_runsurf_diff),2);
abs_mean_local_runsurf_diff_index = find(abs_mean_local_runsurf_diff==max(abs_mean_local_runsurf_diff));
