clc
clear all
close all

base_path = '/discover/nobackup/jkolassa/CN51_config_test/';
base_exp_name = 'GEOSldas_CN51_local_280';
nr_of_cycles = 9;

start_year = 1980;
stop_year = 2019;

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

var_col = 37;
col_frac = [0.1 0.45 0.45];

for i = 1:nr_of_cycles

    if (i>1)
       cyc_str = ['c' num2str(i,'%0i')];
       exp_name = [base_exp_name '_' cyc_str];
    else
       exp_name = base_exp_name;
       cyc_str = ['c' num2str(i,'%0i')];
    end

    cn51_rst_file = [base_path exp_name '/output/SMAP_EASEv2_M36/rs/ens0000/Y1980'... 
                    '/M01/' exp_name '.catchcnclm51_internal_rst.19800101_0000'];

    cncol_data = double(ncread(cn51_rst_file,'CNCOL'));
    cnpft_data = double(ncread(cn51_rst_file,'CNPFT'));

    for v = 1:var_col
        v_start_index = (v-1)*3 + 1;
        v_stop_index = v*3;
        cncol{v} = cncol_data(:,v_start_index:v_stop_index);
        cncol_avg{v} = nansum((cncol{v}.*col_frac),2);
    end

    cwdc_mat(:,i) = cncol_avg{2}(:);
    totlitc_mat(:,i) = cncol_avg{15}(:);
    totvegc_mat(:,i) = cncol_avg{6}(:);
    totsomc_mat(:,i) = cncol_avg{10}(:) + cncol_avg{11}(:) + cncol_avg{12}(:) + cncol_avg{13}(:);
    totcolc_mat(:,i) = cncol_avg{14}(:);
end 

% compute average across all sites

cwdc_avg_mat = nanmean(cwdc_mat,1);
totlitc_avg_mat = nanmean(totlitc_mat,1);
totvegc_avg_mat = nanmean(totvegc_mat,1);
totsomc_avg_mat = nanmean(totsomc_mat,1);
totcolc_avg_mat = nanmean(totcolc_mat,1);

% compute deltas

for i = 1:(length(cwdc_avg_mat)-1)

    cwdc_avg_delta(i) = cwdc_avg_mat(i+1) - cwdc_avg_mat(i);
    totlitc_avg_delta(i) = totlitc_avg_mat(i+1) - totlitc_avg_mat(i);
    totvegc_avg_delta(i) = totvegc_avg_mat(i+1) - totvegc_avg_mat(i);
    totsomc_avg_delta(i) = totsomc_avg_mat(i+1) - totsomc_avg_mat(i);
    totcolc_avg_delta(i) = totcolc_avg_mat(i+1) - totcolc_avg_mat(i);

end

% plot the site averages

figure 
plot(1:length(cwdc_avg_mat),cwdc_avg_mat,'LineWidth',2)
grid on
xlabel('cycle [-]')
ylabel('CWDC [gC m^{-2}]')
title('coarse woody debris carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CWDC_avg'],'png')

figure
plot(1:length(totlitc_avg_mat),totlitc_avg_mat,'LineWidth',2)
grid on
xlabel('cycle [-]')
ylabel('TOTLITC [gC m^{-2}]')
title('total litter carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTLITC_avg'],'png')

figure
plot(1:length(totvegc_avg_mat),totvegc_avg_mat,'LineWidth',2)
grid on
xlabel('cycle [-]')
ylabel('TOTVEGC [gC m^{-2}]')
title('total vegetation carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTVEGC_avg'],'png')

figure
plot(1:length(totsomc_avg_mat),totsomc_avg_mat,'LineWidth',2)
grid on
xlabel('cycle [-]')
ylabel('TOTSOMC [gC m^{-2}]')
title('total soil organic carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTSOMC_avg'],'png')

figure
plot(1:length(totcolc_avg_mat),totcolc_avg_mat,'LineWidth',2)
grid on
xlabel('cycle [-]')
ylabel('TOTCOLC [gC m^{-2}]')
title('total column carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTCOLC_avg'],'png')

% plot deltas

x = 1:(length(cwdc_avg_mat)-1);
y = zeros(size(x));

figure
plot(1:(length(cwdc_avg_mat)-1),cwdc_avg_delta,'LineWidth',2)
hold on
plot(x,y,'-r','LineWidth',2)
hold off
grid on
xlabel('cycles completed [-]')
ylabel('\Delta CWDC [gC m^{-2}]')
title('change in coarse woody debris carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CWDC_avg_delta'],'png')

figure
plot(1:(length(totlitc_avg_mat)-1),totlitc_avg_delta,'LineWidth',2)
hold on
plot(x,y,'-r','LineWidth',2)
hold off
grid on
xlabel('cycles completed [-]')
ylabel('\Delta TOTLITC [gC m^{-2}]')
title('change in total litter carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTLITC_avg_delta'],'png')

figure
plot(1:(length(totvegc_avg_mat)-1),totvegc_avg_delta,'LineWidth',2)
hold on
plot(x,y,'-r','LineWidth',2)
hold off
grid on
xlabel('cycles completed [-]')
ylabel('\Delta TOTVEGC [gC m^{-2}]')
title('change in total vegetation carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTVEGC_avg_delta'],'png')

figure
plot(1:(length(totsomc_avg_mat)-1),totsomc_avg_delta,'LineWidth',2)
hold on
plot(x,y,'-r','LineWidth',2)
hold off
grid on
xlabel('cycles completed [-]')
ylabel('\Delta TOTSOMC [gC m^{-2}]')
title('change in total soil organic carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTSOMC_avg_delta'],'png')

figure
plot(1:(length(totcolc_avg_mat)-1),totcolc_avg_delta,'LineWidth',2)
hold on
plot(x,y,'-r','LineWidth',2)
hold off
grid on
xlabel('cycles completed [-]')
ylabel('\Delta TOTCOLC [gC m^{-2}]')
title('change in total column carbon on Jan-01 1980 [gC m^{-2}]')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTCOLC_avg_delta'],'png')
