clc
clear all
close all

base_path = '/discover/nobackup/jkolassa/CN51_global/';
base_exp_name = 'GEOSldas_CN51_280_global';
nr_of_cycles = 3;

cn45_read_path = '/discover/nobackup/projects/geoscm/fzeng/GEOSldas45_M36_rst_ldas06_15/output/SMAP_EASEv2_M36/cat/ens0000/';
cn45_280_read_path = '/discover/nobackup/jkolassa/test_new/GEOSldas_CN45_global_280/output/SMAP_EASEv2_M36/cat/ens0000/';
clm5_of_path = '/discover/nobackup/jkolassa/CLM5_sim/';
cn51_extkn_path = '/discover/nobackup/jkolassa/CN51_exktn_test/GEOSldas_CN51_280_global/output/SMAP_EASEv2_M36/cat/ens0000/';

start_year = 1980;
stop_year = 2019;

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% compute mapping indices
cn51_read_file = ['/discover/nobackup/jkolassa/CN51_global/GEOSldas_CN51_280_global/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_280_global.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
cn45_read_file = [cn45_read_path 'Y2001/M01/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.200101.nc4'];
clm5_nee_read_file = [clm5_of_path 'clm50_release-clm5.0.20_1deg_GSWP3V1_isofix2_hist.clm2.h0.NEE.185001-201412.nc'];

lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));

cn45_lat_vec = double(ncread(cn45_read_file,'lat'));
cn45_lon_vec = double(ncread(cn45_read_file,'lon'));

% read released CLM simulation data

clm5_of_lat_vec = ncread(clm5_nee_read_file,'lat');
clm5_of_lon_vec = ncread(clm5_nee_read_file,'lon');
clm5_of_time_vec = ncread(clm5_nee_read_file,'time');
clm5_of_nee_vec = ncread(clm5_nee_read_file,'NEE');
%convert CLM lons from [0 360] to [-180 180]
clm5_of_lon_vec(clm5_of_lon_vec>180) = clm5_of_lon_vec(clm5_of_lon_vec>180)-360;

for i = 1:length(lat_vec)

    dist_vec = sqrt((cn45_lat_vec-lat_vec(i)).^2 + (cn45_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    data_index(i) = min_index(1);

    dist_vec = sqrt((clm5_of_lat_vec-lat_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lat_index(i) = min_index(1);

    dist_vec = sqrt((clm5_of_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lon_index(i) = min_index(1);

end

for i = 1:nr_of_cycles

    if (i>1)
       cyc_str = ['c' num2str(i,'%0i')];
       exp_name = [base_exp_name '_' cyc_str];
    else
       exp_name = base_exp_name;
    end

    mat_index = 0;
    y_index = 0;
    mat_index_clm5_mod = (start_year-1850)*12;

    for y = start_year:stop_year

        y_index = y_index + 1;
        y_str = num2str(y,'%04i');
        y_index_str = num2str(y_index,'%04i');

        % define month length based on leap year status
        if sum(y==leapYears)>0
            monthLength = monthLength_ly;
        else
            monthLength = monthLength_nly;
        end

        % loop over months
        for m = 1:12

            mat_index = mat_index + 1;
            mat_index_clm5_mod = mat_index_clm5_mod + 1;

            m_str = num2str(m,'%02i');

            % define file names

            cn51_read_file = [base_path exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                           '/M' m_str '/' exp_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

            if (i==1)
               cn45_read_file = [cn45_read_path 'Y' y_str '/M' m_str '/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
               cn45_280_read_file = [cn45_280_read_path 'Y' y_str '/M' m_str '/GEOSldas_CN45_global_280.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
               cn51_extkn_read_file = [cn51_extkn_path 'Y' y_str '/M' m_str '/GEOSldas_CN51_280_global.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
            end

            % initialize arrays

            if (mat_index == 1)

                cnnee_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                if (i ==1)
                   cnnee_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cnnee_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_pi_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_mod_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cnnee_cn51_extkn_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                end
            end % mat_index

            % read data

            if exist(cn51_read_file)
               cnnee_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNNEE'));
            else
               cnnee_mat{i}(:,mat_index) = NaN*ones(size(cnnee_mat{i},1),1);
            end

            if (i == 1)

                if exist(cn45_read_file)
                  tmp_mat = double(ncread(cn45_read_file,'CNNEE'));
                  cnnee_cn45_mat(:,mat_index) = tmp_mat(data_index);
                else
                  cnnee_cn45_mat(:,mat_index) = NaN*ones(size(cnnee_cn45_mat,1),1);
                end

                if exist(cn45_280_read_file)
                   cnnee_cn45_280_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CNNEE'));
                else
                   cnnee_cn45_280_mat(:,mat_index) = NaN*ones(size(cnnee_cn45_280_mat,1),1);
                end

                if exist(cn51_extkn_read_file)
                   cnnee_cn51_extkn_mat(:,mat_index) = double(ncread(cn51_extkn_read_file,'CNNEE'));
                else
                   cnnee_cn51_extkn_mat(:,mat_index) = NaN*ones(size(cnnee_cn51_extkn_mat,1),1);
                end

                for l = 1:length(lat_vec)
                    clm5_of_pi_nee_mat(l,mat_index) = clm5_of_nee_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index);
                    if (mat_index_clm5_mod<=size(clm5_of_nee_vec,3))
                       clm5_of_mod_nee_mat(l,mat_index) = clm5_of_nee_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index_clm5_mod);
                    end
                end

                datenum_vec(mat_index) = datenum(y,m,1);
                year_vec(mat_index) = y;
                month_vec(mat_index) = m;

            end % i == 1

        end % m
      end % y
end % i

% convert CLM5 carbon fluxes from gC/m2/s to kgC/m2/s
% and states from gc/m2 to kgC/m2

clm5_of_pi_nee_mat = clm5_of_pi_nee_mat*10^(-3);
clm5_of_mod_nee_mat = clm5_of_mod_nee_mat*10^(-3);

for i = 1:nr_of_cycles

    ann_index = 0;

    for y = start_year:stop_year

        ann_index = ann_index + 1;
        year_index = (year_vec==y);

        tmp = cnnee_mat{i}(:,year_index);
        mean_global_ann_cnnee{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cnnee{i}(:,ann_index) = nanmean(tmp,2);

        if (i == 1)

           tmp = cnnee_cn45_mat(:,year_index);
           mean_global_ann_cn45_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = cnnee_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_pi_nee_mat(:,year_index);
           mean_global_ann_clm5_of_pi_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_pi_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_mod_nee_mat(:,year_index);
           mean_global_ann_clm5_of_mod_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_mod_cnnee(:,ann_index) = nanmean(tmp,2);

           tmp = cnnee_cn51_extkn_mat(:,year_index);
           mean_global_ann_cn51_extkn_cnnee(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn51_extkn_cnnee(:,ann_index) = nanmean(tmp,2);

        end

     end
end

legend_str = {};

figure
for i = 1:nr_of_cycles
    if (i < 8)
        LS = '-';
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_cnnee{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_cn45_cnnee,'LineWidth',2,'LineStyle','--','Color','k');
hold on
%plot(start_year:stop_year,mean_global_ann_clm5_cngpp,'LineWidth',2,'LineStyle','--','Color','m');
%hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cnnee,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cnnee,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('NEE [kg m^{-2} s^{-1}]')
title('annual average NEE [kg m^{-2} s^{-1}]')
%legend_str{i+5} = 'CN40 (@390ppm)';
legend_str{i+1} = 'CN45 (@390ppm)';
%legend_str{i+6} = 'CLM5 Jana';
legend_str{i+2} = 'CLM5 NCAR (1850 - 1890)';
legend_str{i+3} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_ann_CN51_cycles_280'],'png')

legend_str = {};

figure
for i = 1:nr_of_cycles
    if (i < 8)
        LS = '-';
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_cnnee{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_cn51_extkn_cnnee,'LineWidth',2,'LineStyle','--','Color','r');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cnnee,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cnnee,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('NEE [kg m^{-2} s^{-1}]')
title('annual average NEE [kg m^{-2} s^{-1}]')
legend_str{i+1} = 'CN51 (@280ppm, extkn = 0.11)';
legend_str{i+2} = 'CLM5 NCAR (1850 - 1890)';
legend_str{i+3} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_ann_CN51_cycles_280_extkn'],'png')

% compute and plot mean maps

mean_nee_cn51 = nanmean(cnnee_mat{3},2);
mean_nee_clm5_of_pi = nanmean(clm5_of_pi_nee_mat,2);
mean_nee_clm5_of_mod = nanmean(clm5_of_mod_nee_mat,2);
mean_nee_cn51_extkn = nanmean(cnnee_cn51_extkn_mat,2);
mean_nee_cn51_c1 = nanmean(cnnee_mat{1},2);
mean_nee_cn45_280 = nanmean(cnnee_cn45_280_mat,2);

tmp = mean_nee_cn51*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_nee_cn51 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_nee_clm5_of_pi*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_nee_clm5_of_pi = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_nee_clm5_of_mod*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_nee_clm5_of_mod = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_nee_cn51_extkn*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_nee_cn51_extkn = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_nee_cn51_c1*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_nee_cn51_c1 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1

test_lat = unique(lat_vec);
test_lon = unique(lon_vec);

[lon_mat,lat_mat] = meshgrid(test_lon,test_lat);

mean_nee_cn51_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_nee_clm5_of_pi_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_nee_clm5_of_mod_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_nee_clm5_of_1850_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_nee_cn51_c1_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_nee_cn45_280_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));

for i = 1:length(lon_vec)

    % map tile data to plottable grid

    lat_index = test_lat == lat_vec(i);
    lon_index = test_lon == lon_vec(i);

    mean_nee_cn51_mat(lat_index,lon_index) = mean_nee_cn51(i);
    mean_nee_clm5_of_pi_mat(lat_index,lon_index) = mean_nee_clm5_of_pi(i);
    mean_nee_clm5_of_mod_mat(lat_index,lon_index) = mean_nee_clm5_of_mod(i);
    mean_nee_clm5_of_1850_mat(lat_index,lon_index) = mean_local_ann_clm5_of_pi_cnnee(i,1);
    mean_nee_cn51_c1_mat(lat_index,lon_index) = mean_nee_cn51_c1(i);
    mean_nee_cn45_280_mat(lat_index,lon_index) = mean_nee_cn45_280(i);
end

load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);

latlim = [-60 90];
lonlim = [-180 180];

cmap_mat = cmocean('speed',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(mean_nee_cn51_mat(:),0.01);
s2 = quantile(mean_nee_cn51_mat(:),0.99);
caxis_min = s1;
caxis_max = s2;

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_nee_cn51_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean NEE CN51 [kgC m^{-2} s^{-1}] cycle 3'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_CN51'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_nee_clm5_of_pi_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean NEE CLM5 NCAR [kgC m^{-2} s^{-1}] (1850 - 1890)'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_CLM5_NCAR_1850_1890'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_nee_clm5_of_mod_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean NEE CLM5 NCAR [kgC m^{-2} s^{-1}] (1980 - 2014))'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_CLM5_NCAR_1980_2014'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_nee_clm5_of_1850_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean NEE CLM5 NCAR [kgC m^{-2} s^{-1}] 1850'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_CLM5_NCAR_1850'],'png')

diff_nee_cn51_cn45_280 = mean_nee_cn51_c1_mat - mean_nee_cn45_280_mat;

cmap_mat = cmocean('balance',12);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(diff_nee_cn51_cn45_280(:),0.01);
s2 = quantile(diff_nee_cn51_cn45_280(:),0.99);
caxis_min = s1;
caxis_max = s2;
s1 = min(diff_nee_cn51_cn45_280(:));
s2 = max(diff_nee_cn51_cn45_280(:));
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,diff_nee_cn51_cn45_280)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['diff NEE (CN51 - CN45) @280ppm [kgC m^{-2} s^{-1}] cycle 1'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/NEE_diff_CN51_CN45_280'],'png')
