clc
clear all
close all

base_path = '/discover/nobackup/jkolassa/CN51_global/';
base_exp_name = 'GEOSldas_CN51_280_global';
nr_of_cycles = 3;

cn45_read_path = '/discover/nobackup/projects/geoscm/fzeng/GEOSldas45_M36_rst_ldas06_15/output/SMAP_EASEv2_M36/cat/ens0000/';
cn45_280_read_path = '/discover/nobackup/jkolassa/test_new/GEOSldas_CN45_global_280/output/SMAP_EASEv2_M36/cat/ens0000/';
fluxcom_read_path = '/discover/nobackup/elee15/data/gpp/FluxCom/';
fluxsat_read_path = '/discover/nobackup/elee15/data/gpp/FluxSat/monthly/';
maiac_read_path = '/discover/nobackup/elee15/data/gpp/maiac/';
vpm_read_path = '/discover/nobackup/elee15/data/gpp/vpm/';
clm5_of_path = '/discover/nobackup/jkolassa/CLM5_sim/';
cn51_extkn_path = '/discover/nobackup/jkolassa/CN51_exktn_test/GEOSldas_CN51_280_global/output/SMAP_EASEv2_M36/cat/ens0000/';

start_year = 1980;
stop_year = 2019;
    
leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% compute mapping indices

cn51_read_file = ['/discover/nobackup/jkolassa/CN51_global/GEOSldas_CN51_280_global/output/SMAP_EASEv2_M36/cat/ens0000/Y1980/M01/GEOSldas_CN51_280_global.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
cn45_read_file = [cn45_read_path 'Y2001/M01/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.200101.nc4'];
fluxcom_gpp_read_file = [fluxcom_read_path 'GPP.RS.FP-ALL.MLM-ALL.METEO-NONE.720_360.monthly.2001.nc'];
fluxsat_gpp_read_file = [fluxsat_read_path 'SatFlux_GPP_200301.nc'];
maiac_gpp_read_file = [maiac_read_path 'GPP_MAIAC_200301.nc'];
vpm_gpp_read_file = [vpm_read_path 'VPM_GPP_200301.nc'];
clm5_gpp_read_file = [clm5_of_path 'clm50_release-clm5.0.20_1deg_GSWP3V1_isofix2_hist.clm2.h0.GPP.185001-201412.nc'];

lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));

cn45_lat_vec = double(ncread(cn45_read_file,'lat'));
cn45_lon_vec = double(ncread(cn45_read_file,'lon'));

fc_lat_vec = ncread(fluxcom_gpp_read_file,'latitude');
fc_lon_vec = ncread(fluxcom_gpp_read_file,'longitude');

fs_lat_vec = ncread(fluxsat_gpp_read_file,'latitude');
fs_lon_vec = ncread(fluxsat_gpp_read_file,'longitude');

maiac_lat_vec = ncread(maiac_gpp_read_file,'latitude');
maiac_lon_vec = ncread(maiac_gpp_read_file,'longitude');

vpm_lat_vec = ncread(vpm_gpp_read_file,'latitude');
vpm_lon_vec = ncread(vpm_gpp_read_file,'longitude');

% read released CLM simulation data

clm5_of_lat_vec = ncread(clm5_gpp_read_file,'lat');
clm5_of_lon_vec = ncread(clm5_gpp_read_file,'lon');
clm5_of_time_vec = ncread(clm5_gpp_read_file,'time');
clm5_of_gpp_vec = ncread(clm5_gpp_read_file,'GPP');
%convert CLM lons from [0 360] to [-180 180]
clm5_of_lon_vec(clm5_of_lon_vec>180) = clm5_of_lon_vec(clm5_of_lon_vec>180)-360;

for i = 1:length(lat_vec)
    lat_dist = sqrt((fc_lat_vec-lat_vec(i)).^2);
    min_index = find(lat_dist==min(lat_dist));
    fc_lat_index(i) = min_index(1);

    lon_dist = sqrt((fc_lon_vec-lon_vec(i)).^2);
    min_index = find(lon_dist==min(lon_dist));
    fc_lon_index(i) = min_index(1);

    dist_vec = sqrt((cn45_lat_vec-lat_vec(i)).^2 + (cn45_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    data_index(i) = min_index(1);

%    dist_vec = sqrt((cn40_lat_vec-lat_vec(i)).^2 + (cn40_lon_vec-lon_vec(i)).^2);
%    min_index = find(dist_vec==min(dist_vec));
%    cn40_data_index(i) = min_index(1);

    lat_dist = sqrt((fs_lat_vec-lat_vec(i)).^2);
    min_index = find(lat_dist==min(lat_dist));
    fs_lat_index(i) = min_index(1);

    lon_dist = sqrt((fs_lon_vec-lon_vec(i)).^2);
    min_index = find(lon_dist==min(lon_dist));
    fs_lon_index(i) = min_index(1);

    lat_dist = sqrt((maiac_lat_vec-lat_vec(i)).^2);
    min_index = find(lat_dist==min(lat_dist));
    maiac_lat_index(i) = min_index(1);

    lon_dist = sqrt((maiac_lon_vec-lon_vec(i)).^2);
    min_index = find(lon_dist==min(lon_dist));
    maiac_lon_index(i) = min_index(1);

    lat_dist = sqrt((vpm_lat_vec-lat_vec(i)).^2);
    min_index = find(lat_dist==min(lat_dist));
    vpm_lat_index(i) = min_index(1);

    lon_dist = sqrt((vpm_lon_vec-lon_vec(i)).^2);
    min_index = find(lon_dist==min(lon_dist));
    vpm_lon_index(i) = min_index(1);

    dist_vec = sqrt((clm5_of_lat_vec-lat_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lat_index(i) = min_index(1);

    dist_vec = sqrt((clm5_of_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_of_lon_index(i) = min_index(1);

end

for i = 1:nr_of_cycles

    if (i>1)
       cyc_str = ['c' num2str(i,'%0i')];
       exp_name = [base_exp_name '_' cyc_str];
    else
       exp_name = base_exp_name;
    end

    mat_index = 0;
    y_index = 0;
    mat_index_clm5_mod = (start_year-1850)*12;

    for y = start_year:stop_year

        y_index = y_index + 1;
        y_str = num2str(y,'%04i');
        y_index_str = num2str(y_index,'%04i');

        % define month length based on leap year status
        if sum(y==leapYears)>0
            monthLength = monthLength_ly;
        else
            monthLength = monthLength_nly;
        end

        % loop over months
        for m = 1:12

            mat_index = mat_index + 1;
            mat_index_clm5_mod = mat_index_clm5_mod + 1;

            m_str = num2str(m,'%02i');

            % define file names

            cn51_read_file = [base_path exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/Y' y_str ...
                           '/M' m_str '/' exp_name '.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

            if (i==1)
               cn45_read_file = [cn45_read_path 'Y' y_str '/M' m_str '/GEOSldas45_M36_rst_ldas06_15.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
               cn45_280_read_file = [cn45_280_read_path 'Y' y_str '/M' m_str '/GEOSldas_CN45_global_280.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
               fluxcom_gpp_read_file = [fluxcom_read_path 'GPP.RS.FP-ALL.MLM-ALL.METEO-NONE.720_360.monthly.' y_str '.nc'];
               fluxsat_gpp_read_file = [fluxsat_read_path 'SatFlux_GPP_' y_str m_str '.nc'];
               maiac_gpp_read_file = [maiac_read_path 'GPP_MAIAC_' y_str m_str '.nc'];
               vpm_gpp_read_file = [vpm_read_path 'VPM_GPP_' y_str m_str '.nc'];
               cn51_extkn_read_file = [cn51_extkn_path 'Y' y_str '/M' m_str '/GEOSldas_CN51_280_global.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];
            end

            % initialize arrays

            if (mat_index == 1)

                cngpp_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                cntotc_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                et_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpsoil_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evptrns_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpintr_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                evpsbln_mat{i} = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                if (i ==1)

                   cngpp_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cntotc_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   et_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsoil_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evptrns_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpintr_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsbln_cn45_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   cngpp_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   cntotc_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   et_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsoil_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evptrns_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpintr_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   evpsbln_cn45_280_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   fc_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   fs_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   maiac_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   vpm_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   clm5_of_pi_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                   clm5_of_mod_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

                   cngpp_cn51_extkn_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
                end
            end % mat_index

            % read data

            if exist(cn51_read_file)
               cngpp_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNGPP'));
               cntotc_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'CNTOTC'));
               evpsoil_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPSOIL'));
               evptrns_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPTRNS'));
               evpintr_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPINTR'));
               evpsbln_mat{i}(:,mat_index) = double(ncread(cn51_read_file,'EVPSBLN'));
               et_mat{i}(:,mat_index) = evpsoil_mat{i}(:,mat_index) + evptrns_mat{i}(:,mat_index) ...
                                      + evpintr_mat{i}(:,mat_index) + evpsbln_mat{i}(:,mat_index);
            else
               cngpp_mat{i}(:,mat_index) = NaN*ones(size(cngpp_mat{i},1),1);
               cntotc_mat{i}(:,mat_index) = NaN*ones(size(cntotc_mat{i},1),1);
               evpsoil_mat{i}(:,mat_index) = NaN*ones(size(evpsoil_mat{i},1),1);
               evptrns_mat{i}(:,mat_index) = NaN*ones(size(evptrns_mat{i},1),1);
               evpintr_mat{i}(:,mat_index) = NaN*ones(size(evpintr_mat{i},1),1);
               evpsbln_mat{i}(:,mat_index) = NaN*ones(size(evpsbln_mat{i},1),1);
               et_mat{i}(:,mat_index) = NaN*ones(size(et_mat{i},1),1);
            end

            if (i == 1)

               if exist(cn45_read_file)
                  tmp_mat = double(ncread(cn45_read_file,'CNGPP'));
                  cngpp_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'CNTOTC'));
                  cntotc_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPTRNS'));
                  evptrns_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPSOIL'));
                  evpsoil_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPINTR'));
                  evpintr_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  tmp_mat = double(ncread(cn45_read_file,'EVPSBLN'));
                  evpsbln_cn45_mat(:,mat_index) = tmp_mat(data_index);
                  et_cn45_mat(:,mat_index) = evpsoil_cn45_mat(:,mat_index) + evptrns_cn45_mat(:,mat_index) ...
                                              + evpintr_cn45_mat(:,mat_index) + evpsbln_cn45_mat(:,mat_index);
                else
                  cngpp_cn45_mat(:,mat_index) = NaN*ones(size(cngpp_cn45_mat,1),1);
                  cntotc_cn45_mat(:,mat_index) = NaN*ones(size(cntotc_cn45_mat,1),1);
                  evpsoil_cn45_mat(:,mat_index) = NaN*ones(size(evpsoil_cn45_mat,1),1);
                  evptrns_cn45_mat(:,mat_index) = NaN*ones(size(evptrns_cn45_mat,1),1);
                  evpintr_cn45_mat(:,mat_index) = NaN*ones(size(evpintr_cn45_mat,1),1);
                  evpsbln_cn45_mat(:,mat_index) = NaN*ones(size(evpsbln_cn45_mat,1),1);
                  et_cn45_mat(:,mat_index) = NaN*ones(size(et_cn45_mat,1),1);
                end

                if exist(cn45_280_read_file)
                   cngpp_cn45_280_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CNGPP'));
                   cntotc_cn45_280_mat(:,mat_index) = double(ncread(cn45_280_read_file,'CNTOTC'));
                   evpsoil_cn45_280_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPSOIL'));
                   evptrns_cn45_280_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPTRNS'));
                   evpintr_cn45_280_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPINTR'));
                   evpsbln_cn45_280_mat(:,mat_index) = double(ncread(cn45_280_read_file,'EVPSBLN'));
                   et_cn45_280_mat(:,mat_index) = evpsoil_cn45_280_mat(:,mat_index) + evptrns_cn45_280_mat(:,mat_index) ...
                                          + evpintr_cn45_280_mat(:,mat_index) + evpsbln_cn45_280_mat(:,mat_index);
                else
                   cngpp_cn45_280_mat(:,mat_index) = NaN*ones(size(cngpp_cn45_280_mat,1),1);
                   cntotc_cn45_280_mat(:,mat_index) = NaN*ones(size(cntotc_cn45_280_mat,1),1);
                   evpsoil_cn45_280_mat(:,mat_index) = NaN*ones(size(evpsoil_cn45_280_mat,1),1);
                   evptrns_cn45_280_mat(:,mat_index) = NaN*ones(size(evptrns_cn45_280_mat,1),1);
                   evpintr_cn45_280_mat(:,mat_index) = NaN*ones(size(evpintr_cn45_280_mat,1),1);
                   evpsbln_cn45_280_mat(:,mat_index) = NaN*ones(size(evpsbln_cn45_280_mat,1),1);
                   et_cn45_280_mat(:,mat_index) = NaN*ones(size(et_cn45_280_mat,1),1);
                end

                if (exist(fluxsat_gpp_read_file)~=0)
                   fs_gpp_tmp_mat = ncread(fluxsat_gpp_read_file,'GPP');
                   for k = 1:length(lat_vec)
                       fs_gpp_mat(k,mat_index) = fs_gpp_tmp_mat(fs_lon_index(k),fs_lat_index(k));
                   end
                end

                if (exist(maiac_gpp_read_file)~=0)
                   maiac_gpp_tmp_mat = ncread(maiac_gpp_read_file,'GPP');
                   maiac_gpp_tmp_mat(maiac_gpp_tmp_mat==-999) = NaN;
                   for k = 1:length(lat_vec)
                       maiac_gpp_mat(k,mat_index) = maiac_gpp_tmp_mat(maiac_lon_index(k),maiac_lat_index(k));
                   end
                end

                if (exist(vpm_gpp_read_file)~=0)
                   vpm_gpp_tmp_mat = ncread(vpm_gpp_read_file,'GPP');
                   for k = 1:length(lat_vec)
                       vpm_gpp_mat(k,mat_index) = vpm_gpp_tmp_mat(vpm_lon_index(k),vpm_lat_index(k));
                   end
                end

                if exist(cn51_extkn_read_file)
                   cngpp_cn51_extkn_mat(:,mat_index) = double(ncread(cn51_extkn_read_file,'CNGPP'));
                else
                   cngpp_cn51_extkn_mat(:,mat_index) = NaN*ones(size(cngpp_cn51_extkn_mat,1),1);
                end

                datenum_vec(mat_index) = datenum(y,m,1);
                year_vec(mat_index) = y;
                month_vec(mat_index) = m;

                for l = 1:length(lat_vec)
                    clm5_of_pi_gpp_mat(l,mat_index) = clm5_of_gpp_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index);
                    if (mat_index_clm5_mod<=size(clm5_of_gpp_vec,3))
                       clm5_of_mod_gpp_mat(l,mat_index) = clm5_of_gpp_vec(clm5_of_lon_index(l),clm5_of_lat_index(l),mat_index_clm5_mod);
                    end
                end

            end % i == 1

        end % m

        if (i == 1)
           if (exist(fluxcom_gpp_read_file)~=0)
              gpp_tmp_mat = ncread(fluxcom_gpp_read_file,'GPP');
              for k = 1:length(lat_vec)
                  start_index = (y_index-1)*12 + 1;
                  stop_index = y_index*12;
                  fc_gpp_mat(k,start_index:stop_index) = gpp_tmp_mat(fc_lon_index(k),fc_lat_index(k),:);
               end
           end
        end
      end % y
end % i

% convert CLM5 carbon fluxes from gC/m2/s to kgC/m2/s
% and states from gc/m2 to kgC/m2

clm5_of_pi_gpp_mat = clm5_of_pi_gpp_mat*10^(-3);
clm5_of_mod_gpp_mat = clm5_of_mod_gpp_mat*10^(-3);

% convert observed GPP from gC m^-2 day^-1 to kgC m^-2 s^-1

fc_gpp_mat = fc_gpp_mat*10^(-3);
fc_gpp_mat = fc_gpp_mat./86400;

fs_gpp_mat = fs_gpp_mat*10^(-3);
fs_gpp_mat = fs_gpp_mat./86400;

maiac_gpp_mat = maiac_gpp_mat*10^(-3);
maiac_gpp_mat = maiac_gpp_mat./86400;

vpm_gpp_mat = vpm_gpp_mat*10^(-3);
vpm_gpp_mat = vpm_gpp_mat./86400;

for i = 1:nr_of_cycles

    ann_index = 0;

    for y = start_year:stop_year

        ann_index = ann_index + 1;
        year_index = (year_vec==y);

        tmp = cngpp_mat{i}(:,year_index);
        mean_global_ann_cngpp{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cngpp{i}(:,ann_index) = nanmean(tmp,2);

        tmp = cntotc_mat{i}(:,year_index);
        mean_global_ann_cntotc{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_cntotc{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpsoil_mat{i}(:,year_index);
        mean_global_ann_evpsoil{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evpsoil{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evptrns_mat{i}(:,year_index);
        mean_global_ann_evptrns{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evptrns{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpintr_mat{i}(:,year_index);
        mean_global_ann_evpintr{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evpintr{i}(:,ann_index) = nanmean(tmp,2);

        tmp = evpsbln_mat{i}(:,year_index);
        mean_global_ann_evpsbln{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_evpsbln{i}(:,ann_index) = nanmean(tmp,2);

        tmp = et_mat{i}(:,year_index);
        mean_global_ann_et{i}(ann_index) = nanmean(tmp(:));
        mean_local_ann_et{i}(:,ann_index) = nanmean(tmp,2);

        if (i == 1)

           tmp = fc_gpp_mat(:,year_index);
           mean_global_ann_fc_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_fc_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = fs_gpp_mat(:,year_index);
           mean_global_ann_fs_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_fs_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = maiac_gpp_mat(:,year_index);
           mean_global_ann_maiac_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_maiac_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = vpm_gpp_mat(:,year_index);
           mean_global_ann_vpm_gpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_vpm_gpp(:,ann_index) = nanmean(tmp,2);

           tmp = cngpp_cn45_mat(:,year_index);
           mean_global_ann_cn45_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = cntotc_cn45_mat(:,year_index);
           mean_global_ann_cn45_cntotc(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_cntotc(:,ann_index) = nanmean(tmp,2);

           tmp = evpsoil_cn45_mat(:,year_index);
           mean_global_ann_cn45_evpsoil(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evpsoil(:,ann_index) = nanmean(tmp,2);

           tmp = evptrns_cn45_mat(:,year_index);
           mean_global_ann_cn45_evptrns(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evptrns(:,ann_index) = nanmean(tmp,2);

           tmp = evpintr_cn45_mat(:,year_index);
           mean_global_ann_cn45_evpintr(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evpintr(:,ann_index) = nanmean(tmp,2);

           tmp = evpsbln_cn45_mat(:,year_index);
           mean_global_ann_cn45_evpsbln(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_evpsbln(:,ann_index) = nanmean(tmp,2);

           tmp = et_cn45_mat(:,year_index);
           mean_global_ann_cn45_et(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_et(:,ann_index) = nanmean(tmp,2);

           tmp = cngpp_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = cntotc_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_cntotc(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_cntotc(:,ann_index) = nanmean(tmp,2);

           tmp = evpsoil_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_evpsoil(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_evpsoil(:,ann_index) = nanmean(tmp,2);

           tmp = evptrns_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_evptrns(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_evptrns(:,ann_index) = nanmean(tmp,2);

           tmp = evpintr_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_evpintr(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_evpintr(:,ann_index) = nanmean(tmp,2);

           tmp = evpsbln_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_evpsbln(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_evpsbln(:,ann_index) = nanmean(tmp,2);

           tmp = et_cn45_280_mat(:,year_index);
           mean_global_ann_cn45_280_et(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn45_280_et(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_pi_gpp_mat(:,year_index);
           mean_global_ann_clm5_of_pi_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_pi_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = clm5_of_mod_gpp_mat(:,year_index);
           mean_global_ann_clm5_of_mod_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_clm5_of_mod_cngpp(:,ann_index) = nanmean(tmp,2);

           tmp = cngpp_cn51_extkn_mat(:,year_index);
           mean_global_ann_cn51_extkn_cngpp(ann_index) = nanmean(tmp(:));
           mean_local_ann_cn51_extkn_cngpp(:,ann_index) = nanmean(tmp,2);

        end

     end
end

legend_str = {};

figure
for i = 1:nr_of_cycles
    if (i < 8)
        LS = '-';
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_cngpp{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_fc_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_fs_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_maiac_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_vpm_gpp,'LineWidth',2,'LineStyle','-.');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_cngpp,'LineWidth',2,'LineStyle','--','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_280_cngpp,'LineWidth',2,'LineStyle','-','Color','k');
hold on
%plot(start_year:stop_year,mean_global_ann_clm5_cngpp,'LineWidth',2,'LineStyle','--','Color','m');
%hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cngpp,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cngpp,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('GPP [kg m^{-2} s^{-1}]')
title('annual average GPP [kg m^{-2} s^{-1}]')
legend_str{i+1} = 'FluxCom';
legend_str{i+2} = 'FluxSat';
legend_str{i+3} = 'MAIAC';
legend_str{i+4} = 'VPM';
%legend_str{i+5} = 'CN40 (@390ppm)';
legend_str{i+5} = 'CN45 (@390ppm)';
legend_str{i+6} = 'CN45 (@280ppm)';
%legend_str{i+6} = 'CLM5 Jana';
legend_str{i+7} = 'CLM5 NCAR (1850 - 1890)';
legend_str{i+8} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_ann_CN51_cycles_280'],'png')

legend_str = {};

figure
for i = 1:nr_of_cycles
    if (i < 8)
        LS = '-';
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_cngpp{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_cn51_extkn_cngpp,'LineWidth',2,'LineStyle','--','Color','r');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_cngpp,'LineWidth',2,'LineStyle','--','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_280_cngpp,'LineWidth',2,'LineStyle','-','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_pi_cngpp,'LineWidth',2,'LineStyle','-','Color','b');
hold on
plot(start_year:stop_year,mean_global_ann_clm5_of_mod_cngpp,'LineWidth',2,'LineStyle','-','Color','m');
hold off
grid on
xlabel('year')
ylabel('GPP [kg m^{-2} s^{-1}]')
title('annual average GPP [kg m^{-2} s^{-1}]')
legend_str{i+1} = 'CN51 (@280ppm, extkn = 0.11)';
legend_str{i+2} = 'CN45 (@390ppm)';
legend_str{i+3} = 'CN45 (@280ppm)';
legend_str{i+4} = 'CLM5 NCAR (1850 - 1890)';
legend_str{i+5} = 'CLM5 NCAR (1980 - 2014)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_ann_CN51_cycles_280_extkn'],'png')


% compute and plot mean maps

mean_gpp_cn51 = nanmean(cngpp_mat{3},2);
mean_gpp_clm5_of_pi = nanmean(clm5_of_pi_gpp_mat,2);
mean_gpp_clm5_of_mod = nanmean(clm5_of_mod_gpp_mat,2);
mean_gpp_cn51_extkn = nanmean(cngpp_cn51_extkn_mat,2);
mean_gpp_cn51_c1 = nanmean(cngpp_mat{1},2);
mean_gpp_cn45 = nanmean(cngpp_cn45_mat,2);
mean_gpp_cn45_280 = nanmean(cngpp_cn45_280_mat,2);

tmp = mean_gpp_cn51*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_gpp_cn51 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_gpp_clm5_of_pi*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_gpp_clm5_of_pi = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_gpp_clm5_of_mod*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_gpp_clm5_of_mod = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_gpp_cn51_extkn*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_gpp_cn51_extkn = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_gpp_cn51_c1*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_gpp_cn51_c1 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_gpp_cn45*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_gpp_cn45 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1
tmp = mean_gpp_cn45_280*(36000^2)*(365*24*60*60);  % convert from kgC m^-2 s^-1 to kgC y^-1
tot_ann_gpp_cn45_280 = nansum(tmp)*(10^(-12));     % compute global sum and convert to PgC y^-1

tmp = mean_local_ann_clm5_of_pi_cngpp(:,1)*(36000^2)*(365*24*60*60);
tot_ann_gpp_clm5_of_1850 = nansum(tmp)*(10^(-12));
tmp = mean_local_ann_cngpp{3}(:,1)*(36000^2)*(365*24*60*60);
tot_ann_gpp_cn51_1850 = nansum(tmp)*(10^(-12));
tmp = mean_local_ann_cn51_extkn_cngpp(:,1)*(36000^2)*(365*24*60*60);
tot_ann_gpp_cn51_extkn_1850 = nansum(tmp)*(10^(-12));
tmp = mean_local_ann_cngpp{1}(:,1)*(36000^2)*(365*24*60*60);
tot_ann_gpp_cn51_c1_1850 = nansum(tmp)*(10^(-12));


% compute annual GPP estimates over common period

n_years_cp = 13;

mean_gpp_cn51_cp = nanmean(mean_local_ann_cngpp{3}(:,1:n_years_cp),2);
mean_gpp_clm5_of_pi_cp = nanmean(mean_local_ann_clm5_of_pi_cngpp(:,1:n_years_cp),2); 
mean_gpp_clm5_of_mod_cp = nanmean(mean_local_ann_clm5_of_mod_cngpp(:,1:n_years_cp),2);
mean_gpp_cn51_extkn_cp = nanmean(mean_local_ann_cn51_extkn_cngpp(:,1:n_years_cp),2);

tmp = mean_gpp_cn51_cp*(36000^2)*(365*24*60*60);
tot_ann_gpp_cn51_cp = nansum(tmp)*(10^(-12));
tmp = mean_gpp_clm5_of_pi_cp*(36000^2)*(365*24*60*60);
tot_ann_gpp_clm5_of_pi_cp = nansum(tmp)*(10^(-12));
tmp = mean_gpp_clm5_of_mod_cp*(36000^2)*(365*24*60*60);
tot_ann_gpp_clm5_of_mod_cp = nansum(tmp)*(10^(-12));
tmp = mean_gpp_cn51_extkn_cp*(36000^2)*(365*24*60*60);
tot_ann_gpp_cn51_extkn_cp = nansum(tmp)*(10^(-12));

test_lat = unique(lat_vec);
test_lon = unique(lon_vec);

[lon_mat,lat_mat] = meshgrid(test_lon,test_lat);

mean_gpp_cn51_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_gpp_clm5_of_pi_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_gpp_clm5_of_mod_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_gpp_clm5_of_1850_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_gpp_cn51_extkn_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_gpp_cn51_c1_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));
mean_gpp_cn45_280_mat = NaN*ones(size(lon_mat,1),size(lon_mat,2));

for i = 1:length(lon_vec)

    % map tile data to plottable grid

    lat_index = test_lat == lat_vec(i);
    lon_index = test_lon == lon_vec(i);

    mean_gpp_cn51_mat(lat_index,lon_index) = mean_gpp_cn51(i);
    mean_gpp_clm5_of_pi_mat(lat_index,lon_index) = mean_gpp_clm5_of_pi(i);
    mean_gpp_clm5_of_mod_mat(lat_index,lon_index) = mean_gpp_clm5_of_mod(i);
    mean_gpp_clm5_of_1850_mat(lat_index,lon_index) = mean_local_ann_clm5_of_pi_cngpp(i,1);
    mean_gpp_cn51_extkn_mat(lat_index,lon_index) = mean_gpp_cn51_extkn(i);
    mean_gpp_cn51_c1_mat(lat_index,lon_index) = mean_gpp_cn51_c1(i);
    mean_gpp_cn45_280_mat(lat_index,lon_index) = mean_gpp_cn45_280(i);
end

load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);

latlim = [-60 90];
lonlim = [-180 180];

cmap_mat = cmocean('speed',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(mean_gpp_cn51_mat(:),0.01);
s2 = quantile(mean_gpp_cn51_mat(:),0.99);
caxis_min = s1;
caxis_max = s2;

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_gpp_cn51_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean GPP CN51 [kgC m^{-2} s^{-1}] cycle 3'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_CN51'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_gpp_cn51_c1_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean GPP CN51 [kgC m^{-2} s^{-1}] cycle 1'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_CN51_c1'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_gpp_cn51_extkn_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean GPP CN51 [kgC m^{-2} s^{-1}] cycle 3'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_CN51_extkn'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_gpp_clm5_of_pi_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean GPP CLM5 NCAR [kgC m^{-2} s^{-1}] (1850 - 1890)'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_CLM5_NCAR_1850_1890'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_gpp_clm5_of_mod_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean GPP CLM5 NCAR [kgC m^{-2} s^{-1}] (1980 - 2014))'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_CLM5_NCAR_1980_2014'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,mean_gpp_clm5_of_1850_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['mean GPP CLM5 NCAR [kgC m^{-2} s^{-1}] 1850'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_CLM5_NCAR_1850'],'png')

diff_gpp_cn51_cn45_280 = mean_gpp_cn51_c1_mat - mean_gpp_cn45_280_mat;

cmap_mat = cmocean('balance',24);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(diff_gpp_cn51_cn45_280(:),0.01);
s2 = quantile(diff_gpp_cn51_cn45_280(:),0.99);
s1 = min(diff_gpp_cn51_cn45_280(:));
s2 = max(diff_gpp_cn51_cn45_280(:));
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                       
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off;
gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                       
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                            
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,diff_gpp_cn51_cn45_280)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                             
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title(['diff GPP (CN51 - CN45) @280ppm [kgC m^{-2} s^{-1}] cycle 1'])
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/GPP_diff_CN51_CN45_280'],'png')


legend_str = {}; 
           
figure     
for i = 1:nr_of_cycles
    if (i < 8) 
        LS = '-';
    else   
        LS = '--';
    end    
    plot(start_year:stop_year,mean_global_ann_et{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end        
plot(start_year:stop_year,mean_global_ann_cn45_et,'LineWidth',2,'LineStyle','--','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_280_et,'LineWidth',2,'LineStyle','-','Color','k');
hold off
grid on
xlabel('year')
ylabel('ET [W m^{-2}]')
title('annual average ET [W m^{-2}]')
legend_str{i+1} = 'CN45 (@390ppm)';
legend_str{i+2} = 'CN45 (@280ppm)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/ET_ann_CN51_cycles_280'],'png')

legend_str = {}; 
                
figure         
for i = 1:nr_of_cycles
    if (i < 8)  
        LS = '-';
    else   
        LS = '--';
    end                                           
    plot(start_year:stop_year,mean_global_ann_evptrns{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end                   
plot(start_year:stop_year,mean_global_ann_cn45_evptrns,'LineWidth',2,'LineStyle','--','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_280_evptrns,'LineWidth',2,'LineStyle','-','Color','k');
hold off 
grid on
xlabel('year')
ylabel('EVPTRNS [W m^{-2}]')
title('annual average EVPTRNS [W m^{-2}]')
legend_str{i+1} = 'CN45 (@390ppm)';
legend_str{i+2} = 'CN45 (@280ppm)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/EVPTRNS_ann_CN51_cycles_280'],'png')

legend_str = {};
                
figure     
for i = 1:nr_of_cycles
    if (i < 8)  
        LS = '-';   
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_evpsoil{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_cn45_evpsoil,'LineWidth',2,'LineStyle','--','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_280_evpsoil,'LineWidth',2,'LineStyle','-','Color','k');
hold off
grid on
xlabel('year')
ylabel('EVPSOIL [W m^{-2}]')
title('annual average EVPSOIL [W m^{-2}]')
legend_str{i+1} = 'CN45 (@390ppm)';
legend_str{i+2} = 'CN45 (@280ppm)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/EVPSOIL_ann_CN51_cycles_280'],'png')

legend_str = {};
                
figure     
for i = 1:nr_of_cycles
    if (i < 8)  
        LS = '-';   
    else
        LS = '--';
    end
    plot(start_year:stop_year,mean_global_ann_evpintr{i},'LineWidth',2,'LineStyle',LS);
    hold on
    legend_str{i} =  ['CN51 cycle ' num2str(i) ' (@280ppm)'];
end
plot(start_year:stop_year,mean_global_ann_cn45_evpintr,'LineWidth',2,'LineStyle','--','Color','k');
hold on
plot(start_year:stop_year,mean_global_ann_cn45_280_evpintr,'LineWidth',2,'LineStyle','-','Color','k');
hold off
grid on
xlabel('year')
ylabel('EVPINTR [W m^{-2}]')
title('annual average EVPINTR [W m^{-2}]')
legend_str{i+1} = 'CN45 (@390ppm)';
legend_str{i+2} = 'CN45 (@280ppm)';
legend(legend_str,'Location','bestoutside')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/global/EVPINTR_ann_CN51_cycles_280'],'png')
