clc
clear all
close all

cn51_read_path = ['/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/cat/ens0000/'];
clm5_read_path = ['/discover/nobackup/projects/geoscm/fzeng/CLM/clm5_test/lnd/hist/'];
cn45_read_path = ['/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/GEOSldas_CN45_local_390/output/SMAP_EASEv2_M36/cat/ens0000/'];
cn40_read_path = ['/discover/nobackup/jkolassa/test_new/GEOSldas_CN40_local/output/SMAP_EASEv2_M09_GLOBAL/cat/ens0000/'];
cn51_390_read_path = ['/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/GEOSldas_CN51_local_390/output/SMAP_EASEv2_M36/cat/ens0000/'];

start_year = 1980;
stop_year = 1983; 

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

cn51_read_file = [cn51_read_path 'Y1980/M01/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.monthly.198001.nc4'];
cn51_rst_file = '/discover/nobackup/jkolassa/CN51_test_local/GEOSldas_mod/GEOSldas_CN51_local_280/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_CN51_local_280.catchcnclm51_internal_rst.19800101_0000';
tile_vec = double(ncread(cn51_rst_file,'TILE_ID'));
lat_vec = double(ncread(cn51_read_file,'lat'));
lon_vec = double(ncread(cn51_read_file,'lon'));
ity_vec = double(ncread(cn51_rst_file,'ITY'));
fveg_vec = double(ncread(cn51_rst_file,'FVG'));

cn40_read_file = [cn40_read_path 'Y1981/M01/GEOSldas_CN40_local.tavg24_1d_lnd_Nt.monthly.198101.nc4'];
cn40_rst_file = '/discover/nobackup/jkolassa/test_new/GEOSldas_CN40_local/output/SMAP_EASEv2_M09_GLOBAL/rs/ens0000/Y1981/M01/GEOSldas_CN40_local.catchcnclm40_internal_rst.19810101_0000';
cn40_tile_vec = double(ncread(cn40_rst_file,'TILE_ID'));
cn40_lat_vec = double(ncread(cn40_read_file,'lat'));
cn40_lon_vec = double(ncread(cn40_read_file,'lon'));
cn40_ity_vec = double(ncread(cn40_rst_file,'ITY'));
cn40_fveg_vec = double(ncread(cn40_rst_file,'FVG'));

clm5_read_file = [clm5_read_path 'clm5_test.clm2.h0.0001-01.nc'];
clm5_lat_vec = ncread(clm5_read_file,'lat');
clm5_lon_vec = ncread(clm5_read_file,'lon');
%convert CLM lons from [0 360] to [-180 180]

clm5_lon_vec = clm5_lon_vec-180;


for i = 1:length(lat_vec)
    dist_vec = sqrt((clm5_lat_vec-lat_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_lat_index(i) = min_index(1);

    dist_vec = sqrt((clm5_lon_vec-lon_vec(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    clm5_lon_index(i) = min_index(1);

    cn40_index(i) = find(cn40_tile_vec==tile_vec(i));
end


% read data

mat_index = 0;
mat_index_d = 0;
y_index = 0;

for y = start_year:stop_year

    y_index = y_index + 1;
    y_str = num2str(y,'%04i');
    y_index_str = num2str(y_index,'%04i');

    % define month length based on leap year status
    if sum(y==leapYears)>0
       monthLength = monthLength_ly;
    else
       monthLength = monthLength_nly;
    end

    for m = 1:12

        mat_index = mat_index + 1;
        m_str = num2str(m,'%02i');

        datenum_vec(mat_index) = datenum(y,m,1);
        % define file names

        cn51_read_file = [cn51_read_path 'Y' y_str ...
                         '/M' m_str '/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        clm5_read_file = [clm5_read_path 'clm5_test.clm2.h0.' y_index_str '-' m_str '.nc'];

        cn40_read_file = [cn40_read_path 'Y' y_str ...
                         '/M' m_str '/GEOSldas_CN40_local.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        cn51_390_read_file = [cn51_390_read_path 'Y' y_str ...
                         '/M' m_str '/GEOSldas_CN51_local_390.tavg24_1d_lnd_Nt.monthly.' y_str m_str '.nc4'];

        if (mat_index==1)

            cngpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntlai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cncloss_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnnee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnvegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntotsomc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntotlitc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cncwdc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntotc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnctrunc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnxsmr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnpsnsun_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnpsnsha_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

            clm5_gpp_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_lai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_closs_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_nee_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_elai_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_vegc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_totsomc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_totlitc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_cwdc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_totc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_ctrunc_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_xsmr_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_psnsun_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            clm5_psnsha_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

            cngpp_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntlai_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cncloss_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnnee_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnvegc_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntotc_cn40_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);

            cngpp_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntlai_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cncloss_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnnee_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnvegc_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntotsomc_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntotlitc_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cncwdc_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cntotc_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnctrunc_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnxsmr_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnpsnsun_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
            cnpsnsha_390_mat = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12);
        end % mat_index

        if exist(cn51_read_file)
           cngpp_mat(:,mat_index) = double(ncread(cn51_read_file,'CNGPP'));
           cnnee_mat(:,mat_index) = double(ncread(cn51_read_file,'CNNEE'));
           cncloss_mat(:,mat_index) = double(ncread(cn51_read_file,'CLOSS'));
           cntlai_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTLAI'));
           cnvegc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNVEGC'));
           cntotsomc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTOTSOMC'));
           cntotlitc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTOTLITC'));
           cncwdc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNCWDC'));
           cntotc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNTOTC'));
           cnctrunc_mat(:,mat_index) = double(ncread(cn51_read_file,'CNCTRUNC'));
           cnxsmr_mat(:,mat_index) = double(ncread(cn51_read_file,'CNXSMR'));
           cnpsnsun_mat(:,mat_index) = double(ncread(cn51_read_file,'CNPSNSUN'));
           cnpsnsha_mat(:,mat_index) = double(ncread(cn51_read_file,'CNPSNSHA'));
        else
           cngpp_mat(:,mat_index) = NaN*ones(size(cngpp_mat,1),1);
           cnnee_mat(:,mat_index) = NaN*ones(size(cnnee_mat,1),1);
           cncloss_mat(:,mat_index) = NaN*ones(size(cncloss_mat,1),1);
           cntlai_mat(:,mat_index) = NaN*ones(size(cntlai_mat,1),1);
           cnvegc_mat(:,mat_index) = NaN*ones(size(cnvegc_mat,1),1);
           cntotsomc_mat(:,mat_index) = NaN*ones(size(cntotsomc_mat,1),1);
           cntotlitc_mat(:,mat_index) = NaN*ones(size(cntotlitc_mat,1),1);
           cncwdc_mat(:,mat_index) = NaN*ones(size(cncwdc_mat,1),1);
           cntotc_mat(:,mat_index) = NaN*ones(size(cntotc_mat,1),1);
           cnctrunc_mat(:,mat_index) = NaN*ones(size(cnctrunc_mat,1),1);
           cnxsmr_mat(:,mat_index) = NaN*ones(size(cnxsmr_mat,1),1);
           cnpsnsun_mat(:,mat_index) = NaN*ones(size(cnpsnsun_mat,1),1);
           cnpsnsha_mat(:,mat_index) = NaN*ones(size(cnpsnsha_mat,1),1);
        end % exist

        if exist(cn51_390_read_file)
           cngpp_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNGPP'));
           cnnee_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNNEE'));
           cncloss_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CLOSS'));
           cntlai_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNTLAI'));
           cnvegc_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNVEGC'));
           cntotsomc_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNTOTSOMC'));
           cntotlitc_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNTOTLITC'));
           cncwdc_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNCWDC'));
           cntotc_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNTOTC'));
           cnctrunc_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNCTRUNC'));
           cnxsmr_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNXSMR'));
           cnpsnsun_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNPSNSUN'));
           cnpsnsha_390_mat(:,mat_index) = double(ncread(cn51_390_read_file,'CNPSNSHA'));
        else
           cngpp_390_mat(:,mat_index) = NaN*ones(size(cngpp_390_mat,1),1);
           cnnee_390_mat(:,mat_index) = NaN*ones(size(cnnee_390_mat,1),1);
           cncloss_390_mat(:,mat_index) = NaN*ones(size(cncloss_390_mat,1),1);
           cntlai_390_mat(:,mat_index) = NaN*ones(size(cntlai_390_mat,1),1);
           cnvegc_390_mat(:,mat_index) = NaN*ones(size(cnvegc_390_mat,1),1);
           cntotsomc_390_mat(:,mat_index) = NaN*ones(size(cntotsomc_390_mat,1),1);
           cntotlitc_390_mat(:,mat_index) = NaN*ones(size(cntotlitc_390_mat,1),1);
           cncwdc_390_mat(:,mat_index) = NaN*ones(size(cncwdc_390_mat,1),1);
           cntotc_390_mat(:,mat_index) = NaN*ones(size(cntotc_390_mat,1),1);
           cnctrunc_390_mat(:,mat_index) = NaN*ones(size(cnctrunc_390_mat,1),1);
           cnxsmr_390_mat(:,mat_index) = NaN*ones(size(cnxsmr_390_mat,1),1);
           cnpsnsun_390_mat(:,mat_index) = NaN*ones(size(cnpsnsun_390_mat,1),1);
           cnpsnsha_390_mat(:,mat_index) = NaN*ones(size(cnpsnsha_390_mat,1),1);
        end % exist

        if exist(cn40_read_file)
           tmp_gpp = double(ncread(cn40_read_file,'CNGPP'));
           cngpp_cn40_mat(:,mat_index) = tmp_gpp(cn40_index);
           tmp_nee = double(ncread(cn40_read_file,'CNNEE'));
           cnnee_cn40_mat(:,mat_index) = tmp_nee(cn40_index);
           tmp_closs = double(ncread(cn40_read_file,'CLOSS'));
           cncloss_cn40_mat(:,mat_index) = tmp_closs(cn40_index);
           tmp_lai = double(ncread(cn40_read_file,'CNTLAI'));
           cntlai_cn40_mat(:,mat_index) = tmp_lai(cn40_index);
           tmp_vegc = double(ncread(cn40_read_file,'CNVEGC'));
           cnvegc_cn40_mat(:,mat_index) = tmp_vegc(cn40_index);
           tmp_totc = double(ncread(cn40_read_file,'CNTOTC'));
           cntotc_cn40_mat(:,mat_index) = tmp_totc(cn40_index);
        else
           cngpp_cn40_mat(:,mat_index) = NaN*ones(size(cngpp_mat,1),1);
           cnnee_cn40_mat(:,mat_index) = NaN*ones(size(cnnee_mat,1),1);
           cncloss_cn40_mat(:,mat_index) = NaN*ones(size(cncloss_mat,1),1);
           cntlai_cn40_mat(:,mat_index) = NaN*ones(size(cntlai_mat,1),1);
           cnvegc_cn40_mat(:,mat_index) = NaN*ones(size(cnvegc_mat,1),1);
           cntotc_cn40_mat(:,mat_index) = NaN*ones(size(cntotc_mat,1),1);
        end 

        if exist(clm5_read_file)
           tmp_gpp = double(ncread(clm5_read_file,'GPP'));
           tmp_nee = double(ncread(clm5_read_file,'NEE'));
           tmp_closs = double(ncread(clm5_read_file,'COL_FIRE_CLOSS'));
           tmp_lai = double(ncread(clm5_read_file,'TLAI')); 
           tmp_elai = double(ncread(clm5_read_file,'ELAI'));
           tmp_vegc = double(ncread(clm5_read_file,'TOTVEGC'));
           tmp_totsomc = double(ncread(clm5_read_file,'TOTSOMC'));
           tmp_totlitc = double(ncread(clm5_read_file,'TOTLITC'));   
           tmp_totc = double(ncread(clm5_read_file,'TOTCOLC'));
           tmp_cwdc = double(ncread(clm5_read_file,'CWDC'));
           tmp_xsmr = double(ncread(clm5_read_file,'XSMRPOOL'));
           tmp_psnsun = double(ncread(clm5_read_file,'PSNSUN'));
           tmp_psnsha = double(ncread(clm5_read_file,'PSNSHA'));

           for i = 1:length(lat_vec)
               clm5_gpp_mat(i,mat_index) = tmp_gpp(clm5_lon_index(i),clm5_lat_index(i));
               clm5_nee_mat(i,mat_index) = tmp_nee(clm5_lon_index(i),clm5_lat_index(i));
               clm5_closs_mat(i,mat_index) = tmp_closs(clm5_lon_index(i),clm5_lat_index(i));
               clm5_elai_mat(i,mat_index) = tmp_elai(clm5_lon_index(i),clm5_lat_index(i));
               clm5_lai_mat(i,mat_index) = tmp_lai(clm5_lon_index(i),clm5_lat_index(i));
               clm5_vegc_mat(i,mat_index) = tmp_vegc(clm5_lon_index(i),clm5_lat_index(i));
               clm5_totsomc_mat(i,mat_index) = tmp_totsomc(clm5_lon_index(i),clm5_lat_index(i));          
               clm5_totlitc_mat(i,mat_index) = tmp_totlitc(clm5_lon_index(i),clm5_lat_index(i));
               clm5_totc_mat(i,mat_index) = tmp_totc(clm5_lon_index(i),clm5_lat_index(i));
               clm5_cwdc_mat(i,mat_index) = tmp_cwdc(clm5_lon_index(i),clm5_lat_index(i));
               clm5_xsmr_mat(i,mat_index) = tmp_xsmr(clm5_lon_index(i),clm5_lat_index(i));
               clm5_psnsun_mat(i,mat_index) = tmp_psnsun(clm5_lon_index(i),clm5_lat_index(i));
               clm5_psnsha_mat(i,mat_index) = tmp_psnsha(clm5_lon_index(i),clm5_lat_index(i));

           end
        else
           clm5_gpp_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_nee_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_closs_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_lai_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_elai_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_vegc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_totsomc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_totlitc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_totc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_cwdc_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_xsmr_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_psnsun_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
           clm5_psnsha_mat(:,mat_index) = NaN*ones(length(lat_vec),1);
        end % exist

        % read daily data

        for d = 1:monthLength(m)

            mat_index_d = mat_index_d + 1;
            d_str = num2str(d,'%02i');

            datenum_vec_d(mat_index_d) = datenum(y,m,d);
            % define file names

            cn51_read_file_d = [cn51_read_path 'Y' y_str ...
                             '/M' m_str '/GEOSldas_CN51_local_280.tavg24_1d_lnd_Nt.' y_str m_str d_str '_1200z.nc4'];
            cn45_read_file_d = [cn45_read_path 'Y' y_str ...
                             '/M' m_str '/GEOSldas_CN45_local_390.tavg24_1d_lnd_Nt.' y_str m_str d_str '_1200z.nc4'];

            cn51_390_read_file_d = [cn51_390_read_path 'Y' y_str ...
                             '/M' m_str '/GEOSldas_CN51_local_390.tavg24_1d_lnd_Nt.' y_str m_str d_str '_1200z.nc4'];

            if (mat_index_d==1)

               cngpp_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntlai_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cncloss_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnnee_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnvegc_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotsomc_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotlitc_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cncwdc_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotc_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnctrunc_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnxsmr_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnpsnsun_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnpsnsha_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);

               cngpp_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntlai_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cncloss_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnnee_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnvegc_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotsomc_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotlitc_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cncwdc_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotc_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnctrunc_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnxsmr_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnpsnsun_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnpsnsha_cn45_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);

               cngpp_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntlai_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cncloss_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnnee_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnvegc_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotsomc_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotlitc_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cncwdc_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cntotc_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnctrunc_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnxsmr_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnpsnsun_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
               cnpsnsha_390_mat_d = NaN*ones(length(lat_vec),(stop_year-start_year+1)*12*31);
             end

             if exist(cn51_read_file_d)
                cngpp_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNGPP'));
                cnnee_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNNEE'));
                cncloss_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CLOSS'));
                cntlai_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNTLAI'));
                cnvegc_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNVEGC'));
                cntotsomc_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNTOTSOMC'));
                cntotlitc_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNTOTLITC'));
                cncwdc_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNCWDC'));
                cntotc_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNTOTC'));
                cnctrunc_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNCTRUNC'));
                cnxsmr_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNXSMR'));
                cnpsnsun_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNPSNSUN'));
                cnpsnsha_mat_d(:,mat_index_d) = double(ncread(cn51_read_file_d,'CNPSNSHA'));

             else
                cngpp_mat_d(:,mat_index_d) = NaN*ones(size(cngpp_mat_d,1),1);
                cnnee_mat_d(:,mat_index_d) = NaN*ones(size(cnnee_mat_d,1),1);
                cncloss_mat_d(:,mat_index_d) = NaN*ones(size(cncloss_mat_d,1),1);
                cntlai_mat_d(:,mat_index_d) = NaN*ones(size(cntlai_mat_d,1),1);
                cnvegc_mat_d(:,mat_index_d) = NaN*ones(size(cnvegc_mat_d,1),1);
                cntotsomc_mat_d(:,mat_index_d) = NaN*ones(size(cntotsomc_mat_d,1),1);
                cntotlitc_mat_d(:,mat_index_d) = NaN*ones(size(cntotlitc_mat_d,1),1);
                cncwdc_mat_d(:,mat_index_d) = NaN*ones(size(cncwdc_mat_d,1),1);
                cntotc_mat_d(:,mat_index_d) = NaN*ones(size(cntotc_mat_d,1),1);
                cnctrunc_mat_d(:,mat_index_d) = NaN*ones(size(cnctrunc_mat_d,1),1);
                cnxsmr_mat_d(:,mat_index_d) = NaN*ones(size(cnxsmr_mat_d,1),1);
                cnpsnsun_mat_d(:,mat_index_d) = NaN*ones(size(cnpsnsun_mat_d,1),1);
                cnpsnsha_mat_d(:,mat_index_d) = NaN*ones(size(cnpsnsha_mat_d,1),1);
             end

             if exist(cn51_390_read_file_d)
                cngpp_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNGPP'));
                cnnee_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNNEE'));
                cncloss_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CLOSS'));
                cntlai_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNTLAI'));
                cnvegc_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNVEGC'));
                cntotsomc_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNTOTSOMC'));
                cntotlitc_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNTOTLITC'));
                cncwdc_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNCWDC'));
                cntotc_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNTOTC'));
                cnctrunc_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNCTRUNC'));
                cnxsmr_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNXSMR'));
                cnpsnsun_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNPSNSUN'));
                cnpsnsha_390_mat_d(:,mat_index_d) = double(ncread(cn51_390_read_file_d,'CNPSNSHA'));

             else
                cngpp_390_mat_d(:,mat_index_d) = NaN*ones(size(cngpp_390_mat_d,1),1);
                cnnee_390_mat_d(:,mat_index_d) = NaN*ones(size(cnnee_390_mat_d,1),1);
                cncloss_390_mat_d(:,mat_index_d) = NaN*ones(size(cncloss_390_mat_d,1),1);
                cntlai_390_mat_d(:,mat_index_d) = NaN*ones(size(cntlai_390_mat_d,1),1);
                cnvegc_390_mat_d(:,mat_index_d) = NaN*ones(size(cnvegc_390_mat_d,1),1);
                cntotsomc_390_mat_d(:,mat_index_d) = NaN*ones(size(cntotsomc_390_mat_d,1),1);
                cntotlitc_390_mat_d(:,mat_index_d) = NaN*ones(size(cntotlitc_390_mat_d,1),1);
                cncwdc_390_mat_d(:,mat_index_d) = NaN*ones(size(cncwdc_390_mat_d,1),1);
                cntotc_390_mat_d(:,mat_index_d) = NaN*ones(size(cntotc_390_mat_d,1),1);
                cnctrunc_390_mat_d(:,mat_index_d) = NaN*ones(size(cnctrunc_390_mat_d,1),1);
                cnxsmr_390_mat_d(:,mat_index_d) = NaN*ones(size(cnxsmr_390_mat_d,1),1);
                cnpsnsun_390_mat_d(:,mat_index_d) = NaN*ones(size(cnpsnsun_390_mat_d,1),1);
                cnpsnsha_390_mat_d(:,mat_index_d) = NaN*ones(size(cnpsnsha_390_mat_d,1),1);
             end

             if exist(cn45_read_file_d)
                cngpp_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNGPP'));
                cnnee_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNNEE'));
                cncloss_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CLOSS'));
                cntlai_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNTLAI'));
                cnvegc_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNVEGC'));
                cntotsomc_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNTOTSOMC'));
                cntotlitc_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNTOTLITC'));
                cncwdc_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNCWDC'));
                cntotc_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNTOTC'));
                cnctrunc_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNCTRUNC'));
                cnxsmr_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNXSMR'));
                cnpsnsun_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNPSNSUN'));
                cnpsnsha_cn45_mat_d(:,mat_index_d) = double(ncread(cn45_read_file_d,'CNPSNSHA'));
             else
                cngpp_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cngpp_cn45_mat_d,1),1);
                cnnee_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cnnee_cn45_mat_d,1),1);
                cncloss_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cncloss_cn45_mat_d,1),1);
                cntlai_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cntlai_cn45_mat_d,1),1);
                cnvegc_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cnvegc_cn45_mat_d,1),1);
                cntotsomc_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cntotsomc_cn45_mat_d,1),1);
                cntotlitc_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cntotlitc_cn45_mat_d,1),1);
                cncwdc_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cncwdc_cn45_mat_d,1),1);
                cntotc_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cntotc_cn45_mat_d,1),1);
                cnctrunc_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cnctrunc_cn45_mat_d,1),1);
                cnxsmr_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cnxsmr_cn45_mat_d,1),1);
                cnpsnsun_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cnpsnsun_cn45_mat_d,1),1);
                cnpsnsha_cn45_mat_d(:,mat_index_d) = NaN*ones(size(cnpsnsha_cn45_mat_d,1),1);
             end % exist

        end % d
        
    end % m

end % y 

% remove extra entries in daily matrices

cngpp_mat_d(:,mat_index_d+1:end) = [];
cnnee_mat_d(:,mat_index_d+1:end) = [];
cncloss_mat_d(:,mat_index_d+1:end) = [];
cntlai_mat_d(:,mat_index_d+1:end) = [];
cnvegc_mat_d(:,mat_index_d+1:end) = [];
cntotsomc_mat_d(:,mat_index_d+1:end) = [];
cntotlitc_mat_d(:,mat_index_d+1:end) = [];
cncwdc_mat_d(:,mat_index_d+1:end) = [];
cntotc_mat_d(:,mat_index_d+1:end) = [];
cnctrunc_mat_d(:,mat_index_d+1:end) = [];
cnxsmr_mat_d(:,mat_index_d+1:end) = [];
cnpsnsun_mat_d(:,mat_index_d+1:end) = [];
cnpsnsha_mat_d(:,mat_index_d+1:end) = [];

cngpp_cn45_mat_d(:,mat_index_d+1:end) = []; 
cnnee_cn45_mat_d(:,mat_index_d+1:end) = []; 
cncloss_cn45_mat_d(:,mat_index_d+1:end) = []; 
cntlai_cn45_mat_d(:,mat_index_d+1:end) = []; 
cnvegc_cn45_mat_d(:,mat_index_d+1:end) = []; 
cntotsomc_cn45_mat_d(:,mat_index_d+1:end) = []; 
cntotlitc_cn45_mat_d(:,mat_index_d+1:end) = []; 
cncwdc_cn45_mat_d(:,mat_index_d+1:end) = []; 
cntotc_cn45_mat_d(:,mat_index_d+1:end) = []; 
cnctrunc_cn45_mat_d(:,mat_index_d+1:end) = []; 
cnxsmr_cn45_mat_d(:,mat_index_d+1:end) = []; 
cnpsnsun_cn45_mat_d(:,mat_index_d+1:end) = [];
cnpsnsha_cn45_mat_d(:,mat_index_d+1:end) = [];

cngpp_390_mat_d(:,mat_index_d+1:end) = [];
cnnee_390_mat_d(:,mat_index_d+1:end) = [];
cncloss_390_mat_d(:,mat_index_d+1:end) = [];
cntlai_390_mat_d(:,mat_index_d+1:end) = [];
cnvegc_390_mat_d(:,mat_index_d+1:end) = [];
cntotsomc_390_mat_d(:,mat_index_d+1:end) = [];
cntotlitc_390_mat_d(:,mat_index_d+1:end) = [];
cncwdc_390_mat_d(:,mat_index_d+1:end) = [];
cntotc_390_mat_d(:,mat_index_d+1:end) = [];
cnctrunc_390_mat_d(:,mat_index_d+1:end) = [];
cnxsmr_390_mat_d(:,mat_index_d+1:end) = [];
cnpsnsun_390_mat_d(:,mat_index_d+1:end) = [];
cnpsnsha_390_mat_d(:,mat_index_d+1:end) = [];

% convert CLM5 carbon fluxes from gC/m2/s to kgC/m2/s
% and states from gc/m2 to kgC/m2

clm5_gpp_mat = clm5_gpp_mat*10^(-3);
clm5_nee_mat = clm5_nee_mat*10^(-3);
clm5_closs_mat = clm5_closs_mat*10^(-3);
clm5_vegc_mat = clm5_vegc_mat*10^(-3);
clm5_totsomc_mat = clm5_totsomc_mat*10^(-3);
clm5_totlitc_mat = clm5_totlitc_mat*10^(-3);
clm5_totc_mat = clm5_totc_mat*10^(-3);
clm5_cwdc_mat = clm5_cwdc_mat*10^(-3);
clm5_xsmr_mat = clm5_xsmr_mat*10^(-3);

%clm5_gpp_mat_d = clm5_gpp_mat_d*10^(-3);
%clm5_nee_mat_d = clm5_nee_mat_d*10^(-3);
%clm5_closs_mat_d = clm5_closs_mat_d*10^(-3);
%clm5_vegc_mat_d = clm5_vegc_mat_d*10^(-3);
%clm5_totsomc_mat_d = clm5_totsomc_mat_d*10^(-3);
%clm5_totlitc_mat_d = clm5_totlitc_mat_d*10^(-3);
%clm5_totc_mat_d = clm5_totc_mat_d*10^(-3);
%clm5_cwdc_mat_d = clm5_cwdc_mat_d*10^(-3);
%clm5_xsmr_mat_d = clm5_xsmr_mat_d*10^(-3);

% plot data

for i = 1:length(lat_vec)

    legend_str = {};

    figure
    plot(datenum_vec,cnnee_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_nee_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('NEE [kgC m^{-2} s^{-1}]')
    title(['monthly average NEE [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/NEE_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cngpp_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_gpp_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('GPP [kgC m^{-2} s^{-1}]')
    title(['monthly average GPP [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cncloss_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_closs_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('CLOSS [kgC m^{-2} s^{-1}]')
    title(['monthly average CLOSS [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CLOSS_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cntlai_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_lai_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('LAI [-]')
    title(['monthly average LAI [-] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cnvegc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_vegc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('VEGC [kgC m^{-2} s^{-1}]')
    title(['monthly average VEGC [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGC_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cntotc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_totc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('TOTC [kgC m^{-2} s^{-1}]')
    title(['monthly average TOTC [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTC_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cntotsomc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_totsomc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('TOTSOMC [kgC m^{-2} s^{-1}]')
    title(['monthly average TOTSOMC [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTSOMC_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cntotlitc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_totlitc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('TOTLITC [kgC m^{-2} s^{-1}]')
    title(['monthly average TOTLITC [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTLITC_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cncwdc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_cwdc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('CWDC [kgC m^{-2} s^{-1}]')
    title(['monthly average CWDC [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CWDC_mon_CN51_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec,cnxsmr_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_xsmr_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','mm-yyyy')
    grid on
    xlabel('date [MM-YYYY]')
    ylabel('XSMR [kgC m^{-2} s^{-1}]')
    title(['monthly average XSMR [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/XSMR_mon_CN51_CLM5_loc' num2str(i)],'png')

    % daily plots

    legend_str = {};

    figure
    plot(datenum_vec_d,cngpp_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cngpp_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_gpp_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,cngpp_cn40_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('GPP [kgC m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average GPP [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend_str{4} = 'CN40';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnnee_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnnee_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_nee_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,cnnee_cn40_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('NEE [kgC m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average NEE [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend_str{4} = 'CN40';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/NEE_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cncloss_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cncloss_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_closs_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,cncloss_cn40_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('CLOSS [kgC m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average CLOSS [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend_str{4} = 'CN40';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CLOSS_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cntotc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntotc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_totc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,cntotc_cn40_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('TOTC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average TOTC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend_str{4} = 'CN40';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTC_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnvegc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnvegc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_vegc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,cnvegc_cn40_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('VEGC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average VEGC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend_str{4} = 'CN40';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGC_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cncwdc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cncwdc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_cwdc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('CWDC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average CWDC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CWDC_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cntotsomc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntotsomc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_totsomc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('TOTSOMC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average TOTSOMC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTSOMC_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cntotlitc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntotlitc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_totlitc_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('TOTLITC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average TOTLITC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTLITC_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnxsmr_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnxsmr_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_xsmr_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('XSMR [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average XSMR [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/XSMR_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cntlai_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntlai_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_lai_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,cntlai_cn40_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('LAI [-]')
    title(['daily (CN) and monthly (CLM) average LAI [-] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend_str{4} = 'CN40';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnpsnsun_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnpsnsun_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_psnsun_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('PSNSUN [umolCO2 m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average PSNSUN [umolCO2 m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/PSNSUN_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnpsnsha_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnpsnsha_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec,clm5_psnsha_mat(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('PSNSHA [umolCO2 m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average PSNSHA [umolCO2 m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CLM5';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/PSNSHA_day_CN51_CN45_CLM5_loc' num2str(i)],'png')

    % daily plots without CLM

    legend_str = {};

    figure
    plot(datenum_vec_d,cntlai_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntlai_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntlai_390_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('LAI [-]')
    title(['daily (CN) and monthly (CLM) average LAI [-] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51 @280ppm';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CN51 @390ppm'
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/LAI_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cngpp_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cngpp_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cngpp_390_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('GPP [kgC m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average GPP [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51 @280ppm';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CN51 @390ppm'
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/GPP_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnnee_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnnee_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('NEE [kgC m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average NEE [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/NEE_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cncloss_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cncloss_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('CLOSS [kgC m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average CLOSS [kgC m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CLOSS_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cntotc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntotc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntotc_390_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('TOTC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average TOTC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51 @280ppm';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CN51 @390ppm';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTC_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnctrunc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnctrunc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('CTRUNC [kgC m^{-2}]')
    title(['daily (CN)  average CTRUNC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CTRUNC_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnvegc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnvegc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnvegc_390_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('VEGC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average VEGC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51 @280ppm';
    legend_str{2} = 'CN45';
    legend_str{3} = 'CN51 @390ppm';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/VEGC_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cncwdc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cncwdc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('CWDC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average CWDC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/CWDC_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cntotsomc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntotsomc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('TOTSOMC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average TOTSOMC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTSOMC_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cntotlitc_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cntotlitc_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('TOTLITC [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average TOTLITC [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/TOTLITC_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnxsmr_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnxsmr_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('XSMR [kgC m^{-2}]')
    title(['daily (CN) and monthly (CLM) average XSMR [kgC m^{-2}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/XSMR_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnpsnsun_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnpsnsun_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('PSNSUN [umolCO2 m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average PSNSUN [umolCO2 m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/PSNSUN_day_CN51_CN45_loc' num2str(i)],'png')

    legend_str = {};

    figure
    plot(datenum_vec_d,cnpsnsha_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold on
    plot(datenum_vec_d,cnpsnsha_cn45_mat_d(i,:),'LineWidth',2,'LineStyle','-');
    hold off
    datetick('x','dd-mm-yyyy')
    grid on
    xlabel('date [DD-MM-YYYY]')
    ylabel('PSNSHA [umolCO2 m^{-2} s^{-1}]')
    title(['daily (CN) and monthly (CLM) average PSNSHA [umolCO2 m^{-2} s^{-1}] @ ' num2str(lat_vec(i)) 'N ' num2str(lon_vec(i)) 'E'])
    legend_str{1} = 'CN51';
    legend_str{2} = 'CN45';
    legend(legend_str,'Location','bestoutside')
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 25 15])
    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/PSNSHA_day_CN51_CN45_loc' num2str(i)],'png')

end 
