clc
clear all
close all

gridcell_carbon_balance_file = '/discover/nobackup/jkolassa/CN51_config_debug/carbon_error_files/carbon_error_grc_year1';

fid = fopen(gridcell_carbon_balance_file,'r');
data = fscanf(fid,'%i %f');
fclose(fid);

carbon_balance_data = reshape(data,[2,length(data)/2]);
carbon_balance_data = carbon_balance_data';

for i = 1:max(carbon_balance_data(:,1))

    loc_index = carbon_balance_data(:,1)==i;
    carbon_balance_mat(i,:) = carbon_balance_data(loc_index,2);

    mean_balance(i) = nanmean(carbon_balance_mat(i,:));

%    x_vec = 1:size(carbon_balance_mat,2);
%    mean_balance_vec = mean_balance(i)*ones(size(x_vec));  

%    figure 
%    plot(carbon_balance_mat(i,:),'-b')
%    hold on
%    plot(x_vec,mean_balance_vec)
%    hold off
%    grid on
%    title(['carbon imbalance location ' num2str(i)])
%    set(gcf,'paperunits','centimeters')
%    set(gcf,'paperposition',[1 1 25 15])
%    saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/cb_loc_' num2str(i)],'png')
     

end

figure
plot(1:118,mean_balance,'ob','MarkerFaceColor','b')
hold on 
plot(1:118,0.1*ones(size(mean_balance)),'-r')
hold on 
plot(1:118,10^(-6)*ones(size(mean_balance)),'-k')
xlabel('location nr')
ylabel('average carbon imbalance [gC/m^2]')
title('average carbon imbalance during first year')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/cb_avg_all_wLimits'],'png')

figure
plot(1:118,mean_balance,'ob','MarkerFaceColor','b')
%hold on
%plot(1:118,0.1*ones(size(mean_balance)),'-r')
%hold on
%plot(1:118,10^(-6)*ones(size(mean_balance)),'-k')
ylim([-0.01 0.05])
xlabel('location nr')
ylabel('average carbon imbalance [gC/m^2]')
title('average carbon imbalance during first year')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/CN51_plots/local/cb_avg_all_noLimits'],'png')

% compute total carbon change

gc_mat = carbon_balance_mat*(36000*36000);
gcy_mat = nansum(gc_mat,2);
avg_gcy = nanmean(gcy_mat);
global_gcy = avg_gcy*112573;
global_Pgcy = global_gcy*10^(-15);
global_Pgcy_scaled = global_Pgcy*(0.0034/0.0040);
