clc
clear all 
close all

read_path = '/discover/nobackup/projects/geoscm/fzeng/CLM/archive/clm5_test/lnd/hist/';

for m = 1:12

    m_str = num2str(m,'%02i');

    read_file = [read_path 'clm5_test.clm2.h0.0001-' m_str '.nc'];

    gpp_data(:,:,m) = ncread(read_file,'GPP');
    laisha_data = ncread(read_file,'LAISHA');
    laisun_data = ncread(read_file,'LAISUN');
    lai_data(:,:,m) = laisha_data + laisun_data;

    if m == 1
       lat_data = ncread(read_file,'lat');
       lon_data = ncread(read_file,'lon');
       lon_data(lon_data>180) = lon_data(lon_data>180) - 360;
    end 
end

% convert GPP from gC/m^2/s to kgC/m^2/s

gpp_data = gpp_data*10^(-3);

load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);

latlim = [-60 90];
lonlim = [-180 180];

cmap_mat = cmocean('algae',12);
cmap = cmap_mat;
s1 = quantile(lai_data(:),0.01);
s2 = quantile(lai_data(:),0.99);
caxis_min = s1;
caxis_max = s2;
caxis_min = 0;
caxis_max = 11;


cmap_mat = cmocean('algae',12);
cmap_gpp = cmap_mat;
s1 = quantile(gpp_data(:),0.01);
s2 = quantile(gpp_data(:),0.99);
caxis_min_gpp = s1; 
caxis_max_gpp = s2; 
caxis_min_gpp = 0;
caxis_max_gpp = 3.5*10^(-7);

for m = 1:12

    m_str = num2str(m,'%02i');

    figure
    ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                             
               'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
     framem off;
     gridm on;
     setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                        
          'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                     
          'MLabelParallel','south','FontSize',12)
     geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
     pcolorm(lat_data,lon_data,lai_data(:,:,m)')
     caxis([caxis_min caxis_max]);
     set(gcf,'Colormap',cmap);
     plotm(coastlat, coastlon,'k')
     hold on                                                                             
     set(gca,'XLim',lonlim);
     set(gca,'YLim',latlim);
     tightmap
     title(['total LAI [-] month ' m_str])
     h = colorbar;
     set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
     set(gcf,'paperunits','centimeters')
     set(gcf,'paperposition',[1 1 17 15])
     saveas(gcf,['/discover/nobackup/jkolassa/CLM5_plots/LAI_' m_str],'png')


    figure
    ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                             
               'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
     framem off;
     gridm on;
     setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                        
          'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                     
          'MLabelParallel','south','FontSize',12)
     geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
     pcolorm(lat_data,lon_data,gpp_data(:,:,m)')
     caxis([caxis_min_gpp caxis_max_gpp]);
     set(gcf,'Colormap',cmap_gpp);
     plotm(coastlat, coastlon,'k')
     hold on
     set(gca,'XLim',lonlim);
     set(gca,'YLim',latlim);
     tightmap
     title(['GPP [kgC/m^2/s] month ' m_str])
     h = colorbar;
     set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
     set(gcf,'paperunits','centimeters')
     set(gcf,'paperposition',[1 1 17 15])
     saveas(gcf,['/discover/nobackup/jkolassa/CLM5_plots/GPP_' m_str],'png')
end 

nc_lat = 35.68;
nc_lon = -76.74;

lat_dist = sqrt((lat_data-nc_lat).^2);
lat_index = find(lat_dist==min(lat_dist)); 
lon_dist = sqrt((lon_data-nc_lon).^2);
lon_index = find(lon_dist==min(lon_dist));
