clc
clear all 
close all

rst_1 = '/discover/nobackup/jkolassa/GEOSgcm_CLM45/GEOSldas_clm45_fire_M36/output/SMAP_EASEv2_M36/rs/ens0000/Y1980/M01/GEOSldas_clm45_fire_M36.catchcn_internal_rst.19800101_0000';
rst_2 = '/discover/nobackup/jkolassa/clm4.5_restart/clm4.5_DE720_test1/output/global/rs/ens0000/Y1980/M01/clm4.5_DE720_test1.ens0000.catchcn_ldas_rst.19800101_0000z';

coord_file_1 = 'GEOSldas_clm45_fire_M36.ldas_tilecoord.bin';
m36_coord = read_tilecoord_le(coord_file_1);
coord_file_2 = 'clm4.5_DE720_test1.ldas_tilecoord.bin';
ll_coord = read_tilecoord(coord_file_2);

finfo = ncinfo(rst_1);


mat_index = 0;
red_index = 0;

for j = 1:length(finfo.Variables)
    var_name = finfo.Variables(j).Name;

    m36_data = ncread(rst_1,var_name);
    ll_data = ncread(rst_2,var_name);

for i = 1:size(ll_data,2)

    mat_index = mat_index + 1;   

    data_name{mat_index} = [var_name '_' num2str(i)];

    ll_max = max(ll_data(:,i));
    ll_min = min(ll_data(:,i));
    ll_median = nanmedian(ll_data(:,i));
    ll_mean = nanmean(ll_data(:,i));

    m36_max = max(m36_data(:,i));
    m36_min = min(m36_data(:,i));
    m36_median = nanmedian(m36_data(:,i));
    m36_mean = nanmean(m36_data(:,i));

    comp_mat(mat_index,:) = [mat_index j i ll_min m36_min ll_max m36_max ll_median m36_median ll_mean m36_mean];
    diff_mat(mat_index,:) = [mat_index j i ll_min-m36_min ll_max-m36_max ll_median-m36_median ll_mean-m36_mean];
    
    if abs(ll_mean-m36_mean)>=(0.1*ll_mean)
       red_index = red_index + 1;
       red_mat(red_index,:) = [mat_index i j ll_median-m36_median ll_mean-m36_mean]; 
    end
    if (j==35) & (sum(i == [157 158 159 331 332 333 325 326 327 505 506 511 512 277 278])>0)
       caxis_min = min(m36_min,ll_min);
       caxis_max = max(m36_max,ll_max);

       figure
       map_plot(m36_coord.com_lat,m36_coord.com_lon,m36_data(:,i),[num2str(i) '; mean: ' num2str(m36_mean)],'[-]',[caxis_min caxis_max])
       saveas(gcf,['rst_test_' num2str(i) '_m36'], 'png')

       figure
       map_plot(ll_coord.com_lat,ll_coord.com_lon,ll_data(:,i),[num2str(i) '; mean: ' num2str(ll_mean)],'[-]',[caxis_min caxis_max])                                                      
       saveas(gcf,['rst_test_' num2str(i) '_ll'], 'png')
     end
end
end
