clc
clear all
close all

exp_name = 'GEOSldas_CNCLM40_NT_rst_new_scale';

gl_path = ['/discover/nobackup/jkolassa/GEOSgcm_GC_287_fixes_new_tag/' exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/'];
ld_path = '/gpfsm/dnb05/projects/p144/fzeng/NOBACKUP/Catchment/SMAP_EASEv2_M09/e0004s_transientCO2_05/output/SMAP_EASEv2_M09_GLOBAL/cat/ens_avg/';

start_year = 1981;
stop_year = 1981;
start_month = 1;
total_months = (stop_year-start_year+1)*12;

% define read parameters for LDASsa run

collectionID = 1;
nrOutVar = 44;

[data_tag, data_units] = get_data_tag(collectionID, nrOutVar, nrOutVar);

% read LDASsa coordinate data

coord_path = '/gpfsm/dnb05/projects/p144/fzeng/NOBACKUP/Catchment/SMAP_EASEv2_M09/e0004s_transientCO2_05/output/SMAP_EASEv2_M09_GLOBAL/rc_out/';

tileCoordFile = [coord_path 'e0004s_transientCO2.ldas_tilecoord.bin'];
[tile_coord ] = read_tilecoord( tileCoordFile, 0 );

ld_points = length(tile_coord.com_lat);
ld_lats = tile_coord.com_lat(1:ld_points);
ld_lons = tile_coord.com_lon(1:ld_points);
ld_tilenum = tile_coord.tile_id(1:ld_points);
ld_area = tile_coord.area(1:ld_points);

% define constants

rho_snow = 330;   % [kg m^-3]
rho_water = 1000; % [kg m^-3]

% read static data (geolocation, fill value, etc.) for GEOSldas run

test_file = [gl_path 'Y' num2str(start_year) '/M0' num2str(start_month) '/' exp_name '.tavg24_1d_lnd_Nt.' num2str(start_year) '0' num2str(start_month) '01_1200z.nc4'];
lat_data = ncread(test_file,'lat');
lon_data = ncread(test_file,'lon');
lat_data = double(lat_data);
lon_data = double(lon_data);
unit_data = ncreadatt(test_file,'CNGPP','units');
%fill_value = ncreadatt(test_file,'CNGPP','_FillValue');

% read soil parameter data for soil moisture conversion

ld_param_file = ['/gpfsm/dnb05/projects/p144/fzeng/NOBACKUP/Catchment/SMAP_EASEv2_M09/e0004s_transientCO2_05/output/SMAP_EASEv2_M09_GLOBAL/rc_out/Y' num2str(start_year) '/M0' num2str(start_month) '/e0004s_transientCO2.ldas_catparam.' num2str(start_year) '0' num2str(start_month) '01_0000z.bin'];
[ ld_param, ld_param_units ] = read_catparam_old( ld_param_file, ld_points );
ld_poros = ld_param.poros;
ld_poros30 = ld_param.poros30;

% define leap year data

leapYears = 1980:4:2017;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% initialize arrays

mat_index = 0;
gl_monthly_sfmc = NaN*ones(length(lon_data),total_months);
ld_monthly_sfmc_m09 = NaN*ones(ld_points,total_months);
gl_monthly_rzmc = NaN*ones(length(lon_data),total_months);
ld_monthly_rzmc_m09 = NaN*ones(ld_points,total_months);
gl_monthly_eveg = NaN*ones(length(lon_data),total_months);
ld_monthly_eveg_m09 = NaN*ones(ld_points,total_months);
gl_monthly_esoil = NaN*ones(length(lon_data),total_months);
ld_monthly_esoil_m09 = NaN*ones(ld_points,total_months);
gl_monthly_eint = NaN*ones(length(lon_data),total_months);
ld_monthly_eint_m09 = NaN*ones(ld_points,total_months);
gl_monthly_esno = NaN*ones(length(lon_data),total_months);
ld_monthly_esno_m09 = NaN*ones(ld_points,total_months);
gl_monthly_asnow = NaN*ones(length(lon_data),total_months);
ld_monthly_asnow_m09 = NaN*ones(ld_points,total_months);
gl_monthly_swe = NaN*ones(length(lon_data),total_months);
ld_monthly_swe_m09 = NaN*ones(ld_points,total_months);

month_vec = NaN*ones(total_months,1);
date_vec = NaN*ones(total_months,1);

% read data

disp('read data')

for y = start_year:stop_year
    y

    year_str = num2str(y);

    if sum(y==leapYears)>0
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end

    for m = 1

        mat_index = mat_index + 1;
        month_vec(mat_index) = m;
        date_vec = datenum(y,m,15);

        if m < 10
           month_str = ['0' num2str(m)];
        else
           month_str = num2str(m);
        end

        sfmc_tmp = zeros(length(lon_data),monthLength(m));
        rzmc_tmp = zeros(length(lon_data),monthLength(m));
        eveg_tmp = zeros(length(lon_data),monthLength(m));
        esoil_tmp = zeros(length(lon_data),monthLength(m));
        eint_tmp = zeros(length(lon_data),monthLength(m));
        esno_tmp = zeros(length(lon_data),monthLength(m));
        asnow_tmp = zeros(length(lon_data),monthLength(m));
        swe_tmp = zeros(length(lon_data),monthLength(m));

        for d = 1:monthLength(m)

            if d < 10
               day_str = ['0' num2str(d)];
            else
               day_str = num2str(d);
            end

            gl_file = [gl_path 'Y' year_str '/M' month_str ...
                         '/' exp_name '.tavg24_1d_lnd_Nt.' year_str month_str day_str '_1200z.nc4'];

            sfmc_data = ncread(gl_file,'SFMC');
            rzmc_data = ncread(gl_file,'RZMC');
            eveg_data = ncread(gl_file,'EVPTRNS');
            esoil_data = ncread(gl_file,'EVPSOIL');
            eint_data = ncread(gl_file,'EVPINTR');
            esno_data = ncread(gl_file,'EVPSNO');
            asnow_data = ncread(gl_file,'FRSNO');
            snodp_data = ncread(gl_file,'SNODP');

            % replace fill values with NaN and convert all data to doubles

            sfmc_data = double(sfmc_data);
            rzmc_data = double(rzmc_data);
            eveg_data = double(eveg_data);
            esoil_data = double(esoil_data);
            eint_data = double(eint_data);
            asnow_data = double(asnow_data);
            snodp_data = double(snodp_data);

            % convert snow depth [m] to SWE [mm]

            swe_data = (snodp_data*(rho_snow/rho_water))*1000;

            % convert evaporation data into mm/day

            eveg_data = eveg_data*0.0864*0.408;
            esoil_data = esoil_data*0.0864*0.408;
            eint_data = eint_data*0.0864*0.408;
            esno_data = esno_data*0.0864*0.352;

            % add to monthly array
            sfmc_tmp(:,d) = sfmc_data;
            rzmc_tmp(:,d) = rzmc_data;
            eveg_tmp(:,d) = eveg_data;
            esoil_tmp(:,d) = esoil_data;
            eint_tmp(:,d) = eint_data;
            esno_tmp(:,d) = esno_data;
            asnow_tmp(:,d) = asnow_data;
            swe_tmp(:,d) = swe_data;

           % disp(['min gl: ' num2str(min(sfmc_data))])
           % disp(['max gl: ' num2str(max(sfmc_data))])

           end

           % compute monthly mean field

            gl_monthly_sfmc(:,mat_index) = nanmean(sfmc_tmp,2);
            gl_monthly_rzmc(:,mat_index) = nanmean(rzmc_tmp,2);
            gl_monthly_eveg(:,mat_index) = nanmean(eveg_tmp,2);
            gl_monthly_esoil(:,mat_index) = nanmean(esoil_tmp,2);
            gl_monthly_eint(:,mat_index) = nanmean(eint_tmp,2);
            gl_monthly_esno(:,mat_index) = nanmean(esno_tmp,2);
            gl_monthly_asnow(:,mat_index) = nanmean(asnow_tmp,2);
            gl_monthly_swe(:,mat_index) = nanmean(swe_tmp,2);

           % read LDASsa run data

           ld_file = [ld_path 'Y' year_str '/M' month_str ...
           '/e0004s_transientCO2.ens_avg.ldas_tile_monthly_out.' year_str month_str '.bin'];

           ld_data = read_tile_data(ld_file, ld_points, nrOutVar+36);
           tmp = ld_data(19,:)';
           tmp = tmp.*ld_poros;
          % disp(['min ld: ' num2str(min(tmp))])
          % disp(['max ld: ' num2str(max(tmp))])
           ld_monthly_sfmc_m09(:,mat_index) = tmp;
           tmp = ld_data(20,:)';
           tmp = tmp.*ld_poros;
           ld_monthly_rzmc_m09(:,mat_index) = tmp;
           ld_monthly_eveg_m09(:,mat_index) = ld_data(32,:)';
           ld_monthly_esoil_m09(:,mat_index) = ld_data(33,:)';
           ld_monthly_eint_m09(:,mat_index) = ld_data(31,:)';
           ld_monthly_esno_m09(:,mat_index) = ld_data(34,:)';
           ld_monthly_asnow_m09(:,mat_index) = ld_data(18,:)';
           ld_snodp = ld_data(15,:)';
           ld_monthly_swe_m09(:,mat_index) = (rho_snow/rho_water)*ld_snodp*1000;
end
end

% compute total mean fields

disp('compute mean estimates')

gl_mean_sfmc_tot = nanmean(gl_monthly_sfmc,2);
ld_mean_sfmc_tot = nanmean(ld_monthly_sfmc_m09,2);

gl_mean_rzmc_tot = nanmean(gl_monthly_rzmc,2);
ld_mean_rzmc_tot = nanmean(ld_monthly_rzmc_m09,2);

gl_mean_eveg_tot = nanmean(gl_monthly_eveg,2);
ld_mean_eveg_tot = nanmean(ld_monthly_eveg_m09,2);

gl_mean_esoil_tot = nanmean(gl_monthly_esoil,2);
ld_mean_esoil_tot = nanmean(ld_monthly_esoil_m09,2);

gl_mean_eint_tot = nanmean(gl_monthly_eint,2);
ld_mean_eint_tot = nanmean(ld_monthly_eint_m09,2);

gl_mean_esno_tot = nanmean(gl_monthly_esno,2);
ld_mean_esno_tot = nanmean(ld_monthly_esno_m09,2);

gl_mean_asnow_tot = nanmean(gl_monthly_asnow,2);
ld_mean_asnow_tot = nanmean(ld_monthly_asnow_m09,2);

gl_mean_swe_tot = nanmean(gl_monthly_swe,2);
ld_mean_swe_tot = nanmean(ld_monthly_swe_m09,2);

% regrid from 9-km to 36-km grid

ld_sfmc_new = zeros(length(lat_data),1);
ld_sfmc_count = zeros(length(lat_data),1);

ld_rzmc_new = zeros(length(lat_data),1);
ld_rzmc_count = zeros(length(lat_data),1);

ld_eveg_new = zeros(length(lat_data),1);
ld_eveg_count = zeros(length(lat_data),1);

ld_esoil_new = zeros(length(lat_data),1);
ld_esoil_count = zeros(length(lat_data),1);

ld_eint_new = zeros(length(lat_data),1);
ld_eint_count = zeros(length(lat_data),1);

ld_esno_new = zeros(length(lat_data),1);
ld_esno_count = zeros(length(lat_data),1);

ld_asnow_new = zeros(length(lat_data),1);
ld_asnow_count = zeros(length(lat_data),1);

ld_swe_new = zeros(length(lat_data),1);
ld_swe_count = zeros(length(lat_data),1);

for i = 1:length(ld_lats)

    dist_vec = sqrt((lat_data-ld_lats(i)).^2 + (lon_data-ld_lons(i)).^2);
    min_index = find(dist_vec==min(dist_vec));
    ld_sfmc_new(min_index) = ld_sfmc_new(min_index) + ld_mean_sfmc_tot(i);
    ld_sfmc_count(min_index) = ld_sfmc_count(min_index) + 1;

    ld_rzmc_new(min_index) = ld_rzmc_new(min_index) + ld_mean_rzmc_tot(i);
    ld_rzmc_count(min_index) = ld_rzmc_count(min_index) + 1;  

     ld_eveg_new(min_index) = ld_eveg_new(min_index) + ld_mean_eveg_tot(i);
    ld_eveg_count(min_index) = ld_eveg_count(min_index) + 1;                                                      

     ld_esoil_new(min_index) = ld_esoil_new(min_index) + ld_mean_esoil_tot(i);
    ld_esoil_count(min_index) = ld_esoil_count(min_index) + 1;

     ld_eint_new(min_index) = ld_eint_new(min_index) + ld_mean_eint_tot(i);
    ld_eint_count(min_index) = ld_eint_count(min_index) + 1;

      ld_esno_new(min_index) = ld_esno_new(min_index) + ld_mean_esno_tot(i);
    ld_esno_count(min_index) = ld_esno_count(min_index) + 1;

      ld_asnow_new(min_index) = ld_asnow_new(min_index) + ld_mean_asnow_tot(i);
    ld_asnow_count(min_index) = ld_asnow_count(min_index) + 1;

      ld_swe_new(min_index) = ld_swe_new(min_index) + ld_mean_swe_tot(i);
    ld_swe_count(min_index) = ld_swe_count(min_index) + 1;
end

ld_sfmc_new(ld_sfmc_count>0) = ld_sfmc_new(ld_sfmc_count>0)./ld_sfmc_count(ld_sfmc_count>0);                        
ld_sfmc_new(ld_sfmc_count==0) = NaN;                                                                                

ld_rzmc_new(ld_rzmc_count>0) = ld_rzmc_new(ld_rzmc_count>0)./ld_rzmc_count(ld_rzmc_count>0);
ld_rzmc_new(ld_rzmc_count==0) = NaN;   

ld_eveg_new(ld_eveg_count>0) = ld_eveg_new(ld_eveg_count>0)./ld_eveg_count(ld_eveg_count>0);                        
ld_eveg_new(ld_eveg_count==0) = NaN;  

ld_esoil_new(ld_esoil_count>0) = ld_esoil_new(ld_esoil_count>0)./ld_esoil_count(ld_esoil_count>0);
ld_esoil_new(ld_esoil_count==0) = NaN;

ld_eint_new(ld_eint_count>0) = ld_eint_new(ld_eint_count>0)./ld_eint_count(ld_eint_count>0);
ld_eint_new(ld_eint_count==0) = NaN;

ld_esno_new(ld_esno_count>0) = ld_esno_new(ld_esno_count>0)./ld_esno_count(ld_esno_count>0);
ld_esno_new(ld_esno_count==0) = NaN;

ld_asnow_new(ld_asnow_count>0) = ld_asnow_new(ld_asnow_count>0)./ld_asnow_count(ld_asnow_count>0);
ld_asnow_new(ld_asnow_count==0) = NaN;

ld_swe_new(ld_swe_count>0) = ld_swe_new(ld_swe_count>0)./ld_swe_count(ld_swe_count>0);
ld_swe_new(ld_swe_count==0) = NaN;

% convert vectors to grids

disp('regrid vectors to 2D arrays')

test_lat = unique(lat_data);
test_lon = unique(lon_data);

[lon_mat,lat_mat] = meshgrid(test_lon,test_lat);

gl_mean_sfmc_tot_mat = NaN*ones(size(lon_mat));
ld_mean_sfmc_tot_mat = NaN*ones(size(lon_mat));
gl_mean_rzmc_tot_mat = NaN*ones(size(lon_mat));
ld_mean_rzmc_tot_mat = NaN*ones(size(lon_mat));
gl_mean_eveg_tot_mat = NaN*ones(size(lon_mat));
ld_mean_eveg_tot_mat = NaN*ones(size(lon_mat));
gl_mean_esoil_tot_mat = NaN*ones(size(lon_mat));
ld_mean_esoil_tot_mat = NaN*ones(size(lon_mat));
gl_mean_eint_tot_mat = NaN*ones(size(lon_mat));
ld_mean_eint_tot_mat = NaN*ones(size(lon_mat));
gl_mean_esno_tot_mat = NaN*ones(size(lon_mat));
ld_mean_esno_tot_mat = NaN*ones(size(lon_mat));
gl_mean_asnow_tot_mat = NaN*ones(size(lon_mat));
ld_mean_asnow_tot_mat = NaN*ones(size(lon_mat));
gl_mean_swe_tot_mat = NaN*ones(size(lon_mat));
ld_mean_swe_tot_mat = NaN*ones(size(lon_mat));

for i = 1:length(lon_data)

    lat_index = test_lat == lat_data(i);
    lon_index = test_lon == lon_data(i);

    gl_mean_sfmc_tot_mat(lat_index,lon_index) = gl_mean_sfmc_tot(i);
    ld_mean_sfmc_tot_mat(lat_index,lon_index) = ld_sfmc_new(i);
    gl_mean_rzmc_tot_mat(lat_index,lon_index) = gl_mean_rzmc_tot(i);
    ld_mean_rzmc_tot_mat(lat_index,lon_index) = ld_rzmc_new(i);
    gl_mean_eveg_tot_mat(lat_index,lon_index) = gl_mean_eveg_tot(i);
    ld_mean_eveg_tot_mat(lat_index,lon_index) = ld_eveg_new(i);
    gl_mean_esoil_tot_mat(lat_index,lon_index) = gl_mean_esoil_tot(i);
    ld_mean_esoil_tot_mat(lat_index,lon_index) = ld_esoil_new(i);
    gl_mean_eint_tot_mat(lat_index,lon_index) = gl_mean_eint_tot(i);
    ld_mean_eint_tot_mat(lat_index,lon_index) = ld_eint_new(i);
    gl_mean_esno_tot_mat(lat_index,lon_index) = gl_mean_esno_tot(i);
    ld_mean_esno_tot_mat(lat_index,lon_index) = ld_esno_new(i);
    gl_mean_asnow_tot_mat(lat_index,lon_index) = gl_mean_asnow_tot(i);
    ld_mean_asnow_tot_mat(lat_index,lon_index) = ld_asnow_new(i);
    gl_mean_swe_tot_mat(lat_index,lon_index) = gl_mean_swe_tot(i);
    ld_mean_swe_tot_mat(lat_index,lon_index) = ld_swe_new(i);
end

sfmc_diff_mat = gl_mean_sfmc_tot_mat - ld_mean_sfmc_tot_mat;
rzmc_diff_mat = gl_mean_rzmc_tot_mat - ld_mean_rzmc_tot_mat;
eveg_diff_mat = gl_mean_eveg_tot_mat - ld_mean_eveg_tot_mat;
esoil_diff_mat = gl_mean_esoil_tot_mat - ld_mean_esoil_tot_mat;
eint_diff_mat = gl_mean_eint_tot_mat - ld_mean_eint_tot_mat;
esno_diff_mat = gl_mean_esno_tot_mat - ld_mean_esno_tot_mat;
asnow_diff_mat = gl_mean_asnow_tot_mat - ld_mean_asnow_tot_mat;
swe_diff_mat = gl_mean_swe_tot_mat - ld_mean_swe_tot_mat;

% plot data

disp('plot data')


load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);


latlim = [-60 90];
lonlim = [-180 180];

cmap_mat = cmocean('rain',12);                                                                                   
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);                                                   
cmap = cmap_mat;                                                                                                    
s1 = quantile(ld_mean_sfmc_tot_mat(:),0.05);                                                                               
s2 = quantile(ld_mean_sfmc_tot_mat(:),0.95);                                                                               
caxis_min = s1;                                                                                
caxis_max = s2;                                                                                   
figure                                                                                                              
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...                                             
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);                                                                   
framem off; gridm on;                                                                                               
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...                                              
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...                                                
    'MLabelParallel','south','FontSize',12)                                                                         
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])                                                                
pcolorm(lat_mat,lon_mat,ld_mean_sfmc_tot_mat)                                                                              
caxis([caxis_min caxis_max]);                                                                                       
set(gcf,'Colormap',cmap);                                                                                           
plotm(coastlat, coastlon,'k')                                                                                       
hold on                                                                                                             
%geoshow(states,'facealpha',0);                                                                                     
set(gca,'XLim',lonlim);                                                                                             
set(gca,'YLim',latlim);                                                                                             
tightmap                                                                                                            
title('total mean SFMC [m^{3} m^{-3}] LDASsa')                                                              
h = colorbar;                                                                                                       
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);                                             
set(gcf,'paperunits','centimeters')                                                                                 
set(gcf,'paperposition',[1 1 17 15])                                                                                
saveas(gcf,['/home/jkolassa/Projects/NT_comp/SFMC_Fanwei_total'],'png')
saveas(gcf,['/home/jkolassa/Projects/NT_comp/SFMC_Fanwei_total'],'fig')   

cmap_mat = cmocean('balance',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(sfmc_diff_mat(:),0.05);
s2 = quantile(sfmc_diff_mat(:),0.95);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));
figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,sfmc_diff_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean SFMC [m^{3} m^{-3}] GEOldas-LDASsa')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/NT_comp/SFMC_diff_' exp_name ],'png')
saveas(gcf,['/home/jkolassa/Projects/NT_comp/SFMC_diff_' exp_name ],'fig') 

cmap_mat = cmocean('balance',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(rzmc_diff_mat(:),0.05);
s2 = quantile(rzmc_diff_mat(:),0.95);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));
figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on; 
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,rzmc_diff_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                                                                     
set(gca,'XLim',lonlim);                                                                                             
set(gca,'YLim',latlim);                                                                                             
tightmap                                                                                                            
title('total mean RZMC [m^{3} m^{-3}] GEOldas-LDASsa')                                                              
h = colorbar;                                                                                                       
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);                                             
set(gcf,'paperunits','centimeters')                                                                                 
set(gcf,'paperposition',[1 1 17 15])                                                                                
saveas(gcf,['/home/jkolassa/Projects/NT_comp/RZMC_diff_' exp_name],'png') 
saveas(gcf,['/home/jkolassa/Projects/NT_comp/RZMC_diff_' exp_name],'fig')   

cmap_mat = cmocean('balance',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(eveg_diff_mat(:),0.05);
s2 = quantile(eveg_diff_mat(:),0.95);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));
figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on; 
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,eveg_diff_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                                                                     
set(gca,'XLim',lonlim);                                                                                             
set(gca,'YLim',latlim);                                                                                             
tightmap                                                                                                            
title('total mean EVEG [mm/day] GEOldas-LDASsa')                                                              
h = colorbar;                                                                                                       
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);                                             
set(gcf,'paperunits','centimeters')                                                                                 
set(gcf,'paperposition',[1 1 17 15])                                                                                
saveas(gcf,['/home/jkolassa/Projects/NT_comp/EVEG_diff_' exp_name],'png') 
saveas(gcf,['/home/jkolassa/Projects/NT_comp/EVEG_diff_' exp_name],'fig') 

cmap_mat = cmocean('balance',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);                                                   
cmap = cmap_mat;
s1 = quantile(esoil_diff_mat(:),0.05);
s2 = quantile(esoil_diff_mat(:),0.95);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));
figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,esoil_diff_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                                                                     
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap                                                                                                            
title('total mean ESOIL [mm/day] GEOldas-LDASsa')      
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/NT_comp/ESOIL_diff_' exp_name],'png')
saveas(gcf,['/home/jkolassa/Projects/NT_comp/ESOIL_diff_' exp_name],'fig') 

cmap_mat = cmocean('balance',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);                                                   
cmap = cmap_mat;
s1 = quantile(eint_diff_mat(:),0.05);
s2 = quantile(eint_diff_mat(:),0.95);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));
figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,eint_diff_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                                                                     
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap                                                                                                            
title('total mean EINT [mm/day] GEOldas-LDASsa')      
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/NT_comp/EINT_diff_' exp_name],'png')
saveas(gcf,['/home/jkolassa/Projects/NT_comp/EINT_diff_' exp_name],'fig') 

cmap_mat = cmocean('balance',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);                                                   
cmap = cmap_mat;
s1 = quantile(esno_diff_mat(:),0.05);
s2 = quantile(esno_diff_mat(:),0.95);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));
figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,esno_diff_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);                                                                                     
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap                                                                                                            
title('total mean ESNO [mm/day] GEOldas-LDASsa')      
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/NT_comp/ESNO_diff_' exp_name],'png')
saveas(gcf,['/home/jkolassa/Projects/NT_comp/ESNO_diff_' exp_name],'fig')   
