clc
clear all
close all

%--------------------------------------------------------------------------
% SET PARAMETERS
%--------------------------------------------------------------------------

amsre_ascat_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_NN_AMSRE_ASCAT/output/SMAP_EASEv2_M09_CONUS/cat/ens_avg/';
amsre_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_NN_AMSRE/output/SMAP_EASEv2_M09_CONUS/cat/ens_avg/';
ascat_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_NN_ASCAT/output/SMAP_EASEv2_M09_CONUS/cat/ens_avg/';
ol_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_noDA/output/SMAP_EASEv2_M09_CONUS/cat/ens_avg/';

amsre_ascat_coord_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_NN_AMSRE_ASCAT/output/SMAP_EASEv2_M09_CONUS/rc_out/';
ol_coord_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/';

startYear = 2007;
stopYear = 2010;
startMonth = 8;
stopMonth = 10;
collectionID = 10;
nrOutVar = 46;
varIndex = 19;


%--------------------------------------------------------------------------
% COMPUTATIONS
%--------------------------------------------------------------------------

% account for data availability

startMonths = ones((stopYear-startYear+1),1);
startMonths(1) = startMonth;
stopMonths = 12*ones((stopYear-startYear+1),1);
stopMonths(end) = stopMonth;
totalMonths = sum(stopMonths-startMonths+1);

% account for effect of leap year

leapYears = 1992:4:2013;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% get variable names and units according to collection ID and number of
% outputs variables

[data_tag, data_units] = get_data_tag(collectionID, nrOutVar, nrOutVar);

% read no DA coordinate data

noDA_tileCoordFile = [ol_coord_path 'AMSRE_ASCAT_DA_noDA.ldas_tilecoord.bin'];
[noDA_tile_coord ] = read_tilecoord( noDA_tileCoordFile, 0 );

noDA_tileGridFile = [ol_coord_path 'AMSRE_ASCAT_DA_noDA.ldas_tilegrids.bin'];
[ noDA_tile_grid_g, noDA_tile_grid_d ] = read_tilegrids( noDA_tileGridFile );

noDAPoints = length(noDA_tile_coord.com_lat);

noDA_plot_lats = noDA_tile_coord.com_lat(1:noDAPoints);
noDA_plot_lons = noDA_tile_coord.com_lon(1:noDAPoints);

% read DA coordinate data

amsre_ascat_tileCoordFile = [amsre_ascat_coord_path 'AMSRE_ASCAT_DA_NN_AMSRE_ASCAT.ldas_tilecoord.bin'];
[amsre_ascat_tile_coord ] = read_tilecoord( amsre_ascat_tileCoordFile, 0 );

amsre_ascat_tileGridFile = [amsre_ascat_coord_path 'AMSRE_ASCAT_DA_NN_AMSRE_ASCAT.ldas_tilegrids.bin'];
[ amsre_ascat_tile_grid_g, amsre_ascat_tile_grid_d ] = read_tilegrids( amsre_ascat_tileGridFile );

amsre_ascat_Points = length(amsre_ascat_tile_coord.com_lat);

amsre_ascat_plot_lats = amsre_ascat_tile_coord.com_lat(1:amsre_ascat_Points);
amsre_ascat_plot_lons = amsre_ascat_tile_coord.com_lon(1:amsre_ascat_Points);


% initialize matrices and indices

yearIndex = 0;
matIndex = 0;
ol_mat = NaN*ones(noDAPoints,totalMonths*31);
amsre_ascat_mat = NaN*ones(amsre_ascat_Points,totalMonths*31);
amsre_mat = NaN*ones(amsre_ascat_Points,totalMonths*31);
ascat_mat = NaN*ones(amsre_ascat_Points,totalMonths*31);

ol_cell = cell(12,1);
amsre_ascat_cell = cell(12,1);
amsre_cell = cell(12,1);
ascat_cell = cell(12,1);

ol_mm_mat = NaN*ones(noDAPoints,12);
amsre_ascat_mm_mat = NaN*ones(amsre_ascat_Points,12);
ascat_mm_mat = NaN*ones(amsre_ascat_Points,12);
amsre_mm_mat = NaN*ones(amsre_ascat_Points,12);

diff_mm_ol_amsre_ascat = NaN*ones(noDAPoints,12);
diff_mm_ol_amsre = NaN*ones(noDAPoints,12);
diff_mm_ol_ascat = NaN*ones(noDAPoints,12);

% read data for the entire period

for y = startYear:stopYear
    y
    
    yearStr = num2str(y);
    yearIndex = yearIndex + 1;
    
    if any(y==leapYears)
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end
    
    for m = startMonths(yearIndex):stopMonths(yearIndex)
        m
        
        if m < 10
            monthStr = ['0' num2str(m)];
        else
            monthStr = num2str(m);
        end
        
        for d = 1:monthLength(m)
            
            matIndex = matIndex + 1;
            
            if d < 10 
                dayStr = ['0' num2str(d)];
            else
                dayStr = num2str(d);
            end
            
            noDA_File = [ol_cat_path 'Y' yearStr '/M' monthStr '/' ...
                'AMSRE_ASCAT_DA_noDA.ens_avg.ldas_tile_daily_out.' yearStr ...
                monthStr dayStr '.bin'];
            
            if exist(noDA_File,'file')
                [noDA_tile_data] = read_tile_data(noDA_File, noDAPoints, nrOutVar);
                ol_mat(:,matIndex) = noDA_tile_data(varIndex,:);
                ol_cell{m} = [ol_cell{m} noDA_tile_data(varIndex,:)'];
            end
            
            
            amsre_ascat_File = [amsre_ascat_cat_path 'Y' yearStr '/M' monthStr '/' ...
                'AMSRE_ASCAT_DA_NN_AMSRE_ASCAT.ens_avg.ldas_tile_daily_out.' ...
                yearStr monthStr dayStr '.bin'];
            
            if exist(amsre_ascat_File,'file')
                [amsre_ascat_tile_data] = read_tile_data(amsre_ascat_File, amsre_ascat_Points, nrOutVar);
                amsre_ascat_mat(:,matIndex) = amsre_ascat_tile_data(varIndex,:);
                amsre_ascat_cell{m} = [amsre_ascat_cell{m} amsre_ascat_tile_data(varIndex,:)'];
            end
            
            amsre_File = [amsre_cat_path 'Y' yearStr '/M' monthStr '/' ...
                'AMSRE_ASCAT_DA_NN_AMSRE.ens_avg.ldas_tile_daily_out.' ...
                yearStr monthStr dayStr '.bin'];
            
            if exist(amsre_File,'file')
                [amsre_tile_data] = read_tile_data(amsre_File, amsre_ascat_Points, nrOutVar);
                amsre_mat(:,matIndex) = amsre_tile_data(varIndex,:);
                amsre_cell{m} = [amsre_cell{m} amsre_tile_data(varIndex,:)'];
            end
            
            ascat_File = [ascat_cat_path 'Y' yearStr '/M' monthStr '/' ...
                'AMSRE_ASCAT_DA_NN_ASCAT.ens_avg.ldas_tile_daily_out.' ...
                yearStr monthStr dayStr '.bin'];
            
            if exist(ascat_File,'file')
                [ascat_tile_data] = read_tile_data(ascat_File, amsre_ascat_Points, nrOutVar);
                ascat_mat(:,matIndex) = ascat_tile_data(varIndex,:);
                ascat_cell{m} = [ascat_cell{m} ascat_tile_data(varIndex,:)'];
            end
            
        end
        
    end
    
end
%%
% compute monthly mean differences

figure(1)
for d = 1:4
    
    diffVec = ol_cell{9}(:,d) - amsre_ascat_cell{9}(:,d);
    
    subplot(2,2,d)
%     map_plot_sub(amsre_ascat_plot_lats,amsre_ascat_plot_lons,diffVec,...
%         ['08/' num2str(d)],'soil moisture [m^3 m^{-3}]',[-0.02 0.02])

map_plot_sub(amsre_ascat_plot_lats,amsre_ascat_plot_lons,ol_cell{9}(:,d),...
    ['09/' num2str(d)],'soil moisture [m^3 m^{-3}]',[0 0.45])
    
    
    
end

figure(2)
for d = 1:4
    
    diffVec = ol_cell{9}(:,d) - amsre_ascat_cell{9}(:,d);
    
    subplot(2,2,d)
%     map_plot_sub(amsre_ascat_plot_lats,amsre_ascat_plot_lons,diffVec,...
%         ['09/' num2str(d)],'soil moisture [m^3 m^{-3}]',[-0.02 0.02])
%     
    map_plot_sub(amsre_ascat_plot_lats,amsre_ascat_plot_lons,amsre_ascat_cell{9}(:,d),...
    ['09/' num2str(d)],'soil moisture [m^3 m^{-3}]',[0 0.45])
    
end

for m = 1:12
    
    if ~isempty(ol_cell{m})
        ol_mm_mat(:,m) = nanmean(ol_cell{m},2);
        
        amsre_ascat_mm_mat(:,m) = nanmean(amsre_ascat_cell{m},2);
        amsre_mm_mat(:,m) = nanmean(amsre_cell{m},2);
        ascat_mm_mat(:,m) = nanmean(ascat_cell{m},2);
        
        diff_mm_ol_amsre_ascat(:,m) = ol_mm_mat(:,m) - amsre_ascat_mm_mat(:,m);
        diff_mm_ol_amsre(:,m) = ol_mm_mat(:,m) - amsre_mm_mat(:,m);
        diff_mm_ol_ascat(:,m) = ol_mm_mat(:,m) - ascat_mm_mat(:,m);
        
    end
end

figure(3)
for m = 1:12
    
    subplot(3,4,m)
    map_plot_sub(amsre_ascat_plot_lats,amsre_ascat_plot_lons,diff_mm_ol_amsre_ascat(:,m),...
        num2str(m),'soil moisture [m^3 m^{-3}]',[-0.02 0.02])
    
    
end

figure(4)
for m = 1:12 
    
    subplot(3,4,m)
    map_plot_sub(amsre_ascat_plot_lats,amsre_ascat_plot_lons,diff_mm_ol_amsre(:,m),...
        num2str(m),'soil moisture [m^3 m^{-3}]',[-0.02 0.02])
    
    
end

figure(5)
for m = 1:12 
    
    subplot(3,4,m)
    map_plot_sub(amsre_ascat_plot_lats,amsre_ascat_plot_lons,diff_mm_ol_ascat(:,m),...
        num2str(m),'soil moisture [m^3 m^{-3}]',[-0.02 0.02])
    
    
end