clc 
clear all 
close all

%--------------------------------------------------------------------------
% SET PARAMETERS
%--------------------------------------------------------------------------

amsre_ascat_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT/cat/ens_avg/';
amsre_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE/cat/ens_avg/';
ascat_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/ASCAT/cat/ens_avg/';
ol_cat_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_noDA/output/SMAP_EASEv2_M09_CONUS/cat/ens_avg/';

amsre_ascat_coord_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_NN_AMSRE_ASCAT/output/SMAP_EASEv2_M09_CONUS/rc_out/';
ol_coord_path = '/discover/nobackup/jkolassa/AMSRE_ASCAT_DA_experiment/AMSRE_ASCAT_DA_noDA/output/SMAP_EASEv2_M09_CONUS/rc_out/';

scanPath = '/discover/nobackup/jkolassa/PROCESSED/';
scanCoordPath = '/discover/nobackup/jkolassa/';
scanIndices = [1 2 3 10 14 15 19];
scanPoints = 5479;

startYear = 2007;
stopYear = 2008;
startMonth = 8;
stopMonth = 2;
collectionID = 10;
nrOutVar = 46;
varIndex = 19;

%--------------------------------------------------------------------------
% COMPUTATIONS
%--------------------------------------------------------------------------


% account for data availability

startMonths = ones((stopYear-startYear+1),1);
startMonths(1) = startMonth;
stopMonths = 12*ones((stopYear-startYear+1),1);
stopMonths(end) = stopMonth;
totalMonths = sum(stopMonths-startMonths+1);

% account for effect of leap year

leapYears = 1992:4:2013;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% get variable names and units according to collection ID and number of
% outputs variables

[data_tag, data_units] = get_data_tag(collectionID, nrOutVar, nrOutVar);

% read no DA coordinate data

noDA_tileCoordFile = [ol_coord_path 'AMSRE_ASCAT_DA_noDA.ldas_tilecoord.bin'];
[noDA_tile_coord ] = read_tilecoord( noDA_tileCoordFile, 0 );

noDA_tileGridFile = [ol_coord_path 'AMSRE_ASCAT_DA_noDA.ldas_tilegrids.bin'];
[ noDA_tile_grid_g, noDA_tile_grid_d ] = read_tilegrids( noDA_tileGridFile );

noDAPoints = length(noDA_tile_coord.com_lat);

noDA_plot_lats = noDA_tile_coord.com_lat(1:noDAPoints);
noDA_plot_lons = noDA_tile_coord.com_lon(1:noDAPoints);

% read DA coordinate data

amsre_ascat_tileCoordFile = [amsre_ascat_coord_path 'AMSRE_ASCAT_DA_NN_AMSRE_ASCAT.ldas_tilecoord.bin'];
[amsre_ascat_tile_coord ] = read_tilecoord( amsre_ascat_tileCoordFile, 0 );

amsre_ascat_tileGridFile = [amsre_ascat_coord_path 'AMSRE_ASCAT_DA_NN_AMSRE_ASCAT.ldas_tilegrids.bin'];
[ amsre_ascat_tile_grid_g, amsre_ascat_tile_grid_d ] = read_tilegrids( amsre_ascat_tileGridFile );

amsre_ascat_Points = length(amsre_ascat_tile_coord.com_lat);

amsre_ascat_plot_lats = amsre_ascat_tile_coord.com_lat(1:amsre_ascat_Points);
amsre_ascat_plot_lons = amsre_ascat_tile_coord.com_lon(1:amsre_ascat_Points);


% read SCAN data

scanSites = dir(scanPath);
scanSites = scanSites(3:end);

scanMat = NaN*ones(scanPoints,length(scanIndices),length(scanSites));

% read SCAN coordinate data

scanCoordFile = [scanCoordPath 'ALL_SCAN_coord.txt'];

fid = fopen(scanCoordFile);
scanCoordData = textscan(fid,'%s %d %f %f %d %d');
fclose(fid);


for i = 1:length(scanSites)
    
    readPath = [scanPath scanSites(i).name '/'];
    readFile = [readPath 'SCAN_' scanSites(i).name '_1d.mat'];
    readData = load(readFile);
    
    scanMat(:,:,i) = readData.Sdata_1d(:,scanIndices);

    
end


% initialize matrices and indices

yearIndex = 0;
matIndex = 0;
ol_mat = NaN*ones(noDAPoints,totalMonths*31);
amsre_ascat_mat = NaN*ones(amsre_ascat_Points,totalMonths*31);
insituMat_surf = NaN*ones(length(scanSites),totalMonths*31);
insituMat_root = NaN*ones(length(scanSites),totalMonths*31);
dateVec = NaN*ones(1,totalMonths*31);

corr_insituS_ol = NaN*ones(length(scanSites),1);
p_insituS_ol = NaN*ones(length(scanSites),1);
corr_insituS_amsre_ascat = NaN*ones(length(scanSites),1);
p_insituS_amsre_ascat = NaN*ones(length(scanSites),1);
corr_insituR_ol = NaN*ones(length(scanSites),1);
p_insituR_ol = NaN*ones(length(scanSites),1);
corr_insituR_amsre_ascat = NaN*ones(length(scanSites),1);
p_insituR_amsre_ascat = NaN*ones(length(scanSites),1);

% read data for the entire period

for y = startYear:stopYear
    
    y
    
    yearStr = num2str(y);
    yearIndex = yearIndex + 1;
    
    if any(y==leapYears)
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end
    
    for m = startMonths(yearIndex):stopMonths(yearIndex)
        m
        
        if m < 10
            monthStr = ['0' num2str(m)];
        else
            monthStr = num2str(m);
        end
        
        for d = 1:monthLength(m)
            
            matIndex = matIndex + 1;
            
            if d < 10 
                dayStr = ['0' num2str(d)];
            else
                dayStr = num2str(d);
            end
            
            noDA_File = [ol_cat_path 'Y' yearStr '/M' monthStr '/' ...
                'AMSRE_ASCAT_DA_noDA.ens_avg.ldas_tile_daily_out.' yearStr ...
                monthStr dayStr '.bin'];
            
            amsre_ascat_File = [amsre_ascat_cat_path 'Y' yearStr '/M' monthStr '/' ...
                'AMSRE_ASCAT_DA_NN_AMSRE_ASCAT.ens_avg.ldas_tile_daily_out.' ...
                yearStr monthStr dayStr '.bin'];
            
            if exist(noDA_File,'file') && exist(amsre_ascat_File,'file')
                [noDA_tile_data] = read_tile_data(noDA_File, noDAPoints, nrOutVar);
                ol_mat(:,matIndex) = noDA_tile_data(varIndex,:);
                
                [amsre_ascat_tile_data] = read_tile_data(amsre_ascat_File, amsre_ascat_Points, nrOutVar);
                amsre_ascat_mat(:,matIndex) = amsre_ascat_tile_data(varIndex,:);
                
                
                timeIndex = (scanMat(:,1,1)==y) + (scanMat(:,2,1)==m) + ...
                    (scanMat(:,3,1)==d);
                timeIndex = timeIndex ==3;
                
                insituMat_surf(:,matIndex) = scanMat(timeIndex,4,:);
                insituMat_root(:,matIndex) = scanMat(timeIndex,5,:);
                
                dateVec(1,matIndex) = datenum(y,m,d);
                
            end
            
        end
        
    end
    
end

bufferIndex = isnan(dateVec);
dateVec(bufferIndex) = [];
ol_mat(:,bufferIndex) = [];
amsre_ascat_mat(:,bufferIndex) = [];
insituMat_surf(:,bufferIndex) = [];
insituMat_root(:,bufferIndex) = [];

% compute correlations between model runs and in situ data

for i = 1:length(scanSites) 
    
    distVec = sqrt((amsre_ascat_plot_lats-scanCoordData{1,3}(i)).^2 + ...
        (amsre_ascat_plot_lons-scanCoordData{1,4}(i)).^2);
    locationIndex = find(distVec == min(distVec));
    locationIndex = locationIndex(1);
    
    amsre_ascat_vec = amsre_ascat_mat(locationIndex,:);
    ol_vec = ol_mat(locationIndex,:);
    insituVec_surf = insituMat_surf(i,:);
    insituVec_root = insituMat_root(i,:);
    
    dataIndex = isnan(insituVec_surf) + isnan(amsre_ascat_vec);
    dataIndex = dataIndex == 0; 
    
    if sum(dataIndex) > 10
       [rhoMat,pMat] = corrcoef(insituVec_surf(dataIndex),amsre_ascat_vec(dataIndex));
       corr_insituS_amsre_ascat(i) = rhoMat(1,2);
       p_insituS_amsre_ascat(i) = pMat(1,2);
    end
    
    dataIndex = isnan(insituVec_root) + isnan(amsre_ascat_vec);
    dataIndex = dataIndex == 0; 
    
    if sum(dataIndex) > 10
       [rhoMat,pMat] = corrcoef(insituVec_root(dataIndex),amsre_ascat_vec(dataIndex));
       corr_insituR_amsre_ascat(i) = rhoMat(1,2);
       p_insituR_amsre_ascat(i) = pMat(1,2);
    end
    
    dataIndex = isnan(insituVec_surf) + isnan(ol_vec);
    dataIndex = dataIndex == 0; 
    
    if sum(dataIndex) > 10
       [rhoMat,pMat] = corrcoef(insituVec_surf(dataIndex),ol_vec(dataIndex));
       corr_insituS_ol(i) = rhoMat(1,2);
       p_insituS_ol(i) = pMat(1,2);
    end
    
    dataIndex = isnan(insituVec_root) + isnan(ol_vec);
    dataIndex = dataIndex == 0; 
    
    if sum(dataIndex) > 10
       [rhoMat,pMat] = corrcoef(insituVec_root(dataIndex),ol_vec(dataIndex));
       corr_insituR_ol(i) = rhoMat(1,2);
       p_insituR_ol(i) = pMat(1,2);
    end
    
    
end
%%
plot_corr_insituS_ol = corr_insituS_ol;
plot_corr_insituS_ol(p_insituS_ol>0.05) = NaN;
plot_corr_insituR_ol = corr_insituR_ol;
plot_corr_insituR_ol(p_insituR_ol>0.05) = NaN;
plot_corr_insituS_amsre_ascat = corr_insituS_amsre_ascat;
plot_corr_insituS_amsre_ascat(p_insituS_amsre_ascat>0.05) = NaN;
plot_corr_insituR_amsre_ascat = corr_insituR_amsre_ascat;
plot_corr_insituR_amsre_ascat(p_insituR_amsre_ascat>0.05) = NaN;

map_plot(scanCoordData{1,3},scanCoordData{1,4},plot_corr_insituS_amsre_ascat,...
    'DAn surface','correlation [-]',[0 1])
map_plot(scanCoordData{1,3},scanCoordData{1,4},plot_corr_insituS_ol,...
    'OL surface','correlation [-]',[0 1])
map_plot(scanCoordData{1,3},scanCoordData{1,4},plot_corr_insituR_amsre_ascat,...
    'DA root zone','correlation [-]',[-1 1])
map_plot(scanCoordData{1,3},scanCoordData{1,4},plot_corr_insituR_ol,...
    'OL root zone','correlation [-]',[-1 1])
map_plot(scanCoordData{1,3},scanCoordData{1,4},plot_corr_insituS_amsre_ascat-plot_corr_insituS_ol,...
    'DA-OL surface','correlation [-]',[-0.1 0.1])
map_plot(scanCoordData{1,3},scanCoordData{1,4},plot_corr_insituR_amsre_ascat-plot_corr_insituR_ol,...
    'DA-OL root zone','correlation [-]',[-0.1 0.1])