clc
clear all
close all

storm_name = 'Grace';
storm_id = '2021225N15313';
agency_choice = 'NHC';

track_file = '/gpfsm/dnb31/jkolassa/SMAP_TC_project/track_files/IBTrACS.NA.v04r00.nc';

storm_names = ncread(track_file,'name');
storm_ids = ncread(track_file,'sid');
time_data = ncread(track_file,'time');
iso_time_data = ncread(track_file,'iso_time');
us_agency = ncread(track_file,'usa_agency');
us_lat = ncread(track_file,'usa_lat');
us_lon = ncread(track_file,'usa_lon');

for i = 1:size(storm_ids,2)
 
      storm_id_new(i) = convertCharsToStrings(storm_ids(:,i));

end

storm_id_new = storm_id_new';
storm_index = strcmp(storm_id_new,storm_id);

iso_time_storm = iso_time_data(:,:,storm_index);

for i = 1:size(iso_time_storm,2)
    year_str(i) = convertCharsToStrings(iso_time_storm(1:4,i));
    month_str(i) = convertCharsToStrings(iso_time_storm(6:7,i));
    day_str(i) = convertCharsToStrings(iso_time_storm(9:10,i));
    hour_str(i) = convertCharsToStrings(iso_time_storm(12:13,i));
end

year_vec = str2double(year_str)';
month_vec = str2double(month_str)';
day_vec = str2double(day_str)';
hour_vec = str2double(hour_str)';

if strcmp(agency_choice,'NHC')
   lat_vec = us_lat(:,storm_index);
   lon_vec = us_lon(:,storm_index);
end 

nan_index = isnan(lat_vec);
lat_vec(nan_index) = [];
lon_vec(nan_index) = [];
year_vec(nan_index) = [];
month_vec(nan_index) = [];
day_vec(nan_index) = [];
hour_vec(nan_index) = [];

datenum_vec = datenum(year_vec,month_vec,day_vec,hour_vec,0,0);

track_mat = [datenum_vec year_vec month_vec day_vec hour_vec lat_vec lon_vec];

write_file = ['/discover/nobackup/jkolassa/SMAP_TC_project/track_files/' storm_name '_track.mat'];
save(write_file,'track_mat');
