clc
clear all
close all

error_file = '/discover/nobackup/jkolassa/Idai_Errors.xlsx';
along_track_error_data = xlsread(error_file,2);
intensity_error_data = xlsread(error_file,4);

fcst_hour = along_track_error_data(1,:);
cntrl_along_track_error = along_track_error_data(2:7,:);
smap_along_track_error = along_track_error_data(13:18,:);

cntrl_intensity_error = intensity_error_data(2:7,:);
smap_intensity_error = intensity_error_data(12:17,:);

cntrl_along_track_error_abs = abs(cntrl_along_track_error);
smap_along_track_error_abs = abs(smap_along_track_error);
cntrl_intensity_error_abs = abs(cntrl_intensity_error);
smap_intensity_error_abs = abs(smap_intensity_error);

cntrl_along_track_error_abs_vec = cntrl_along_track_error_abs(:);
cntrl_along_track_error_abs_vec(isnan(cntrl_along_track_error_abs_vec)) = [];
smap_along_track_error_abs_vec = smap_along_track_error_abs(:);
smap_along_track_error_abs_vec(isnan(smap_along_track_error_abs_vec)) = [];
cntrl_intensity_error_abs_vec = cntrl_intensity_error_abs(:);
cntrl_intensity_error_abs_vec(isnan(cntrl_intensity_error_abs_vec)) = [];
smap_intensity_error_abs_vec = smap_intensity_error_abs(:);
smap_intensity_error_abs_vec(isnan(smap_intensity_error_abs_vec)) = [];

tmp = smap_along_track_error_abs_vec < cntrl_along_track_error_abs_vec;
fsp_along_track_total = sum(tmp)/length(tmp);
tmp = smap_intensity_error_abs_vec < cntrl_intensity_error_abs_vec;
fsp_intensity_total = sum(tmp)/length(tmp);

for i = 1:length(fcst_hour)

    data_index = isnan(smap_along_track_error_abs(:,i)) + isnan(cntrl_along_track_error_abs(:,i));
    data_index = data_index ==0;
    tmp = smap_along_track_error_abs(data_index,i) < cntrl_along_track_error_abs(data_index,i);
    fsp_along_track_lead_time(i) = sum(tmp)/length(tmp);

    data_index = isnan(smap_intensity_error_abs(:,i)) + isnan(cntrl_intensity_error_abs(:,i));
    data_index = data_index ==0;
    tmp = smap_intensity_error_abs(data_index,i) < cntrl_intensity_error_abs(data_index,i);
    fsp_intensity_lead_time(i) = sum(tmp)/length(tmp);
end
