clc
clear all
close all

r34_lat_data_CNTRL = [NaN 95 232 154 196 240 250];
r34_lat_data_SMAP = [NaN NaN 230 155 192 198 221];
r34_lat_data_index = isnan(r34_lat_data_CNTRL) + isnan(r34_lat_data_SMAP);
r34_lat_data_index = r34_lat_data_index == 0;
r34_lat_data_CNTRL_plot = r34_lat_data_CNTRL;
r34_lat_data_CNTRL_plot(r34_lat_data_index==0) = NaN;
r34_lat_data_SMAP_plot = r34_lat_data_SMAP;
r34_lat_data_SMAP_plot(r34_lat_data_index==0) = NaN;

r34_lon_data_CNTRL = [NaN 62 263 158 208 202 221];
r34_lon_data_SMAP = [NaN NaN 234 168 203 199 212];
r34_lon_data_index = isnan(r34_lon_data_CNTRL) + isnan(r34_lon_data_SMAP);
r34_lon_data_index = r34_lon_data_index == 0;
r34_lon_data_CNTRL_plot = r34_lon_data_CNTRL;
r34_lon_data_CNTRL_plot(r34_lon_data_index==0) = NaN;
r34_lon_data_SMAP_plot = r34_lon_data_SMAP;
r34_lon_data_SMAP_plot(r34_lon_data_index==0) = NaN;

r50_lat_data_CNTRL = [NaN NaN 99 105 112 116 131];
r50_lat_data_SMAP = [NaN NaN NaN 98 114 109 118];
r50_lat_data_index = isnan(r50_lat_data_CNTRL) + isnan(r50_lat_data_SMAP);
r50_lat_data_index = r50_lat_data_index == 0;
r50_lat_data_CNTRL_plot = r50_lat_data_CNTRL;
r50_lat_data_CNTRL_plot(r50_lat_data_index==0) = NaN;
r50_lat_data_SMAP_plot = r50_lat_data_SMAP;
r50_lat_data_SMAP_plot(r50_lat_data_index==0) = NaN;

r50_lon_data_CNTRL = [NaN NaN 137 97 103 111 108];
r50_lon_data_SMAP = [NaN NaN NaN 87 109 98 NaN];
r50_lon_data_index = isnan(r50_lon_data_CNTRL) + isnan(r50_lon_data_SMAP);
r50_lon_data_index = r50_lon_data_index == 0;
r50_lon_data_CNTRL_plot = r50_lon_data_CNTRL;
r50_lon_data_CNTRL_plot(r50_lon_data_index==0) = NaN;
r50_lon_data_SMAP_plot = r50_lon_data_SMAP;
r50_lon_data_SMAP_plot(r50_lon_data_index==0) = NaN;

r34_ne_ibtracs = [NaN 175.94 157.42 212.98 194.46 212.98 157.42 74.08];  
r34_se_ibtracs = [NaN 138.9 157.42 203.72 203.72 231.5 175.94 74.08]; 
r34_sw_ibtracs = [NaN 83.34 157.42 212.98 194.46 250.02 185.2 83.34];
r34_nw_ibtracs = [NaN 120.38 166.68 212.98 222.24 212.98 157.42 74.08];

r50_ne_ibtracs = [NaN NaN 92.6 111.12 120.38 111.12 74.08 NaN];
r50_se_ibtracs = [NaN NaN 101.86 120.38 101.86 120.38 101.86 NaN];
r50_sw_ibtracs = [NaN NaN 83.34 111.12 101.86 138.9 111.12 NaN]; 
r50_nw_ibtracs = [NaN NaN 92.6 101.86 101.86 111.12 83.34 NaN];

r34_e_ibtracs = NaN*ones(size(r34_ne_ibtracs));
r34_w_ibtracs = NaN*ones(size(r34_ne_ibtracs));
r34_n_ibtracs = NaN*ones(size(r34_ne_ibtracs));
r34_s_ibtracs = NaN*ones(size(r34_ne_ibtracs));

r50_e_ibtracs = NaN*ones(size(r34_ne_ibtracs));
r50_w_ibtracs = NaN*ones(size(r34_ne_ibtracs));
r50_n_ibtracs = NaN*ones(size(r34_ne_ibtracs));
r50_s_ibtracs = NaN*ones(size(r34_ne_ibtracs));

for i = 1:length(r34_ne_ibtracs)

    r34_e_ibtracs(i) = 1/2*cosd(45)*(r34_ne_ibtracs(i)+r34_se_ibtracs(i));
    r34_w_ibtracs(i) = 1/2*cosd(45)*(r34_nw_ibtracs(i)+r34_sw_ibtracs(i));
    r34_n_ibtracs(i) = 1/2*cosd(45)*(r34_nw_ibtracs(i)+r34_ne_ibtracs(i));
    r34_s_ibtracs(i) = 1/2*cosd(45)*(r34_sw_ibtracs(i)+r34_se_ibtracs(i));

    r50_e_ibtracs(i) = 1/2*cosd(45)*(r50_ne_ibtracs(i)+r50_se_ibtracs(i));
    r50_w_ibtracs(i) = 1/2*cosd(45)*(r50_nw_ibtracs(i)+r50_sw_ibtracs(i));
    r50_n_ibtracs(i) = 1/2*cosd(45)*(r50_nw_ibtracs(i)+r50_ne_ibtracs(i));
    r50_s_ibtracs(i) = 1/2*cosd(45)*(r50_sw_ibtracs(i)+r50_se_ibtracs(i));
end

r34_lat_ibtracs = nanmean([r34_e_ibtracs; r34_w_ibtracs],1);
r34_lon_ibtracs = nanmean([r34_n_ibtracs; r34_s_ibtracs],1);
r50_lat_ibtracs = nanmean([r50_e_ibtracs; r50_w_ibtracs],1);
r50_lon_ibtracs = nanmean([r50_n_ibtracs; r50_s_ibtracs],1);

year_vec = 2019*ones(size(r34_lat_data_CNTRL));
month_vec = 3*ones(size(r34_lat_data_CNTRL));
day_vec = [9 10 11 12 13 14 15];
year_vec_ibtracs = 2019*ones(size(r34_lat_ibtracs));
month_vec_ibtracs = 3*ones(size(r34_lat_ibtracs));
day_vec_ibtracs = [9 10 11 12 13 14 15 16];
datenum_vec = datenum(year_vec,month_vec,day_vec);
datenum_vec_ibtracs = datenum(year_vec_ibtracs,month_vec_ibtracs,day_vec_ibtracs);

h1=figure
plot(datenum_vec,r34_lat_data_CNTRL_plot,'LineWidth',2,'LineStyle','-','Color',[0.5 0.5 0.5])
hold on 
plot(datenum_vec,r34_lat_data_SMAP_plot,'LineWidth',2,'LineStyle','-','Color',[0 0 0])
hold on
plot(datenum_vec_ibtracs,r34_lat_ibtracs,'LineWidth',2,'LineStyle','-','Color','r')
hold on
plot(datenum_vec,r50_lat_data_CNTRL_plot,'LineWidth',2,'LineStyle','--','Color',[0.5 0.5 0.5])
hold on
plot(datenum_vec,r50_lat_data_SMAP_plot,'LineWidth',2,'LineStyle','--','Color',[0 0 0])
hold on
plot(datenum_vec_ibtracs,r50_lat_ibtracs,'LineWidth',2,'LineStyle','--','Color','r')
hold off
grid on
ax = gca(h1)
ax.FontSize = 16; 
datetick('x','dd-mmm')
title('Meridional wind speed radius [km]','FontSize',16)
ylabel('wind speed radius [km]','FontSize',16)
xlabel('date [DD-MMM]','FontSize',16)
legend(['R34 CNTRL\_ANA (avg=' num2str(round(nanmean(r34_lat_data_CNTRL_plot))) 'km)'],...
['R34 SMAP\_ANA (avg=' num2str(round(nanmean(r34_lat_data_SMAP_plot))) 'km)'],...
['R34 IBTrACS (avg=' num2str(round(nanmean(r34_lat_ibtracs))) 'km)'],...
['R50 CNTRL\_ANA (avg=' num2str(round(nanmean(r50_lat_data_CNTRL_plot))) 'km)'],...
['R50 SMAP\_ANA(avg=' num2str(round(nanmean(r50_lat_data_SMAP_plot))) 'km)'],...
['R50 IBTrACS(avg=' num2str(round(nanmean(r50_lat_ibtracs))) 'km)'],...
'Location','bestoutside','FontSize',16)
%legend(['R34 CNTRL\_ANA'],...
%['R34 SMAP\_ANA'],...
%['R34 IBTrACS'],...
%['R50 CNTRL\_ANA'],...
%['R50 SMAP\_ANA'],...
%['R50 IBTrACS'],...
%'Location','bestoutside','FontSize',16)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/Idai/Paper1_wind_speed_R_timeseries_meridional_wLegend'],'png')

h1=figure
plot(datenum_vec,r34_lat_data_CNTRL_plot,'LineWidth',2,'LineStyle','-','Color','b')
hold on
plot(datenum_vec,r34_lat_data_SMAP_plot,'LineWidth',2,'LineStyle','-','Color','r')
hold on
plot(datenum_vec_ibtracs,r34_lat_ibtracs,'LineWidth',2,'LineStyle','-','Color','k')
hold on
plot(datenum_vec,r50_lat_data_CNTRL_plot,'LineWidth',2,'LineStyle','--','Color','b')
hold on
plot(datenum_vec,r50_lat_data_SMAP_plot,'LineWidth',2,'LineStyle','--','Color','r')
hold on
plot(datenum_vec_ibtracs,r50_lat_ibtracs,'LineWidth',2,'LineStyle','--','Color','k')
hold off
grid on
ax = gca(h1)
ax.FontSize = 16;
datetick('x','dd-mmm')
title('Meridional wind speed radius [km]','FontSize',16)
ylabel('wind speed radius [km]','FontSize',16)
xlabel('date [DD-MMM]','FontSize',16)
legend(['R34 CNTRL\_ANA (avg=' num2str(round(nanmean(r34_lat_data_CNTRL_plot))) 'km)'],...
['R34 SMAP\_ANA (avg=' num2str(round(nanmean(r34_lat_data_SMAP_plot))) 'km)'],...
['R34 IBTrACS (avg=' num2str(round(nanmean(r34_lat_ibtracs))) 'km)'],...
['R50 CNTRL\_ANA (avg=' num2str(round(nanmean(r50_lat_data_CNTRL_plot))) 'km)'],...
['R50 SMAP\_ANA(avg=' num2str(round(nanmean(r50_lat_data_SMAP_plot))) 'km)'],...
['R50 IBTrACS(avg=' num2str(round(nanmean(r50_lat_ibtracs))) 'km)'],...
'Location','bestoutside','FontSize',16)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/Idai/Paper1_wind_speed_R_timeseries_meridional_wLegend'],'png')

h2=figure
plot(datenum_vec,r34_lon_data_CNTRL_plot,'LineWidth',2,'LineStyle','-','Color',[0.5 0.5 0.5])
hold on
plot(datenum_vec,r34_lon_data_SMAP_plot,'LineWidth',2,'LineStyle','-','Color',[0 0 0])
hold on
plot(datenum_vec_ibtracs,r34_lon_ibtracs,'LineWidth',2,'LineStyle','-','Color','r')
hold on
plot(datenum_vec,r50_lon_data_CNTRL_plot,'LineWidth',2,'LineStyle','--','Color',[0.5 0.5 0.5])
hold on
plot(datenum_vec,r50_lon_data_SMAP_plot,'LineWidth',2,'LineStyle','--','Color',[0 0 0])
hold on
plot(datenum_vec_ibtracs,r50_lon_ibtracs,'LineWidth',2,'LineStyle','--','Color','r')
hold off
grid on
ax = gca(h2)
ax.FontSize = 16; 
datetick('x','dd-mmm')
title('Zonal wind speed radius [km]','FontSize',16)
ylabel('wind speed radius [km]','FontSize',16)
xlabel('date [DD-MMM]','FontSize',16)
legend(['R34 CNTRL\_ANA (avg=' num2str(round(nanmean(r34_lon_data_CNTRL_plot))) 'km)'],...
['R34 SMAP\_ANA (avg=' num2str(round(nanmean(r34_lon_data_SMAP_plot))) 'km)'],...
['R34 IBTrACS (avg=' num2str(round(nanmean(r34_lon_ibtracs))) 'km)'],...
['R50 CNTRL\_ANA (avg=' num2str(round(nanmean(r50_lon_data_CNTRL_plot))) 'km)'],...
['R50 SMAP\_ANA (avg=' num2str(round(nanmean(r50_lon_data_SMAP_plot))) 'km)'],...
['R50 IBTrACS(avg=' num2str(round(nanmean(r50_lon_ibtracs))) 'km)'],...
'Location','bestoutside','FontSize',16)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/Idai/Paper1_wind_speed_R_timeseries_zonal_wLegend'],'png')

h2=figure
plot(datenum_vec,r34_lon_data_CNTRL_plot,'LineWidth',2,'LineStyle','-','Color','b')
hold on
plot(datenum_vec,r34_lon_data_SMAP_plot,'LineWidth',2,'LineStyle','-','Color','r')
hold on
plot(datenum_vec_ibtracs,r34_lon_ibtracs,'LineWidth',2,'LineStyle','-','Color','k')
hold on
plot(datenum_vec,r50_lon_data_CNTRL_plot,'LineWidth',2,'LineStyle','--','Color','b')
hold on
plot(datenum_vec,r50_lon_data_SMAP_plot,'LineWidth',2,'LineStyle','--','Color','r')
hold on
plot(datenum_vec_ibtracs,r50_lon_ibtracs,'LineWidth',2,'LineStyle','--','Color','k')
hold off
grid on
ax = gca(h2)
ax.FontSize = 16;
datetick('x','dd-mmm')
title('Zonal wind speed radius [km]','FontSize',16)
ylabel('wind speed radius [km]','FontSize',16)
xlabel('date [DD-MMM]','FontSize',16)
legend(['R34 CNTRL\_ANA (avg=' num2str(round(nanmean(r34_lon_data_CNTRL_plot))) 'km)'],...
['R34 SMAP\_ANA (avg=' num2str(round(nanmean(r34_lon_data_SMAP_plot))) 'km)'],...
['R34 IBTrACS (avg=' num2str(round(nanmean(r34_lon_ibtracs))) 'km)'],...
['R50 CNTRL\_ANA (avg=' num2str(round(nanmean(r50_lon_data_CNTRL_plot))) 'km)'],...
['R50 SMAP\_ANA (avg=' num2str(round(nanmean(r50_lon_data_SMAP_plot))) 'km)'],...
['R50 IBTrACS(avg=' num2str(round(nanmean(r50_lon_ibtracs))) 'km)'],...
'Location','bestoutside','FontSize',16)
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 25 15])
saveas(gcf,['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/Idai/Paper1_wind_speed_R_timeseries_zonal_wLegend'],'png')
