clc
clear all 
close all

%-----------------------------------------
% EXPERIMENT DEFINITION
%-----------------------------------------

storm_name = 'Idai';
save_path = ['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/' storm_name '/'];

control_dir = ['/discover/nobackup/projects/smaptc/jkolassa/archive/' storm_name '/'];
control_name = 'LADAS_control_4D_new';
exp_dir = ['/discover/nobackup/projects/smaptc/jkolassa/archive/' storm_name '/'];
exp_name = 'Idai_SMAP_4D';

lat_range = [-24 -10];
lon_range = [24 52];

%start_year = 2019;
%start_month = 2;
%start_day = 4;

start_year = 2019;
start_month = 3;
start_day = 1;

%end_year = 2019;
%end_month = 3;
%end_day = 22;

end_year = 2019;
end_month = 3;
end_day = 15;

ocean_mask_flag = 'on'; % when making summary flux plots, use entire domain or mask to only use land pixels expected to influence storm

bt_time_str = '72h';   % string specifying how far back in time backtrajectories are computed that are used to create ocean_mask

%---------------------------------------------
% DATA READ PREPARATION
%---------------------------------------------

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];
mat_index = 0;
mask_index  = 0;
month_vec = ['Jan';'Feb';'Mar';'Apr';'May';,'Jun';'Jul';'Aug';'Sep';'Oct';'Nov';'Dec'];

%---------------------------------------------
% DATA READ
%---------------------------------------------

% read track data

track_file = ['/discover/nobackup/jkolassa/SMAP_TC_project/track_files/' storm_name '_track.ascii'];
track_data = dlmread(track_file);
track_datenum = datenum(start_year, track_data(:,1), track_data(:,2), track_data(:,3), 0, 0);


% define latitude and longitude index for domain

coord_file = [control_dir control_name '/diag/Y' num2str(start_year,'%04i') '/M' num2str(start_month,'%02i') ...
             '/' control_name '.tavg1_2d_lnd_Nx.' num2str(start_year,'%04i') num2str(start_month,'%02i') ...
              num2str(start_day,'%02i') '_2130z.nc4'];

lat_vec = double(ncread(coord_file,'lat'));
lon_vec = double(ncread(coord_file,'lon'));

lat_index = (lat_vec<lat_range(1)) + (lat_vec>lat_range(2));
lat_index = lat_index == 0;
lon_index = (lon_vec<lon_range(1)) + (lon_vec>lon_range(2));
lon_index = lon_index == 0;

coord_ana_file = [control_dir control_name '/ana/Y' num2str(start_year,'%04i') '/M' num2str(start_month,'%02i') '/' control_name ... 
                 '.ana.inst3d_met_p.' num2str(start_year,'%04i') num2str(start_month,'%02i') num2str(start_day,'%02i')...
                 '_2100z.nc4'];

lat_vec_coarse = double(ncread(coord_ana_file,'lat'));
lon_vec_coarse = double(ncread(coord_ana_file,'lon'));

lat_index_coarse = (lat_vec_coarse<lat_range(1)) + (lat_vec_coarse>lat_range(2));
lat_index_coarse = lat_index_coarse == 0;
lon_index_coarse = (lon_vec_coarse<lon_range(1)) + (lon_vec_coarse>lon_range(2));
lon_index_coarse = lon_index_coarse == 0;

% loop over years
for y = start_year:end_year

    disp('read data')

    y_str = num2str(y,'%04i');
 
    % define month length based on leap year status
    if sum(y==leapYears)>0
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end

% loop over months
    for m = start_month:end_month

        m_str = num2str(m,'%02i');

        % define start and end day for current month
        day_first = 1;
        day_last = monthLength(m);

        if (m == start_month)
           day_first = start_day;
        end

        if (m == end_month)
           day_last = end_day;
        end

        % loop over days
        for d = day_first:day_last

            mat_index = mat_index + 1;

            d_str = num2str(d,'%02i');

            % loop over time steps
            for t = 0:23

                mask_index = mask_index + 1;

                t_str = num2str(t,'%02i');

                % define diagnostic file names
                control_diag_file = [control_dir control_name '/diag/Y' y_str '/M' m_str '/' control_name ...
                                    '.tavg1_2d_ocn_Nx.' y_str m_str d_str '_' t_str '30z.nc4'];

                exp_diag_file = [exp_dir exp_name '/diag/Y' y_str '/M' m_str '/' exp_name ... 
                                '.tavg1_2d_ocn_Nx.' y_str m_str d_str '_' t_str '30z.nc4'];

                ocean_mask_file = ['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/backtrajectories/' ...
                                storm_name '/land_mask/ocean_mask_' d_str '-' month_vec(m,:) '-' y_str '_' ...
                                t_str  ':30:00.mat'];

                ocean_mask_file_control = ['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/backtrajectories/' ...
                                storm_name '/land_mask/ocean_mask_interp_' bt_time_str '_control_' d_str '-' month_vec(m,:) '-' y_str '_' ...
                                '.mat'];

                ocean_mask_file_exp = ['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/backtrajectories/' ...
                                storm_name '/land_mask/ocean_mask_interp_' bt_time_str '_experiment_' d_str '-' month_vec(m,:) '-' y_str '_' ...
                                '.mat'];

                % on first time step read coordinate information and initialize matrices

                if (mat_index == 1) && (t == 0)

                   datenum_vec = NaN*ones(sum(monthLength(start_month:end_month)),1);

                   control_totlh_ttot24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_totlh_ttot24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));

                   control_ocean_mask_heat_map_daily = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_ocean_mask_heat_map_daily = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   control_ocean_mask_daily = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_ocean_mask_daily = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   control_ocean_mask_time_daily = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_ocean_mask_time_daily = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));

                   control_totlh_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
                   exp_totlh_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

                   exp_ocean_mask = NaN*ones(sum(lon_index),sum(lat_index),24);
                   control_ocean_mask = NaN*ones(sum(lon_index),sum(lat_index),24);

                end % if

                % read hourly data

                tmp_read_mat = double(ncread(control_diag_file,'EFLUXWTR'));
                control_totlh_hour_mat(:,:,t+1) = tmp_read_mat(lon_index,lat_index);
                tmp_read_mat = double(ncread(exp_diag_file,'EFLUXWTR'));
                exp_totlh_hour_mat(:,:,t+1) = tmp_read_mat(lon_index,lat_index);


                % read ocean mask
                if (exist(ocean_mask_file_control))
                ocean_mask_control = load(ocean_mask_file_control);
                ocean_mask_exp = load(ocean_mask_file_exp);
                end


                 % filter out points that are not expected to influence the storm

                 if (strcmp(ocean_mask_flag,'on')) & (exist(ocean_mask_file_control))
           
                    tmp_mat = control_totlh_hour_mat(:,:,t+1);
                    tmp_mat(ocean_mask_control.ocean_mask_mat(lon_index,lat_index)==0) = NaN;
                    control_totlh_hour_mat(:,:,t+1) = tmp_mat;

                    tmp_mat = exp_totlh_hour_mat(:,:,t+1);
                    tmp_mat(ocean_mask_exp.ocean_mask_mat(lon_index,lat_index)==0) = NaN;
                    exp_totlh_hour_mat(:,:,t+1) = tmp_mat;

                 end
%
            end  %t

            % compute mm/hr temporary matrices for daily total calculations

            tmp_cntrl_totlh_mat = control_totlh_hour_mat*0.0036*0.408;
            tmp_exp_totlh_mat = exp_totlh_hour_mat*0.0036*0.408;
            
            % convert total evaporation from W m^-2 to mm/day

            control_totlh_hour_mat = control_totlh_hour_mat*0.0864*0.408;
            exp_totlh_hour_mat = exp_totlh_hour_mat*0.0864*0.408;            

            % log date

            datenum_vec(mat_index,1) = datenum(y,m,d);

            % compute daily averages
            if (exist(ocean_mask_file_control))
            control_ocean_mask_heat_map_daily(:,:,mat_index) = ocean_mask_control.ocean_mask_heat_mat(lon_index,lat_index);
            exp_ocean_mask_heat_map_daily(:,:,mat_index) = ocean_mask_exp.ocean_mask_heat_mat(lon_index,lat_index);
            control_ocean_mask_daily(:,:,mat_index) = ocean_mask_control.ocean_mask_mat(lon_index,lat_index);
            exp_ocean_mask_daily(:,:,mat_index) = ocean_mask_exp.ocean_mask_mat(lon_index,lat_index);
            control_ocean_mask_time_daily(:,:,mat_index) = ocean_mask_control.ocean_mask_time_mat(lon_index,lat_index);
            exp_ocean_mask_time_daily(:,:,mat_index) = ocean_mask_exp.ocean_mask_time_mat(lon_index,lat_index);
            end


            control_totlh_ttot24_mat(:,:,mat_index) = sum(tmp_cntrl_totlh_mat,3,'omitnan');
            nan_index = (sum(isnan(tmp_cntrl_totlh_mat))==size(tmp_cntrl_totlh_mat,3));
            %nan_index = isnan(control_rzmc_tavg24_mat(:,:,mat_index));
            tmp = control_totlh_ttot24_mat(:,:,mat_index);
            tmp(nan_index) = NaN;
            control_totlh_ttot24_mat(:,:,mat_index) = tmp;

            exp_totlh_ttot24_mat(:,:,mat_index) = sum(tmp_exp_totlh_mat,3,'omitnan');
            nan_index = (sum(isnan(tmp_exp_totlh_mat))==size(tmp_exp_totlh_mat,3));
            tmp = exp_totlh_ttot24_mat(:,:,mat_index);
            tmp(nan_index) = NaN;
            exp_totlh_ttot24_mat(:,:,mat_index) = tmp;


            % reset hourly matrices

            control_totlh_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
            exp_totlh_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

        end %d
    end %m
end %y

disp('done reading data')

% remove excess allocated slots

datenum_vec((mat_index+1):end) = [];
control_totlh_ttot24_mat(:,:,(mat_index+1):end) = [];
exp_totlh_ttot24_mat(:,:,(mat_index+1):end) = [];
control_ocean_mask_heat_map_daily(:,:,(mat_index+1):end) = [];
exp_ocean_mask_heat_map_daily(:,:,(mat_index+1):end) = [];
control_ocean_mask_daily(:,:,(mat_index+1):end) = [];
exp_ocean_mask_daily(:,:,(mat_index+1):end) = [];
control_ocean_mask_time_daily(:,:,(mat_index+1):end) = [];
exp_ocean_mask_time_daily(:,:,(mat_index+1):end) = [];


%control_totlh_ttot24_mat_corr = NaN*ones(size(control_totlh_ttot24_mat)); 
%exp_totlh_ttot24_mat_corr = NaN*ones(size(exp_totlh_ttot24_mat));
%control_totsh_ttot24_mat_corr = NaN*ones(size(control_totsh_ttot24_mat));
%exp_totsh_ttot24_mat_corr = NaN*ones(size(exp_totsh_ttot24_mat));
%control_totevptrns_ttot24_mat_corr = NaN*ones(size(control_totevptrns_ttot24_mat));
%exp_totevptrns_ttot24_mat_corr = NaN*ones(size(exp_totevptrns_ttot24_mat));
%control_sfmc_tavg24_mat_corr = NaN*ones(size(control_sfmc_tavg24_mat));
%exp_sfmc_tavg24_mat_corr = NaN*ones(size(exp_sfmc_tavg24_mat));
%control_rzmc_tavg24_mat_corr = NaN*ones(size(control_rzmc_tavg24_mat));
%exp_rzmc_tavg24_mat_corr = NaN*ones(size(exp_rzmc_tavg24_mat));
%control_prmc_tavg24_mat_corr = NaN*ones(size(control_prmc_tavg24_mat));
%exp_prmc_tavg24_mat_corr = NaN*ones(size(exp_prmc_tavg24_mat));
%
%% compute matrices mixing correct time steps from land maks
%
%for i = 1:length(datenum_vec)
%
%    if (i>3)
%    lm_tmp = control_land_mask_heat_map_daily(:,:,i);
%    lm_tmp_exp = exp_land_mask_heat_map_daily(:,:,i);
%    sum_control_heat_mask(i) = sum(lm_tmp(:),'omitnan');
%
%    control_lh_tmp = zeros(size(control_totlh_ttot24_mat(:,:,i)));
%    control_sh_tmp = zeros(size(control_totsh_ttot24_mat(:,:,i)));
%    control_totevptrns_tmp = zeros(size(control_totevptrns_ttot24_mat(:,:,i)));
%    control_sfmc_tmp = zeros(size(control_sfmc_tavg24_mat(:,:,i)));
%    control_rzmc_tmp = zeros(size(control_rzmc_tavg24_mat(:,:,i)));
%    control_prmc_tmp = zeros(size(control_prmc_tavg24_mat(:,:,i)));
%
%    exp_lh_tmp = zeros(size(exp_totlh_ttot24_mat(:,:,i)));
%    exp_sh_tmp = zeros(size(exp_totsh_ttot24_mat(:,:,i)));
%    exp_totevptrns_tmp = zeros(size(exp_totevptrns_ttot24_mat(:,:,i)));
%    exp_sfmc_tmp = zeros(size(exp_sfmc_tavg24_mat(:,:,i)));
%    exp_rzmc_tmp = zeros(size(exp_rzmc_tavg24_mat(:,:,i)));
%    exp_prmc_tmp = zeros(size(exp_prmc_tavg24_mat(:,:,i)));
%
%    control_lh_count = zeros(size(control_totlh_ttot24_mat(:,:,i)));
%    control_sh_count = zeros(size(control_totsh_ttot24_mat(:,:,i)));
%    control_totevptrns_count = zeros(size(control_totevptrns_ttot24_mat(:,:,i)));
%    control_sfmc_count = zeros(size(control_sfmc_tavg24_mat(:,:,i)));
%    control_rzmc_count = zeros(size(control_rzmc_tavg24_mat(:,:,i)));
%    control_prmc_count = zeros(size(control_prmc_tavg24_mat(:,:,i)));
%
%    exp_lh_count = zeros(size(exp_totlh_ttot24_mat(:,:,i)));
%    exp_sh_count = zeros(size(exp_totsh_ttot24_mat(:,:,i)));
%    exp_totevptrns_count = zeros(size(exp_totevptrns_ttot24_mat(:,:,i)));
%    exp_sfmc_count = zeros(size(exp_sfmc_tavg24_mat(:,:,i)));
%    exp_rzmc_count = zeros(size(exp_rzmc_tavg24_mat(:,:,i)));
%    exp_prmc_count = zeros(size(exp_prmc_tavg24_mat(:,:,i)));
%
%    for j = 0:3
%
%        control_data_index = (control_land_mask_time_daily(:,:,i)==j);
%        control_data_index = control_data_index;
%
%        tmp = control_totlh_ttot24_mat(:,:,i-j);
%        control_lh_tmp(control_data_index) = control_lh_tmp(control_data_index) + tmp(control_data_index); 
%        control_lh_count(control_data_index) = control_lh_count(control_data_index) + 1;
%       % control_lh_tmp(control_data_index) = control_lh_tmp(control_data_index).*lm_tmp(control_index);
%
%        tmp = control_totsh_ttot24_mat(:,:,i-j);
%        control_sh_tmp(control_data_index) = control_sh_tmp(control_data_index) + tmp(control_data_index); 
%        control_sh_count(control_data_index) = control_sh_count(control_data_index) + 1;
%        %control_sh_tmp(control_data_index) = control_sh_tmp(control_data_index).*lm_tmp(control_index);
%
%        tmp = control_totevptrns_ttot24_mat(:,:,i-j);
%        control_totevptrns_tmp(control_data_index) = control_totevptrns_tmp(control_data_index) + tmp(control_data_index);
%        control_totevptrns_count(control_data_index) = control_totevptrns_count(control_data_index) + 1;
%        %control_totevptrns_tmp(control_data_index) = control_totevptrns_tmp(control_data_index).*lm_tmp(control_index);
%
%        tmp = control_sfmc_tavg24_mat(:,:,i-j);
%        control_sfmc_tmp(control_data_index) = control_sfmc_tmp(control_data_index) + tmp(control_data_index);
%        control_sfmc_count(control_data_index) = control_sfmc_count(control_data_index) + 1;
%        %control_sfmc_tmp(control_data_index) = control_sfmc_tmp(control_data_index).*lm_tmp(control_index);
%
%        tmp = control_rzmc_tavg24_mat(:,:,i-j);
%        control_rzmc_tmp(control_data_index) = control_rzmc_tmp(control_data_index) + tmp(control_data_index);
%        control_rzmc_count(control_data_index) = control_rzmc_count(control_data_index) + 1;
%        %control_rzmc_tmp(control_data_index) = control_rzmc_tmp(control_data_index).*lm_tmp(control_index);
%
%        tmp = control_prmc_tavg24_mat(:,:,i-j);
%        control_prmc_tmp(control_data_index) = control_prmc_tmp(control_data_index) + tmp(control_data_index);
%        control_prmc_count(control_data_index) = control_prmc_count(control_data_index) + 1;
%        %control_rzmc_tmp(control_data_index) = control_rzmc_tmp(control_data_index).*lm_tmp(control_index);
%
%        exp_data_index = (exp_land_mask_time_daily(:,:,i)==j);
%     %   exp_data_index = exp_data_index == 2;
%
%        tmp = exp_totlh_ttot24_mat(:,:,i-j);
%        exp_lh_tmp(exp_data_index) = exp_lh_tmp(exp_data_index) + tmp(exp_data_index);
%        exp_lh_count(exp_data_index) = exp_lh_count(exp_data_index) + 1;
%        %exp_lh_tmp(exp_data_index) = exp_lh_tmp(exp_data_index).*lm_tmp_exp(exp_index);
%
%        tmp = exp_totsh_ttot24_mat(:,:,i-j);
%        exp_sh_tmp(exp_data_index) = exp_sh_tmp(exp_data_index) + tmp(exp_data_index);
%        exp_sh_count(exp_data_index) = exp_sh_count(exp_data_index) + 1;
%        %exp_sh_tmp(exp_data_index) = exp_sh_tmp(exp_data_index).*lm_tmp_exp(exp_index);
%
%        tmp = exp_totevptrns_ttot24_mat(:,:,i-j);
%        exp_totevptrns_tmp(exp_data_index) = exp_totevptrns_tmp(exp_data_index) + tmp(exp_data_index);
%        exp_totevptrns_count(exp_data_index) = exp_totevptrns_count(exp_data_index) + 1;
%        %exp_totevptrns_tmp(exp_data_index) = exp_totevptrns_tmp(exp_data_index).*lm_tmp_exp(exp_index);
%
%        tmp = exp_sfmc_tavg24_mat(:,:,i-j);
%        exp_sfmc_tmp(exp_data_index) = exp_sfmc_tmp(exp_data_index) + tmp(exp_data_index);
%        exp_sfmc_count(exp_data_index) = exp_sfmc_count(exp_data_index) + 1;
%        % exp_sfmc_tmp(exp_data_index) = exp_sfmc_tmp(exp_data_index).*lm_tmp_exp(exp_index);
%
%        tmp = exp_rzmc_tavg24_mat(:,:,i-j);
%        exp_rzmc_tmp(exp_data_index) = exp_rzmc_tmp(exp_data_index) + tmp(exp_data_index);
%        exp_rzmc_count(exp_data_index) = exp_rzmc_count(exp_data_index) + 1;
%        %exp_rzmc_tmp(exp_data_index) = exp_rzmc_tmp(exp_data_index).*lm_tmp_exp(exp_index);
%
%        tmp = exp_prmc_tavg24_mat(:,:,i-j);
%        exp_prmc_tmp(exp_data_index) = exp_prmc_tmp(exp_data_index) + tmp(exp_data_index);
%        exp_prmc_count(exp_data_index) = exp_prmc_count(exp_data_index) + 1;
%        %exp_rzmc_tmp(exp_data_index) = exp_rzmc_tmp(exp_data_index).*lm_tmp_exp(exp_index);
%
%    end % j 
%
%    control_lh_tmp(control_lh_tmp==0) = NaN;
%    control_sh_tmp(control_sh_tmp==0) = NaN;
%    control_totevptrns_tmp(control_totevptrns_tmp==0) = NaN;
%    control_sfmc_tmp(control_sfmc_tmp==0) = NaN;
%    control_rzmc_tmp(control_rzmc_tmp==0) = NaN;
%    control_prmc_tmp(control_prmc_tmp==0) = NaN;
%
%    exp_lh_tmp(exp_lh_tmp==0) = NaN;
%    exp_sh_tmp(exp_sh_tmp==0) = NaN;
%    exp_totevptrns_tmp(exp_totevptrns_tmp==0) = NaN;
%    exp_sfmc_tmp(exp_sfmc_tmp==0) = NaN;
%    exp_rzmc_tmp(exp_rzmc_tmp==0) = NaN;
%    exp_prmc_tmp(exp_prmc_tmp==0) = NaN;
%
%    control_lh_count(control_lh_count==0) = NaN;
%    control_sh_count(control_sh_count==0) = NaN;
%    control_totevptrns_count(control_totevptrns_count==0) = NaN;
%    control_sfmc_count(control_sfmc_count==0) = NaN;
%    control_rzmc_count(control_rzmc_count==0) = NaN;
%    control_prmc_count(control_prmc_count==0) = NaN;
%
%    exp_lh_count(exp_lh_count==0) = NaN;
%    exp_sh_count(exp_sh_count==0) = NaN;
%    exp_totevptrns_count(exp_totevptrns_count==0) = NaN;
%    exp_sfmc_count(exp_sfmc_count==0) = NaN;
%    exp_rzmc_count(exp_rzmc_count==0) = NaN;
%    exp_prmc_count(exp_prmc_count==0) = NaN;
%
%    control_lh_tmp = control_lh_tmp./control_lh_count;
%    control_sh_tmp = control_sh_tmp./control_sh_count;
%    control_totevptrns_tmp = control_totevptrns_tmp./control_totevptrns_count;
%    control_sfmc_tmp = control_sfmc_tmp./control_sfmc_count;
%    control_rzmc_tmp = control_rzmc_tmp./control_rzmc_count;
%    control_prmc_tmp = control_prmc_tmp./control_prmc_count;
%
%    exp_lh_tmp = exp_lh_tmp./exp_lh_count;
%    exp_sh_tmp = exp_sh_tmp./exp_sh_count;
%    exp_totevptrns_tmp = exp_totevptrns_tmp./exp_totevptrns_count;
%    exp_sfmc_tmp = exp_sfmc_tmp./exp_sfmc_count;
%    exp_rzmc_tmp = exp_rzmc_tmp./exp_rzmc_count;
%    exp_prmc_tmp = exp_prmc_tmp./exp_prmc_count;
%
%    control_totlh_ttot24_mat_corr(:,:,i) = control_lh_tmp;
%    exp_totlh_ttot24_mat_corr(:,:,i) = exp_lh_tmp;
%    control_totsh_ttot24_mat_corr(:,:,i) = control_sh_tmp;
%    exp_totsh_ttot24_mat_corr(:,:,i) = exp_sh_tmp;
%    control_totevptrns_ttot24_mat_corr(:,:,i) = control_totevptrns_tmp;
%    exp_totevptrns_ttot24_mat_corr(:,:,i) = exp_totevptrns_tmp;
%    control_sfmc_tavg24_mat_corr(:,:,i) = control_sfmc_tmp;
%    exp_sfmc_tavg24_mat_corr(:,:,i) = exp_sfmc_tmp;
%    control_rzmc_tavg24_mat_corr(:,:,i) = control_rzmc_tmp;
%    exp_rzmc_tavg24_mat_corr(:,:,i) = exp_rzmc_tmp;
%    control_prmc_tavg24_mat_corr(:,:,i) = control_prmc_tmp;
%    exp_prmc_tavg24_mat_corr(:,:,i) = exp_prmc_tmp;
%
%    end % if 
%
%
%end 
%
%
%% compute differences between experiment and control
%
%diff_sfmc_tavg24_mat = exp_sfmc_tavg24_mat_corr - control_sfmc_tavg24_mat_corr;
%diff_rzmc_tavg24_mat = exp_rzmc_tavg24_mat_corr - control_rzmc_tavg24_mat_corr;
%diff_prmc_tavg24_mat = exp_prmc_tavg24_mat_corr - control_prmc_tavg24_mat_corr;
%diff_totevptrns_ttot24_mat = exp_totevptrns_ttot24_mat_corr - control_totevptrns_ttot24_mat_corr;
%diff_KEint_tavg24_mat = exp_KEint_tavg24_mat - control_KEint_tavg24_mat;
%diff_QVint_tavg24_mat = exp_QVint_tavg24_mat - control_QVint_tavg24_mat;


% create animation and plot of differences

% define plot domain
[lon_mat,lat_mat] = meshgrid(lon_vec,lat_vec);
load coastlines;
%[latcells, loncells] = polysplit(coastlat, coastlon);
latlim = lat_range;
lonlim = lon_range;


mean_totlh_control = NaN*ones(length(datenum_vec),1);
mean_totlh_exp = NaN*ones(length(datenum_vec),1);
cum_totlh_control = zeros(length(datenum_vec),1);
cum_totlh_exp = zeros(length(datenum_vec),1);

for i = 1:length(datenum_vec)
   

    if (i>3)
    lm_tmp = control_ocean_mask_heat_map_daily(:,:,i);
    sum_control_heat_mask(i) = sum(lm_tmp(:),'omitnan'); 


    control_lh_tmp = zeros(size(control_totlh_ttot24_mat(:,:,i)));

    for j = 1:3

        control_data_index = control_ocean_mask_daily(:,:,i) + (control_ocean_mask_time_daily(:,:,i)==j);
        control_data_index = control_data_index == 2;

        tmp = control_totlh_ttot24_mat(:,:,i-j);
        control_lh_tmp = control_lh_tmp + tmp.*lm_tmp;
        control_lh_tmp = control_lh_tmp;


    end 

    control_lh_tmp(control_lh_tmp==0) = NaN;

    mean_totlh_control(i) = sum(control_lh_tmp(:),'omitnan')./sum(3*lm_tmp(:),'omitnan');

    lm_tmp = exp_ocean_mask_heat_map_daily(:,:,i);
    sum_exp_heat_mask(i) = sum(lm_tmp(:),'omitnan');


    exp_lh_tmp = zeros(size(exp_totlh_ttot24_mat(:,:,i)));

    for j = 1:3

        exp_data_index = exp_ocean_mask_daily(:,:,i) + (exp_ocean_mask_time_daily(:,:,i)==j);
        exp_data_index = exp_data_index == 2;

        tmp = exp_totlh_ttot24_mat(:,:,i-j);
        exp_lh_tmp = exp_lh_tmp + tmp.*lm_tmp;
        exp_lh_tmp = exp_lh_tmp;

    end

    exp_lh_tmp(exp_lh_tmp==0) = NaN;

    mean_totlh_exp(i) = sum(exp_lh_tmp(:),'omitnan')./sum(3*lm_tmp(:),'omitnan');

    if (i==1)
     
        cum_totlh_control(i) = mean_totlh_control(i);
        cum_totlh_exp(i) = mean_totlh_exp(i);

    else
        cum_totlh_control(i) = cum_totlh_control(i-1) + mean_totlh_control(i);
        cum_totlh_exp(i) = cum_totlh_exp(i-1) + mean_totlh_exp(i);

    end 
    end 
end 

mean_totlh_plot_mat = [mean_totlh_exp mean_totlh_control];

figure
bar(datenum_vec,mean_totlh_plot_mat)
datetick('x','dd-mmm')
xlabel('Day')
title('mean latent heat [mm]')
h=legend('SMAP DA','Control','Location','northwest')
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,[save_path storm_name '_mean_LH_bar_interp_ocean'],'png')


cum_totlh_plot_mat = [cum_totlh_exp cum_totlh_control];

figure
bar(datenum_vec,cum_totlh_plot_mat)
datetick('x','dd-mmm')
xlabel('Day')
title('cumulative latent heat [mm]')
h=legend('SMAP DA','Control','Location','northwest')
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,[save_path storm_name '_cum_LH_bar_interp_ocean'],'png')



figure 
colororder({'k','k'})
yyaxis left 
plot(datenum_vec(4:end),mean_totlh_plot_mat(4:end,2),'--','Color',[0.7 0.7 0.7],'LineWidth',4)
hold on 
plot(datenum_vec(4:end),mean_totlh_plot_mat(4:end,1),'--k','LineWidth',2)
ylabel('mean daily latent heat [mm]', 'FontSize',14)
yyaxis right
plot(datenum_vec(4:end),cum_totlh_plot_mat(4:end,2),'-','Color',[0.7 0.7 0.7],'LineWidth',4)
hold on
plot(datenum_vec(4:end),cum_totlh_plot_mat(4:end,1),'-k','LineWidth',2)
ylabel('cumulative daily latent heat [mm]', 'FontSize',14)
grid on
datetick('x','dd')
ax= gca;
ax.FontSize = 14;
xlabel('March', 'FontSize',14)
title('ocean latent heat [mm]', 'FontSize',14)
%legend('mean SMAP\_FCST','mean CNTRL\_FCST','cumulative SMAP\_FCST','cumulative CNTRL\_FCST','Location','northwest','FontSize',14)
%set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,[save_path storm_name '_mean_cum_LH_line_ocean'],'png')


sum_heat_mask = [sum_exp_heat_mask' sum_control_heat_mask'];

sum_heat_mask_area = sum_heat_mask*209.7;
    
figure
plot(datenum_vec(4:end),sum_heat_mask_area(4:end,2),'--','Color',[0.7 0.7 0.7],'LineWidth',4)
hold on 
plot(datenum_vec(4:end),sum_heat_mask_area(4:end,1),'--k','LineWidth',2)
grid on
datetick('x','dd')
ax= gca;
ax.FontSize = 14;
xlabel('March', 'FontSize',14)
ylabel('Contributing ocean area [km^2]','FontSize',14)
title('(a) Contributing ocean area [km^2]','FontSize',14)
legend('CNTRL\_ANA','SMAP\_ANA','Location','northeast')
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,[save_path storm_name '_heat_map_area_line_interp_ocean'],'png')
