clc
clear all 
close all

%-----------------------------------------
% EXPERIMENT DEFINITION
%-----------------------------------------

storm_name = 'Idai';
save_path = ['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/' storm_name '/'];

control_dir = ['/discover/nobackup/projects/smaptc/jkolassa/archive/' storm_name '/'];
control_name = 'LADAS_control_4D_new';
exp_dir = ['/discover/nobackup/projects/smaptc/jkolassa/archive/' storm_name '/'];
exp_name = 'Idai_SMAP_4D';
                    
lat_range = [-24 -10];
lon_range = [24 52];
                
%start_year = 2019;
%start_month = 2;
%start_day = 4; 
                
start_year = 2019;
start_month = 3;
start_day = 1;  
                
%end_year = 2019;
%end_month = 3; 
%end_day = 22;  
                
end_year = 2019;
end_month = 3;  
end_day = 15;  

%---------------------------------------------
% DATA READ PREPARATION
%---------------------------------------------

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];
mat_index = 0;
mask_index  = 0;
month_vec = ['Jan';'Feb';'Mar';'Apr';'May';,'Jun';'Jul';'Aug';'Sep';'Oct';'Nov';'Dec'];

%---------------------------------------------
% DATA READ
%---------------------------------------------

% read track data

track_file = ['/discover/nobackup/jkolassa/SMAP_TC_project/track_files/' storm_name '_track.ascii'];
track_data = dlmread(track_file);
track_datenum = datenum(start_year, track_data(:,1), track_data(:,2), track_data(:,3), 0, 0);

% define latitude and longitude index for domain

coord_file = [control_dir control_name '/diag/Y' num2str(start_year,'%04i') '/M' num2str(start_month,'%02i') ...
             '/' control_name '.tavg1_2d_lnd_Nx.' num2str(start_year,'%04i') num2str(start_month,'%02i') ...
              num2str(start_day,'%02i') '_2130z.nc4'];

lat_vec = double(ncread(coord_file,'lat'));
lon_vec = double(ncread(coord_file,'lon'));

lat_index = (lat_vec<lat_range(1)) + (lat_vec>lat_range(2));
lat_index = lat_index == 0;
lon_index = (lon_vec<lon_range(1)) + (lon_vec>lon_range(2));
lon_index = lon_index == 0;

coord_ana_file = [control_dir control_name '/ana/Y' num2str(start_year,'%04i') '/M' num2str(start_month,'%02i') '/' control_name ... 
                 '.ana.inst3d_met_p.' num2str(start_year,'%04i') num2str(start_month,'%02i') num2str(start_day,'%02i')...
                 '_2100z.nc4'];

lat_vec_coarse = double(ncread(coord_ana_file,'lat'));
lon_vec_coarse = double(ncread(coord_ana_file,'lon'));

lat_index_coarse = (lat_vec_coarse<lat_range(1)) + (lat_vec_coarse>lat_range(2));
lat_index_coarse = lat_index_coarse == 0;
lon_index_coarse = (lon_vec_coarse<lon_range(1)) + (lon_vec_coarse>lon_range(2));
lon_index_coarse = lon_index_coarse == 0;

% loop over years
for y = start_year:end_year

    disp('read data')

    y_str = num2str(y,'%04i');

    % define month length based on leap year status
    if sum(y==leapYears)>0
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end

% loop over months
    for m = start_month:end_month

        m_str = num2str(m,'%02i');

        % define start and end day for current month
        day_first = 1;
        day_last = monthLength(m);

        if (m == start_month)
           day_first = start_day;
        end

        if (m == end_month)
           day_last = end_day;
        end

        % loop over days
        for d = day_first:day_last
             d
            mat_index = mat_index + 1;

            d_str = num2str(d,'%02i');

            % loop over time steps
            for t = 0:23
                t
                mask_index = mask_index + 1;

                t_str = num2str(t,'%02i');

                % define diagnostic file names
                control_diag_file = [control_dir control_name '/diag/Y' y_str '/M' m_str '/' control_name ...
                                    '.tavg1_2d_lnd_Nx.' y_str m_str d_str '_' t_str '30z.nc4'];

                exp_diag_file = [exp_dir exp_name '/diag/Y' y_str '/M' m_str '/' exp_name ... 
                                '.tavg1_2d_lnd_Nx.' y_str m_str d_str '_' t_str '30z.nc4'];

                control_ana_file = [control_dir control_name '/ana/Y' y_str '/M' m_str '/' control_name ...
                                    '.ana.inst3d_met_p.' y_str m_str d_str '_' t_str '00z.nc4'];

                exp_ana_file = [exp_dir exp_name '/ana/Y' y_str '/M' m_str '/' exp_name ...
                                '.ana.inst3d_met_p.' y_str m_str d_str '_' t_str '00z.nc4'];

                % on first time step read coordinate information and initialize matrices

                if (mat_index == 1) && (t == 0)

                   datenum_vec = NaN*ones(sum(monthLength(start_month:end_month)),1);

                   control_QVint_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_QVint_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));

                   control_TCMint_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_TCMint_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));

                   control_u_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_u_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));

                   control_v_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));
                   exp_v_tavg24_mat = NaN*ones(sum(lon_index),sum(lat_index),sum(monthLength(start_month:end_month)));

                   control_QVint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
                   exp_QVint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

                   control_TCMint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
                   exp_TCMint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

                   control_u_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
                   exp_u_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

                   control_v_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
                   exp_v_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

                end % if

                % read hourly data

                % read in wind data for filtering

                control_hPa = double(ncread(control_ana_file,'lev'));
                control_level_index = find(control_hPa>=150);
                tmp_read_mat = double(ncread(control_ana_file,'U'));
                control_u_mat = tmp_read_mat(lon_index_coarse,lat_index_coarse,control_level_index);
                tmp_read_mat = double(ncread(control_ana_file,'V'));
                control_v_mat = tmp_read_mat(lon_index_coarse,lat_index_coarse,control_level_index);
                tmp_read_mat = double(ncread(control_ana_file,'T'));
                control_temp_mat = tmp_read_mat(lon_index_coarse,lat_index_coarse,control_level_index);
                tmp_read_mat = double(ncread(control_ana_file,'QV'));
                control_qv_mat = tmp_read_mat(lon_index_coarse,lat_index_coarse,control_level_index);
                tmp_read_mat = double(ncread(control_ana_file,'H'));
                control_h_mat = tmp_read_mat(lon_index_coarse,lat_index_coarse,control_level_index);


                tmp_read_mat = double(ncread(control_ana_file,'lat'));
                control_ana_lat = tmp_read_mat(lat_index_coarse);
                tmp_read_mat = double(ncread(control_ana_file,'lon'));
                control_ana_lon = tmp_read_mat(lon_index_coarse);

                exp_hPa = double(ncread(exp_ana_file,'lev'));
                exp_level_index = find(exp_hPa>=600);
                tmp_read_mat = double(ncread(exp_ana_file,'U'));
                exp_u_mat = tmp_read_mat(lon_index,lat_index,control_level_index);
                tmp_read_mat = double(ncread(exp_ana_file,'V'));
                exp_v_mat = tmp_read_mat(lon_index,lat_index,control_level_index);
                tmp_read_mat = double(ncread(exp_ana_file,'T'));
                exp_temp_mat = tmp_read_mat(lon_index,lat_index,control_level_index);
                tmp_read_mat = double(ncread(exp_ana_file,'QV'));
                exp_qv_mat = tmp_read_mat(lon_index,lat_index,control_level_index);
                tmp_read_mat = double(ncread(exp_ana_file,'H'));
                exp_h_mat = tmp_read_mat(lon_index_coarse,lat_index_coarse,control_level_index);


                tmp_read_mat = double(ncread(exp_ana_file,'lat'));
                exp_ana_lat = tmp_read_mat(lat_index);
                tmp_read_mat = double(ncread(exp_ana_file,'lon'));
                exp_ana_lon = tmp_read_mat(lon_index);

                [exp_ana_lat_mat,exp_ana_lon_mat] = meshgrid(exp_ana_lat,exp_ana_lon);

                control_KE_lev = NaN*ones(sum(lon_index),sum(lat_index),length(exp_level_index));
                exp_KE_lev = NaN*ones(sum(lon_index),sum(lat_index),length(exp_level_index));

                control_QV_lev = NaN*ones(sum(lon_index),sum(lat_index),length(exp_level_index));
                exp_QV_lev = exp_qv_mat;

                control_TCM_lev = NaN*ones(sum(lon_index),sum(lat_index),length(exp_level_index));
                exp_TCM_lev = NaN*ones(sum(lon_index),sum(lat_index),length(exp_level_index));

                for l = 1:length(exp_level_index)

                    control_u_interp_mat = interp2(control_ana_lat,control_ana_lon,control_u_mat(:,:,l),exp_ana_lat_mat,exp_ana_lon_mat);
                    control_v_interp_mat = interp2(control_ana_lat,control_ana_lon,control_v_mat(:,:,l),exp_ana_lat_mat,exp_ana_lon_mat);
                    control_temp_interp_mat = interp2(control_ana_lat,control_ana_lon,control_temp_mat(:,:,l),exp_ana_lat_mat,exp_ana_lon_mat);
                    control_QV_lev(:,:,l) = interp2(control_ana_lat,control_ana_lon,control_qv_mat(:,:,l),exp_ana_lat_mat,exp_ana_lon_mat);
                    control_h_interp_mat = interp2(control_ana_lat,control_ana_lon,control_h_mat(:,:,l),exp_ana_lat_mat,exp_ana_lon_mat);


                    control_rho_mat = 1000*control_hPa(l)./(287*control_temp_interp_mat);
                    exp_rho_mat = 1000*exp_hPa(l)./(287*exp_temp_mat(:,:,l));

                    control_ws_mat = sqrt((control_u_interp_mat).^2 + (control_v_interp_mat).^2);
                    exp_ws_mat = sqrt((exp_u_mat(:,:,l)).^2 + (exp_v_mat(:,:,l)).^2);

                    %control_TCM_tmp = 1/(1000*9.81)*control_QV_tmp*(control_hPa(exp_level_index)-control_hPa(exp_level_index+1))*1000; % total layer water content in m
                   % exp_TCM_tmp = 1/(1000*9.81)*exp_QV_tmp*(exp_hPa(exp_level_index)-exp_hPa(exp_level_index+1))*1000; %total layer water content in m

                    % remove points outside of tropical cyclone (wind speed exceeds 17 m/s)

                    TC_index_control = control_ws_mat >= 17;
                    TC_index_exp = exp_ws_mat >= 17;

                    control_QV_tmp = control_QV_lev(:,:,l);
                    exp_QV_tmp = exp_QV_lev(:,:,l);

                    control_QV_tmp(TC_index_control==0) = NaN;
                    exp_QV_tmp(TC_index_exp==0) = NaN;

                    control_QV_lev(:,:,l) = control_QV_tmp;
                    exp_QV_lev(:,:,l) = exp_QV_tmp;

                    control_TCM_tmp = 1/(1000*9.81)*control_QV_tmp.*(control_hPa(exp_level_index(l))-control_hPa(exp_level_index(l)+1))*1000; % total layer water content in m
                    exp_TCM_tmp = 1/(1000*9.81)*exp_QV_tmp.*(exp_hPa(exp_level_index(l))-exp_hPa(exp_level_index(l)+1))*1000; %total layer water content in m

                    control_TCM_lev(:,:,l) = control_TCM_tmp*1000;  % convert from m of water to mm of water
                    exp_TCM_lev(:,:,l) = exp_TCM_tmp*1000;          % convert from m of water to mm of water

                end % l

                for l = 1:size(control_u_mat,3)

                    control_u_interp_mat_allLevels(:,:,l) = interp2(control_ana_lat,control_ana_lon,control_u_mat(:,:,l),exp_ana_lat_mat,exp_ana_lon_mat,'cubic');
                    control_v_interp_mat_allLevels(:,:,l) = interp2(control_ana_lat,control_ana_lon,control_v_mat(:,:,l),exp_ana_lat_mat,exp_ana_lon_mat,'cubic');
                end %l 

                control_QVint_hour_mat(:,:,t+1) = sum(control_QV_lev,3,'omitnan');
                nan_mat = isnan(control_QV_lev);
                nan_sum = sum(nan_mat,3);
                nan_index = (nan_sum == length(exp_level_index));
                control_tmp = control_QVint_hour_mat(:,:,t+1);
                control_tmp(nan_index) = NaN;
                control_QVint_hour_mat(:,:,t+1) = control_tmp;

                exp_QVint_hour_mat(:,:,t+1) = sum(exp_QV_lev,3,'omitnan');
                nan_mat = isnan(exp_QV_lev);
                nan_sum = sum(nan_mat,3);
                nan_index = (nan_sum == length(exp_level_index));
                exp_tmp = exp_QVint_hour_mat(:,:,t+1);
                exp_tmp(nan_index) = NaN;
                exp_QVint_hour_mat(:,:,t+1) = exp_tmp;

                control_TCMint_hour_mat(:,:,t+1) = sum(control_TCM_lev,3,'omitnan');
                nan_mat = isnan(control_TCM_lev);
                nan_sum = sum(nan_mat,3);
                nan_index = (nan_sum == length(exp_level_index));
                control_tmp = control_TCMint_hour_mat(:,:,t+1);
                control_tmp(nan_index) = NaN;
                control_TCMint_hour_mat(:,:,t+1) = control_tmp;

                exp_TCMint_hour_mat(:,:,t+1) = sum(exp_TCM_lev,3,'omitnan');
                nan_mat = isnan(exp_TCM_lev);
                nan_sum = sum(nan_mat,3);
                nan_index = (nan_sum == length(exp_level_index));
                exp_tmp = exp_TCMint_hour_mat(:,:,t+1);
                exp_tmp(nan_index) = NaN;
                exp_TCMint_hour_mat(:,:,t+1) = exp_tmp;

                surface_level_index = find(control_hPa==850);
                control_u_hour_mat(:,:,t+1) = control_u_interp_mat_allLevels(:,:,surface_level_index);
                exp_u_hour_mat(:,:,t+1) = exp_u_mat(:,:,surface_level_index);
                control_v_hour_mat(:,:,t+1) = control_v_interp_mat_allLevels(:,:,surface_level_index);
                exp_v_hour_mat(:,:,t+1) = exp_v_mat(:,:,surface_level_index);



            end  %t

            % log date

            datenum_vec(mat_index,1) = datenum(y,m,d);

            % compute daily averages
            control_QVint_tavg24_mat(:,:,mat_index) = nanmean(control_QVint_hour_mat,3);
            exp_QVint_tavg24_mat(:,:,mat_index) = nanmean(exp_QVint_hour_mat,3);
             
            control_TCMint_tavg24_mat(:,:,mat_index) = nanmean(control_TCMint_hour_mat,3);
            exp_TCMint_tavg24_mat(:,:,mat_index) = nanmean(exp_TCMint_hour_mat,3);

            control_u_tavg24_mat(:,:,mat_index) = nanmean(control_u_hour_mat,3);
            exp_u_tavg24_mat(:,:,mat_index) = nanmean(exp_u_hour_mat,3);

            control_v_tavg24_mat(:,:,mat_index) = nanmean(control_v_hour_mat,3);
            exp_v_tavg24_mat(:,:,mat_index) = nanmean(exp_v_hour_mat,3);

            % reset hourly matrices
            control_QVint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
            exp_QVint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

            control_TCMint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
            exp_TCMint_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

            control_u_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
            exp_u_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

            control_v_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);
            exp_v_hour_mat = NaN*ones(sum(lon_index),sum(lat_index),24);

        end %d
    end %m
end %y

disp('done reading data')

% remove excess allocated slots
control_QVint_tavg24_mat(:,:,(mat_index+1):end) = [];
exp_QVint_tavg24_mat(:,:,(mat_index+1):end) = [];
control_TCMint_tavg24_mat(:,:,(mat_index+1):end) = [];
exp_TCMint_tavg24_mat(:,:,(mat_index+1):end) = [];
control_u_tavg24_mat(:,:,(mat_index+1):end) = [];
exp_u_tavg24_mat(:,:,(mat_index+1):end) = [];
control_v_tavg24_mat(:,:,(mat_index+1):end) = [];
exp_v_tavg24_mat(:,:,(mat_index+1):end) = [];
datenum_vec((mat_index+1):end) = [];

% compute difference matrix

diff_QVint_tavg24_mat = exp_QVint_tavg24_mat - control_QVint_tavg24_mat;

% define plot domain
load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);
latlim = lat_range;
lonlim = lon_range;

% define colorbars and limits
                
lat_index = (lat_vec<lat_range(1)) + (lat_vec>lat_range(2));
lat_index = lat_index == 0;
lon_index = (lon_vec<lon_range(1)) + (lon_vec>lon_range(2));
lon_index = lon_index == 0;

s1 = quantile(diff_QVint_tavg24_mat(:),0.99);
s2 = quantile(diff_QVint_tavg24_mat(:),0.01);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_min = round(caxis_min,2);
caxis_max = max(abs(s1),abs(s2));
caxis_max = round(caxis_max,2);

c_length = caxis_max/0.01;
c_length = c_length*2;

cmap_mat = cmocean('balance',c_length);
cmap_mat = flipud(cmap_mat);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = 0.85*ones(2,3);
cmap = cmap_mat;

s1 = quantile(control_QVint_tavg24_mat(:),0.99);
s2 = quantile(control_QVint_tavg24_mat(:),0.01);
caxis_min_abs = s2;
caxis_min_abs = round(caxis_min_abs,2);
caxis_max_abs = s1;
caxis_max_abs = round(caxis_max_abs,2);

c_length = (caxis_max_abs-caxis_min_abs)/0.01;

cmap_mat_abs = cmocean('deep',c_length);
%cmap_mat_abs = flipud(cmap_mat_abs);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = 0.85*ones(2,3);
cmap_abs = cmap_mat_abs;

s1 = quantile(exp_TCMint_tavg24_mat(:),0.99);
s2 = quantile(exp_TCMint_tavg24_mat(:),0.01);
caxis_min_tcm = s2;
caxis_min_tcm = round(caxis_min_tcm,2);
caxis_max_tcm = s1;
caxis_max_tcm = round(caxis_max_tcm,2);

c_length = (caxis_max_tcm-caxis_min_tcm)/0.01;

cmap_mat_tcm = cmocean('deep',c_length);
%cmap_mat_abs = flipud(cmap_mat_abs);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = 0.85*ones(2,3);
cmap_tcm = cmap_mat_tcm;

[lon_mat,lat_mat] = meshgrid(lon_vec(lon_index),lat_vec(lat_index));

for i = 1:size(control_QVint_tavg24_mat,3)

    datenum_dist = sqrt((track_datenum-datenum_vec(i)).^2);
    date_index = find(datenum_dist==min(datenum_dist));

    figure 
    ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
               'FLatLimit',lat_range,'FLonLimit',lon_range);
    framem 
    gridm on;
    setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
         'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
          'MLabelParallel','south','FontSize',12)
    geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
    pcolorm(lat_vec(lat_index),lon_vec(lon_index),diff_QVint_tavg24_mat(:,:,i)')
    caxis([caxis_min caxis_max]);
    set(gcf,'Colormap',cmap);
    plotm(coastlat, coastlon,'k')
    hold on
    plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-m','LineWidth',2)
    hold off
    set(gca,'XLim',lonlim);
    set(gca,'YLim',latlim);
    tightmap
    title(['\Delta QVint (EXP - CTRL) [kg/kg] ' datestr(datenum_vec(i),'yyyy-mm-dd')])
    h = colorbar;
    set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 17 15])
    saveas(gcf,[save_path storm_name '_diag_QVint_diff_' datestr(datenum_vec(i),'yyyy-mm-dd')],'png')

    figure
    ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
               'FLatLimit',lat_range,'FLonLimit',lon_range);
    framem
    gridm on;
    setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
         'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
          'MLabelParallel','south','FontSize',12)
    geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
    pcolorm(lat_vec(lat_index),lon_vec(lon_index),control_QVint_tavg24_mat(:,:,i)')
    caxis([caxis_min_abs caxis_max_abs]);
    set(gcf,'Colormap',cmap_abs);
    plotm(coastlat, coastlon,'k')
    hold on
    quiverm(lat_mat,lon_mat,control_v_tavg24_mat(:,:,i)',control_u_tavg24_mat(:,:,i)','color','k','scale','off')
    hold on 
    plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-m','LineWidth',2)
    hold off
    set(gca,'XLim',lonlim);
    set(gca,'YLim',latlim);
    tightmap
    title([' QVint [kg/kg] ' datestr(datenum_vec(i),'yyyy-mm-dd')])
    h = colorbar;
    set(h,'Location','southoutside','Orientation','horizontal','FontSize',14);
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 17 15])
    saveas(gcf,[save_path storm_name '_diag_QVint_control_' datestr(datenum_vec(i),'yyyy-mm-dd')],'png')

    figure
    ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
               'FLatLimit',lat_range,'FLonLimit',lon_range);
    framem
    gridm on;
    setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
         'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
          'MLabelParallel','south','FontSize',12)    
    geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])   
    pcolorm(lat_vec(lat_index),lon_vec(lon_index),exp_QVint_tavg24_mat(:,:,i)')
    caxis([caxis_min_abs caxis_max_abs]);
    set(gcf,'Colormap',cmap_abs);
    plotm(coastlat, coastlon,'k')
    hold on
    quiverm(lat_mat,lon_mat,exp_v_tavg24_mat(:,:,i)',exp_u_tavg24_mat(:,:,i)','color','k','scale','off')
    hold on
    plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-m','LineWidth',2)
    hold off
    set(gca,'XLim',lonlim);
    set(gca,'YLim',latlim);
    tightmap
    title([' QVint [kg/kg] ' datestr(datenum_vec(i),'yyyy-mm-dd')])
    h = colorbar;
    set(h,'Location','southoutside','Orientation','horizontal','FontSize',14);
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 17 15])
    saveas(gcf,[save_path storm_name '_diag_QVint_exp_' datestr(datenum_vec(i),'yyyy-mm-dd')],'png')

    figure
    ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
               'FLatLimit',lat_range,'FLonLimit',lon_range);
    framem
    gridm on;
    setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
         'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
          'MLabelParallel','south','FontSize',12)
    geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
    pcolorm(lat_vec(lat_index),lon_vec(lon_index),control_TCMint_tavg24_mat(:,:,i)')
    caxis([caxis_min_tcm caxis_max_tcm]);
    set(gcf,'Colormap',cmap_tcm);
    plotm(coastlat, coastlon,'k')
    hold on
%    quiverm(lat_mat,lon_mat,control_v_tavg24_mat(:,:,i)',control_u_tavg24_mat(:,:,i)','color','k','scale','off')
%    hold on
    bordersm('countries','k')
    hold on
    plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-m','LineWidth',2)
    hold off
    set(gca,'XLim',lonlim);
    set(gca,'YLim',latlim);
    tightmap
    title([' TCM [mm] ' datestr(datenum_vec(i),'yyyy-mm-dd')])
    h = colorbar;
    set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 17 15])
    saveas(gcf,[save_path storm_name '_diag_TCM_control_' datestr(datenum_vec(i),'yyyy-mm-dd')],'png')

    figure
    ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
               'FLatLimit',lat_range,'FLonLimit',lon_range);
    framem
    gridm on;
    setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
         'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
          'MLabelParallel','south','FontSize',12)
    geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
    pcolorm(lat_vec(lat_index),lon_vec(lon_index),exp_TCMint_tavg24_mat(:,:,i)')
    caxis([caxis_min_tcm caxis_max_tcm]);
    set(gcf,'Colormap',cmap_tcm);
    plotm(coastlat, coastlon,'k')
    hold on
%    quiverm(lat_mat,lon_mat,exp_v_tavg24_mat(:,:,i)',exp_u_tavg24_mat(:,:,i)','color','k','scale','off')
%    hold on
    bordersm('countries','k')
    hold on
    plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-m','LineWidth',2)
    hold off
    set(gca,'XLim',lonlim);
    set(gca,'YLim',latlim);
    tightmap
    title([' TCM [mm] ' datestr(datenum_vec(i),'yyyy-mm-dd')])
    h = colorbar;
    set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
    set(gcf,'paperunits','centimeters')
    set(gcf,'paperposition',[1 1 17 15])
    saveas(gcf,[save_path storm_name '_diag_TCM_exp_' datestr(datenum_vec(i),'yyyy-mm-dd')],'png')
end

%lat_range = [-90 90];
%lon_range = [-180 180];

[lon_mat,lat_mat] = meshgrid(lon_vec(lon_index),lat_vec(lat_index));

figure
ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
           'FLatLimit',lat_range,'FLonLimit',lon_range);
framem
gridm on;
setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
     'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
     'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
quiverm(lat_mat,lon_mat,exp_v_tavg24_mat(:,:,4)',exp_u_tavg24_mat(:,:,4)')
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,[save_path storm_name 'test'],'png')


cum_TCMint_control = zeros(length(datenum_vec),1);
cum_TCMint_exp = zeros(length(datenum_vec),1);

mean_TCMint_control = zeros(length(datenum_vec),1);
mean_TCMint_exp = zeros(length(datenum_vec),1);

for i = 1:length(datenum_vec)

    if (i>3)

    tmp = exp_TCMint_tavg24_mat(:,:,i);
    mean_TCMint_exp(i) = nanmean(tmp(:));

    tmp = control_TCMint_tavg24_mat(:,:,i);
    mean_TCMint_control(i) = nanmean(tmp(:));

    if (i==1)

        cum_TCMint_control(i) = mean_TCMint_control(i);
        cum_TCMint_exp(i) = mean_TCMint_exp(i);
    else

        cum_TCMint_control(i) = cum_TCMint_control(i-1) + mean_TCMint_control(i);
        cum_TCMint_exp(i) = cum_TCMint_exp(i-1) + mean_TCMint_exp(i);
    end
    end
end

mean_TCMint_plot_mat = [mean_TCMint_exp mean_TCMint_control];
cum_TCMint_plot_mat = [cum_TCMint_exp cum_TCMint_control];

figure
colororder({'k','k'})
yyaxis left
plot(datenum_vec(4:end),mean_TCMint_plot_mat(4:end,2),'--','Color',[0.7 0.7 0.7],'LineWidth',4)
hold on
plot(datenum_vec(4:end),mean_TCMint_plot_mat(4:end,1),'--k','LineWidth',2)
ylabel('mean TCM [mm]', 'FontSize',14)
yyaxis right
plot(datenum_vec(4:end),cum_TCMint_plot_mat(4:end,2),'-','Color',[0.7 0.7 0.7],'LineWidth',4)
hold on
plot(datenum_vec(4:end),cum_TCMint_plot_mat(4:end,1),'-k','LineWidth',2)
ylabel('cumulative TCM [mm]', 'FontSize',14)
grid on
datetick('x','dd')
ax= gca;
ax.FontSize = 14;
xlabel('March', 'FontSize',14)
title('(e) total column moisture [mm]', 'FontSize',14)
%legend('mean SMAP\_FCST','mean CNTRL\_FCST','cumulative SMAP\_FCST','cumulative CNTRL\_FCST','Location','northwest','FontSize',14)
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,[save_path storm_name '_mean_cum_TCM_line'],'png')
