clc
clear all
close all

% make selections
storm_name = 'Idai';
save_path = ['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/' storm_name '/'];

start_date = '20190204';
stop_date = '20190322';
lat_range = [-24 -10];      % [southern_border northern_border]
lon_range = [24 52];  % [western_border eastern_border]

smap_stream = 'Vv6032';
ol_stream = 'OL6000';

% convert selections
smap_l4_path = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/gph/'];
smap_ol_path = ['/css/smapl4/public/Model-Only/SoilMoisture/' ol_stream '/gph/'];

start_year = str2double(start_date(1:4));
start_month = str2double(start_date(5:6));
start_day = str2double(start_date(7:8));
stop_year = str2double(stop_date(1:4));
stop_month = str2double(stop_date(5:6));
stop_day = str2double(stop_date(7:8));

% read track data

track_file = ['/discover/nobackup/jkolassa/SMAP_TC_project/track_files/' storm_name '_track.ascii'];
track_data = dlmread(track_file);
track_datenum = datenum(start_year, track_data(:,1), track_data(:,2), track_data(:,3), 0, 0);

t_vec = {'0130' '0430' '0730' '1030' '1330' '1630' '1930' '2230'};
month_length = [31 28 31 30 31 30 31 31 30 31 30 31];

mat_index = 0;
day_index = 0;
%v_diff = VideoWriter(['/home/jkolassa/Projects/SMAP_TC/' storm_name '_SFMC_DAOLdiff']);
%v_diff.FrameRate = 1;
%open(v_diff);
%
%v_sm = VideoWriter(['/home/jkolassa/Projects/SMAP_TC/' storm_name '_L4_SFMC']);
%v_sm.FrameRate = 1;
%open(v_sm);

for y = start_year:stop_year

    y_str = num2str(y);

    m_first = 1;
    m_last = 12;
    if (y==start_year)
        m_first = start_month;
    end

    if (y==stop_year)
        m_last = stop_month;
    end

    for m = m_first:m_last

        m_str = num2str(m,'%02i');

        day_first = 1;
        day_last = month_length(m);
        if (y==start_year)&(m==start_month)
           day_first = start_day;
        end
        if (y==stop_year)&(m==stop_month)
            day_last = stop_day;
        end

        for d = day_first:day_last

            day_index = day_index + 1;

            d_str = num2str(d,'%02i');

            for t = 1:length(t_vec)

                mat_index = mat_index + 1;

                smap_l4_file = [smap_l4_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' smap_stream '_001.h5'];
                smap_ol_file = [smap_ol_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' ol_stream '_001.h5'];

                if (mat_index==1)
                   lat_data = double(h5read(smap_l4_file,'/cell_lat'));
                   lon_data = double(h5read(smap_l4_file,'/cell_lon'));
                   lat_index = (lat_data(1,:)>=lat_range(1)) + (lat_data(1,:)<=lat_range(2));
                   lat_index = lat_index == 2;
                   lon_index = (lon_data(:,1)>=lon_range(1)) + (lon_data(:,1)<=lon_range(2));
                   lon_index = lon_index == 2;
                   domain_lats = lat_data(lon_index,lat_index);
                   domain_lons = lon_data(lon_index,lat_index);
                   sm_diff_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2),104);
                   domain_lai_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2),104);
                   sfmc_diff_hourly_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));
                  % mwrtm_param_file = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/rc_out/Y' y_str '/M11' ...
                  % '/SPL4SM_' smap_stream '.ldas_mwRTMparam.' y_str '1101_0000z.nc4'];
                  % mwrtm_lewt = ncread(mwrtm_param_file,'MWRTM_LEWT');
                end
                sm_l4_data = double(h5read(smap_l4_file,'/Geophysical_Data/sm_surface'));
                sm_ol_data = double(h5read(smap_ol_file,'/Geophysical_Data/sm_surface'));
                lai_l4_data = double(h5read(smap_ol_file,'/Geophysical_Data/leaf_area_index'));
                domain_lai_l4 = lai_l4_data(lon_index,lat_index);
                domain_sm_l4 = sm_l4_data(lon_index,lat_index);
                domain_sm_ol = sm_ol_data(lon_index,lat_index);

                domain_sm_diff = domain_sm_l4 - domain_sm_ol;
                sm_diff_mat(:,:,mat_index) = domain_sm_diff;
                domain_lai_mat(:,:,mat_index) = domain_lai_l4;
                test_vec(mat_index,1) = max(domain_sm_diff(:));
                test_vec(mat_index,2) = min(domain_sm_diff(:));

                sfmc_diff_hourly_mat(:,:,t) = sm_diff_mat(:,:,mat_index);

                % find nearest track point

                smap_datenum = datenum(y,m,d,str2double(t_vec{t}(1:2)),str2double(t_vec{t}(3:4)),0);
                datenum_dist = sqrt((track_datenum-smap_datenum).^2);
                date_index = find(datenum_dist==min(datenum_dist));
% plot domain-wide surface SM increments

                load coastlines;
                [latcells, loncells] = polysplit(coastlat, coastlon);
                 latlim = lat_range;
                 lonlim = lon_range;

                 cmap_mat = cmocean('rain',14);
                % cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
                 cmap = cmap_mat;
                 s1 = quantile(domain_sm_diff(:),0.99);
                 s2 = quantile(domain_sm_diff(:),0.01);
                 caxis_min = -1*max(abs(s1),abs(s2));
                 caxis_max = max(abs(s1),abs(s2));
                 caxis_min = 0;
                 caxis_max = 0.7;

%                 figure                                                                                         
%                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...                        
%                 'FLatLimit',lat_range,'FLonLimit',lon_range);                                                  
%                 framem off; gridm on;                                                                          
%                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...                           
%                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...                                 
%                 'MLabelParallel','south','FontSize',12)                                                        
%                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])                                          
%                  pcolorm(domain_lats,domain_lons,domain_sm_l4)                                               
%                  caxis([caxis_min caxis_max]);                                                                 
%                  set(gcf,'Colormap',cmap);                                                                     
%                  plotm(coastlat, coastlon,'k')                                                                 
%                  hold on                        
%                  plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-r','LineWidth',2)
%                  hold on                                                               
%                  %geoshow(states,'facealpha',0);                                                               
%                  set(gca,'XLim',lonlim);                                                                       
%                  set(gca,'YLim',latlim);                                                                       
%                  tightmap                                                                                      
%                  title(['L4 SFMC [m^{3} m^{-3}] ' y_str m_str d_str t_vec{t}])                 
%                  h = colorbar;                                                                                 
%                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);                       
%                  set(gcf,'paperunits','centimeters')                                                           
%                  set(gcf,'paperposition',[1 1 17 15])                                                          
%                  saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_L4_SFMC_' y_str m_str d_str t_vec{t}],'png')
%
%                  frame = getframe(gcf);                                                                        
%                  writeVideo(v_sm,frame);
%
%                 cmap_mat = cmocean('balance',20);
%                 cmap_mat = flipud(cmap_mat);
%                 cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
%                 cmap = cmap_mat;
%                 s1 = quantile(domain_sm_diff(:),0.99);
%                 s2 = quantile(domain_sm_diff(:),0.01);
%                 caxis_min = -1*max(abs(s1),abs(s2));
%                 caxis_max = max(abs(s1),abs(s2));
%                 caxis_min = -0.05;
%                 caxis_max = 0.05;
%
%                 figure
%                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
%                 'FLatLimit',lat_range,'FLonLimit',lon_range);
%                 framem off; gridm on;
%                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
%                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
%                 'MLabelParallel','south','FontSize',12)
%                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
%                  pcolorm(domain_lats,domain_lons,domain_sm_diff)
%                  caxis([caxis_min caxis_max]);
%                  set(gcf,'Colormap',cmap);
%                  plotm(coastlat, coastlon,'k')
%                  hold on                                                                                       
%                  plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-r','LineWidth',2)  
%                  hold on
%                  %geoshow(states,'facealpha',0);
%                  set(gca,'XLim',lonlim);
%                  set(gca,'YLim',latlim);
%                  tightmap
%                  title(['difference SFMC [m^{3} m^{-3}] (DA-OL) ' y_str m_str d_str t_vec{t}])
%                  h = colorbar;
%                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
%                  set(gcf,'paperunits','centimeters')
%                  set(gcf,'paperposition',[1 1 17 15])
%                  saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_SFMC_DAOLdiff_' y_str m_str d_str t_vec{t}],'png')
%
%                  frame = getframe(gcf);
%                  writeVideo(v_diff,frame);
            end

            sfmc_diff_daily_mat(:,:,day_index) = nanmean(sfmc_diff_hourly_mat,3);
         
            sfmc_diff_hourly_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));

            datenum_vec(day_index) = datenum(y,m,d);
     

        end

    end
end

                 cmap_mat = cmocean('balance',20);
                 cmap_mat = flipud(cmap_mat);
                 cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
                 cmap = cmap_mat;
                 s1 = quantile(sfmc_diff_daily_mat(:),0.99);
                 s2 = quantile(sfmc_diff_daily_mat(:),0.01);
                 caxis_min = -1*max(abs(s1),abs(s2));
                 caxis_max = max(abs(s1),abs(s2));

for i = 1:length(datenum_vec)

                 datenum_dist_daily = sqrt((track_datenum-datenum_vec(i)).^2);
                 date_index_daily = find(datenum_dist_daily==min(datenum_dist_daily));

                 figure
                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
                 'FLatLimit',lat_range,'FLonLimit',lon_range);
                 framem off; gridm on;
                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
                 'MLabelParallel','south','FontSize',12)
                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
                  pcolorm(domain_lats,domain_lons,sfmc_diff_daily_mat(:,:,i))
                  caxis([caxis_min caxis_max]);
                  set(gcf,'Colormap',cmap);
                  plotm(coastlat, coastlon,'k')
                  hold on
                  plotm(track_data(1:date_index_daily,5),track_data(1:date_index_daily,4),'-m','LineWidth',2)
                  hold on
                  %geoshow(states,'facealpha',0);
                  set(gca,'XLim',lonlim);
                  set(gca,'YLim',latlim);
                  tightmap
                  title(['\Delta SFMC [m^{3} m^{-3}] (DA-OL) ' datestr(datenum_vec(i),'yyyy-mm-dd')])
                  h = colorbar;
                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
                  set(gcf,'paperunits','centimeters')
                  set(gcf,'paperposition',[1 1 17 15])
                  saveas(gcf,[save_path storm_name '_L4_SMFC_diff_' datestr(datenum_vec(i),'yyyy-mm-dd')],'png')


end

%close(v_diff);
%close(v_sm);

tile_coord_file = ['/nfs3m/css/curated01/smapl4/data/public/L4_Products/L4_SM/Vv5014/rc_out/SPL4SM_Vv5014.ldas_tilecoord.bin'];
[tile_coord ] = read_tilecoord_le( tile_coord_file, 0 )
avg_lai = nanmean(domain_lai_mat,3);

%for i = 1:size(domain_lai_mat,1)
%    if mod(i,50)==0
%       i
%    end
%    for j = 1:size(domain_lai_mat,2)
%
%        dist_vec = sqrt((tile_coord.com_lat - domain_lats(i,j)).^2 + (tile_coord.com_lon-domain_lons(i,j)).^2);
%        point_index = find(dist_vec==min(dist_vec));
%        mwrtm_lewt_mat(i,j) = mwrtm_lewt(point_index(1));
%    end
%end
%
%avg_VWC = avg_lai.*mwrtm_lewt_mat;
%nan_index = avg_lai == -9999;
%avg_VWC(nan_index) = NaN;
%
%cmap_mat = cmocean('speed',20);
%cmap = cmap_mat;
%                 s1 = quantile(avg_VWC(:),0.99);
%                 s2 = quantile(avg_VWC(:),0.01);
%                 caxis_min = -1*max(abs(s1),abs(s2));
%                 caxis_max = max(abs(s1),abs(s2));
%                 caxis_min = 0;
%                 caxis_max = 10;
%
%                 figure
%                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
%                 'FLatLimit',lat_range,'FLonLimit',lon_range);
%                 framem off; gridm on;
%                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
%                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
%                 'MLabelParallel','south','FontSize',12)
%                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
%                  pcolorm(domain_lats,domain_lons,avg_VWC)
%                  caxis([caxis_min caxis_max]);
%                  set(gcf,'Colormap',cmap);
%                  plotm(coastlat, coastlon,'k')
%                  hold on
%                  %geoshow(states,'facealpha',0);
%                  set(gca,'XLim',lonlim);
%                  set(gca,'YLim',latlim);
%                  tightmap
%                  title(['average vegetation water content [kg m^{-2}] '])
%                  h = colorbar;
%                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
%                  set(gcf,'paperunits','centimeters')
%                  set(gcf,'paperposition',[1 1 17 15])
%                  saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_VWC'],'png')
