clc
clear all
close all

% make selections
storm_name = 'Idai';
start_date = '20190222';
stop_date = '20190323';
lat_range = [-24 -10];      % [southern_border northern_border]
lon_range = [25 52];  % [western_border eastern_border]
period_length = 'one_month';
plot_data = 'yes';
write_files = 'no';
write_path = '/discover/nobackup/jkolassa/SMAP_TC_data/';


smap_stream = 'Vv4030';
ol_stream = 'OL4001';

clim_file = ['/discover/nobackup/jkolassa/Projects/SMAP_TC/' storm_name '_clim_daily_' period_length '.mat'];
clim_data = load(clim_file);

% convert selections
smap_l4_path = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/gph/'];
smap_ol_path = ['/css/smapl4/public/Model-Only/SoilMoisture/' ol_stream '/gph/'];

start_year = str2double(start_date(1:4));
start_month = str2double(start_date(5:6));
start_day = str2double(start_date(7:8));
stop_year = str2double(stop_date(1:4));
stop_month = str2double(stop_date(5:6));
stop_day = str2double(stop_date(7:8));

% read track data

track_file = ['/discover/nobackup/jkolassa/Projects/SMAP_TC/' storm_name '_track.ascii'];
track_data = dlmread(track_file);
track_datenum = datenum(start_year, track_data(:,1), track_data(:,2), track_data(:,3), 0, 0);

t_vec = {'0130' '0430' '0730' '1030' '1330' '1630' '1930' '2230'};
month_length = [31 28 31 30 31 30 31 31 30 31 30 31];

mat_index = 0;

if strcmp(plot_data,'yes')
v_sm = VideoWriter(['/discover/nobackup/jkolassa/Projects/SMAP_TC/' storm_name '_L4_SFMC_anom_daily']);
v_sm.FrameRate = 1;
open(v_sm);
end

for y = start_year:stop_year

    y_str = num2str(y);

    if (y==2016) | (y==2020)
       month_length = [31 29 31 30 31 30 31 31 30 31 30 31]; 
    else
       month_length = [31 28 31 30 31 30 31 31 30 31 30 31];  
    end 

    m_first = 1;
    m_last = 12;
    if (y==start_year)
        m_first = start_month;
    end

    if (y==stop_year)
        m_last = stop_month;
    end

    for m = m_first:m_last

        m_str = num2str(m,'%02i');

        day_first = 1;
        day_last = month_length(m);
        if (y==start_year)&(m==start_month)
           day_first = start_day;
        end
        if (y==stop_year)&(m==stop_month)
            day_last = stop_day;
        end

        for d = day_first:day_last

            d_str = num2str(d,'%02i');

            if (m==2) & (d==29)
                clim_index = (clim_data.month_vec==m) + (clim_data.day_vec==28);
                clim_index = clim_index == 2;
            else
            clim_index = (clim_data.month_vec==m) + (clim_data.day_vec==d);
            clim_index = clim_index == 2;
            end

            for t = 1:length(t_vec)

                mat_index = mat_index + 1;

                smap_l4_file = [smap_l4_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' smap_stream '_001.h5'];
                smap_ol_file = [smap_ol_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' ol_stream '_001.h5'];

                if (mat_index==1)
                   lat_data = double(h5read(smap_l4_file,'/cell_lat'));
                   lat_long_name = h5readatt(smap_l4_file,'/cell_lat','long_name');
                   lat_units = h5readatt(smap_l4_file,'/cell_lat','units');
                   lon_data = double(h5read(smap_l4_file,'/cell_lon'));
                   lon_long_name = h5readatt(smap_l4_file,'/cell_lon','long_name');
                   lon_units = h5readatt(smap_l4_file,'/cell_lon','units');
                   lat_index = (lat_data(1,:)>=lat_range(1)) + (lat_data(1,:)<=lat_range(2));
                   lat_index = lat_index == 2;
                   lon_index = (lon_data(:,1)>=lon_range(1)) + (lon_data(:,1)<=lon_range(2));
                   lon_index = lon_index == 2;
                   domain_lats = lat_data(lon_index,lat_index);
                   domain_lons = lon_data(lon_index,lat_index);
                   sm_diff_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2),104);
                   domain_lai_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2),104);
                  % mwrtm_param_file = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/rc_out/Y' y_str '/M11' ...
                  % '/SPL4SM_' smap_stream '.ldas_mwRTMparam.' y_str '1101_0000z.nc4'];
                  % mwrtm_lewt = ncread(mwrtm_param_file,'MWRTM_LEWT');
                   time_data = h5read(smap_l4_file,'/time');
                   time_units = h5readatt(smap_l4_file,'/time','units');
                   time_long_name = h5readatt(smap_l4_file,'/time','long_name');
                end
                sm_l4_data = double(h5read(smap_l4_file,'/Geophysical_Data/sm_surface'));
                sm_units = h5readatt(smap_l4_file,'/Geophysical_Data/sm_surface','units');
                sm_fill_value = h5readatt(smap_l4_file,'/Geophysical_Data/sm_surface','_FillValue');
                evap_l4_data = double(h5read(smap_l4_file,'/Geophysical_Data/land_evapotranspiration_flux'));  
                evap_units = h5readatt(smap_l4_file,'/Geophysical_Data/land_evapotranspiration_flux','units'); 
                evap_fill_value = h5readatt(smap_l4_file,'/Geophysical_Data/land_evapotranspiration_flux','_FillValue');
                rz_l4_data = double(h5read(smap_l4_file,'/Geophysical_Data/sm_rootzone'));
                rz_units = h5readatt(smap_l4_file,'/Geophysical_Data/sm_rootzone','units');
                rz_fill_value = h5readatt(smap_l4_file,'/Geophysical_Data/sm_rootzone','_FillValue');
                sm_ol_data = double(h5read(smap_ol_file,'/Geophysical_Data/sm_surface'));
                lai_l4_data = double(h5read(smap_ol_file,'/Geophysical_Data/leaf_area_index'));
                domain_lai_l4 = lai_l4_data(lon_index,lat_index);
                domain_sm_l4 = sm_l4_data(lon_index,lat_index)-clim_data.clim_sm_l4(:,:,clim_index);
                nan_index = sm_l4_data(lon_index,lat_index) == sm_fill_value;
                domain_sm_l4(nan_index) = sm_fill_value;
                domain_evap_l4 = evap_l4_data(lon_index,lat_index)*86400-clim_data.clim_et_l4(:,:,clim_index);
                nan_index = evap_l4_data(lon_index,lat_index) == evap_fill_value;
                domain_evap_l4(nan_index) = evap_fill_value;
                domain_rz_l4 = rz_l4_data(lon_index,lat_index)-clim_data.clim_rz_l4(:,:,clim_index);     
                nan_index = rz_l4_data(lon_index,lat_index) == rz_fill_value;              
                domain_rz_l4(nan_index) = rz_fill_value; 
                domain_sm_ol = sm_ol_data(lon_index,lat_index)-clim_data.clim_sm_ol(:,:,clim_index);

                domain_lai_mat(:,:,mat_index) = domain_lai_l4;

                % write netcdf files
                if strcmp(write_files,'yes')

                   filename = [write_path storm_name '_L4_SM_anom_' y_str m_str d_str '_' t_vec{t} 'z.nc']

                   nccreate(filename,'lon','Dimensions', {'x',size(domain_lons,1),'y',size(domain_lons,2)});
                   ncwrite(filename,'lon',domain_lons);
                   ncwriteatt(filename,'/lon','long_name', 'longitude');
                   ncwriteatt(filename,'/lon','units','degrees_east');

                   nccreate(filename,'lat','Dimensions', {'x',size(domain_lats,1),'y',size(domain_lats,2)});
                   ncwrite(filename,'lat',domain_lats);
                   ncwriteatt(filename,'/lat','long_name','latitude');
                   ncwriteatt(filename,'/lat','units','degrees_north');

                   nccreate(filename,'time');
                   ncwrite(filename,'time',time_data);
                   ncwriteatt(filename,'/time','long_name',time_long_name);
                   ncwriteatt(filename,'/time','units',time_units);

                   nccreate(filename,'sfmc_anomaly','Dimensions', {'x',size(domain_sm_l4,1),'y',size(domain_sm_l4,2)},...
                           'FillValue',sm_fill_value);
                   ncwrite(filename,'sfmc_anomaly',domain_sm_l4);
                   ncwriteatt(filename,'/sfmc_anomaly','long_name','anomaly of surface soil moisture with respect to daily climatology computed over SMAP L4 SM period');
                   ncwriteatt(filename,'/sfmc_anomaly','units',sm_units);

                   nccreate(filename,'rzmc_anomaly','Dimensions', {'x',size(domain_rz_l4,1),'y',size(domain_rz_l4,2)},...
                           'FillValue',rz_fill_value);                                     
                   ncwrite(filename,'rzmc_anomaly',domain_rz_l4);                          
                   ncwriteatt(filename,'/rzmc_anomaly','long_name','anomaly of root-zone soil moisture with respect to daily climatology computed over SMAP L4 SM period');
                   ncwriteatt(filename,'/rzmc_anomaly','units',rz_units);

                   nccreate(filename,'et_anomaly','Dimensions', {'x',size(domain_evap_l4,1),'y',size(domain_evap_l4,2)},...
                           'FillValue',evap_fill_value);                                                                 
                   ncwrite(filename,'et_anomaly',domain_evap_l4);                                                      
                   ncwriteatt(filename,'/et_anomaly','long_name','anomaly of land evapotranspirationwith respect to daily climatology computed over SMAP L4 SM period');
                   ncwriteatt(filename,'/et_anomaly','units','mm/day');    
                end

                % find nearest track point

                smap_datenum = datenum(y,m,d,str2double(t_vec{t}(1:2)),str2double(t_vec{t}(3:4)),0);
                datenum_dist = sqrt((track_datenum-smap_datenum).^2);
                date_index = find(datenum_dist==min(datenum_dist));
% plot domain-wide surface SM increments

                domain_sm_l4(domain_sm_l4==sm_fill_value) = NaN; 

                if strcmp(plot_data,'yes')
                load coastlines;
                [latcells, loncells] = polysplit(coastlat, coastlon);
                 latlim = lat_range;
                 lonlim = lon_range;

                 cmap_mat = cmocean('balance',20);
                 cmap_mat = flipud(cmap_mat);
                 cmap_mat = jet(20);
                 cmap_mat = flipud(cmap_mat);
                 cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = 0.7*ones(2,3);
                 cmap = cmap_mat;
                 s1 = quantile(domain_sm_l4(:),0.99);
                 s2 = quantile(domain_sm_l4(:),0.01);
                 caxis_min = -1*max(abs(s1),abs(s2));
                 caxis_max = max(abs(s1),abs(s2));
                 caxis_min = -0.1;
                 caxis_max = 0.1;

                 figure
                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
                 'FLatLimit',lat_range,'FLonLimit',lon_range);
                 framem off; gridm on;
                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
                 'MLabelParallel','south','FontSize',12)
                  geoshow('landareas.shp', 'FaceColor', [1 1 1])
                  pcolorm(domain_lats,domain_lons,domain_sm_l4)
                  caxis([caxis_min caxis_max]);
                  set(gcf,'Colormap',cmap);
                  plotm(coastlat, coastlon,'k')
                  hold on
                  plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-m','LineWidth',2)
                  hold on
                  %geoshow(states,'facealpha',0);
                  set(gca,'XLim',lonlim);
                  set(gca,'YLim',latlim);
                  tightmap
                  title(['surface soil moisture anomaly [m^{3} m^{-3}] (DA-clim) ' y_str m_str d_str t_vec{t}])
                  h = colorbar;
                  set(h,'Location','southoutside','Orientation','vertical','FontSize',14);
                  set(gcf,'paperunits','centimeters')
                  set(gcf,'paperposition',[1 1 17 15])
                  saveas(gcf,['/discover/nobackup/jkolassa/Projects/SMAP_TC/' storm_name '_L4_SFMC_anom_daily_' y_str m_str d_str t_vec{t}],'png')

                  frame = getframe(gcf);
                  writeVideo(v_sm,frame);
                  end % if plot_data

            end

        end

    end
end

if strcmp(plot_data,'yes')
%close(v_diff);
close(v_sm);
end

tile_coord_file = ['/nfs3m/css/curated01/smapl4/data/public/L4_Products/L4_SM/Vv5014/rc_out/SPL4SM_Vv5014.ldas_tilecoord.bin'];
[tile_coord ] = read_tilecoord_le( tile_coord_file, 0 )
avg_lai = nanmean(domain_lai_mat,3);

%for i = 1:size(domain_lai_mat,1)
%    if mod(i,50)==0
%       i
%    end
%    for j = 1:size(domain_lai_mat,2)
%
%        dist_vec = sqrt((tile_coord.com_lat - domain_lats(i,j)).^2 + (tile_coord.com_lon-domain_lons(i,j)).^2);
%        point_index = find(dist_vec==min(dist_vec));
%        mwrtm_lewt_mat(i,j) = mwrtm_lewt(point_index(1));
%    end
%end
%
%avg_VWC = avg_lai.*mwrtm_lewt_mat;
%nan_index = avg_lai == -9999;
%avg_VWC(nan_index) = NaN;
%
%cmap_mat = cmocean('speed',20);
%cmap = cmap_mat;
%                 s1 = quantile(avg_VWC(:),0.99);
%                 s2 = quantile(avg_VWC(:),0.01);
%                 caxis_min = -1*max(abs(s1),abs(s2));
%                 caxis_max = max(abs(s1),abs(s2));
%                 caxis_min = 0;
%                 caxis_max = 10;
%
%                 figure
%                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
%                 'FLatLimit',lat_range,'FLonLimit',lon_range);
%                 framem off; gridm on;
%                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
%                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
%                 'MLabelParallel','south','FontSize',12)
%                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
%                  pcolorm(domain_lats,domain_lons,avg_VWC)
%                  caxis([caxis_min caxis_max]);
%                  set(gcf,'Colormap',cmap);
%                  plotm(coastlat, coastlon,'k')
%                  hold on
%                  %geoshow(states,'facealpha',0);
%                  set(gca,'XLim',lonlim);
%                  set(gca,'YLim',latlim);
%                  tightmap
%                  title(['average vegetation water content [kg m^{-2}] '])
%                  h = colorbar;
%                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
%                  set(gcf,'paperunits','centimeters')
%                  set(gcf,'paperposition',[1 1 17 15])
%                  saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_VWC'],'png')
