clc
clear all
close all

% make selections
storm_name = 'Idai';
start_date = '20190215';
stop_date = '20200323';
lat_range = [-24 -10];      % [southern_border northern_border]
lon_range = [25 52];  % [western_border eastern_border]
period_name = 'one_month';

smap_stream = 'Vv4030';
ol_stream = 'OL4001';

switch_datenum = datenum(2020,8,26,0,0,0);
% convert selections
smap_l4_path = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/gph/'];
smap_ol_path = ['/css/smapl4/public/Model-Only/SoilMoisture/' ol_stream '/gph/'];

start_year = str2double(start_date(1:4));
start_month = str2double(start_date(5:6));
start_day = str2double(start_date(7:8));
stop_year = str2double(stop_date(1:4));
stop_month = str2double(stop_date(5:6));
stop_day = str2double(stop_date(7:8));


t_vec = {'0130' '0430' '0730' '1030' '1330' '1630' '1930' '2230'};
month_length = [31 28 31 30 31 30 31 31 30 31 30 31];

mat_index = 0;
day_index = 0;
m_first = start_month;
m_last = stop_month;

start_datenum = datenum(start_year,start_month,start_day,0,0,0);
stop_datenum = datenum(stop_year,stop_month,stop_day,0,0,0);
ndays = (stop_datenum-start_datenum+1);

    for m = m_first:m_last

        m_str = num2str(m,'%02i');

        day_first = 1;
        day_last = month_length(m);
        if (m==start_month)
           day_first = start_day;
        end
        if (m==stop_month)
            day_last = stop_day;
        end

        for d = day_first:day_last
            d
            day_index = day_index + 1;
            d_str = num2str(d,'%02i');
            
            mat_index = 0;

            for y = 2016:2020

                curr_datenum = datenum(y,m,d,0,0,0);
                if (curr_datenum<=switch_datenum)
                    smap_stream = 'Vv4030';
                    ol_stream = 'OL4001';
                else
                    smap_stream = 'Vv5014';
                    ol_stream = 'OL5030';
                end
            smap_l4_path = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/gph/'];
            smap_ol_path = ['/css/smapl4/public/Model-Only/SoilMoisture/' ol_stream '/gph/'];
            read_datenum = (curr_datenum-5):1:(curr_datenum+5);

            for k = read_datenum

                  [Y,M,D,H,MN,S] = datevec(k);
                  y2_str = num2str(Y);
                  m2_str = num2str(M,'%02i');
                  d2_str = num2str(D,'%02i');

            for t = 1:length(t_vec)

                mat_index = mat_index + 1;

                smap_l4_file = [smap_l4_path 'Y' y2_str '/M' m2_str '/D' d2_str ...
                           '/SMAP_L4_SM_gph_' y2_str m2_str d2_str 'T' t_vec{t} '00_' smap_stream '_001.h5'];
                smap_ol_file = [smap_ol_path 'Y' y2_str '/M' m2_str '/D' d2_str ...
                           '/SMAP_L4_SM_gph_' y2_str m2_str d2_str 'T' t_vec{t} '00_' ol_stream '_001.h5'];

                if (mat_index==1)
                   start_datenum = datenum(start_year,start_month,start_day,0,0,0);
                   stop_datenum = datenum(stop_year,stop_month,stop_day,0,0,0);
                   time_steps = length(read_datenum)*length(t_vec)*6;
                   lat_data = double(h5read(smap_l4_file,'/cell_lat'));
                   lon_data = double(h5read(smap_l4_file,'/cell_lon'));
                   lat_index = (lat_data(1,:)>=lat_range(1)) + (lat_data(1,:)<=lat_range(2));
                   lat_index = lat_index == 2;
                   lon_index = (lon_data(:,1)>=lon_range(1)) + (lon_data(:,1)<=lon_range(2));
                   lon_index = lon_index == 2;
                   domain_lats = lat_data(lon_index,lat_index);
                   domain_lons = lon_data(lon_index,lat_index);
                   domain_sm_l4 = NaN*ones(size(domain_lats,1),size(domain_lats,2),time_steps);
                   domain_sm_ol = NaN*ones(size(domain_lats,1),size(domain_lats,2),time_steps);
                   domain_et_l4 = NaN*ones(size(domain_lats,1),size(domain_lats,2),time_steps);
                   domain_et_ol = NaN*ones(size(domain_lats,1),size(domain_lats,2),time_steps);
                end
                sm_l4_data = double(h5read(smap_l4_file,'/Geophysical_Data/sm_surface'));
                sm_ol_data = double(h5read(smap_ol_file,'/Geophysical_Data/sm_surface'));
                rz_l4_data = double(h5read(smap_l4_file,'/Geophysical_Data/sm_rootzone'));                     
                rz_ol_data = double(h5read(smap_ol_file,'/Geophysical_Data/sm_rootzone'));     
                et_l4_data = double(h5read(smap_l4_file,'/Geophysical_Data/land_evapotranspiration_flux'));
                et_ol_data = double(h5read(smap_ol_file,'/Geophysical_Data/land_evapotranspiration_flux'));
                domain_sm_l4(:,:,mat_index) = sm_l4_data(lon_index,lat_index);
                domain_sm_ol(:,:,mat_index) = sm_ol_data(lon_index,lat_index);
                domain_rz_l4(:,:,mat_index) = rz_l4_data(lon_index,lat_index);                                
                domain_rz_ol(:,:,mat_index) = rz_ol_data(lon_index,lat_index); 
                domain_et_l4(:,:,mat_index) = et_l4_data(lon_index,lat_index).*86400;  % convert to mm/day
                domain_et_ol(:,:,mat_index) = et_ol_data(lon_index,lat_index).*86400;  % convert to mm/day
            end
           end
          end

          month_vec(day_index) = m;
          day_vec(day_index) = d;
          clim_sm_l4(:,:,day_index) = nanmean(domain_sm_l4,3);
          clim_sm_ol(:,:,day_index) = nanmean(domain_sm_ol,3);
          clim_rz_l4(:,:,day_index) = nanmean(domain_rz_l4,3);                                                
          clim_rz_ol(:,:,day_index) = nanmean(domain_rz_ol,3); 
          clim_et_l4(:,:,day_index) = nanmean(domain_et_l4,3);
          clim_et_ol(:,:,day_index) = nanmean(domain_et_ol,3);
        end

    end


save_file_name = ['/home/jkolassa/Projects/SMAP_TC/' storm_name '_clim_daily_' period_name '.mat']
save(save_file_name,'clim_sm_l4','clim_sm_ol','clim_rz_l4','clim_rz_ol','clim_et_l4','clim_et_ol','month_vec','day_vec');
