clc
clear all
close all

% make selections
storm_name = 'Esther';
start_date = '20200218';
stop_date = '20200224';
lat_range = [-40 0];      % [southern_border northern_border]
lon_range = [110 160];  % [western_border eastern_border]
period_length = 'one_month';

sub_lat_range = [-22.5 -10];
sub_lon_range = lon_range;

smap_stream = 'Vv4030';
ol_stream = 'OL4001';

clim_file = ['/home/jkolassa/Projects/SMAP_TC/' storm_name '_clim_daily_' period_length '.mat'];
clim_data = load(clim_file);


% convert selections
smap_l4_path = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/gph/'];
smap_ol_path = ['/css/smapl4/public/Model-Only/SoilMoisture/' ol_stream '/gph/'];

start_year = str2double(start_date(1:4));
start_month = str2double(start_date(5:6));
start_day = str2double(start_date(7:8));
stop_year = str2double(stop_date(1:4));
stop_month = str2double(stop_date(5:6));
stop_day = str2double(stop_date(7:8));

% read track data

track_file = ['/home/jkolassa/Projects/SMAP_TC/' storm_name '_track.ascii'];
track_data = dlmread(track_file);
track_datenum = datenum(start_year, track_data(:,1), track_data(:,2), track_data(:,3), 0, 0);

t_vec = {'0130' '0430' '0730' '1030' '1330' '1630' '1930' '2230'};
month_length = [31 28 31 30 31 30 31 31 30 31 30 31];

mat_index = 0;

for y = start_year:stop_year

    y_str = num2str(y);

    m_first = 1;
    m_last = 12;
    if (y==start_year)
        m_first = start_month;
    end

    if (y==stop_year)
        m_last = stop_month;
    end

    for m = m_first:m_last

        m_str = num2str(m,'%02i');

        day_first = 1;
        day_last = month_length(m);
        if (y==start_year)&(m==start_month)
           day_first = start_day;
        end
        if (y==stop_year)&(m==stop_month)
            day_last = stop_day;
        end

        for d = day_first:day_last

            d_str = num2str(d,'%02i');

            clim_index = (clim_data.month_vec==m) + (clim_data.day_vec==d);                     
            clim_index = clim_index == 2;  

            for t = 1:length(t_vec)

                mat_index = mat_index + 1;

                smap_l4_file = [smap_l4_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' smap_stream '_001.h5'];
                smap_ol_file = [smap_ol_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' ol_stream '_001.h5'];

                if (mat_index==1)
                   lat_data = double(h5read(smap_l4_file,'/cell_lat'));
                   lon_data = double(h5read(smap_l4_file,'/cell_lon'));
                   lat_index = (lat_data(1,:)>=lat_range(1)) + (lat_data(1,:)<=lat_range(2));
                   lat_index = lat_index == 2;
                   lon_index = (lon_data(:,1)>=lon_range(1)) + (lon_data(:,1)<=lon_range(2));
                   lon_index = lon_index == 2;
                   domain_lats = lat_data(lon_index,lat_index);
                   domain_lons = lon_data(lon_index,lat_index);
                   domain_evap_l4_anom = NaN*ones(size(domain_lats,1),size(domain_lats,2));
                   domain_evap_ol_anom = NaN*ones(size(domain_lats,1),size(domain_lats,2));
            
                   sub_lat_index = (domain_lats(1,:)>=sub_lat_range(1)) + (domain_lats(1,:)<=sub_lat_range(2));
                   sub_lat_index = find(sub_lat_index == 2);
                  % sub_lon_index = (domain_lons(1,:)>=sub_lon_range(1)) + (domain_lons(1,:)<=sub_lon_range(2));
                  % sub_lon_index = sub_lon_index == 2;

                   sub_lats = domain_lats(:,sub_lat_index);
                   sub_lons = domain_lons(:,sub_lat_index);
                   l4_hov_mat =  NaN*ones(size(domain_lats,2),100);

                end
                sm_l4_evap_data = double(h5read(smap_l4_file,'/Geophysical_Data/land_evapotranspiration_flux'));
                sm_l4_evap_data(sm_l4_evap_data==-9999) = NaN;
                sm_ol_evap_data = double(h5read(smap_ol_file,'/Geophysical_Data/land_evapotranspiration_flux'));
                sm_ol_evap_data(sm_ol_evap_data==-9999) = NaN;
                % select domain and convert all to mm/day
                sm_l4_evap_tmp = sm_l4_evap_data(lon_index,lat_index).*86400;
                % select sub-domain and convert to mm
                sm_l4_evap_tmp2 = sm_l4_evap_tmp(:,sub_lat_index);
                sm_l4_evap_tmp2 = sm_l4_evap_tmp2.*10800/86400;
                tmp = nansum(sm_l4_evap_tmp2,1);
                if (mat_index == 1)
                l4_evap_hovm(:,mat_index) = tmp';
                else
                l4_evap_hovm(:,mat_index) = nansum(l4_evap_hovm(:,1:(mat_index-1)),2) + tmp';
                end

                date_vec(mat_index) = datenum(y,m,d,str2double(t_vec{t}(1:2)),str2double(t_vec{t}(3:4)),0); 

                domain_evap_l4_anom = sm_l4_evap_data(lon_index,lat_index).*86400-clim_data.clim_et_l4(:,:,clim_index);
                domain_evap_ol_anom = sm_ol_evap_data(lon_index,lat_index).*86400-clim_data.clim_et_ol(:,:,clim_index);

                % select sub-domain and convert to mm
                sub_l4_evap_anom = domain_evap_l4_anom(:,sub_lat_index)*10800/86400;
                tmp = nansum(sub_l4_evap_anom,1);
                if (mat_index == 1)
                l4_evap_anom_hovm(:,mat_index) = tmp';
                else
                l4_evap_anom_hovm(:,mat_index) = nansum(l4_evap_anom_hovm(:,1:(mat_index-1)),2) + tmp';
                end
                end % end of t_vec loop
        end

    end
end

cmap_mat = cmocean('tempo',20);
cmap = cmap_mat;

figure
colormap('jet')
h=imagesc(date_vec,sub_lats(1,:),l4_evap_hovm);
datetick('x',6)
set(gca,'YDir','normal')
set(gca,'ColorScale','log')
set(gcf,'Colormap',cmap)
colorbar
saveas(gcf,'/home/jkolassa/Projects/SMAP_TC/Esther_cumul_evap','png')

cmap_mat = cmocean('balance',20);
cmap = cmap_mat;

figure
colormap('jet')
h=imagesc(date_vec,sub_lats(1,:),l4_evap_anom_hovm);
datetick('x',6)
set(gca,'YDir','normal')
set(gca,'ColorScale','log')
set(gcf,'Colormap',cmap)
colorbar
saveas(gcf,'/home/jkolassa/Projects/SMAP_TC/Esther_cumul_evap_anom','png')
