clc
clear all
close all

% make selections
storm_name = 'Idai';
start_date = '20190222';
stop_date = '20190323';
lat_range = [-24 -10];      % [southern_border northern_border]
lon_range = [25 52];  % [western_border eastern_border]
period_length = 'one_month';

sub_lat_range = [-24 -10];
sub_lon_range = [25 52];

smap_stream = 'Vv4030';
ol_stream = 'OL4001';

clim_file = ['/home/jkolassa/Projects/SMAP_TC/' storm_name '_clim_daily_' period_length '.mat'];
clim_data = load(clim_file);


% convert selections
smap_l4_path = ['/css/smapl4/public/L4_Products/L4_SM/' smap_stream '/gph/'];
smap_ol_path = ['/css/smapl4/public/Model-Only/SoilMoisture/' ol_stream '/gph/'];

start_year = str2double(start_date(1:4));
start_month = str2double(start_date(5:6));
start_day = str2double(start_date(7:8));
stop_year = str2double(stop_date(1:4));
stop_month = str2double(stop_date(5:6));
stop_day = str2double(stop_date(7:8));

% read track data

track_file = ['/home/jkolassa/Projects/SMAP_TC/' storm_name '_track.ascii'];
track_data = dlmread(track_file);
track_datenum = datenum(start_year, track_data(:,1), track_data(:,2), track_data(:,3), 0, 0);

t_vec = {'0130' '0430' '0730' '1030' '1330' '1630' '1930' '2230'};
month_length = [31 28 31 30 31 30 31 31 30 31 30 31];

%v_evap_diff = VideoWriter(['/home/jkolassa/Projects/SMAP_TC/' storm_name '_evap_anom_daily']);
%v_evap_diff.FrameRate = 1;
%open(v_evap_diff);

d_index = 0;

for y = start_year:stop_year

    y_str = num2str(y);

    m_first = 1;
    m_last = 12;
    if (y==start_year)
        m_first = start_month;
    end

    if (y==stop_year)
        m_last = stop_month;
    end

    for m = m_first:m_last

        m_str = num2str(m,'%02i');

        day_first = 1;
        day_last = month_length(m);
        if (y==start_year)&(m==start_month)
           day_first = start_day;
        end
        if (y==stop_year)&(m==stop_month)
            day_last = stop_day;
        end

        for d = day_first:day_last

            d_index = d_index + 1;

            d_str = num2str(d,'%02i');
            mat_index = 0;
  
            if (m==2) & (d==29)
            clim_index = (clim_data.month_vec==m) + (clim_data.day_vec==28);                                        
            clim_index = clim_index == 2; 
            else
            clim_index = (clim_data.month_vec==m) + (clim_data.day_vec==d);                     
            clim_index = clim_index == 2;  
            end

            for t = 1:length(t_vec)

                mat_index = mat_index + 1;

                smap_l4_file = [smap_l4_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' smap_stream '_001.h5'];
                smap_ol_file = [smap_ol_path 'Y' y_str '/M' m_str '/D' d_str ...
                           '/SMAP_L4_SM_gph_' y_str m_str d_str 'T' t_vec{t} '00_' ol_stream '_001.h5'];

                if (mat_index==1)
                   lat_data = double(h5read(smap_l4_file,'/cell_lat'));
                   lon_data = double(h5read(smap_l4_file,'/cell_lon'));
                   lat_index = (lat_data(1,:)>=lat_range(1)) + (lat_data(1,:)<=lat_range(2));
                   lat_index = lat_index == 2;
                   lon_index = (lon_data(:,1)>=lon_range(1)) + (lon_data(:,1)<=lon_range(2));
                   lon_index = lon_index == 2;
                   domain_lats = lat_data(lon_index,lat_index);
                   domain_lons = lon_data(lon_index,lat_index);
                   domain_evap_l4 = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));
                   domain_evap_ol = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));
                   domain_sfmc_l4 = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));
                   domain_sfmc_ol = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));
                   domain_rzmc_l4 = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));
                   domain_rzmc_ol = NaN*ones(size(domain_lats,1),size(domain_lats,2),length(t_vec));
                   evap_diff_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2));
                   lh_diff_mat = NaN*ones(size(domain_lats,1),size(domain_lats,2));
                end
                l4_evap_data = double(h5read(smap_l4_file,'/Geophysical_Data/land_evapotranspiration_flux'));
                ol_evap_data = double(h5read(smap_ol_file,'/Geophysical_Data/land_evapotranspiration_flux'));
                l4_sfmc_data = double(h5read(smap_l4_file,'/Geophysical_Data/sm_surface'));
                ol_sfmc_data = double(h5read(smap_ol_file,'/Geophysical_Data/sm_surface'));
                l4_rzmc_data = double(h5read(smap_l4_file,'/Geophysical_Data/sm_rootzone'));
                ol_rzmc_data = double(h5read(smap_ol_file,'/Geophysical_Data/sm_rootzone'));
                % select domain and convert all to mm/day
                domain_evap_l4(:,:,mat_index) = l4_evap_data(lon_index,lat_index).*86400-clim_data.clim_et_l4(:,:,clim_index);
                domain_evap_ol(:,:,mat_index) = ol_evap_data(lon_index,lat_index).*86400-clim_data.clim_et_ol(:,:,clim_index);
                domain_sfmc_l4(:,:,mat_index) = l4_sfmc_data(lon_index,lat_index)-clim_data.clim_sm_l4(:,:,clim_index);
                domain_sfmc_ol(:,:,mat_index) = ol_sfmc_data(lon_index,lat_index)-clim_data.clim_sm_ol(:,:,clim_index);
                domain_rzmc_l4(:,:,mat_index) = l4_rzmc_data(lon_index,lat_index)-clim_data.clim_rz_l4(:,:,clim_index);
                domain_rzmc_ol(:,:,mat_index) = ol_rzmc_data(lon_index,lat_index)-clim_data.clim_rz_ol(:,:,clim_index);
                end % end of t_vec loop


                % compute daily total
                mean_evap_l4(:,:,d_index) = nanmean(domain_evap_l4,3);
                mean_sfmc_l4(:,:,d_index) = nanmean(domain_sfmc_l4,3);
                mean_rzmc_l4(:,:,d_index) = nanmean(domain_rzmc_l4,3);
                %mean_lh_l4 = nanmean(domain_lh_l4,3);

                % find nearest track point

                smap_datenum = datenum(y,m,d);
                datenum_dist = sqrt((track_datenum-smap_datenum).^2);
                date_index = find(datenum_dist==min(datenum_dist));
% plot domain-wide surface SM increments

                load coastlines;
                [latcells, loncells] = polysplit(coastlat, coastlon);
                 latlim = lat_range;
                 lonlim = lon_range;

                 cmap_mat = cmocean('balance',16);
                 cmap_mat = flipud(cmap_mat);
                 cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
                 cmap = cmap_mat;
               %  s1 = quantile(domain_sm_diff(:),0.99);
               %  s2 = quantile(domain_sm_diff(:),0.01);
               %  caxis_min = -1*max(abs(s1),abs(s2));
               %  caxis_max = max(abs(s1),abs(s2));
                 caxis_min = -2;
                 caxis_max = 2;

                 figure
                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...
                 'FLatLimit',lat_range,'FLonLimit',lon_range);
                 framem off; gridm on;
                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...
                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...
                 'MLabelParallel','south','FontSize',12)
                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
                  pcolorm(domain_lats,domain_lons,mean_evap_l4(:,:,d_index))
                  caxis([caxis_min caxis_max]);
                  set(gcf,'Colormap',cmap);
                  plotm(coastlat, coastlon,'k')
                  hold on
                  plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-r','LineWidth',2)
                  hold on
                  %geoshow(states,'facealpha',0);
                  set(gca,'XLim',lonlim);
                  set(gca,'YLim',latlim);
                  tightmap
                  date_time_str = datestr(datetime(smap_datenum,'ConvertFrom','datenum'));
                  title(['land evaporation anomaly [mm] (DA-clim) ' date_time_str])
                  h = colorbar;
                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
                  set(gcf,'paperunits','centimeters')
                  set(gcf,'paperposition',[1 1 17 15])
                  saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_evap_anom_daily_' y_str m_str d_str],'png')

               %   frame = getframe(gcf);
               %   writeVideo(v_evap_diff,frame);

                  cmap_mat = cmocean('balance',16);                                                                            
                 cmap_mat = flipud(cmap_mat);                                                                                 
                 cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);                                             
                 cmap = cmap_mat;                                                                                             
               %  s1 = quantile(domain_sm_diff(:),0.99);                                                                      
               %  s2 = quantile(domain_sm_diff(:),0.01);                                                                      
               %  caxis_min = -1*max(abs(s1),abs(s2));                                                                        
               %  caxis_max = max(abs(s1),abs(s2));                                                                           
                 caxis_min = -0.1;                                                                                              
                 caxis_max = 0.1;                                                                                               

                 figure                                                                                                       
                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...                                      
                 'FLatLimit',lat_range,'FLonLimit',lon_range);                                                                
                 framem off; gridm on;                                                                                        
                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...                                         
                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...                                               
                 'MLabelParallel','south','FontSize',12)                                                                      
                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])                                                        
                  pcolorm(domain_lats,domain_lons,mean_sfmc_l4(:,:,d_index))                                                      
                  caxis([caxis_min caxis_max]);                                                                               
                  set(gcf,'Colormap',cmap);                                                                                   
                  plotm(coastlat, coastlon,'k')                                                                               
                  hold on                                                                                                     
                  plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-r','LineWidth',2)
                  hold on                                                                                                     
                  %geoshow(states,'facealpha',0);                                                                             
                  set(gca,'XLim',lonlim);                                                                                     
                  set(gca,'YLim',latlim);                                                                                     
                  tightmap                                                                                                    
                  date_time_str = datestr(datetime(smap_datenum,'ConvertFrom','datenum'));                                    
                  title(['SFMC anomaly [m^3 m^{-3}] (DA-clim) ' date_time_str])                                           
                  h = colorbar;                                                                                               
                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);                                     
                  set(gcf,'paperunits','centimeters')                                                                         
                  set(gcf,'paperposition',[1 1 17 15])                                                                        
                  saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_sfmc_anom_daily_' y_str m_str d_str],'png') 

                  cmap_mat = cmocean('balance',16);
                 cmap_mat = flipud(cmap_mat);
                 cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
                 cmap = cmap_mat;
               %  s1 = quantile(domain_sm_diff(:),0.99);                                                                      
               %  s2 = quantile(domain_sm_diff(:),0.01);                                                                      
               %  caxis_min = -1*max(abs(s1),abs(s2));                                                                        
               %  caxis_max = max(abs(s1),abs(s2));                                                                           
                 caxis_min = -0.1;
                 caxis_max = 0.1;                                                                                             

                 figure
                 ax = axesm('miller','MapLatLimit',lat_range,'MapLonLimit',lon_range,...                                      
                 'FLatLimit',lat_range,'FLonLimit',lon_range);                                                                
                 framem off; gridm on;                                                                                        
                 setm(ax,'MLineLocation',5,'PLineLocation',5,'MeridianLabel','on',...                                         
                 'ParallelLabel','on','MLabelLocation',5,'PLabelLocation',5,...                                               
                 'MLabelParallel','south','FontSize',12)                                                                      
                  geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])                                                        
                  pcolorm(domain_lats,domain_lons,mean_rzmc_l4(:,:,d_index))                                                      
                  caxis([caxis_min caxis_max]);                                                                               
                  set(gcf,'Colormap',cmap);                                                                                   
                  plotm(coastlat, coastlon,'k')                                                                               
                  hold on                                                                                                     
                  plotm(track_data(1:date_index,5),track_data(1:date_index,4),'-r','LineWidth',2)                             
                  hold on                                                                                                     
                  %geoshow(states,'facealpha',0);                                                                             
                  set(gca,'XLim',lonlim);                                                                                     
                  set(gca,'YLim',latlim);                                                                                     
                  tightmap                                                                                                    
                  date_time_str = datestr(datetime(smap_datenum,'ConvertFrom','datenum'));                                    
                  title(['RZMC anomaly [m^3 m^{-3}] (DA-clim) ' date_time_str])                                               
                  h = colorbar;                                                                                               
                  set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);                                     
                  set(gcf,'paperunits','centimeters')                                                                         
                  set(gcf,'paperposition',[1 1 17 15])                                                                        
                  saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_rzmc_anom_daily_' y_str m_str d_str],'png') 
      
                  date_vec(d_index) = datenum(y,m,d,0,0,0);

          end

    end
end

sub_lat_index = (domain_lats(1,:)>=sub_lat_range(1)) + (domain_lats(1,:)<=sub_lat_range(2));               
sub_lat_index = find(sub_lat_index == 2);                                                                  
sub_lon_index = (domain_lons(:,1)>=sub_lon_range(1)) + (domain_lons(:,1)<=sub_lon_range(2));
sub_lon_index = find(sub_lon_index == 2);                                                                                                                              
sub_lats = domain_lats(sub_lon_index,sub_lat_index);                                                                   
sub_lons = domain_lons(sub_lon_index,sub_lat_index);

sub_et_mat = mean_evap_l4(sub_lon_index,sub_lat_index,:);
sub_sfmc_mat = mean_sfmc_l4(sub_lon_index,sub_lat_index,:);
sub_rzmc_mat = mean_rzmc_l4(sub_lon_index,sub_lat_index,:);

et_hovm_mat = nanmean(sub_et_mat,1);
sfmc_hovm_mat = nanmean(sub_sfmc_mat,1);
rzmc_hovm_mat = nanmean(sub_rzmc_mat,1);

et_hovm_cum_mat = NaN*ones(size(et_hovm_mat));
sfmc_hovm_cum_mat = NaN*ones(size(sfmc_hovm_mat));
rzmc_hovm_cum_mat = NaN*ones(size(rzmc_hovm_mat));

et_ts = NaN*ones(1,size(sub_et_mat,3));
et_cum_ts = NaN*ones(1,size(sub_et_mat,3));
sfmc_ts = NaN*ones(1,size(sub_sfmc_mat,3));
sfmc_cum_ts = NaN*ones(1,size(sub_sfmc_mat,3));
rzmc_ts = NaN*ones(1,size(sub_rzmc_mat,3));
rzmc_cum_ts = NaN*ones(1,size(sub_rzmc_mat,3));

for i = 1:d_index

    tmp_et = sub_et_mat(:,:,i);
    et_ts(i) = nanmean(tmp_et(:));
  
    tmp_sfmc = sub_sfmc_mat(:,:,i);
    sfmc_ts(i) = nanmean(tmp_sfmc(:));
 
    tmp_rzmc = sub_rzmc_mat(:,:,i);
    rzmc_ts(i) = nanmean(tmp_rzmc(:));

    if i == 1
       et_cum_ts(i) = et_ts(i);
       sfmc_cum_ts(i) = sfmc_ts(i);
       rzmc_cum_ts(i) = rzmc_ts(i);
    else
       et_cum_ts(i) = et_cum_ts(i-1) + nanmean(tmp_et(:));
       sfmc_cum_ts(i) = sfmc_cum_ts(i-1) + nanmean(tmp_sfmc(:)); 
       rzmc_cum_ts(i) = rzmc_cum_ts(i-1) + nanmean(tmp_rzmc(:)); 
    end

    if i == 1
       et_hovm_cum_mat(:,:,i) = et_hovm_mat(:,:,i);
       sfmc_hovm_cum_mat(:,:,i) = sfmc_hovm_mat(:,:,i);
       rzmc_hovm_cum_mat(:,:,i) = rzmc_hovm_mat(:,:,i);
    else
       et_hovm_cum_mat(:,:,i) = et_hovm_cum_mat(:,:,i-1) + et_hovm_mat(:,:,i);
       sfmc_hovm_cum_mat(:,:,i) = sfmc_hovm_cum_mat(:,:,i-1) + sfmc_hovm_mat(:,:,i);
       rzmc_hovm_cum_mat(:,:,i) = rzmc_hovm_cum_mat(:,:,i-1) + rzmc_hovm_mat(:,:,i);

    end
end

cmap_mat = cmocean('balance',16);
cmap_mat = flipud(cmap_mat);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = min(et_hovm_mat(:));
s2 = max(et_hovm_mat(:));
caxis_max = max(abs(s1),abs(s2));
caxis_min = -1*max(abs(s1),abs(s2));

et_hovm_plot_mat = reshape(et_hovm_mat,[size(et_hovm_mat,2),size(et_hovm_mat,3)]);

figure
imagesc(date_vec,sub_lats(1,:),et_hovm_plot_mat)
set(gca,'YDir','normal')
datetick('x',6)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
title('ET anomaly [mm]')
colorbar
saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_ET_hovm_anomaly'],'png')

cmap_mat = cmocean('balance',16);                                                                                             
cmap_mat = flipud(cmap_mat);                                                                                                  
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);                                                              
cmap = cmap_mat;                                                                                                              
s1 = min(et_hovm_cum_mat(:));                                                                                                     
s2 = max(et_hovm_cum_mat(:));                                                                                                     
caxis_max = max(abs(s1),abs(s2));                                                                                             
caxis_min = -1*max(abs(s1),abs(s2));                                                                                          

et_hovm_cum_plot_mat = reshape(et_hovm_cum_mat,[size(et_hovm_cum_mat,2),size(et_hovm_cum_mat,3)]);                                            

figure
imagesc(date_vec,sub_lats(1,:),et_hovm_cum_plot_mat)                                                                              
set(gca,'YDir','normal')                                                                                                      
datetick('x',6)                                                                                                               
caxis([caxis_min caxis_max]);                                                                                                 
set(gcf,'Colormap',cmap); 
title('ET cumulative anomaly [mm]')                                                                                                    
colorbar
saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_ET_hovm_cum_anomaly'],'png')  


figure 
plot(date_vec,et_ts,'-k','LineWidth',2)
hold on
plot(date_vec,et_cum_ts,'-r','LineWidth',2)
hold off
grid on
datetick('x',6)  
title('ET anomaly [mm]')
legend('ET anomaly','ET cumulative anomaly')
saveas(gcf,['/home/jkolassa/Projects/SMAP_TC/' storm_name '_ET_ts_anomaly'],'png')    
