clc
clear all
close all

%---------------------------------------------
% DATA PROCESSING DETAILS
%---------------------------------------------

smap_path = '/gpfsm/dnb05/projects/p51/SMAP_L4/SMAP/OPS/L2_SM_P/';
save_path = ['/discover/nobackup/jkolassa/SMAP_TC_project/Data_analysis/SMAP_L2_daily/'];

start_year = 2019;
start_month = 2;
start_day = 4;

end_year = 2019;
end_month = 3;
end_day = 22;

%---------------------------------------------
% DATA READ PREPARATION
%---------------------------------------------

leapYears = 1980:4:2022;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];
mat_index = 0;

%---------------------------------------------
% DATA READ
%---------------------------------------------

% loop over years
for y = start_year:end_year

    y_str = num2str(y,'%04i');

    % define month length based on leap year status
    if sum(y==leapYears)>0
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end

    % loop over months
    for m = start_month:end_month

        m_str = num2str(m,'%02i');

        % define start and end day for current month
        day_first = 1;
        day_last = monthLength(m);

        if (m == start_month)
           day_first = start_day;
        end

        if (m == end_month)
           day_last = end_day;
        end

        % loop over days
        for d = day_first:day_last

            mat_index = mat_index + 1;

            d_str = num2str(d,'%02i');

            dir_name = [smap_path '/Y' y_str '/M' m_str '/D' d_str '/'];
            smap_files = dir([dir_name '*R18290*h5']);

            if (length(smap_files)>=1)
            for f = 1:length(smap_files)

                smap_file = [dir_name smap_files(f).name];

            end % f
            end % if 

        end % d
     end % m
end % y 


