clc
clear all
close all

exp_name = 'GEOSldas_clm45_fire_M36';

gl_path = ['/discover/nobackup/jkolassa/GEOSgcm_CLM45_RT/' exp_name '/output/SMAP_EASEv2_M36/cat/ens0000/'];
ld_path = '/discover/nobackup/jkolassa/GEOSgcm_CLM45_RT/GEOSldas_clm45_fire_M36/output/SMAP_EASEv2_M36/cat/ens0000/';
test_file = [gl_path 'Y1980/M01/' exp_name '.tavg24_1d_lnd_Nt.19800101_1200z.nc4'];

start_year = 1980;
start_month = 1;
stop_year = 1980;
total_months = (stop_year-start_year+1)*12;

% define read parameters for LDASsa run


% define constants

rho_snow = 330;   % [kg m^-3]
rho_water = 1000; % [kg m^-3]

% read static data (geolocation, fill value, etc.) for GEOSldas run

lat_data = ncread(test_file,'lat');
lon_data = ncread(test_file,'lon');
lat_data = double(lat_data);
lon_data = double(lon_data);
unit_data = ncreadatt(test_file,'CNGPP','units');
%fill_value = ncreadatt(test_file,'CNGPP','_FillValue');


% define leap year data

leapYears = 1980:4:2017;
monthLength_nly = [31 28 31 30 31 30 31 31 30 31 30 31];
monthLength_ly = [31 29 31 30 31 30 31 31 30 31 30 31];

% initialize arrays

mat_index = 0;
gl_monthly_sfmc = NaN*ones(length(lon_data),total_months);
ld_monthly_sfmc_m09 = NaN*ones(length(lon_data),total_months);
gl_monthly_rzmc = NaN*ones(length(lon_data),total_months);
ld_monthly_rzmc_m09 = NaN*ones(length(lon_data),total_months);
gl_monthly_eveg = NaN*ones(length(lon_data),total_months);
ld_monthly_eveg_m09 = NaN*ones(length(lon_data),total_months);
gl_monthly_esoil = NaN*ones(length(lon_data),total_months);
ld_monthly_esoil_m09 = NaN*ones(length(lon_data),total_months);
gl_monthly_eint = NaN*ones(length(lon_data),total_months);
ld_monthly_eint_m09 = NaN*ones(length(lon_data),total_months);
gl_monthly_esno = NaN*ones(length(lon_data),total_months);
ld_monthly_esno_m09 = NaN*ones(length(lon_data),total_months);
gl_monthly_asnow = NaN*ones(length(lon_data),total_months);
ld_monthly_asnow_m09 = NaN*ones(length(lon_data),total_months);
gl_monthly_swe = NaN*ones(length(lon_data),total_months);
ld_monthly_swe_m09 = NaN*ones(length(lon_data),total_months);

month_vec = NaN*ones(total_months,1);
date_vec = NaN*ones(total_months,1);

% read data

disp('read data')

for y = start_year:stop_year
    y

    year_str = num2str(y);

    if sum(y==leapYears)>0
        monthLength = monthLength_ly;
    else
        monthLength = monthLength_nly;
    end

    for m = 1%:12

        mat_index = mat_index + 1;
        month_vec(mat_index) = m;
        date_vec = datenum(y,m,15);

        if m < 10
           month_str = ['0' num2str(m)];
        else
           month_str = num2str(m);
        end


        for d = 1%:monthLength(m)

            if d < 10
               day_str = ['0' num2str(d)];
            else
               day_str = num2str(d);
            end

            gl_file = [gl_path 'Y' year_str '/M' month_str ...
                         '/' exp_name '.tavg24_1d_lnd_Nt.' year_str month_str day_str '_1200z.nc4'];

            ld_file = [ld_path 'Y' year_str '/M' month_str ...                         
                          '/' exp_name '.tavg24_1d_lnd_Nt.' year_str month_str day_str '_1200z.nc4'];

            sfmc_data = ncread(gl_file,'SFMC');
            rzmc_data = ncread(gl_file,'RZMC');
            eveg_data = ncread(gl_file,'EVPTRNS');
            esoil_data = ncread(gl_file,'EVPSOIL');
            eint_data = ncread(gl_file,'EVPINTR');
            esno_data = ncread(gl_file,'EVPSNO');
            asnow_data = ncread(gl_file,'FRSNO');
            snodp_data = ncread(gl_file,'SNODP');

            sfmc_data_ld = ncread(ld_file,'SFMC');
            rzmc_data_ld = ncread(ld_file,'RZMC');
            eveg_data_ld = ncread(ld_file,'EVPTRNS');
            esoil_data_ld = ncread(ld_file,'EVPSOIL');
            eint_data_ld = ncread(ld_file,'EVPINTR');
            esno_data_ld = ncread(ld_file,'EVPSNO');
            asnow_data_ld = ncread(ld_file,'FRSNO');
            snodp_data_ld = ncread(ld_file,'SNODP');

            % replace fill values with NaN and convert all data to doubles

            sfmc_data = double(sfmc_data);
            rzmc_data = double(rzmc_data);
            eveg_data = double(eveg_data);
            esoil_data = double(esoil_data);
            eint_data = double(eint_data);
            asnow_data = double(asnow_data);
            snodp_data = double(snodp_data);

            sfmc_data_ld = double(sfmc_data_ld);                                                 
            rzmc_data_ld = double(rzmc_data_ld);                                                 
            eveg_data_ld = double(eveg_data_ld);                                                 
            esoil_data_ld = double(esoil_data_ld);                                               
            eint_data_ld = double(eint_data_ld);                                                 
            asnow_data_ld = double(asnow_data_ld);                                               
            snodp_data_ld = double(snodp_data_ld);  

            % convert snow depth [m] to SWE [mm]

            swe_data = (snodp_data*(rho_snow/rho_water))*1000;
            swe_data_ld = (snodp_data_ld*(rho_snow/rho_water))*1000;

            % convert evaporation data into mm/day

            eveg_data = eveg_data*0.0864*0.408;
            esoil_data = esoil_data*0.0864*0.408;
            eint_data = eint_data*0.0864*0.408;
            esno_data = esno_data*0.0864*0.352;

            eveg_data_ld = eveg_data_ld*0.0864*0.408;                                            
            esoil_data_ld = esoil_data_ld*0.0864*0.408;                                          
            eint_data_ld = eint_data_ld*0.0864*0.408;                                            
            esno_data_ld = esno_data_ld*0.0864*0.352; 

           end

end
end

% convert vectors to grids

disp('regrid vectors to 2D arrays')

test_lat = unique(lat_data);
test_lon = unique(lon_data);

[lon_mat,lat_mat] = meshgrid(test_lon,test_lat);

gl_mean_sfmc_tot_mat = NaN*ones(size(lon_mat));
ld_mean_sfmc_tot_mat = NaN*ones(size(lon_mat));
gl_mean_rzmc_tot_mat = NaN*ones(size(lon_mat));
ld_mean_rzmc_tot_mat = NaN*ones(size(lon_mat));
gl_mean_eveg_tot_mat = NaN*ones(size(lon_mat));
ld_mean_eveg_tot_mat = NaN*ones(size(lon_mat));
gl_mean_esoil_tot_mat = NaN*ones(size(lon_mat));
ld_mean_esoil_tot_mat = NaN*ones(size(lon_mat));
gl_mean_eint_tot_mat = NaN*ones(size(lon_mat));
ld_mean_eint_tot_mat = NaN*ones(size(lon_mat));
gl_mean_esno_tot_mat = NaN*ones(size(lon_mat));
ld_mean_esno_tot_mat = NaN*ones(size(lon_mat));
gl_mean_asnow_tot_mat = NaN*ones(size(lon_mat));
ld_mean_asnow_tot_mat = NaN*ones(size(lon_mat));
gl_mean_swe_tot_mat = NaN*ones(size(lon_mat));
ld_mean_swe_tot_mat = NaN*ones(size(lon_mat));

for i = 1:length(lon_data)

    lat_index = test_lat == lat_data(i);
    lon_index = test_lon == lon_data(i);

    gl_mean_sfmc_tot_mat(lat_index,lon_index) = sfmc_data(i);
    ld_mean_sfmc_tot_mat(lat_index,lon_index) = sfmc_data_ld(i);
    gl_mean_rzmc_tot_mat(lat_index,lon_index) = rzmc_data(i);
    ld_mean_rzmc_tot_mat(lat_index,lon_index) = rzmc_data_ld(i);
    gl_mean_eveg_tot_mat(lat_index,lon_index) = eveg_data(i);
    ld_mean_eveg_tot_mat(lat_index,lon_index) = eveg_data_ld(i);
    gl_mean_esoil_tot_mat(lat_index,lon_index) = esoil_data(i);
    ld_mean_esoil_tot_mat(lat_index,lon_index) = esoil_data_ld(i);
    gl_mean_eint_tot_mat(lat_index,lon_index) = eint_data(i);
    ld_mean_eint_tot_mat(lat_index,lon_index) = eint_data_ld(i);
    gl_mean_esno_tot_mat(lat_index,lon_index) = esno_data(i);
    ld_mean_esno_tot_mat(lat_index,lon_index) = esno_data_ld(i);
    gl_mean_asnow_tot_mat(lat_index,lon_index) = asnow_data(i);
    ld_mean_asnow_tot_mat(lat_index,lon_index) = asnow_data_ld(i);
    gl_mean_swe_tot_mat(lat_index,lon_index) = swe_data(i);
    ld_mean_swe_tot_mat(lat_index,lon_index) = swe_data_ld(i);
end

% plot data

disp('plot data')


load coastlines;
[latcells, loncells] = polysplit(coastlat, coastlon);


latlim = [-60 90];
lonlim = [-180 180];

sfmc_tot_mean_diff = gl_mean_sfmc_tot_mat - ld_mean_sfmc_tot_mat;
rzmc_tot_mean_diff = gl_mean_rzmc_tot_mat - ld_mean_rzmc_tot_mat;
eveg_tot_mean_diff = gl_mean_eveg_tot_mat - ld_mean_eveg_tot_mat;
esoil_tot_mean_diff = gl_mean_esoil_tot_mat - ld_mean_esoil_tot_mat;
eint_tot_mean_diff = gl_mean_eint_tot_mat - ld_mean_eint_tot_mat;
esno_tot_mean_diff = gl_mean_esno_tot_mat - ld_mean_esno_tot_mat;
asnow_tot_mean_diff = gl_mean_asnow_tot_mat - ld_mean_asnow_tot_mat;
swe_tot_mean_diff = gl_mean_swe_tot_mat - ld_mean_swe_tot_mat;

cmap_mat = cmocean('rain',12);
%cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
caxis_min = 0;
caxis_max = 0.6;

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,gl_mean_sfmc_tot_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean SFMC [m^{3} m^{-3}] GEOldas')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/SFMC_mean_total_GEOSldas_M09'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,ld_mean_sfmc_tot_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean SFMC [m^{3} m^{-3}] LDASsa')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/SFMC_mean_total_LDASsa_M09'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,gl_mean_rzmc_tot_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean RZMC [m^{3} m^{-3}] GEOldas')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/RZMC_mean_total_GEOSldas_M09'],'png')

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,ld_mean_rzmc_tot_mat)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean RZMC [m^{3} m^{-3}] GEOldas')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/RZMC_mean_total_LDASsa_M09'],'png')

cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(sfmc_tot_mean_diff(:),0.95);
s2 = quantile(sfmc_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,sfmc_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean diff SFMC [m^{3} m^{-3}] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/SFMC_mean_total_diff_M09'],'png')

cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
s1 = quantile(rzmc_tot_mean_diff(:),0.95);
s2 = quantile(rzmc_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(s1),abs(s2));
caxis_max = max(abs(s1),abs(s2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,rzmc_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean diff RZMC [m^{3} m^{-3}] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/RZMC_mean_total_diff_M09'],'png')

cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
e1 = quantile(eveg_tot_mean_diff(:),0.95);
e2 = quantile(eveg_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(e1),abs(e2));
caxis_max = max(abs(e1),abs(e2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,eveg_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean diff transpiration [mm day^{-1}] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/eveg_mean_total_diff_M09'],'png')

cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
e1 = quantile(esoil_tot_mean_diff(:),0.95);
e2 = quantile(esoil_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(e1),abs(e2));
caxis_max = max(abs(e1),abs(e2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,esoil_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean diff soil evaporation [mm day^{-1}] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/esoil_mean_total_diff_M09'],'png')

cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
e1 = quantile(eint_tot_mean_diff(:),0.95);
e2 = quantile(eint_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(e1),abs(e2));
caxis_max = max(abs(e1),abs(e2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,eint_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean diff interception loss [mm day^{-1}] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/eint_mean_total_diff_M09'],'png')

cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
e1 = quantile(esno_tot_mean_diff(:),0.95);
e2 = quantile(esno_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(e1),abs(e2));
caxis_max = max(abs(e1),abs(e2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,esno_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('total mean diff snowpack evaporation [mm day^{-1}] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/esno_mean_total_diff_M09'],'png')


cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
e1 = quantile(asnow_tot_mean_diff(:),0.95);
e2 = quantile(asnow_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(e1),abs(e2));
caxis_max = max(abs(e1),abs(e2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
    'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
    'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
    'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,asnow_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('mean diff snow area [-] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/asnow_mean_total_diff_M09'],'png')

cmap_mat = cmocean('balance',20);
cmap_mat(length(cmap_mat)/2:length(cmap_mat)/2+1,:) = ones(2,3);
cmap = cmap_mat;
e1 = quantile(swe_tot_mean_diff(:),0.95);
e2 = quantile(swe_tot_mean_diff(:),0.05);
caxis_min = -1*max(abs(e1),abs(e2));
caxis_max = max(abs(e1),abs(e2));

figure
ax = axesm('miller','MapLatLimit',[-60 90],'MapLonLimit',[-180 180],...
'FLatLimit',[-60 90],'FLonLimit',[-180 180]);
framem off; gridm on;
setm(ax,'MLineLocation',20,'PLineLocation',20,'MeridianLabel','on',...
'ParallelLabel','on','MLabelLocation',60,'PLabelLocation',20,...
'MLabelParallel','south','FontSize',12)
geoshow('landareas.shp', 'FaceColor', [0.7 0.7 0.7])
pcolorm(lat_mat,lon_mat,swe_tot_mean_diff)
caxis([caxis_min caxis_max]);
set(gcf,'Colormap',cmap);
plotm(coastlat, coastlon,'k')
hold on
%geoshow(states,'facealpha',0);
set(gca,'XLim',lonlim);
set(gca,'YLim',latlim);
tightmap
title('mean diff snow water equivalent [mm] (GEOldas-LDASsa)')
h = colorbar;
set(h,'Location','eastoutside','Orientation','vertical','FontSize',14);
set(gcf,'paperunits','centimeters')
set(gcf,'paperposition',[1 1 17 15])
saveas(gcf,['/home/jkolassa/Projects/' exp_name '/swe_mean_total_diff_M09'],'png')
