clc 
clear all
close all

exp_dir = '/discover/nobackup/jkolassa/CN40_CN45_test_runs/AGCM_CN40/scratch/';
ref_dir = '/discover/nobackup/jkolassa/AGCM_ref/AGCM_CN40_ref/scratch/';

t_vec = {'0130','0430','0730','1030','1330','1630','1930','2230'};

mat_index = 0;

for d = 18:30

    d_str = num2str(d,'%02i');

    for t = 1:length(t_vec)

        mat_index = mat_index + 1;

        ref_file = [ref_dir 'AGCM_CN40_ref.geosgcm_surf.201608' d_str '_' t_vec{t} 'z.nc4'];
        exp_file = [exp_dir 'AGCM_CN40.geosgcm_surf.201608' d_str '_' t_vec{t} 'z.nc4'];

        if (mat_index==1)
           lat_data = double(ncread(ref_file,'lat'));
           lon_data = double(ncread(ref_file,'lon'));
        end

        wet1_data_ref(:,:,mat_index) = double(ncread(ref_file,'WET1'));
        wet2_data_ref(:,:,mat_index) = double(ncread(ref_file,'WET2'));
        cnlai_data_ref(:,:,mat_index) = double(ncread(ref_file,'CNTLAI'));
        cnnee_data_ref(:,:,mat_index) = double(ncread(ref_file,'CNNEE'))*1000;
        wat10cm_data_ref(:,:,mat_index) = double(ncread(ref_file,'WAT10CM'));
        tsurf_data_ref(:,:,mat_index) = double(ncread(ref_file,'TSURF'));
        evpveg_data_ref_tmp = double(ncread(ref_file,'EVPVEG'));
        evpveg_data_ref(:,:,mat_index) = evpveg_data_ref_tmp*0.0864*0.408;
      
        wet1_data_exp(:,:,mat_index) = double(ncread(exp_file,'WET1'));
        wet2_data_exp(:,:,mat_index) = double(ncread(exp_file,'WET2'));
        cnlai_data_exp(:,:,mat_index) = double(ncread(exp_file,'CNTLAI'));
        cnnee_data_exp(:,:,mat_index) = double(ncread(exp_file,'CNNEE'))*1000;
        wat10cm_data_exp(:,:,mat_index) = double(ncread(exp_file,'WAT10CM'));
        tsurf_data_exp(:,:,mat_index) = double(ncread(exp_file,'TSURF'));
        evpveg_data_exp_tmp = double(ncread(exp_file,'EVPVEG'));
        evpveg_data_exp(:,:,mat_index) = evpveg_data_exp_tmp*0.0864*0.408;
    end
end

disp('compute differences')

wet1_diff = wet1_data_exp - wet1_data_ref;
diff_range = [min(wet1_diff(:)) max(wet1_diff(:))]
wet2_diff = wet2_data_exp - wet2_data_ref;
diff_range = [min(wet2_diff(:)) max(wet2_diff(:))]
cnlai_diff = cnlai_data_exp - cnlai_data_ref;
diff_range = [min(cnlai_diff(:)) max(cnlai_diff(:))]
cnnee_diff = cnnee_data_exp - cnnee_data_ref;
diff_range = [min(cnnee_diff(:)) max(cnnee_diff(:))]
wat10cm_diff = wat10cm_data_exp - wat10cm_data_ref;
diff_range = [min(wat10cm_diff(:)) max(wat10cm_diff(:))]
tsurf_diff = tsurf_data_exp - tsurf_data_ref;
diff_range = [min(tsurf_diff(:)) max(tsurf_diff(:))]
evpveg_diff = evpveg_data_exp - evpveg_data_ref;
diff_range = [min(evpveg_diff(:)) max(evpveg_diff(:))]
